/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConflictingAliasesRequest extends CloudFrontRequest implements
        ToCopyableBuilder<ListConflictingAliasesRequest.Builder, ListConflictingAliasesRequest> {
    private static final SdkField<String> DISTRIBUTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DistributionId")
            .getter(getter(ListConflictingAliasesRequest::distributionId))
            .setter(setter(Builder::distributionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DistributionId")
                    .unmarshallLocationName("DistributionId").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Alias")
            .getter(getter(ListConflictingAliasesRequest::alias))
            .setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Alias")
                    .unmarshallLocationName("Alias").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(ListConflictingAliasesRequest::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems")
            .getter(getter(ListConflictingAliasesRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_ID_FIELD,
            ALIAS_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));

    private final String distributionId;

    private final String alias;

    private final String marker;

    private final Integer maxItems;

    private ListConflictingAliasesRequest(BuilderImpl builder) {
        super(builder);
        this.distributionId = builder.distributionId;
        this.alias = builder.alias;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The ID of a distribution in your account that has an attached SSL/TLS certificate that includes the provided
     * alias.
     * </p>
     * 
     * @return The ID of a distribution in your account that has an attached SSL/TLS certificate that includes the
     *         provided alias.
     */
    public final String distributionId() {
        return distributionId;
    }

    /**
     * <p>
     * The alias (also called a CNAME) to search for conflicting aliases.
     * </p>
     * 
     * @return The alias (also called a CNAME) to search for conflicting aliases.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * Use this field when paginating results to indicate where to begin in the list of conflicting aliases. The
     * response includes conflicting aliases in the list that occur after the marker. To get the next page of the list,
     * set this field’s value to the value of <code>NextMarker</code> from the current page’s response.
     * </p>
     * 
     * @return Use this field when paginating results to indicate where to begin in the list of conflicting aliases. The
     *         response includes conflicting aliases in the list that occur after the marker. To get the next page of
     *         the list, set this field’s value to the value of <code>NextMarker</code> from the current page’s
     *         response.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of conflicting aliases that you want in the response.
     * </p>
     * 
     * @return The maximum number of conflicting aliases that you want in the response.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConflictingAliasesRequest)) {
            return false;
        }
        ListConflictingAliasesRequest other = (ListConflictingAliasesRequest) obj;
        return Objects.equals(distributionId(), other.distributionId()) && Objects.equals(alias(), other.alias())
                && Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConflictingAliasesRequest").add("DistributionId", distributionId()).add("Alias", alias())
                .add("Marker", marker()).add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionId":
            return Optional.ofNullable(clazz.cast(distributionId()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConflictingAliasesRequest, T> g) {
        return obj -> g.apply((ListConflictingAliasesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListConflictingAliasesRequest> {
        /**
         * <p>
         * The ID of a distribution in your account that has an attached SSL/TLS certificate that includes the provided
         * alias.
         * </p>
         * 
         * @param distributionId
         *        The ID of a distribution in your account that has an attached SSL/TLS certificate that includes the
         *        provided alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionId(String distributionId);

        /**
         * <p>
         * The alias (also called a CNAME) to search for conflicting aliases.
         * </p>
         * 
         * @param alias
         *        The alias (also called a CNAME) to search for conflicting aliases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * Use this field when paginating results to indicate where to begin in the list of conflicting aliases. The
         * response includes conflicting aliases in the list that occur after the marker. To get the next page of the
         * list, set this field’s value to the value of <code>NextMarker</code> from the current page’s response.
         * </p>
         * 
         * @param marker
         *        Use this field when paginating results to indicate where to begin in the list of conflicting aliases.
         *        The response includes conflicting aliases in the list that occur after the marker. To get the next
         *        page of the list, set this field’s value to the value of <code>NextMarker</code> from the current
         *        page’s response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of conflicting aliases that you want in the response.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of conflicting aliases that you want in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String distributionId;

        private String alias;

        private String marker;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConflictingAliasesRequest model) {
            super(model);
            distributionId(model.distributionId);
            alias(model.alias);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getDistributionId() {
            return distributionId;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConflictingAliasesRequest build() {
            return new ListConflictingAliasesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
