/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that determines whether any cookies in viewer requests (and if so, which cookies) are included in the cache
 * key and in requests that CloudFront sends to the origin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CachePolicyCookiesConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CachePolicyCookiesConfig.Builder, CachePolicyCookiesConfig> {
    private static final SdkField<String> COOKIE_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CookieBehavior")
            .getter(getter(CachePolicyCookiesConfig::cookieBehaviorAsString))
            .setter(setter(Builder::cookieBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CookieBehavior")
                    .unmarshallLocationName("CookieBehavior").build()).build();

    private static final SdkField<CookieNames> COOKIES_FIELD = SdkField
            .<CookieNames> builder(MarshallingType.SDK_POJO)
            .memberName("Cookies")
            .getter(getter(CachePolicyCookiesConfig::cookies))
            .setter(setter(Builder::cookies))
            .constructor(CookieNames::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cookies")
                    .unmarshallLocationName("Cookies").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COOKIE_BEHAVIOR_FIELD,
            COOKIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cookieBehavior;

    private final CookieNames cookies;

    private CachePolicyCookiesConfig(BuilderImpl builder) {
        this.cookieBehavior = builder.cookieBehavior;
        this.cookies = builder.cookies;
    }

    /**
     * <p>
     * Determines whether any cookies in viewer requests are included in the cache key and in requests that CloudFront
     * sends to the origin. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>none</code> – No cookies in viewer requests are included in the cache key or in requests that CloudFront
     * sends to the origin. Even when this field is set to <code>none</code>, any cookies that are listed in an
     * <code>OriginRequestPolicy</code> <i>are</i> included in origin requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>whitelist</code> – Only the cookies in viewer requests that are listed in the <code>CookieNames</code> type
     * are included in the cache key and in requests that CloudFront sends to the origin.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>allExcept</code> – All cookies in viewer requests are included in the cache key and in requests that
     * CloudFront sends to the origin, <i> <b>except</b> </i> for those that are listed in the <code>CookieNames</code>
     * type, which are not included.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>all</code> – All cookies in viewer requests are included in the cache key and in requests that CloudFront
     * sends to the origin.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cookieBehavior}
     * will return {@link CachePolicyCookieBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #cookieBehaviorAsString}.
     * </p>
     * 
     * @return Determines whether any cookies in viewer requests are included in the cache key and in requests that
     *         CloudFront sends to the origin. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>none</code> – No cookies in viewer requests are included in the cache key or in requests that
     *         CloudFront sends to the origin. Even when this field is set to <code>none</code>, any cookies that are
     *         listed in an <code>OriginRequestPolicy</code> <i>are</i> included in origin requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>whitelist</code> – Only the cookies in viewer requests that are listed in the
     *         <code>CookieNames</code> type are included in the cache key and in requests that CloudFront sends to the
     *         origin.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>allExcept</code> – All cookies in viewer requests are included in the cache key and in requests
     *         that CloudFront sends to the origin, <i> <b>except</b> </i> for those that are listed in the
     *         <code>CookieNames</code> type, which are not included.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>all</code> – All cookies in viewer requests are included in the cache key and in requests that
     *         CloudFront sends to the origin.
     *         </p>
     *         </li>
     * @see CachePolicyCookieBehavior
     */
    public final CachePolicyCookieBehavior cookieBehavior() {
        return CachePolicyCookieBehavior.fromValue(cookieBehavior);
    }

    /**
     * <p>
     * Determines whether any cookies in viewer requests are included in the cache key and in requests that CloudFront
     * sends to the origin. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>none</code> – No cookies in viewer requests are included in the cache key or in requests that CloudFront
     * sends to the origin. Even when this field is set to <code>none</code>, any cookies that are listed in an
     * <code>OriginRequestPolicy</code> <i>are</i> included in origin requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>whitelist</code> – Only the cookies in viewer requests that are listed in the <code>CookieNames</code> type
     * are included in the cache key and in requests that CloudFront sends to the origin.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>allExcept</code> – All cookies in viewer requests are included in the cache key and in requests that
     * CloudFront sends to the origin, <i> <b>except</b> </i> for those that are listed in the <code>CookieNames</code>
     * type, which are not included.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>all</code> – All cookies in viewer requests are included in the cache key and in requests that CloudFront
     * sends to the origin.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cookieBehavior}
     * will return {@link CachePolicyCookieBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #cookieBehaviorAsString}.
     * </p>
     * 
     * @return Determines whether any cookies in viewer requests are included in the cache key and in requests that
     *         CloudFront sends to the origin. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>none</code> – No cookies in viewer requests are included in the cache key or in requests that
     *         CloudFront sends to the origin. Even when this field is set to <code>none</code>, any cookies that are
     *         listed in an <code>OriginRequestPolicy</code> <i>are</i> included in origin requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>whitelist</code> – Only the cookies in viewer requests that are listed in the
     *         <code>CookieNames</code> type are included in the cache key and in requests that CloudFront sends to the
     *         origin.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>allExcept</code> – All cookies in viewer requests are included in the cache key and in requests
     *         that CloudFront sends to the origin, <i> <b>except</b> </i> for those that are listed in the
     *         <code>CookieNames</code> type, which are not included.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>all</code> – All cookies in viewer requests are included in the cache key and in requests that
     *         CloudFront sends to the origin.
     *         </p>
     *         </li>
     * @see CachePolicyCookieBehavior
     */
    public final String cookieBehaviorAsString() {
        return cookieBehavior;
    }

    /**
     * Returns the value of the Cookies property for this object.
     * 
     * @return The value of the Cookies property for this object.
     */
    public final CookieNames cookies() {
        return cookies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cookieBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cookies());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CachePolicyCookiesConfig)) {
            return false;
        }
        CachePolicyCookiesConfig other = (CachePolicyCookiesConfig) obj;
        return Objects.equals(cookieBehaviorAsString(), other.cookieBehaviorAsString())
                && Objects.equals(cookies(), other.cookies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CachePolicyCookiesConfig").add("CookieBehavior", cookieBehaviorAsString())
                .add("Cookies", cookies()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CookieBehavior":
            return Optional.ofNullable(clazz.cast(cookieBehaviorAsString()));
        case "Cookies":
            return Optional.ofNullable(clazz.cast(cookies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CachePolicyCookiesConfig, T> g) {
        return obj -> g.apply((CachePolicyCookiesConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CachePolicyCookiesConfig> {
        /**
         * <p>
         * Determines whether any cookies in viewer requests are included in the cache key and in requests that
         * CloudFront sends to the origin. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>none</code> – No cookies in viewer requests are included in the cache key or in requests that
         * CloudFront sends to the origin. Even when this field is set to <code>none</code>, any cookies that are listed
         * in an <code>OriginRequestPolicy</code> <i>are</i> included in origin requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>whitelist</code> – Only the cookies in viewer requests that are listed in the <code>CookieNames</code>
         * type are included in the cache key and in requests that CloudFront sends to the origin.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>allExcept</code> – All cookies in viewer requests are included in the cache key and in requests that
         * CloudFront sends to the origin, <i> <b>except</b> </i> for those that are listed in the
         * <code>CookieNames</code> type, which are not included.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>all</code> – All cookies in viewer requests are included in the cache key and in requests that
         * CloudFront sends to the origin.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cookieBehavior
         *        Determines whether any cookies in viewer requests are included in the cache key and in requests that
         *        CloudFront sends to the origin. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>none</code> – No cookies in viewer requests are included in the cache key or in requests that
         *        CloudFront sends to the origin. Even when this field is set to <code>none</code>, any cookies that are
         *        listed in an <code>OriginRequestPolicy</code> <i>are</i> included in origin requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>whitelist</code> – Only the cookies in viewer requests that are listed in the
         *        <code>CookieNames</code> type are included in the cache key and in requests that CloudFront sends to
         *        the origin.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>allExcept</code> – All cookies in viewer requests are included in the cache key and in requests
         *        that CloudFront sends to the origin, <i> <b>except</b> </i> for those that are listed in the
         *        <code>CookieNames</code> type, which are not included.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>all</code> – All cookies in viewer requests are included in the cache key and in requests that
         *        CloudFront sends to the origin.
         *        </p>
         *        </li>
         * @see CachePolicyCookieBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CachePolicyCookieBehavior
         */
        Builder cookieBehavior(String cookieBehavior);

        /**
         * <p>
         * Determines whether any cookies in viewer requests are included in the cache key and in requests that
         * CloudFront sends to the origin. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>none</code> – No cookies in viewer requests are included in the cache key or in requests that
         * CloudFront sends to the origin. Even when this field is set to <code>none</code>, any cookies that are listed
         * in an <code>OriginRequestPolicy</code> <i>are</i> included in origin requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>whitelist</code> – Only the cookies in viewer requests that are listed in the <code>CookieNames</code>
         * type are included in the cache key and in requests that CloudFront sends to the origin.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>allExcept</code> – All cookies in viewer requests are included in the cache key and in requests that
         * CloudFront sends to the origin, <i> <b>except</b> </i> for those that are listed in the
         * <code>CookieNames</code> type, which are not included.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>all</code> – All cookies in viewer requests are included in the cache key and in requests that
         * CloudFront sends to the origin.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cookieBehavior
         *        Determines whether any cookies in viewer requests are included in the cache key and in requests that
         *        CloudFront sends to the origin. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>none</code> – No cookies in viewer requests are included in the cache key or in requests that
         *        CloudFront sends to the origin. Even when this field is set to <code>none</code>, any cookies that are
         *        listed in an <code>OriginRequestPolicy</code> <i>are</i> included in origin requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>whitelist</code> – Only the cookies in viewer requests that are listed in the
         *        <code>CookieNames</code> type are included in the cache key and in requests that CloudFront sends to
         *        the origin.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>allExcept</code> – All cookies in viewer requests are included in the cache key and in requests
         *        that CloudFront sends to the origin, <i> <b>except</b> </i> for those that are listed in the
         *        <code>CookieNames</code> type, which are not included.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>all</code> – All cookies in viewer requests are included in the cache key and in requests that
         *        CloudFront sends to the origin.
         *        </p>
         *        </li>
         * @see CachePolicyCookieBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CachePolicyCookieBehavior
         */
        Builder cookieBehavior(CachePolicyCookieBehavior cookieBehavior);

        /**
         * Sets the value of the Cookies property for this object.
         *
         * @param cookies
         *        The new value for the Cookies property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cookies(CookieNames cookies);

        /**
         * Sets the value of the Cookies property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CookieNames.Builder} avoiding the need to
         * create one manually via {@link CookieNames#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CookieNames.Builder#build()} is called immediately and its result
         * is passed to {@link #cookies(CookieNames)}.
         * 
         * @param cookies
         *        a consumer that will call methods on {@link CookieNames.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cookies(CookieNames)
         */
        default Builder cookies(Consumer<CookieNames.Builder> cookies) {
            return cookies(CookieNames.builder().applyMutation(cookies).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String cookieBehavior;

        private CookieNames cookies;

        private BuilderImpl() {
        }

        private BuilderImpl(CachePolicyCookiesConfig model) {
            cookieBehavior(model.cookieBehavior);
            cookies(model.cookies);
        }

        public final String getCookieBehavior() {
            return cookieBehavior;
        }

        public final void setCookieBehavior(String cookieBehavior) {
            this.cookieBehavior = cookieBehavior;
        }

        @Override
        public final Builder cookieBehavior(String cookieBehavior) {
            this.cookieBehavior = cookieBehavior;
            return this;
        }

        @Override
        public final Builder cookieBehavior(CachePolicyCookieBehavior cookieBehavior) {
            this.cookieBehavior(cookieBehavior == null ? null : cookieBehavior.toString());
            return this;
        }

        public final CookieNames.Builder getCookies() {
            return cookies != null ? cookies.toBuilder() : null;
        }

        public final void setCookies(CookieNames.BuilderImpl cookies) {
            this.cookies = cookies != null ? cookies.build() : null;
        }

        @Override
        public final Builder cookies(CookieNames cookies) {
            this.cookies = cookies;
            return this;
        }

        @Override
        public CachePolicyCookiesConfig build() {
            return new CachePolicyCookiesConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
