/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration information about a CloudFront function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionConfig implements SdkPojo, Serializable, ToCopyableBuilder<FunctionConfig.Builder, FunctionConfig> {
    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(FunctionConfig::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final SdkField<String> RUNTIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Runtime")
            .getter(getter(FunctionConfig::runtimeAsString))
            .setter(setter(Builder::runtime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runtime")
                    .unmarshallLocationName("Runtime").build()).build();

    private static final SdkField<KeyValueStoreAssociations> KEY_VALUE_STORE_ASSOCIATIONS_FIELD = SdkField
            .<KeyValueStoreAssociations> builder(MarshallingType.SDK_POJO)
            .memberName("KeyValueStoreAssociations")
            .getter(getter(FunctionConfig::keyValueStoreAssociations))
            .setter(setter(Builder::keyValueStoreAssociations))
            .constructor(KeyValueStoreAssociations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyValueStoreAssociations")
                    .unmarshallLocationName("KeyValueStoreAssociations").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, RUNTIME_FIELD,
            KEY_VALUE_STORE_ASSOCIATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String comment;

    private final String runtime;

    private final KeyValueStoreAssociations keyValueStoreAssociations;

    private FunctionConfig(BuilderImpl builder) {
        this.comment = builder.comment;
        this.runtime = builder.runtime;
        this.keyValueStoreAssociations = builder.keyValueStoreAssociations;
    }

    /**
     * <p>
     * A comment to describe the function.
     * </p>
     * 
     * @return A comment to describe the function.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The function's runtime environment version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link FunctionRuntime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runtimeAsString}.
     * </p>
     * 
     * @return The function's runtime environment version.
     * @see FunctionRuntime
     */
    public final FunctionRuntime runtime() {
        return FunctionRuntime.fromValue(runtime);
    }

    /**
     * <p>
     * The function's runtime environment version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link FunctionRuntime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runtimeAsString}.
     * </p>
     * 
     * @return The function's runtime environment version.
     * @see FunctionRuntime
     */
    public final String runtimeAsString() {
        return runtime;
    }

    /**
     * <p>
     * The configuration for the Key Value Store associations.
     * </p>
     * 
     * @return The configuration for the Key Value Store associations.
     */
    public final KeyValueStoreAssociations keyValueStoreAssociations() {
        return keyValueStoreAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyValueStoreAssociations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionConfig)) {
            return false;
        }
        FunctionConfig other = (FunctionConfig) obj;
        return Objects.equals(comment(), other.comment()) && Objects.equals(runtimeAsString(), other.runtimeAsString())
                && Objects.equals(keyValueStoreAssociations(), other.keyValueStoreAssociations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunctionConfig").add("Comment", comment()).add("Runtime", runtimeAsString())
                .add("KeyValueStoreAssociations", keyValueStoreAssociations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "Runtime":
            return Optional.ofNullable(clazz.cast(runtimeAsString()));
        case "KeyValueStoreAssociations":
            return Optional.ofNullable(clazz.cast(keyValueStoreAssociations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionConfig, T> g) {
        return obj -> g.apply((FunctionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionConfig> {
        /**
         * <p>
         * A comment to describe the function.
         * </p>
         * 
         * @param comment
         *        A comment to describe the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The function's runtime environment version.
         * </p>
         * 
         * @param runtime
         *        The function's runtime environment version.
         * @see FunctionRuntime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionRuntime
         */
        Builder runtime(String runtime);

        /**
         * <p>
         * The function's runtime environment version.
         * </p>
         * 
         * @param runtime
         *        The function's runtime environment version.
         * @see FunctionRuntime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionRuntime
         */
        Builder runtime(FunctionRuntime runtime);

        /**
         * <p>
         * The configuration for the Key Value Store associations.
         * </p>
         * 
         * @param keyValueStoreAssociations
         *        The configuration for the Key Value Store associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyValueStoreAssociations(KeyValueStoreAssociations keyValueStoreAssociations);

        /**
         * <p>
         * The configuration for the Key Value Store associations.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyValueStoreAssociations.Builder}
         * avoiding the need to create one manually via {@link KeyValueStoreAssociations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyValueStoreAssociations.Builder#build()} is called immediately
         * and its result is passed to {@link #keyValueStoreAssociations(KeyValueStoreAssociations)}.
         * 
         * @param keyValueStoreAssociations
         *        a consumer that will call methods on {@link KeyValueStoreAssociations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyValueStoreAssociations(KeyValueStoreAssociations)
         */
        default Builder keyValueStoreAssociations(Consumer<KeyValueStoreAssociations.Builder> keyValueStoreAssociations) {
            return keyValueStoreAssociations(KeyValueStoreAssociations.builder().applyMutation(keyValueStoreAssociations).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String comment;

        private String runtime;

        private KeyValueStoreAssociations keyValueStoreAssociations;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionConfig model) {
            comment(model.comment);
            runtime(model.runtime);
            keyValueStoreAssociations(model.keyValueStoreAssociations);
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getRuntime() {
            return runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(FunctionRuntime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final KeyValueStoreAssociations.Builder getKeyValueStoreAssociations() {
            return keyValueStoreAssociations != null ? keyValueStoreAssociations.toBuilder() : null;
        }

        public final void setKeyValueStoreAssociations(KeyValueStoreAssociations.BuilderImpl keyValueStoreAssociations) {
            this.keyValueStoreAssociations = keyValueStoreAssociations != null ? keyValueStoreAssociations.build() : null;
        }

        @Override
        public final Builder keyValueStoreAssociations(KeyValueStoreAssociations keyValueStoreAssociations) {
            this.keyValueStoreAssociations = keyValueStoreAssociations;
            return this;
        }

        @Override
        public FunctionConfig build() {
            return new FunctionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
