/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Key Value Store. Use this to separate data from function code, allowing you to update data without having to
 * publish a new version of a function. The Key Value Store holds keys and their corresponding values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyValueStore implements SdkPojo, Serializable, ToCopyableBuilder<KeyValueStore.Builder, KeyValueStore> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(KeyValueStore::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(KeyValueStore::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(KeyValueStore::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ARN")
            .getter(getter(KeyValueStore::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").unmarshallLocationName("ARN")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(KeyValueStore::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(KeyValueStore::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            COMMENT_FIELD, ARN_FIELD, STATUS_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String id;

    private final String comment;

    private final String arn;

    private final String status;

    private final Instant lastModifiedTime;

    private KeyValueStore(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.comment = builder.comment;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The name of the Key Value Store.
     * </p>
     * 
     * @return The name of the Key Value Store.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique Id for the Key Value Store.
     * </p>
     * 
     * @return The unique Id for the Key Value Store.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A comment for the Key Value Store.
     * </p>
     * 
     * @return A comment for the Key Value Store.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Key Value Store.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Key Value Store.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the Key Value Store.
     * </p>
     * 
     * @return The status of the Key Value Store.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The last-modified time of the Key Value Store.
     * </p>
     * 
     * @return The last-modified time of the Key Value Store.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyValueStore)) {
            return false;
        }
        KeyValueStore other = (KeyValueStore) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id())
                && Objects.equals(comment(), other.comment()) && Objects.equals(arn(), other.arn())
                && Objects.equals(status(), other.status()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyValueStore").add("Name", name()).add("Id", id()).add("Comment", comment()).add("ARN", arn())
                .add("Status", status()).add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyValueStore, T> g) {
        return obj -> g.apply((KeyValueStore) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyValueStore> {
        /**
         * <p>
         * The name of the Key Value Store.
         * </p>
         * 
         * @param name
         *        The name of the Key Value Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique Id for the Key Value Store.
         * </p>
         * 
         * @param id
         *        The unique Id for the Key Value Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A comment for the Key Value Store.
         * </p>
         * 
         * @param comment
         *        A comment for the Key Value Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Key Value Store.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Key Value Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the Key Value Store.
         * </p>
         * 
         * @param status
         *        The status of the Key Value Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The last-modified time of the Key Value Store.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last-modified time of the Key Value Store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String id;

        private String comment;

        private String arn;

        private String status;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyValueStore model) {
            name(model.name);
            id(model.id);
            comment(model.comment);
            arn(model.arn);
            status(model.status);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public KeyValueStore build() {
            return new KeyValueStore(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
