/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfrontkeyvaluestore;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.paginators.ListKeysPublisher;

/**
 * Service client for accessing Amazon CloudFront KeyValueStore asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Amazon CloudFront KeyValueStore Service to View and Update Data in a KVS Resource
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CloudFrontKeyValueStoreAsyncClient extends AwsClient {
    String SERVICE_NAME = "cloudfront-keyvaluestore";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cloudfront-keyvaluestore";

    /**
     * <p>
     * Deletes the key value pair specified by the key.
     * </p>
     *
     * @param deleteKeyRequest
     * @return A Java Future containing the result of the DeleteKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Resource is not in expected state.</li>
     *         <li>ValidationException Validation failed.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ServiceQuotaExceededException Limit exceeded.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontKeyValueStoreException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CloudFrontKeyValueStoreAsyncClient.DeleteKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/DeleteKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteKeyResponse> deleteKey(DeleteKeyRequest deleteKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the key value pair specified by the key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKeyRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteKeyRequest#builder()}
     * </p>
     *
     * @param deleteKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DeleteKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Resource is not in expected state.</li>
     *         <li>ValidationException Validation failed.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ServiceQuotaExceededException Limit exceeded.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontKeyValueStoreException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CloudFrontKeyValueStoreAsyncClient.DeleteKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/DeleteKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteKeyResponse> deleteKey(Consumer<DeleteKeyRequest.Builder> deleteKeyRequest) {
        return deleteKey(DeleteKeyRequest.builder().applyMutation(deleteKeyRequest).build());
    }

    /**
     * <p>
     * Returns metadata information about Key Value Store.
     * </p>
     *
     * @param describeKeyValueStoreRequest
     * @return A Java Future containing the result of the DescribeKeyValueStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Resource is not in expected state.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontKeyValueStoreException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CloudFrontKeyValueStoreAsyncClient.DescribeKeyValueStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/DescribeKeyValueStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeKeyValueStoreResponse> describeKeyValueStore(
            DescribeKeyValueStoreRequest describeKeyValueStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata information about Key Value Store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeKeyValueStoreRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeKeyValueStoreRequest#builder()}
     * </p>
     *
     * @param describeKeyValueStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.DescribeKeyValueStoreRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeKeyValueStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Resource is not in expected state.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontKeyValueStoreException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CloudFrontKeyValueStoreAsyncClient.DescribeKeyValueStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/DescribeKeyValueStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeKeyValueStoreResponse> describeKeyValueStore(
            Consumer<DescribeKeyValueStoreRequest.Builder> describeKeyValueStoreRequest) {
        return describeKeyValueStore(DescribeKeyValueStoreRequest.builder().applyMutation(describeKeyValueStoreRequest).build());
    }

    /**
     * <p>
     * Returns a key value pair.
     * </p>
     *
     * @param getKeyRequest
     * @return A Java Future containing the result of the GetKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Resource is not in expected state.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontKeyValueStoreException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CloudFrontKeyValueStoreAsyncClient.GetKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/GetKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetKeyResponse> getKey(GetKeyRequest getKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a key value pair.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKeyRequest.Builder} avoiding the need to create
     * one manually via {@link GetKeyRequest#builder()}
     * </p>
     *
     * @param getKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.GetKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Resource is not in expected state.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontKeyValueStoreException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CloudFrontKeyValueStoreAsyncClient.GetKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/GetKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetKeyResponse> getKey(Consumer<GetKeyRequest.Builder> getKeyRequest) {
        return getKey(GetKeyRequest.builder().applyMutation(getKeyRequest).build());
    }

    /**
     * <p>
     * Returns a list of key value pairs.
     * </p>
     *
     * @param listKeysRequest
     * @return A Java Future containing the result of the ListKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Resource is not in expected state.</li>
     *         <li>ValidationException Validation failed.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontKeyValueStoreException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CloudFrontKeyValueStoreAsyncClient.ListKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/ListKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListKeysResponse> listKeys(ListKeysRequest listKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of key value pairs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListKeysRequest#builder()}
     * </p>
     *
     * @param listKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Resource is not in expected state.</li>
     *         <li>ValidationException Validation failed.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontKeyValueStoreException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CloudFrontKeyValueStoreAsyncClient.ListKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/ListKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListKeysResponse> listKeys(Consumer<ListKeysRequest.Builder> listKeysRequest) {
        return listKeys(ListKeysRequest.builder().applyMutation(listKeysRequest).build());
    }

    /**
     * <p>
     * Returns a list of key value pairs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKeys(software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudfrontkeyvaluestore.paginators.ListKeysPublisher publisher = client.listKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudfrontkeyvaluestore.paginators.ListKeysPublisher publisher = client.listKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeys(software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest)} operation.</b>
     * </p>
     *
     * @param listKeysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Resource is not in expected state.</li>
     *         <li>ValidationException Validation failed.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontKeyValueStoreException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CloudFrontKeyValueStoreAsyncClient.ListKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/ListKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeysPublisher listKeysPaginator(ListKeysRequest listKeysRequest) {
        return new ListKeysPublisher(this, listKeysRequest);
    }

    /**
     * <p>
     * Returns a list of key value pairs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKeys(software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudfrontkeyvaluestore.paginators.ListKeysPublisher publisher = client.listKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudfrontkeyvaluestore.paginators.ListKeysPublisher publisher = client.listKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeys(software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListKeysRequest#builder()}
     * </p>
     *
     * @param listKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Resource is not in expected state.</li>
     *         <li>ValidationException Validation failed.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontKeyValueStoreException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CloudFrontKeyValueStoreAsyncClient.ListKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/ListKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default ListKeysPublisher listKeysPaginator(Consumer<ListKeysRequest.Builder> listKeysRequest) {
        return listKeysPaginator(ListKeysRequest.builder().applyMutation(listKeysRequest).build());
    }

    /**
     * <p>
     * Creates a new key value pair or replaces the value of an existing key.
     * </p>
     *
     * @param putKeyRequest
     *        A key value pair.
     * @return A Java Future containing the result of the PutKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Resource is not in expected state.</li>
     *         <li>ValidationException Validation failed.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ServiceQuotaExceededException Limit exceeded.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontKeyValueStoreException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CloudFrontKeyValueStoreAsyncClient.PutKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/PutKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutKeyResponse> putKey(PutKeyRequest putKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new key value pair or replaces the value of an existing key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutKeyRequest.Builder} avoiding the need to create
     * one manually via {@link PutKeyRequest#builder()}
     * </p>
     *
     * @param putKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.PutKeyRequest.Builder} to create a
     *        request. A key value pair.
     * @return A Java Future containing the result of the PutKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Resource is not in expected state.</li>
     *         <li>ValidationException Validation failed.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ServiceQuotaExceededException Limit exceeded.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontKeyValueStoreException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CloudFrontKeyValueStoreAsyncClient.PutKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/PutKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutKeyResponse> putKey(Consumer<PutKeyRequest.Builder> putKeyRequest) {
        return putKey(PutKeyRequest.builder().applyMutation(putKeyRequest).build());
    }

    /**
     * <p>
     * Puts or Deletes multiple key value pairs in a single, all-or-nothing operation.
     * </p>
     *
     * @param updateKeysRequest
     * @return A Java Future containing the result of the UpdateKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Resource is not in expected state.</li>
     *         <li>ValidationException Validation failed.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ServiceQuotaExceededException Limit exceeded.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontKeyValueStoreException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CloudFrontKeyValueStoreAsyncClient.UpdateKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/UpdateKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateKeysResponse> updateKeys(UpdateKeysRequest updateKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Puts or Deletes multiple key value pairs in a single, all-or-nothing operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateKeysRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateKeysRequest#builder()}
     * </p>
     *
     * @param updateKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.UpdateKeysRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Resource is not in expected state.</li>
     *         <li>ValidationException Validation failed.</li>
     *         <li>InternalServerException Internal server error.</li>
     *         <li>ServiceQuotaExceededException Limit exceeded.</li>
     *         <li>ResourceNotFoundException Resource was not found.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontKeyValueStoreException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample CloudFrontKeyValueStoreAsyncClient.UpdateKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-keyvaluestore-2022-07-26/UpdateKeys"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateKeysResponse> updateKeys(Consumer<UpdateKeysRequest.Builder> updateKeysRequest) {
        return updateKeys(UpdateKeysRequest.builder().applyMutation(updateKeysRequest).build());
    }

    @Override
    default CloudFrontKeyValueStoreServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link CloudFrontKeyValueStoreAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudFrontKeyValueStoreAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudFrontKeyValueStoreAsyncClient}.
     */
    static CloudFrontKeyValueStoreAsyncClientBuilder builder() {
        return new DefaultCloudFrontKeyValueStoreAsyncClientBuilder();
    }
}
