/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code><a>DescribeIndexFields</a></code> operation. Specifies the name of the
 * domain you want to describe. To restrict the response to particular index fields, specify the names of the index
 * fields you want to describe. To show the active configuration and exclude any pending changes, set the
 * <code>Deployed</code> option to <code>true</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIndexFieldsRequest extends CloudSearchRequest implements
        ToCopyableBuilder<DescribeIndexFieldsRequest.Builder, DescribeIndexFieldsRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DescribeIndexFieldsRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<List<String>> FIELD_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FieldNames")
            .getter(getter(DescribeIndexFieldsRequest::fieldNames))
            .setter(setter(Builder::fieldNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DEPLOYED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Deployed").getter(getter(DescribeIndexFieldsRequest::deployed)).setter(setter(Builder::deployed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deployed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            FIELD_NAMES_FIELD, DEPLOYED_FIELD));

    private final String domainName;

    private final List<String> fieldNames;

    private final Boolean deployed;

    private DescribeIndexFieldsRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.fieldNames = builder.fieldNames;
        this.deployed = builder.deployed;
    }

    /**
     * <p>
     * The name of the domain you want to describe.
     * </p>
     * 
     * @return The name of the domain you want to describe.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldNames property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFieldNames() {
        return fieldNames != null && !(fieldNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the index fields you want to describe. If not specified, information is returned for all configured
     * index fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldNames} method.
     * </p>
     * 
     * @return A list of the index fields you want to describe. If not specified, information is returned for all
     *         configured index fields.
     */
    public final List<String> fieldNames() {
        return fieldNames;
    }

    /**
     * <p>
     * Whether to display the deployed configuration (<code>true</code>) or include any pending changes (
     * <code>false</code>). Defaults to <code>false</code>.
     * </p>
     * 
     * @return Whether to display the deployed configuration (<code>true</code>) or include any pending changes (
     *         <code>false</code>). Defaults to <code>false</code>.
     */
    public final Boolean deployed() {
        return deployed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldNames() ? fieldNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deployed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIndexFieldsRequest)) {
            return false;
        }
        DescribeIndexFieldsRequest other = (DescribeIndexFieldsRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && hasFieldNames() == other.hasFieldNames()
                && Objects.equals(fieldNames(), other.fieldNames()) && Objects.equals(deployed(), other.deployed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIndexFieldsRequest").add("DomainName", domainName())
                .add("FieldNames", hasFieldNames() ? fieldNames() : null).add("Deployed", deployed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "FieldNames":
            return Optional.ofNullable(clazz.cast(fieldNames()));
        case "Deployed":
            return Optional.ofNullable(clazz.cast(deployed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIndexFieldsRequest, T> g) {
        return obj -> g.apply((DescribeIndexFieldsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIndexFieldsRequest> {
        /**
         * <p>
         * The name of the domain you want to describe.
         * </p>
         * 
         * @param domainName
         *        The name of the domain you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A list of the index fields you want to describe. If not specified, information is returned for all configured
         * index fields.
         * </p>
         * 
         * @param fieldNames
         *        A list of the index fields you want to describe. If not specified, information is returned for all
         *        configured index fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldNames(Collection<String> fieldNames);

        /**
         * <p>
         * A list of the index fields you want to describe. If not specified, information is returned for all configured
         * index fields.
         * </p>
         * 
         * @param fieldNames
         *        A list of the index fields you want to describe. If not specified, information is returned for all
         *        configured index fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldNames(String... fieldNames);

        /**
         * <p>
         * Whether to display the deployed configuration (<code>true</code>) or include any pending changes (
         * <code>false</code>). Defaults to <code>false</code>.
         * </p>
         * 
         * @param deployed
         *        Whether to display the deployed configuration (<code>true</code>) or include any pending changes (
         *        <code>false</code>). Defaults to <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployed(Boolean deployed);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudSearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private List<String> fieldNames = DefaultSdkAutoConstructList.getInstance();

        private Boolean deployed;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIndexFieldsRequest model) {
            super(model);
            domainName(model.domainName);
            fieldNames(model.fieldNames);
            deployed(model.deployed);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Collection<String> getFieldNames() {
            if (fieldNames instanceof SdkAutoConstructList) {
                return null;
            }
            return fieldNames;
        }

        public final void setFieldNames(Collection<String> fieldNames) {
            this.fieldNames = DynamicFieldNameListCopier.copy(fieldNames);
        }

        @Override
        public final Builder fieldNames(Collection<String> fieldNames) {
            this.fieldNames = DynamicFieldNameListCopier.copy(fieldNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldNames(String... fieldNames) {
            fieldNames(Arrays.asList(fieldNames));
            return this;
        }

        public final Boolean getDeployed() {
            return deployed;
        }

        public final void setDeployed(Boolean deployed) {
            this.deployed = deployed;
        }

        @Override
        public final Builder deployed(Boolean deployed) {
            this.deployed = deployed;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeIndexFieldsRequest build() {
            return new DescribeIndexFieldsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
