/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.cloudtrail.model.AddTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.AddTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.CancelQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.CancelQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminResponse;
import software.amazon.awssdk.services.cloudtrail.model.DescribeQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.DescribeQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.RegisterOrganizationDelegatedAdminRequest;
import software.amazon.awssdk.services.cloudtrail.model.RegisterOrganizationDelegatedAdminResponse;
import software.amazon.awssdk.services.cloudtrail.model.RemoveTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.RemoveTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.RestoreEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.RestoreEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartLoggingRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartLoggingResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopLoggingRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopLoggingResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateTrailResponse;
import software.amazon.awssdk.services.cloudtrail.paginators.GetQueryResultsPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListChannelsPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListEventDataStoresPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListImportFailuresPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListImportsPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListPublicKeysPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListQueriesPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListTagsPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.ListTrailsPublisher;
import software.amazon.awssdk.services.cloudtrail.paginators.LookupEventsPublisher;

/**
 * Service client for accessing CloudTrail asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>CloudTrail</fullname>
 * <p>
 * This is the CloudTrail API Reference. It provides descriptions of actions, data types, common parameters, and common
 * errors for CloudTrail.
 * </p>
 * <p>
 * CloudTrail is a web service that records Amazon Web Services API calls for your Amazon Web Services account and
 * delivers log files to an Amazon S3 bucket. The recorded information includes the identity of the user, the start time
 * of the Amazon Web Services API call, the source IP address, the request parameters, and the response elements
 * returned by the service.
 * </p>
 * <note>
 * <p>
 * As an alternative to the API, you can use one of the Amazon Web Services SDKs, which consist of libraries and sample
 * code for various programming languages and platforms (Java, Ruby, .NET, iOS, Android, etc.). The SDKs provide
 * programmatic access to CloudTrail. For example, the SDKs handle cryptographically signing requests, managing errors,
 * and retrying requests automatically. For more information about the Amazon Web Services SDKs, including how to
 * download and install them, see <a href="http://aws.amazon.com/tools/">Tools to Build on Amazon Web Services</a>.
 * </p>
 * </note>
 * <p>
 * See the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-user-guide.html">CloudTrail
 * User Guide</a> for information about the data that is included with each Amazon Web Services API call listed in the
 * log files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CloudTrailAsyncClient extends SdkClient {
    String SERVICE_NAME = "cloudtrail";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cloudtrail";

    /**
     * Create a {@link CloudTrailAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudTrailAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudTrailAsyncClient}.
     */
    static CloudTrailAsyncClientBuilder builder() {
        return new DefaultCloudTrailAsyncClientBuilder();
    }

    /**
     * <p>
     * Adds one or more tags to a trail or event data store, up to a limit of 50. Overwrites an existing tag's value
     * when a new value is specified for an existing tag key. Tag key names must be unique for a trail; you cannot have
     * two keys with the same name but different values. If you specify a key without a value, the tag will be created
     * with the specified key and a value of null. You can tag a trail or event data store that applies to all Amazon
     * Web Services Regions only from the Region in which the trail or event data store was created (also known as its
     * home region).
     * </p>
     *
     * @param addTagsRequest
     *        Specifies the tags to add to a trail or event data store.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with a trail ARN
     *         that is not valid. The following is the format of a trail ARN.</p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code></li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>TagsLimitExceededException The number of tags per trail has exceeded the permitted amount. Currently,
     *         the limit is 50.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource. If this exception occurs, wait a few minutes, and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to a trail or event data store, up to a limit of 50. Overwrites an existing tag's value
     * when a new value is specified for an existing tag key. Tag key names must be unique for a trail; you cannot have
     * two keys with the same name but different values. If you specify a key without a value, the tag will be created
     * with the specified key and a value of null. You can tag a trail or event data store that applies to all Amazon
     * Web Services Regions only from the Region in which the trail or event data store was created (also known as its
     * home region).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsRequest.Builder} avoiding the need to create
     * one manually via {@link AddTagsRequest#builder()}
     * </p>
     *
     * @param addTagsRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsRequest.Builder} to create a request. Specifies
     *        the tags to add to a trail or event data store.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with a trail ARN
     *         that is not valid. The following is the format of a trail ARN.</p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code></li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>TagsLimitExceededException The number of tags per trail has exceeded the permitted amount. Currently,
     *         the limit is 50.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource. If this exception occurs, wait a few minutes, and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsResponse> addTags(Consumer<AddTagsRequest.Builder> addTagsRequest) {
        return addTags(AddTagsRequest.builder().applyMutation(addTagsRequest).build());
    }

    /**
     * <p>
     * Cancels a query if the query is not in a terminated state, such as <code>CANCELLED</code>, <code>FAILED</code>,
     * <code>TIMED_OUT</code>, or <code>FINISHED</code>. You must specify an ARN value for <code>EventDataStore</code>.
     * The ID of the query that you want to cancel is also required. When you run <code>CancelQuery</code>, the query
     * status might show as <code>CANCELLED</code> even if the operation is not yet finished.
     * </p>
     *
     * @param cancelQueryRequest
     * @return A Java Future containing the result of the CancelQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InactiveQueryException The specified query cannot be canceled because it is in the
     *         <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code> state.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource. If this exception occurs, wait a few minutes, and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CancelQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CancelQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelQueryResponse> cancelQuery(CancelQueryRequest cancelQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a query if the query is not in a terminated state, such as <code>CANCELLED</code>, <code>FAILED</code>,
     * <code>TIMED_OUT</code>, or <code>FINISHED</code>. You must specify an ARN value for <code>EventDataStore</code>.
     * The ID of the query that you want to cancel is also required. When you run <code>CancelQuery</code>, the query
     * status might show as <code>CANCELLED</code> even if the operation is not yet finished.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelQueryRequest.Builder} avoiding the need to
     * create one manually via {@link CancelQueryRequest#builder()}
     * </p>
     *
     * @param cancelQueryRequest
     *        A {@link Consumer} that will call methods on {@link CancelQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InactiveQueryException The specified query cannot be canceled because it is in the
     *         <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or <code>CANCELLED</code> state.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource. If this exception occurs, wait a few minutes, and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CancelQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CancelQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelQueryResponse> cancelQuery(Consumer<CancelQueryRequest.Builder> cancelQueryRequest) {
        return cancelQuery(CancelQueryRequest.builder().applyMutation(cancelQueryRequest).build());
    }

    /**
     * <p>
     * Creates a new event data store.
     * </p>
     *
     * @param createEventDataStoreRequest
     * @return A Java Future containing the result of the CreateEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreAlreadyExistsException An event data store with that name already exists.</li>
     *         <li>EventDataStoreMaxLimitExceededException Your account has used the maximum number of event data
     *         stores.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource. If this exception occurs, wait a few minutes, and then try the operation again.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CreateEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventDataStoreResponse> createEventDataStore(
            CreateEventDataStoreRequest createEventDataStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new event data store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventDataStoreRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEventDataStoreRequest#builder()}
     * </p>
     *
     * @param createEventDataStoreRequest
     *        A {@link Consumer} that will call methods on {@link CreateEventDataStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreAlreadyExistsException An event data store with that name already exists.</li>
     *         <li>EventDataStoreMaxLimitExceededException Your account has used the maximum number of event data
     *         stores.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource. If this exception occurs, wait a few minutes, and then try the operation again.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CreateEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventDataStoreResponse> createEventDataStore(
            Consumer<CreateEventDataStoreRequest.Builder> createEventDataStoreRequest) {
        return createEventDataStore(CreateEventDataStoreRequest.builder().applyMutation(createEventDataStoreRequest).build());
    }

    /**
     * <p>
     * Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
     * </p>
     *
     * @param createTrailRequest
     *        Specifies the settings for each trail.
     * @return A Java Future containing the result of the CreateTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaximumNumberOfTrailsExceededException This exception is thrown when the maximum number of trails is
     *         reached.</li>
     *         <li>TrailAlreadyExistsException This exception is thrown when the specified trail already exists.</li>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>InsufficientSnsTopicPolicyException This exception is thrown when the policy on the Amazon SNS topic
     *         is not sufficient.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>InvalidS3BucketNameException This exception is thrown when the provided S3 bucket name is not valid.</li>
     *         <li>InvalidS3PrefixException This exception is thrown when the provided S3 prefix is not valid.</li>
     *         <li>InvalidSnsTopicNameException This exception is thrown when the provided SNS topic name is not valid.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>TrailNotProvidedException This exception is no longer in use.</li>
     *         <li>InvalidParameterCombinationException This exception is thrown when the combination of parameters
     *         provided is not valid.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>InvalidCloudWatchLogsLogGroupArnException This exception is thrown when the provided CloudWatch Logs
     *         log group is not valid.</li>
     *         <li>InvalidCloudWatchLogsRoleArnException This exception is thrown when the provided role is not valid.</li>
     *         <li>CloudWatchLogsDeliveryUnavailableException Cannot set a CloudWatch Logs delivery for this region.</li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>CloudTrailInvalidClientTokenIdException This exception is thrown when a call results in the
     *         <code>InvalidClientTokenId</code> error code. This can occur when you are creating or updating a trail to
     *         send notifications to an Amazon SNS topic that is in a suspended Amazon Web Services account.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource. If this exception occurs, wait a few minutes, and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CreateTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateTrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTrailResponse> createTrail(CreateTrailRequest createTrailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrailRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTrailRequest#builder()}
     * </p>
     *
     * @param createTrailRequest
     *        A {@link Consumer} that will call methods on {@link CreateTrailRequest.Builder} to create a request.
     *        Specifies the settings for each trail.
     * @return A Java Future containing the result of the CreateTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MaximumNumberOfTrailsExceededException This exception is thrown when the maximum number of trails is
     *         reached.</li>
     *         <li>TrailAlreadyExistsException This exception is thrown when the specified trail already exists.</li>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>InsufficientSnsTopicPolicyException This exception is thrown when the policy on the Amazon SNS topic
     *         is not sufficient.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>InvalidS3BucketNameException This exception is thrown when the provided S3 bucket name is not valid.</li>
     *         <li>InvalidS3PrefixException This exception is thrown when the provided S3 prefix is not valid.</li>
     *         <li>InvalidSnsTopicNameException This exception is thrown when the provided SNS topic name is not valid.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>TrailNotProvidedException This exception is no longer in use.</li>
     *         <li>InvalidParameterCombinationException This exception is thrown when the combination of parameters
     *         provided is not valid.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>InvalidCloudWatchLogsLogGroupArnException This exception is thrown when the provided CloudWatch Logs
     *         log group is not valid.</li>
     *         <li>InvalidCloudWatchLogsRoleArnException This exception is thrown when the provided role is not valid.</li>
     *         <li>CloudWatchLogsDeliveryUnavailableException Cannot set a CloudWatch Logs delivery for this region.</li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>CloudTrailInvalidClientTokenIdException This exception is thrown when a call results in the
     *         <code>InvalidClientTokenId</code> error code. This can occur when you are creating or updating a trail to
     *         send notifications to an Amazon SNS topic that is in a suspended Amazon Web Services account.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource. If this exception occurs, wait a few minutes, and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.CreateTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateTrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTrailResponse> createTrail(Consumer<CreateTrailRequest.Builder> createTrailRequest) {
        return createTrail(CreateTrailRequest.builder().applyMutation(createTrailRequest).build());
    }

    /**
     * <p>
     * Disables the event data store specified by <code>EventDataStore</code>, which accepts an event data store ARN.
     * After you run <code>DeleteEventDataStore</code>, the event data store enters a <code>PENDING_DELETION</code>
     * state, and is automatically deleted after a wait period of seven days. <code>TerminationProtectionEnabled</code>
     * must be set to <code>False</code> on the event data store; this operation cannot work if
     * <code>TerminationProtectionEnabled</code> is <code>True</code>.
     * </p>
     * <p>
     * After you run <code>DeleteEventDataStore</code> on an event data store, you cannot run <code>ListQueries</code>,
     * <code>DescribeQuery</code>, or <code>GetQueryResults</code> on queries that are using an event data store in a
     * <code>PENDING_DELETION</code> state. An event data store in the <code>PENDING_DELETION</code> state does not
     * incur costs.
     * </p>
     *
     * @param deleteEventDataStoreRequest
     * @return A Java Future containing the result of the DeleteEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>EventDataStoreTerminationProtectedException The event data store cannot be deleted because
     *         termination protection is enabled for it.</li>
     *         <li>EventDataStoreHasOngoingImportException This exception is thrown when you try to update or delete an
     *         event data store that currently has an import in progress.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventDataStoreResponse> deleteEventDataStore(
            DeleteEventDataStoreRequest deleteEventDataStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the event data store specified by <code>EventDataStore</code>, which accepts an event data store ARN.
     * After you run <code>DeleteEventDataStore</code>, the event data store enters a <code>PENDING_DELETION</code>
     * state, and is automatically deleted after a wait period of seven days. <code>TerminationProtectionEnabled</code>
     * must be set to <code>False</code> on the event data store; this operation cannot work if
     * <code>TerminationProtectionEnabled</code> is <code>True</code>.
     * </p>
     * <p>
     * After you run <code>DeleteEventDataStore</code> on an event data store, you cannot run <code>ListQueries</code>,
     * <code>DescribeQuery</code>, or <code>GetQueryResults</code> on queries that are using an event data store in a
     * <code>PENDING_DELETION</code> state. An event data store in the <code>PENDING_DELETION</code> state does not
     * incur costs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventDataStoreRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEventDataStoreRequest#builder()}
     * </p>
     *
     * @param deleteEventDataStoreRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventDataStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>EventDataStoreTerminationProtectedException The event data store cannot be deleted because
     *         termination protection is enabled for it.</li>
     *         <li>EventDataStoreHasOngoingImportException This exception is thrown when you try to update or delete an
     *         event data store that currently has an import in progress.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventDataStoreResponse> deleteEventDataStore(
            Consumer<DeleteEventDataStoreRequest.Builder> deleteEventDataStoreRequest) {
        return deleteEventDataStore(DeleteEventDataStoreRequest.builder().applyMutation(deleteEventDataStoreRequest).build());
    }

    /**
     * <p>
     * Deletes a trail. This operation must be called from the region in which the trail was created.
     * <code>DeleteTrail</code> cannot be called on the shadow trails (replicated trails in other regions) of a trail
     * that is enabled in all regions.
     * </p>
     *
     * @param deleteTrailRequest
     *        The request that specifies the name of a trail to delete.
     * @return A Java Future containing the result of the DeleteTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         region other than the region in which the trail was created.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource. If this exception occurs, wait a few minutes, and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteTrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTrailResponse> deleteTrail(DeleteTrailRequest deleteTrailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a trail. This operation must be called from the region in which the trail was created.
     * <code>DeleteTrail</code> cannot be called on the shadow trails (replicated trails in other regions) of a trail
     * that is enabled in all regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrailRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTrailRequest#builder()}
     * </p>
     *
     * @param deleteTrailRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTrailRequest.Builder} to create a request. The
     *        request that specifies the name of a trail to delete.
     * @return A Java Future containing the result of the DeleteTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         region other than the region in which the trail was created.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>ConflictException This exception is thrown when the specified resource is not ready for an operation.
     *         This can occur when you try to run an operation on a resource before CloudTrail has time to fully load
     *         the resource. If this exception occurs, wait a few minutes, and then try the operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeleteTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteTrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTrailResponse> deleteTrail(Consumer<DeleteTrailRequest.Builder> deleteTrailRequest) {
        return deleteTrail(DeleteTrailRequest.builder().applyMutation(deleteTrailRequest).build());
    }

    /**
     * <p>
     * Removes CloudTrail delegated administrator permissions from a member account in an organization.
     * </p>
     *
     * @param deregisterOrganizationDelegatedAdminRequest
     *        Removes CloudTrail delegated administrator permissions from a specified member account in an organization
     *        that is currently designated as a delegated administrator.
     * @return A Java Future containing the result of the DeregisterOrganizationDelegatedAdmin operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccountNotFoundException This exception is thrown when when the specified account is not found or not
     *         part of an organization.</li>
     *         <li>AccountNotRegisteredException This exception is thrown when the specified account is not registered
     *         as the CloudTrail delegated administrator.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>NotOrganizationManagementAccountException This exception is thrown when the account making the
     *         request is not the organization's management account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeregisterOrganizationDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeregisterOrganizationDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterOrganizationDelegatedAdminResponse> deregisterOrganizationDelegatedAdmin(
            DeregisterOrganizationDelegatedAdminRequest deregisterOrganizationDelegatedAdminRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes CloudTrail delegated administrator permissions from a member account in an organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeregisterOrganizationDelegatedAdminRequest.Builder} avoiding the need to create one manually via
     * {@link DeregisterOrganizationDelegatedAdminRequest#builder()}
     * </p>
     *
     * @param deregisterOrganizationDelegatedAdminRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterOrganizationDelegatedAdminRequest.Builder}
     *        to create a request. Removes CloudTrail delegated administrator permissions from a specified member
     *        account in an organization that is currently designated as a delegated administrator.
     * @return A Java Future containing the result of the DeregisterOrganizationDelegatedAdmin operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccountNotFoundException This exception is thrown when when the specified account is not found or not
     *         part of an organization.</li>
     *         <li>AccountNotRegisteredException This exception is thrown when the specified account is not registered
     *         as the CloudTrail delegated administrator.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>NotOrganizationManagementAccountException This exception is thrown when the account making the
     *         request is not the organization's management account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DeregisterOrganizationDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeregisterOrganizationDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterOrganizationDelegatedAdminResponse> deregisterOrganizationDelegatedAdmin(
            Consumer<DeregisterOrganizationDelegatedAdminRequest.Builder> deregisterOrganizationDelegatedAdminRequest) {
        return deregisterOrganizationDelegatedAdmin(DeregisterOrganizationDelegatedAdminRequest.builder()
                .applyMutation(deregisterOrganizationDelegatedAdminRequest).build());
    }

    /**
     * <p>
     * Returns metadata about a query, including query run time in milliseconds, number of events scanned and matched,
     * and query status. You must specify an ARN for <code>EventDataStore</code>, and a value for <code>QueryID</code>.
     * </p>
     *
     * @param describeQueryRequest
     * @return A Java Future containing the result of the DescribeQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DescribeQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeQueryResponse> describeQuery(DescribeQueryRequest describeQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about a query, including query run time in milliseconds, number of events scanned and matched,
     * and query status. You must specify an ARN for <code>EventDataStore</code>, and a value for <code>QueryID</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeQueryRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeQueryRequest#builder()}
     * </p>
     *
     * @param describeQueryRequest
     *        A {@link Consumer} that will call methods on {@link DescribeQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DescribeQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeQueryResponse> describeQuery(Consumer<DescribeQueryRequest.Builder> describeQueryRequest) {
        return describeQuery(DescribeQueryRequest.builder().applyMutation(describeQueryRequest).build());
    }

    /**
     * <p>
     * Retrieves settings for one or more trails associated with the current region for your account.
     * </p>
     *
     * @param describeTrailsRequest
     *        Returns information about the trail.
     * @return A Java Future containing the result of the DescribeTrails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DescribeTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeTrails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTrailsResponse> describeTrails(DescribeTrailsRequest describeTrailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves settings for one or more trails associated with the current region for your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrailsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTrailsRequest#builder()}
     * </p>
     *
     * @param describeTrailsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTrailsRequest.Builder} to create a request.
     *        Returns information about the trail.
     * @return A Java Future containing the result of the DescribeTrails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DescribeTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeTrails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTrailsResponse> describeTrails(Consumer<DescribeTrailsRequest.Builder> describeTrailsRequest) {
        return describeTrails(DescribeTrailsRequest.builder().applyMutation(describeTrailsRequest).build());
    }

    /**
     * <p>
     * Retrieves settings for one or more trails associated with the current region for your account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeTrails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.DescribeTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeTrails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTrailsResponse> describeTrails() {
        return describeTrails(DescribeTrailsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about a specific channel. Amazon Web Services services create service-linked channels to get
     * information about CloudTrail events on your behalf. For more information about service-linked channels, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/viewing-service-linked-channels.html">Viewing
     * service-linked channels for CloudTrail by using the CLI</a>.
     * </p>
     *
     * @param getChannelRequest
     * @return A Java Future containing the result of the GetChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ChannelNotFoundException The specified channel was not found.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetChannelResponse> getChannel(GetChannelRequest getChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific channel. Amazon Web Services services create service-linked channels to get
     * information about CloudTrail events on your behalf. For more information about service-linked channels, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/viewing-service-linked-channels.html">Viewing
     * service-linked channels for CloudTrail by using the CLI</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelRequest.Builder} avoiding the need to
     * create one manually via {@link GetChannelRequest#builder()}
     * </p>
     *
     * @param getChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ChannelArnInvalidException This exception is thrown when the specified value of
     *         <code>ChannelARN</code> is not valid.</li>
     *         <li>ChannelNotFoundException The specified channel was not found.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetChannelResponse> getChannel(Consumer<GetChannelRequest.Builder> getChannelRequest) {
        return getChannel(GetChannelRequest.builder().applyMutation(getChannelRequest).build());
    }

    /**
     * <p>
     * Returns information about an event data store specified as either an ARN or the ID portion of the ARN.
     * </p>
     *
     * @param getEventDataStoreRequest
     * @return A Java Future containing the result of the GetEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventDataStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventDataStoreResponse> getEventDataStore(GetEventDataStoreRequest getEventDataStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an event data store specified as either an ARN or the ID portion of the ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventDataStoreRequest.Builder} avoiding the need
     * to create one manually via {@link GetEventDataStoreRequest#builder()}
     * </p>
     *
     * @param getEventDataStoreRequest
     *        A {@link Consumer} that will call methods on {@link GetEventDataStoreRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventDataStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventDataStoreResponse> getEventDataStore(
            Consumer<GetEventDataStoreRequest.Builder> getEventDataStoreRequest) {
        return getEventDataStore(GetEventDataStoreRequest.builder().applyMutation(getEventDataStoreRequest).build());
    }

    /**
     * <p>
     * Describes the settings for the event selectors that you configured for your trail. The information returned for
     * your event selectors includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If your event selector includes read-only events, write-only events, or all events. This applies to both
     * management events and data events.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your event selector includes management events.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your event selector includes data events, the resources on which you are logging data events.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about logging management and data events, see the following topics in the <i>CloudTrail User
     * Guide</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html"
     * >Logging management events for trails </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">
     * Logging data events for trails </a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getEventSelectorsRequest
     * @return A Java Future containing the result of the GetEventSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetEventSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventSelectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventSelectorsResponse> getEventSelectors(GetEventSelectorsRequest getEventSelectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the settings for the event selectors that you configured for your trail. The information returned for
     * your event selectors includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If your event selector includes read-only events, write-only events, or all events. This applies to both
     * management events and data events.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your event selector includes management events.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your event selector includes data events, the resources on which you are logging data events.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about logging management and data events, see the following topics in the <i>CloudTrail User
     * Guide</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html"
     * >Logging management events for trails </a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">
     * Logging data events for trails </a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventSelectorsRequest.Builder} avoiding the need
     * to create one manually via {@link GetEventSelectorsRequest#builder()}
     * </p>
     *
     * @param getEventSelectorsRequest
     *        A {@link Consumer} that will call methods on {@link GetEventSelectorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEventSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetEventSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventSelectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventSelectorsResponse> getEventSelectors(
            Consumer<GetEventSelectorsRequest.Builder> getEventSelectorsRequest) {
        return getEventSelectors(GetEventSelectorsRequest.builder().applyMutation(getEventSelectorsRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific import.
     * </p>
     *
     * @param getImportRequest
     * @return A Java Future containing the result of the GetImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetImportResponse> getImport(GetImportRequest getImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImportRequest.Builder} avoiding the need to
     * create one manually via {@link GetImportRequest#builder()}
     * </p>
     *
     * @param getImportRequest
     *        A {@link Consumer} that will call methods on {@link GetImportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetImportResponse> getImport(Consumer<GetImportRequest.Builder> getImportRequest) {
        return getImport(GetImportRequest.builder().applyMutation(getImportRequest).build());
    }

    /**
     * <p>
     * Describes the settings for the Insights event selectors that you configured for your trail.
     * <code>GetInsightSelectors</code> shows if CloudTrail Insights event logging is enabled on the trail, and if it
     * is, which insight types are enabled. If you run <code>GetInsightSelectors</code> on a trail that does not have
     * Insights events enabled, the operation throws the exception <code>InsightNotEnabledException</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html"
     * >Logging CloudTrail Insights Events for Trails </a> in the <i>CloudTrail User Guide</i>.
     * </p>
     *
     * @param getInsightSelectorsRequest
     * @return A Java Future containing the result of the GetInsightSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InsightNotEnabledException If you run <code>GetInsightSelectors</code> on a trail that does not have
     *         Insights events enabled, the operation throws the exception <code>InsightNotEnabledException</code>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetInsightSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetInsightSelectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInsightSelectorsResponse> getInsightSelectors(
            GetInsightSelectorsRequest getInsightSelectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the settings for the Insights event selectors that you configured for your trail.
     * <code>GetInsightSelectors</code> shows if CloudTrail Insights event logging is enabled on the trail, and if it
     * is, which insight types are enabled. If you run <code>GetInsightSelectors</code> on a trail that does not have
     * Insights events enabled, the operation throws the exception <code>InsightNotEnabledException</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html"
     * >Logging CloudTrail Insights Events for Trails </a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightSelectorsRequest.Builder} avoiding the
     * need to create one manually via {@link GetInsightSelectorsRequest#builder()}
     * </p>
     *
     * @param getInsightSelectorsRequest
     *        A {@link Consumer} that will call methods on {@link GetInsightSelectorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInsightSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InsightNotEnabledException If you run <code>GetInsightSelectors</code> on a trail that does not have
     *         Insights events enabled, the operation throws the exception <code>InsightNotEnabledException</code>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetInsightSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetInsightSelectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInsightSelectorsResponse> getInsightSelectors(
            Consumer<GetInsightSelectorsRequest.Builder> getInsightSelectorsRequest) {
        return getInsightSelectors(GetInsightSelectorsRequest.builder().applyMutation(getInsightSelectorsRequest).build());
    }

    /**
     * <p>
     * Gets event data results of a query. You must specify the <code>QueryID</code> value returned by the
     * <code>StartQuery</code> operation, and an ARN for <code>EventDataStore</code>.
     * </p>
     *
     * @param getQueryResultsRequest
     * @return A Java Future containing the result of the GetQueryResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetQueryResults" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetQueryResultsResponse> getQueryResults(GetQueryResultsRequest getQueryResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets event data results of a query. You must specify the <code>QueryID</code> value returned by the
     * <code>StartQuery</code> operation, and an ARN for <code>EventDataStore</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueryResultsRequest.Builder} avoiding the need
     * to create one manually via {@link GetQueryResultsRequest#builder()}
     * </p>
     *
     * @param getQueryResultsRequest
     *        A {@link Consumer} that will call methods on {@link GetQueryResultsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetQueryResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetQueryResults" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetQueryResultsResponse> getQueryResults(
            Consumer<GetQueryResultsRequest.Builder> getQueryResultsRequest) {
        return getQueryResults(GetQueryResultsRequest.builder().applyMutation(getQueryResultsRequest).build());
    }

    /**
     * <p>
     * Gets event data results of a query. You must specify the <code>QueryID</code> value returned by the
     * <code>StartQuery</code> operation, and an ARN for <code>EventDataStore</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getQueryResults(software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.GetQueryResultsPublisher publisher = client.getQueryResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.GetQueryResultsPublisher publisher = client.getQueryResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResults(software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest)} operation.</b>
     * </p>
     *
     * @param getQueryResultsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetQueryResults" target="_top">AWS
     *      API Documentation</a>
     */
    default GetQueryResultsPublisher getQueryResultsPaginator(GetQueryResultsRequest getQueryResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets event data results of a query. You must specify the <code>QueryID</code> value returned by the
     * <code>StartQuery</code> operation, and an ARN for <code>EventDataStore</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getQueryResults(software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.GetQueryResultsPublisher publisher = client.getQueryResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.GetQueryResultsPublisher publisher = client.getQueryResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getQueryResults(software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueryResultsRequest.Builder} avoiding the need
     * to create one manually via {@link GetQueryResultsRequest#builder()}
     * </p>
     *
     * @param getQueryResultsRequest
     *        A {@link Consumer} that will call methods on {@link GetQueryResultsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>QueryIdNotFoundException The query ID does not exist or does not map to a query.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetQueryResults" target="_top">AWS
     *      API Documentation</a>
     */
    default GetQueryResultsPublisher getQueryResultsPaginator(Consumer<GetQueryResultsRequest.Builder> getQueryResultsRequest) {
        return getQueryResultsPaginator(GetQueryResultsRequest.builder().applyMutation(getQueryResultsRequest).build());
    }

    /**
     * <p>
     * Returns settings information for a specified trail.
     * </p>
     *
     * @param getTrailRequest
     * @return A Java Future containing the result of the GetTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTrailResponse> getTrail(GetTrailRequest getTrailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns settings information for a specified trail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrailRequest.Builder} avoiding the need to
     * create one manually via {@link GetTrailRequest#builder()}
     * </p>
     *
     * @param getTrailRequest
     *        A {@link Consumer} that will call methods on {@link GetTrailRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTrailResponse> getTrail(Consumer<GetTrailRequest.Builder> getTrailRequest) {
        return getTrail(GetTrailRequest.builder().applyMutation(getTrailRequest).build());
    }

    /**
     * <p>
     * Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery
     * errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns
     * trail status from a single region. To return trail status from all regions, you must call the operation on each
     * region.
     * </p>
     *
     * @param getTrailStatusRequest
     *        The name of a trail about which you want the current status.
     * @return A Java Future containing the result of the GetTrailStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetTrailStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrailStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTrailStatusResponse> getTrailStatus(GetTrailStatusRequest getTrailStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery
     * errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns
     * trail status from a single region. To return trail status from all regions, you must call the operation on each
     * region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrailStatusRequest.Builder} avoiding the need to
     * create one manually via {@link GetTrailStatusRequest#builder()}
     * </p>
     *
     * @param getTrailStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetTrailStatusRequest.Builder} to create a request.
     *        The name of a trail about which you want the current status.
     * @return A Java Future containing the result of the GetTrailStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.GetTrailStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrailStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTrailStatusResponse> getTrailStatus(Consumer<GetTrailStatusRequest.Builder> getTrailStatusRequest) {
        return getTrailStatus(GetTrailStatusRequest.builder().applyMutation(getTrailStatusRequest).build());
    }

    /**
     * <p>
     * Lists the channels in the current account, and their source names. Amazon Web Services services create
     * service-linked channels get information about CloudTrail events on your behalf. For more information about
     * service-linked channels, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/viewing-service-linked-channels.html">Viewing
     * service-linked channels for CloudTrail by using the CLI</a>.
     * </p>
     *
     * @param listChannelsRequest
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels(ListChannelsRequest listChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the channels in the current account, and their source names. Amazon Web Services services create
     * service-linked channels get information about CloudTrail events on your behalf. For more information about
     * service-linked channels, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/viewing-service-linked-channels.html">Viewing
     * service-linked channels for CloudTrail by using the CLI</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on {@link ListChannelsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels(Consumer<ListChannelsRequest.Builder> listChannelsRequest) {
        return listChannels(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * Lists the channels in the current account, and their source names. Amazon Web Services services create
     * service-linked channels get information about CloudTrail events on your behalf. For more information about
     * service-linked channels, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/viewing-service-linked-channels.html">Viewing
     * service-linked channels for CloudTrail by using the CLI</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @param listChannelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator(ListChannelsRequest listChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the channels in the current account, and their source names. Amazon Web Services services create
     * service-linked channels get information about CloudTrail events on your behalf. For more information about
     * service-linked channels, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/viewing-service-linked-channels.html">Viewing
     * service-linked channels for CloudTrail by using the CLI</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on {@link ListChannelsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator(Consumer<ListChannelsRequest.Builder> listChannelsRequest) {
        return listChannelsPaginator(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * <p>
     * Returns information about all event data stores in the account, in the current region.
     * </p>
     *
     * @param listEventDataStoresRequest
     * @return A Java Future containing the result of the ListEventDataStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListEventDataStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListEventDataStores"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventDataStoresResponse> listEventDataStores(
            ListEventDataStoresRequest listEventDataStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all event data stores in the account, in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventDataStoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListEventDataStoresRequest#builder()}
     * </p>
     *
     * @param listEventDataStoresRequest
     *        A {@link Consumer} that will call methods on {@link ListEventDataStoresRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEventDataStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListEventDataStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListEventDataStores"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventDataStoresResponse> listEventDataStores(
            Consumer<ListEventDataStoresRequest.Builder> listEventDataStoresRequest) {
        return listEventDataStores(ListEventDataStoresRequest.builder().applyMutation(listEventDataStoresRequest).build());
    }

    /**
     * <p>
     * Returns information about all event data stores in the account, in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventDataStores(software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListEventDataStoresPublisher publisher = client.listEventDataStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListEventDataStoresPublisher publisher = client.listEventDataStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventDataStores(software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventDataStoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListEventDataStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListEventDataStores"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventDataStoresPublisher listEventDataStoresPaginator(ListEventDataStoresRequest listEventDataStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about all event data stores in the account, in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventDataStores(software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListEventDataStoresPublisher publisher = client.listEventDataStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListEventDataStoresPublisher publisher = client.listEventDataStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventDataStores(software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventDataStoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListEventDataStoresRequest#builder()}
     * </p>
     *
     * @param listEventDataStoresRequest
     *        A {@link Consumer} that will call methods on {@link ListEventDataStoresRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListEventDataStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListEventDataStores"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventDataStoresPublisher listEventDataStoresPaginator(
            Consumer<ListEventDataStoresRequest.Builder> listEventDataStoresRequest) {
        return listEventDataStoresPaginator(ListEventDataStoresRequest.builder().applyMutation(listEventDataStoresRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of failures for the specified import.
     * </p>
     *
     * @param listImportFailuresRequest
     * @return A Java Future containing the result of the ListImportFailures operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImportFailures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImportFailures" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListImportFailuresResponse> listImportFailures(ListImportFailuresRequest listImportFailuresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of failures for the specified import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportFailuresRequest.Builder} avoiding the
     * need to create one manually via {@link ListImportFailuresRequest#builder()}
     * </p>
     *
     * @param listImportFailuresRequest
     *        A {@link Consumer} that will call methods on {@link ListImportFailuresRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListImportFailures operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImportFailures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImportFailures" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListImportFailuresResponse> listImportFailures(
            Consumer<ListImportFailuresRequest.Builder> listImportFailuresRequest) {
        return listImportFailures(ListImportFailuresRequest.builder().applyMutation(listImportFailuresRequest).build());
    }

    /**
     * <p>
     * Returns a list of failures for the specified import.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImportFailures(software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListImportFailuresPublisher publisher = client.listImportFailuresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListImportFailuresPublisher publisher = client.listImportFailuresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportFailures(software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImportFailuresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImportFailures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImportFailures" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportFailuresPublisher listImportFailuresPaginator(ListImportFailuresRequest listImportFailuresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of failures for the specified import.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listImportFailures(software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListImportFailuresPublisher publisher = client.listImportFailuresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListImportFailuresPublisher publisher = client.listImportFailuresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportFailures(software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportFailuresRequest.Builder} avoiding the
     * need to create one manually via {@link ListImportFailuresRequest#builder()}
     * </p>
     *
     * @param listImportFailuresRequest
     *        A {@link Consumer} that will call methods on {@link ListImportFailuresRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImportFailures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImportFailures" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportFailuresPublisher listImportFailuresPaginator(
            Consumer<ListImportFailuresRequest.Builder> listImportFailuresRequest) {
        return listImportFailuresPaginator(ListImportFailuresRequest.builder().applyMutation(listImportFailuresRequest).build());
    }

    /**
     * <p>
     * Returns information on all imports, or a select set of imports by <code>ImportStatus</code> or
     * <code>Destination</code>.
     * </p>
     *
     * @param listImportsRequest
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportsResponse> listImports(ListImportsRequest listImportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information on all imports, or a select set of imports by <code>ImportStatus</code> or
     * <code>Destination</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on {@link ListImportsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportsResponse> listImports(Consumer<ListImportsRequest.Builder> listImportsRequest) {
        return listImports(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * Returns information on all imports, or a select set of imports by <code>ImportStatus</code> or
     * <code>Destination</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImports(software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest)} operation.</b>
     * </p>
     *
     * @param listImportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsPublisher listImportsPaginator(ListImportsRequest listImportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information on all imports, or a select set of imports by <code>ImportStatus</code> or
     * <code>Destination</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImports(software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on {@link ListImportsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsPublisher listImportsPaginator(Consumer<ListImportsRequest.Builder> listImportsRequest) {
        return listImportsPaginator(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * Returns all public keys whose private keys were used to sign the digest files within the specified time range.
     * The public key is needed to validate digest files that were signed with its corresponding private key.
     * </p>
     * <note>
     * <p>
     * CloudTrail uses different private and public key pairs per region. Each digest file is signed with a private key
     * unique to its region. When you validate a digest file from a specific region, you must look in the same region
     * for its corresponding public key.
     * </p>
     * </note>
     *
     * @param listPublicKeysRequest
     *        Requests the public keys for a specified time range.
     * @return A Java Future containing the result of the ListPublicKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPublicKeysResponse> listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all public keys whose private keys were used to sign the digest files within the specified time range.
     * The public key is needed to validate digest files that were signed with its corresponding private key.
     * </p>
     * <note>
     * <p>
     * CloudTrail uses different private and public key pairs per region. Each digest file is signed with a private key
     * unique to its region. When you validate a digest file from a specific region, you must look in the same region
     * for its corresponding public key.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPublicKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListPublicKeysRequest#builder()}
     * </p>
     *
     * @param listPublicKeysRequest
     *        A {@link Consumer} that will call methods on {@link ListPublicKeysRequest.Builder} to create a request.
     *        Requests the public keys for a specified time range.
     * @return A Java Future containing the result of the ListPublicKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPublicKeysResponse> listPublicKeys(Consumer<ListPublicKeysRequest.Builder> listPublicKeysRequest) {
        return listPublicKeys(ListPublicKeysRequest.builder().applyMutation(listPublicKeysRequest).build());
    }

    /**
     * <p>
     * Returns all public keys whose private keys were used to sign the digest files within the specified time range.
     * The public key is needed to validate digest files that were signed with its corresponding private key.
     * </p>
     * <note>
     * <p>
     * CloudTrail uses different private and public key pairs per region. Each digest file is signed with a private key
     * unique to its region. When you validate a digest file from a specific region, you must look in the same region
     * for its corresponding public key.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the ListPublicKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPublicKeysResponse> listPublicKeys() {
        return listPublicKeys(ListPublicKeysRequest.builder().build());
    }

    /**
     * <p>
     * Returns all public keys whose private keys were used to sign the digest files within the specified time range.
     * The public key is needed to validate digest files that were signed with its corresponding private key.
     * </p>
     * <note>
     * <p>
     * CloudTrail uses different private and public key pairs per region. Each digest file is signed with a private key
     * unique to its region. When you validate a digest file from a specific region, you must look in the same region
     * for its corresponding public key.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listPublicKeys(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListPublicKeysPublisher publisher = client.listPublicKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListPublicKeysPublisher publisher = client.listPublicKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPublicKeys(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPublicKeysPublisher listPublicKeysPaginator() {
        return listPublicKeysPaginator(ListPublicKeysRequest.builder().build());
    }

    /**
     * <p>
     * Returns all public keys whose private keys were used to sign the digest files within the specified time range.
     * The public key is needed to validate digest files that were signed with its corresponding private key.
     * </p>
     * <note>
     * <p>
     * CloudTrail uses different private and public key pairs per region. Each digest file is signed with a private key
     * unique to its region. When you validate a digest file from a specific region, you must look in the same region
     * for its corresponding public key.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listPublicKeys(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListPublicKeysPublisher publisher = client.listPublicKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListPublicKeysPublisher publisher = client.listPublicKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPublicKeys(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest)} operation.</b>
     * </p>
     *
     * @param listPublicKeysRequest
     *        Requests the public keys for a specified time range.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPublicKeysPublisher listPublicKeysPaginator(ListPublicKeysRequest listPublicKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all public keys whose private keys were used to sign the digest files within the specified time range.
     * The public key is needed to validate digest files that were signed with its corresponding private key.
     * </p>
     * <note>
     * <p>
     * CloudTrail uses different private and public key pairs per region. Each digest file is signed with a private key
     * unique to its region. When you validate a digest file from a specific region, you must look in the same region
     * for its corresponding public key.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listPublicKeys(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListPublicKeysPublisher publisher = client.listPublicKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListPublicKeysPublisher publisher = client.listPublicKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPublicKeys(software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPublicKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListPublicKeysRequest#builder()}
     * </p>
     *
     * @param listPublicKeysRequest
     *        A {@link Consumer} that will call methods on {@link ListPublicKeysRequest.Builder} to create a request.
     *        Requests the public keys for a specified time range.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPublicKeysPublisher listPublicKeysPaginator(Consumer<ListPublicKeysRequest.Builder> listPublicKeysRequest) {
        return listPublicKeysPaginator(ListPublicKeysRequest.builder().applyMutation(listPublicKeysRequest).build());
    }

    /**
     * <p>
     * Returns a list of queries and query statuses for the past seven days. You must specify an ARN value for
     * <code>EventDataStore</code>. Optionally, to shorten the list of results, you can specify a time range, formatted
     * as timestamps, by adding <code>StartTime</code> and <code>EndTime</code> parameters, and a
     * <code>QueryStatus</code> value. Valid values for <code>QueryStatus</code> include <code>QUEUED</code>,
     * <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or
     * <code>CANCELLED</code>.
     * </p>
     *
     * @param listQueriesRequest
     * @return A Java Future containing the result of the ListQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidDateRangeException A date range for the query was specified that is not valid. Be sure that
     *         the start time is chronologically before the end time. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidQueryStatusException The query status is not valid for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListQueriesResponse> listQueries(ListQueriesRequest listQueriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of queries and query statuses for the past seven days. You must specify an ARN value for
     * <code>EventDataStore</code>. Optionally, to shorten the list of results, you can specify a time range, formatted
     * as timestamps, by adding <code>StartTime</code> and <code>EndTime</code> parameters, and a
     * <code>QueryStatus</code> value. Valid values for <code>QueryStatus</code> include <code>QUEUED</code>,
     * <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or
     * <code>CANCELLED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueriesRequest#builder()}
     * </p>
     *
     * @param listQueriesRequest
     *        A {@link Consumer} that will call methods on {@link ListQueriesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListQueries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidDateRangeException A date range for the query was specified that is not valid. Be sure that
     *         the start time is chronologically before the end time. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidQueryStatusException The query status is not valid for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListQueriesResponse> listQueries(Consumer<ListQueriesRequest.Builder> listQueriesRequest) {
        return listQueries(ListQueriesRequest.builder().applyMutation(listQueriesRequest).build());
    }

    /**
     * <p>
     * Returns a list of queries and query statuses for the past seven days. You must specify an ARN value for
     * <code>EventDataStore</code>. Optionally, to shorten the list of results, you can specify a time range, formatted
     * as timestamps, by adding <code>StartTime</code> and <code>EndTime</code> parameters, and a
     * <code>QueryStatus</code> value. Valid values for <code>QueryStatus</code> include <code>QUEUED</code>,
     * <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or
     * <code>CANCELLED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listQueries(software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListQueriesPublisher publisher = client.listQueriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListQueriesPublisher publisher = client.listQueriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueries(software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest)} operation.</b>
     * </p>
     *
     * @param listQueriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidDateRangeException A date range for the query was specified that is not valid. Be sure that
     *         the start time is chronologically before the end time. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidQueryStatusException The query status is not valid for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueriesPublisher listQueriesPaginator(ListQueriesRequest listQueriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of queries and query statuses for the past seven days. You must specify an ARN value for
     * <code>EventDataStore</code>. Optionally, to shorten the list of results, you can specify a time range, formatted
     * as timestamps, by adding <code>StartTime</code> and <code>EndTime</code> parameters, and a
     * <code>QueryStatus</code> value. Valid values for <code>QueryStatus</code> include <code>QUEUED</code>,
     * <code>RUNNING</code>, <code>FINISHED</code>, <code>FAILED</code>, <code>TIMED_OUT</code>, or
     * <code>CANCELLED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listQueries(software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListQueriesPublisher publisher = client.listQueriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListQueriesPublisher publisher = client.listQueriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueries(software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueriesRequest#builder()}
     * </p>
     *
     * @param listQueriesRequest
     *        A {@link Consumer} that will call methods on {@link ListQueriesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidDateRangeException A date range for the query was specified that is not valid. Be sure that
     *         the start time is chronologically before the end time. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidQueryStatusException The query status is not valid for the operation.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueriesPublisher listQueriesPaginator(Consumer<ListQueriesRequest.Builder> listQueriesRequest) {
        return listQueriesPaginator(ListQueriesRequest.builder().applyMutation(listQueriesRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the trail or event data store in the current region.
     * </p>
     *
     * @param listTagsRequest
     *        Specifies a list of tags to return.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with a trail ARN
     *         that is not valid. The following is the format of a trail ARN.</p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code></li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the trail or event data store in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsRequest.Builder} to create a request.
     *        Specifies a list of tags to return.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with a trail ARN
     *         that is not valid. The following is the format of a trail ARN.</p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code></li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the trail or event data store in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest)} operation.</b>
     * </p>
     *
     * @param listTagsRequest
     *        Specifies a list of tags to return.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with a trail ARN
     *         that is not valid. The following is the format of a trail ARN.</p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code></li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsPublisher listTagsPaginator(ListTagsRequest listTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the trail or event data store in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsRequest.Builder} to create a request.
     *        Specifies a list of tags to return.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with a trail ARN
     *         that is not valid. The following is the format of a trail ARN.</p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code></li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>InvalidTokenException Reserved for future use.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsPublisher listTagsPaginator(Consumer<ListTagsRequest.Builder> listTagsRequest) {
        return listTagsPaginator(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Lists trails that are in the current account.
     * </p>
     *
     * @param listTrailsRequest
     * @return A Java Future containing the result of the ListTrails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTrails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTrailsResponse> listTrails(ListTrailsRequest listTrailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists trails that are in the current account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrailsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTrailsRequest#builder()}
     * </p>
     *
     * @param listTrailsRequest
     *        A {@link Consumer} that will call methods on {@link ListTrailsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTrails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTrails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTrailsResponse> listTrails(Consumer<ListTrailsRequest.Builder> listTrailsRequest) {
        return listTrails(ListTrailsRequest.builder().applyMutation(listTrailsRequest).build());
    }

    /**
     * <p>
     * Lists trails that are in the current account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTrails(software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListTrailsPublisher publisher = client.listTrailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListTrailsPublisher publisher = client.listTrailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrails(software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest)} operation.</b>
     * </p>
     *
     * @param listTrailsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTrails" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTrailsPublisher listTrailsPaginator(ListTrailsRequest listTrailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists trails that are in the current account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTrails(software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListTrailsPublisher publisher = client.listTrailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.ListTrailsPublisher publisher = client.listTrailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrails(software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrailsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTrailsRequest#builder()}
     * </p>
     *
     * @param listTrailsRequest
     *        A {@link Consumer} that will call methods on {@link ListTrailsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.ListTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTrails" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTrailsPublisher listTrailsPaginator(Consumer<ListTrailsRequest.Builder> listTrailsRequest) {
        return listTrailsPaginator(ListTrailsRequest.builder().applyMutation(listTrailsRequest).build());
    }

    /**
     * <p>
     * Looks up <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events"
     * >management events</a> or <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events"
     * >CloudTrail Insights events</a> that are captured by CloudTrail. You can look up events that occurred in a region
     * within the last 90 days. Lookup supports the following attributes for management events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Web Services access key
     * </p>
     * </li>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * <li>
     * <p>
     * Read only
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource name
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource type
     * </p>
     * </li>
     * <li>
     * <p>
     * User name
     * </p>
     * </li>
     * </ul>
     * <p>
     * Lookup supports the following attributes for Insights events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * </ul>
     * <p>
     * All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The
     * response includes a token that you can use to get the next page of results.
     * </p>
     * <important>
     * <p>
     * The rate of lookup requests is limited to two per second, per account, per region. If this limit is exceeded, a
     * throttling error occurs.
     * </p>
     * </important>
     *
     * @param lookupEventsRequest
     *        Contains a request for LookupEvents.
     * @return A Java Future containing the result of the LookupEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLookupAttributesException Occurs when a lookup attribute is specified that is not valid.</li>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidEventCategoryException Occurs if an event category that is not valid is specified as a value
     *         of <code>EventCategory</code>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.LookupEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<LookupEventsResponse> lookupEvents(LookupEventsRequest lookupEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Looks up <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events"
     * >management events</a> or <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events"
     * >CloudTrail Insights events</a> that are captured by CloudTrail. You can look up events that occurred in a region
     * within the last 90 days. Lookup supports the following attributes for management events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Web Services access key
     * </p>
     * </li>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * <li>
     * <p>
     * Read only
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource name
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource type
     * </p>
     * </li>
     * <li>
     * <p>
     * User name
     * </p>
     * </li>
     * </ul>
     * <p>
     * Lookup supports the following attributes for Insights events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * </ul>
     * <p>
     * All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The
     * response includes a token that you can use to get the next page of results.
     * </p>
     * <important>
     * <p>
     * The rate of lookup requests is limited to two per second, per account, per region. If this limit is exceeded, a
     * throttling error occurs.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link LookupEventsRequest.Builder} avoiding the need to
     * create one manually via {@link LookupEventsRequest#builder()}
     * </p>
     *
     * @param lookupEventsRequest
     *        A {@link Consumer} that will call methods on {@link LookupEventsRequest.Builder} to create a request.
     *        Contains a request for LookupEvents.
     * @return A Java Future containing the result of the LookupEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLookupAttributesException Occurs when a lookup attribute is specified that is not valid.</li>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidEventCategoryException Occurs if an event category that is not valid is specified as a value
     *         of <code>EventCategory</code>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.LookupEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<LookupEventsResponse> lookupEvents(Consumer<LookupEventsRequest.Builder> lookupEventsRequest) {
        return lookupEvents(LookupEventsRequest.builder().applyMutation(lookupEventsRequest).build());
    }

    /**
     * <p>
     * Looks up <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events"
     * >management events</a> or <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events"
     * >CloudTrail Insights events</a> that are captured by CloudTrail. You can look up events that occurred in a region
     * within the last 90 days. Lookup supports the following attributes for management events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Web Services access key
     * </p>
     * </li>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * <li>
     * <p>
     * Read only
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource name
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource type
     * </p>
     * </li>
     * <li>
     * <p>
     * User name
     * </p>
     * </li>
     * </ul>
     * <p>
     * Lookup supports the following attributes for Insights events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * </ul>
     * <p>
     * All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The
     * response includes a token that you can use to get the next page of results.
     * </p>
     * <important>
     * <p>
     * The rate of lookup requests is limited to two per second, per account, per region. If this limit is exceeded, a
     * throttling error occurs.
     * </p>
     * </important>
     *
     * @return A Java Future containing the result of the LookupEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLookupAttributesException Occurs when a lookup attribute is specified that is not valid.</li>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidEventCategoryException Occurs if an event category that is not valid is specified as a value
     *         of <code>EventCategory</code>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.LookupEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<LookupEventsResponse> lookupEvents() {
        return lookupEvents(LookupEventsRequest.builder().build());
    }

    /**
     * <p>
     * Looks up <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events"
     * >management events</a> or <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events"
     * >CloudTrail Insights events</a> that are captured by CloudTrail. You can look up events that occurred in a region
     * within the last 90 days. Lookup supports the following attributes for management events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Web Services access key
     * </p>
     * </li>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * <li>
     * <p>
     * Read only
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource name
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource type
     * </p>
     * </li>
     * <li>
     * <p>
     * User name
     * </p>
     * </li>
     * </ul>
     * <p>
     * Lookup supports the following attributes for Insights events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * </ul>
     * <p>
     * All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The
     * response includes a token that you can use to get the next page of results.
     * </p>
     * <important>
     * <p>
     * The rate of lookup requests is limited to two per second, per account, per region. If this limit is exceeded, a
     * throttling error occurs.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of {@link #lookupEvents(software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.LookupEventsPublisher publisher = client.lookupEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.LookupEventsPublisher publisher = client.lookupEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #lookupEvents(software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLookupAttributesException Occurs when a lookup attribute is specified that is not valid.</li>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidEventCategoryException Occurs if an event category that is not valid is specified as a value
     *         of <code>EventCategory</code>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.LookupEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default LookupEventsPublisher lookupEventsPaginator() {
        return lookupEventsPaginator(LookupEventsRequest.builder().build());
    }

    /**
     * <p>
     * Looks up <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events"
     * >management events</a> or <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events"
     * >CloudTrail Insights events</a> that are captured by CloudTrail. You can look up events that occurred in a region
     * within the last 90 days. Lookup supports the following attributes for management events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Web Services access key
     * </p>
     * </li>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * <li>
     * <p>
     * Read only
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource name
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource type
     * </p>
     * </li>
     * <li>
     * <p>
     * User name
     * </p>
     * </li>
     * </ul>
     * <p>
     * Lookup supports the following attributes for Insights events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * </ul>
     * <p>
     * All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The
     * response includes a token that you can use to get the next page of results.
     * </p>
     * <important>
     * <p>
     * The rate of lookup requests is limited to two per second, per account, per region. If this limit is exceeded, a
     * throttling error occurs.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of {@link #lookupEvents(software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.LookupEventsPublisher publisher = client.lookupEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.LookupEventsPublisher publisher = client.lookupEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #lookupEvents(software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest)} operation.</b>
     * </p>
     *
     * @param lookupEventsRequest
     *        Contains a request for LookupEvents.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLookupAttributesException Occurs when a lookup attribute is specified that is not valid.</li>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidEventCategoryException Occurs if an event category that is not valid is specified as a value
     *         of <code>EventCategory</code>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.LookupEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default LookupEventsPublisher lookupEventsPaginator(LookupEventsRequest lookupEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Looks up <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events"
     * >management events</a> or <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events"
     * >CloudTrail Insights events</a> that are captured by CloudTrail. You can look up events that occurred in a region
     * within the last 90 days. Lookup supports the following attributes for management events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Web Services access key
     * </p>
     * </li>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * <li>
     * <p>
     * Read only
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource name
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource type
     * </p>
     * </li>
     * <li>
     * <p>
     * User name
     * </p>
     * </li>
     * </ul>
     * <p>
     * Lookup supports the following attributes for Insights events:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Event ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Event name
     * </p>
     * </li>
     * <li>
     * <p>
     * Event source
     * </p>
     * </li>
     * </ul>
     * <p>
     * All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The
     * response includes a token that you can use to get the next page of results.
     * </p>
     * <important>
     * <p>
     * The rate of lookup requests is limited to two per second, per account, per region. If this limit is exceeded, a
     * throttling error occurs.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of {@link #lookupEvents(software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.LookupEventsPublisher publisher = client.lookupEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloudtrail.paginators.LookupEventsPublisher publisher = client.lookupEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #lookupEvents(software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link LookupEventsRequest.Builder} avoiding the need to
     * create one manually via {@link LookupEventsRequest#builder()}
     * </p>
     *
     * @param lookupEventsRequest
     *        A {@link Consumer} that will call methods on {@link LookupEventsRequest.Builder} to create a request.
     *        Contains a request for LookupEvents.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidLookupAttributesException Occurs when a lookup attribute is specified that is not valid.</li>
     *         <li>InvalidTimeRangeException Occurs if the timestamp values are not valid. Either the start time occurs
     *         after the end time, or the time range is outside the range of possible values.</li>
     *         <li>InvalidMaxResultsException This exception is thrown if the limit specified is not valid.</li>
     *         <li>InvalidNextTokenException A token that is not valid, or a token that was previously used in a request
     *         with different parameters. This exception is thrown if the token is not valid.</li>
     *         <li>InvalidEventCategoryException Occurs if an event category that is not valid is specified as a value
     *         of <code>EventCategory</code>.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.LookupEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default LookupEventsPublisher lookupEventsPaginator(Consumer<LookupEventsRequest.Builder> lookupEventsRequest) {
        return lookupEventsPaginator(LookupEventsRequest.builder().applyMutation(lookupEventsRequest).build());
    }

    /**
     * <p>
     * Configures an event selector or advanced event selectors for your trail. Use event selectors or advanced event
     * selectors to specify management and data event settings for your trail. By default, trails created without
     * specific event selectors are configured to log all read and write management events, and no data events.
     * </p>
     * <p>
     * When an event occurs in your account, CloudTrail evaluates the event selectors or advanced event selectors in all
     * trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the
     * event doesn't match any event selector, the trail doesn't log the event.
     * </p>
     * <p>
     * Example
     * </p>
     * <ol>
     * <li>
     * <p>
     * You create an event selector for a trail and specify that you want write-only events.
     * </p>
     * </li>
     * <li>
     * <p>
     * The EC2 <code>GetConsoleOutput</code> and <code>RunInstances</code> API operations occur in your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * CloudTrail evaluates whether the events match your event selectors.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>RunInstances</code> is a write-only event and it matches your event selector. The trail logs the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>GetConsoleOutput</code> is a read-only event that doesn't match your event selector. The trail doesn't
     * log the event.
     * </p>
     * </li>
     * </ol>
     * <p>
     * The <code>PutEventSelectors</code> operation must be called from the region in which the trail was created;
     * otherwise, an <code>InvalidHomeRegionException</code> exception is thrown.
     * </p>
     * <p>
     * You can configure up to five event selectors for each trail. For more information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html"
     * >Logging management events for trails </a>, <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html"
     * >Logging data events for trails </a>, and <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Quotas in
     * CloudTrail</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <p>
     * You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500
     * values for all conditions and selectors on a trail. You can use either <code>AdvancedEventSelectors</code> or
     * <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code> to a trail, any
     * existing <code>EventSelectors</code> are overwritten. For more information about advanced event selectors, see <a
     * href
     * ="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging
     * data events for trails</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     *
     * @param putEventSelectorsRequest
     * @return A Java Future containing the result of the PutEventSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         region other than the region in which the trail was created.</li>
     *         <li>InvalidEventSelectorsException This exception is thrown when the <code>PutEventSelectors</code>
     *         operation is called with a number of event selectors, advanced event selectors, or data resources that is
     *         not valid. The combination of event selectors or advanced event selectors and data resources is not
     *         valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of
     *         500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250
     *         data resources. These data resources can be distributed across event selectors, but the overall total
     *         cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.PutEventSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutEventSelectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutEventSelectorsResponse> putEventSelectors(PutEventSelectorsRequest putEventSelectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures an event selector or advanced event selectors for your trail. Use event selectors or advanced event
     * selectors to specify management and data event settings for your trail. By default, trails created without
     * specific event selectors are configured to log all read and write management events, and no data events.
     * </p>
     * <p>
     * When an event occurs in your account, CloudTrail evaluates the event selectors or advanced event selectors in all
     * trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the
     * event doesn't match any event selector, the trail doesn't log the event.
     * </p>
     * <p>
     * Example
     * </p>
     * <ol>
     * <li>
     * <p>
     * You create an event selector for a trail and specify that you want write-only events.
     * </p>
     * </li>
     * <li>
     * <p>
     * The EC2 <code>GetConsoleOutput</code> and <code>RunInstances</code> API operations occur in your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * CloudTrail evaluates whether the events match your event selectors.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>RunInstances</code> is a write-only event and it matches your event selector. The trail logs the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>GetConsoleOutput</code> is a read-only event that doesn't match your event selector. The trail doesn't
     * log the event.
     * </p>
     * </li>
     * </ol>
     * <p>
     * The <code>PutEventSelectors</code> operation must be called from the region in which the trail was created;
     * otherwise, an <code>InvalidHomeRegionException</code> exception is thrown.
     * </p>
     * <p>
     * You can configure up to five event selectors for each trail. For more information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html"
     * >Logging management events for trails </a>, <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html"
     * >Logging data events for trails </a>, and <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Quotas in
     * CloudTrail</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <p>
     * You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500
     * values for all conditions and selectors on a trail. You can use either <code>AdvancedEventSelectors</code> or
     * <code>EventSelectors</code>, but not both. If you apply <code>AdvancedEventSelectors</code> to a trail, any
     * existing <code>EventSelectors</code> are overwritten. For more information about advanced event selectors, see <a
     * href
     * ="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging
     * data events for trails</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEventSelectorsRequest.Builder} avoiding the need
     * to create one manually via {@link PutEventSelectorsRequest#builder()}
     * </p>
     *
     * @param putEventSelectorsRequest
     *        A {@link Consumer} that will call methods on {@link PutEventSelectorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutEventSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         region other than the region in which the trail was created.</li>
     *         <li>InvalidEventSelectorsException This exception is thrown when the <code>PutEventSelectors</code>
     *         operation is called with a number of event selectors, advanced event selectors, or data resources that is
     *         not valid. The combination of event selectors or advanced event selectors and data resources is not
     *         valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of
     *         500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250
     *         data resources. These data resources can be distributed across event selectors, but the overall total
     *         cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li></li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.PutEventSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutEventSelectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutEventSelectorsResponse> putEventSelectors(
            Consumer<PutEventSelectorsRequest.Builder> putEventSelectorsRequest) {
        return putEventSelectors(PutEventSelectorsRequest.builder().applyMutation(putEventSelectorsRequest).build());
    }

    /**
     * <p>
     * Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an
     * existing trail. You also use <code>PutInsightSelectors</code> to turn off Insights event logging, by passing an
     * empty list of insight types. The valid Insights event types in this release are <code>ApiErrorRateInsight</code>
     * and <code>ApiCallRateInsight</code>.
     * </p>
     *
     * @param putInsightSelectorsRequest
     * @return A Java Future containing the result of the PutInsightSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         region other than the region in which the trail was created.</li>
     *         <li>InvalidInsightSelectorsException The formatting or syntax of the <code>InsightSelectors</code> JSON
     *         statement in your <code>PutInsightSelectors</code> or <code>GetInsightSelectors</code> request is not
     *         valid, or the specified insight type in the <code>InsightSelectors</code> statement is not a valid
     *         insight type.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.PutInsightSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutInsightSelectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInsightSelectorsResponse> putInsightSelectors(
            PutInsightSelectorsRequest putInsightSelectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an
     * existing trail. You also use <code>PutInsightSelectors</code> to turn off Insights event logging, by passing an
     * empty list of insight types. The valid Insights event types in this release are <code>ApiErrorRateInsight</code>
     * and <code>ApiCallRateInsight</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutInsightSelectorsRequest.Builder} avoiding the
     * need to create one manually via {@link PutInsightSelectorsRequest#builder()}
     * </p>
     *
     * @param putInsightSelectorsRequest
     *        A {@link Consumer} that will call methods on {@link PutInsightSelectorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutInsightSelectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         region other than the region in which the trail was created.</li>
     *         <li>InvalidInsightSelectorsException The formatting or syntax of the <code>InsightSelectors</code> JSON
     *         statement in your <code>PutInsightSelectors</code> or <code>GetInsightSelectors</code> request is not
     *         valid, or the specified insight type in the <code>InsightSelectors</code> statement is not a valid
     *         insight type.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.PutInsightSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutInsightSelectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInsightSelectorsResponse> putInsightSelectors(
            Consumer<PutInsightSelectorsRequest.Builder> putInsightSelectorsRequest) {
        return putInsightSelectors(PutInsightSelectorsRequest.builder().applyMutation(putInsightSelectorsRequest).build());
    }

    /**
     * <p>
     * Registers an organization’s member account as the CloudTrail delegated administrator.
     * </p>
     *
     * @param registerOrganizationDelegatedAdminRequest
     *        Specifies an organization member account ID as a CloudTrail delegated administrator.
     * @return A Java Future containing the result of the RegisterOrganizationDelegatedAdmin operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccountRegisteredException This exception is thrown when the account is already registered as the
     *         CloudTrail delegated administrator.</li>
     *         <li>AccountNotFoundException This exception is thrown when when the specified account is not found or not
     *         part of an organization.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>CannotDelegateManagementAccountException This exception is thrown when the management account of an
     *         organization is registered as the CloudTrail delegated administrator.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>DelegatedAdminAccountLimitExceededException This exception is thrown when the maximum number of
     *         CloudTrail delegated administrators is reached.</li>
     *         <li>NotOrganizationManagementAccountException This exception is thrown when the account making the
     *         request is not the organization's management account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.RegisterOrganizationDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RegisterOrganizationDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterOrganizationDelegatedAdminResponse> registerOrganizationDelegatedAdmin(
            RegisterOrganizationDelegatedAdminRequest registerOrganizationDelegatedAdminRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an organization’s member account as the CloudTrail delegated administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterOrganizationDelegatedAdminRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterOrganizationDelegatedAdminRequest#builder()}
     * </p>
     *
     * @param registerOrganizationDelegatedAdminRequest
     *        A {@link Consumer} that will call methods on {@link RegisterOrganizationDelegatedAdminRequest.Builder} to
     *        create a request. Specifies an organization member account ID as a CloudTrail delegated administrator.
     * @return A Java Future containing the result of the RegisterOrganizationDelegatedAdmin operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccountRegisteredException This exception is thrown when the account is already registered as the
     *         CloudTrail delegated administrator.</li>
     *         <li>AccountNotFoundException This exception is thrown when when the specified account is not found or not
     *         part of an organization.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>CannotDelegateManagementAccountException This exception is thrown when the management account of an
     *         organization is registered as the CloudTrail delegated administrator.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>DelegatedAdminAccountLimitExceededException This exception is thrown when the maximum number of
     *         CloudTrail delegated administrators is reached.</li>
     *         <li>NotOrganizationManagementAccountException This exception is thrown when the account making the
     *         request is not the organization's management account.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.RegisterOrganizationDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RegisterOrganizationDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterOrganizationDelegatedAdminResponse> registerOrganizationDelegatedAdmin(
            Consumer<RegisterOrganizationDelegatedAdminRequest.Builder> registerOrganizationDelegatedAdminRequest) {
        return registerOrganizationDelegatedAdmin(RegisterOrganizationDelegatedAdminRequest.builder()
                .applyMutation(registerOrganizationDelegatedAdminRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from a trail or event data store.
     * </p>
     *
     * @param removeTagsRequest
     *        Specifies the tags to remove from a trail or event data store.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with a trail ARN
     *         that is not valid. The following is the format of a trail ARN.</p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code></li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.RemoveTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RemoveTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveTagsResponse> removeTags(RemoveTagsRequest removeTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from a trail or event data store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsRequest.Builder} avoiding the need to
     * create one manually via {@link RemoveTagsRequest#builder()}
     * </p>
     *
     * @param removeTagsRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTagsRequest.Builder} to create a request.
     *        Specifies the tags to remove from a trail or event data store.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when the specified resource is not found.</li>
     *         <li>CloudTrailArnInvalidException This exception is thrown when an operation is called with a trail ARN
     *         that is not valid. The following is the format of a trail ARN.</p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code></li>
     *         <li>ResourceTypeNotSupportedException This exception is thrown when the specified resource type is not
     *         supported by CloudTrail.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidTagParameterException This exception is thrown when the specified tag key or values are not
     *         valid. It can also occur if there are duplicate tags or too many tags on the resource.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.RemoveTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RemoveTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveTagsResponse> removeTags(Consumer<RemoveTagsRequest.Builder> removeTagsRequest) {
        return removeTags(RemoveTagsRequest.builder().applyMutation(removeTagsRequest).build());
    }

    /**
     * <p>
     * Restores a deleted event data store specified by <code>EventDataStore</code>, which accepts an event data store
     * ARN. You can only restore a deleted event data store within the seven-day wait period after deletion. Restoring
     * an event data store can take several minutes, depending on the size of the event data store.
     * </p>
     *
     * @param restoreEventDataStoreRequest
     * @return A Java Future containing the result of the RestoreEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>EventDataStoreMaxLimitExceededException Your account has used the maximum number of event data
     *         stores.</li>
     *         <li>InvalidEventDataStoreStatusException The event data store is not in a status that supports the
     *         operation.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.RestoreEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RestoreEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreEventDataStoreResponse> restoreEventDataStore(
            RestoreEventDataStoreRequest restoreEventDataStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a deleted event data store specified by <code>EventDataStore</code>, which accepts an event data store
     * ARN. You can only restore a deleted event data store within the seven-day wait period after deletion. Restoring
     * an event data store can take several minutes, depending on the size of the event data store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreEventDataStoreRequest.Builder} avoiding the
     * need to create one manually via {@link RestoreEventDataStoreRequest#builder()}
     * </p>
     *
     * @param restoreEventDataStoreRequest
     *        A {@link Consumer} that will call methods on {@link RestoreEventDataStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RestoreEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>EventDataStoreMaxLimitExceededException Your account has used the maximum number of event data
     *         stores.</li>
     *         <li>InvalidEventDataStoreStatusException The event data store is not in a status that supports the
     *         operation.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.RestoreEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RestoreEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreEventDataStoreResponse> restoreEventDataStore(
            Consumer<RestoreEventDataStoreRequest.Builder> restoreEventDataStoreRequest) {
        return restoreEventDataStore(RestoreEventDataStoreRequest.builder().applyMutation(restoreEventDataStoreRequest).build());
    }

    /**
     * <p>
     * Starts an import of logged trail events from a source S3 bucket to a destination event data store. By default,
     * CloudTrail only imports events contained in the S3 bucket's <code>CloudTrail</code> prefix and the prefixes
     * inside the <code>CloudTrail</code> prefix, and does not check prefixes for other Amazon Web Services services. If
     * you want to import CloudTrail events contained in another prefix, you must include the prefix in the
     * <code>S3LocationUri</code>. For more considerations about importing trail events, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-copy-trail-to-lake.html#cloudtrail-trail-copy-considerations"
     * >Considerations</a>.
     * </p>
     * <p>
     * When you start a new import, the <code>Destinations</code> and <code>ImportSource</code> parameters are required.
     * Before starting a new import, disable any access control lists (ACLs) attached to the source S3 bucket. For more
     * information about disabling ACLs, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of
     * objects and disabling ACLs for your bucket</a>.
     * </p>
     * <p>
     * When you retry an import, the <code>ImportID</code> parameter is required.
     * </p>
     *
     * @param startImportRequest
     * @return A Java Future containing the result of the StartImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccountHasOngoingImportException This exception is thrown when you start a new import and a previous
     *         import is still in progress.</li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreStatusException The event data store is not in a status that supports the
     *         operation.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidImportSourceException This exception is thrown when the provided source S3 bucket is not valid
     *         for import.</li>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartImportResponse> startImport(StartImportRequest startImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an import of logged trail events from a source S3 bucket to a destination event data store. By default,
     * CloudTrail only imports events contained in the S3 bucket's <code>CloudTrail</code> prefix and the prefixes
     * inside the <code>CloudTrail</code> prefix, and does not check prefixes for other Amazon Web Services services. If
     * you want to import CloudTrail events contained in another prefix, you must include the prefix in the
     * <code>S3LocationUri</code>. For more considerations about importing trail events, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-copy-trail-to-lake.html#cloudtrail-trail-copy-considerations"
     * >Considerations</a>.
     * </p>
     * <p>
     * When you start a new import, the <code>Destinations</code> and <code>ImportSource</code> parameters are required.
     * Before starting a new import, disable any access control lists (ACLs) attached to the source S3 bucket. For more
     * information about disabling ACLs, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of
     * objects and disabling ACLs for your bucket</a>.
     * </p>
     * <p>
     * When you retry an import, the <code>ImportID</code> parameter is required.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImportRequest.Builder} avoiding the need to
     * create one manually via {@link StartImportRequest#builder()}
     * </p>
     *
     * @param startImportRequest
     *        A {@link Consumer} that will call methods on {@link StartImportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccountHasOngoingImportException This exception is thrown when you start a new import and a previous
     *         import is still in progress.</li>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InvalidEventDataStoreStatusException The event data store is not in a status that supports the
     *         operation.</li>
     *         <li>InvalidEventDataStoreCategoryException This exception is thrown when event categories of specified
     *         event data stores are not valid.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidImportSourceException This exception is thrown when the provided source S3 bucket is not valid
     *         for import.</li>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartImportResponse> startImport(Consumer<StartImportRequest.Builder> startImportRequest) {
        return startImport(StartImportRequest.builder().applyMutation(startImportRequest).build());
    }

    /**
     * <p>
     * Starts the recording of Amazon Web Services API calls and log file delivery for a trail. For a trail that is
     * enabled in all regions, this operation must be called from the region in which the trail was created. This
     * operation cannot be called on the shadow trails (replicated trails in other regions) of a trail that is enabled
     * in all regions.
     * </p>
     *
     * @param startLoggingRequest
     *        The request to CloudTrail to start logging Amazon Web Services API calls for an account.
     * @return A Java Future containing the result of the StartLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         region other than the region in which the trail was created.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartLogging" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartLoggingResponse> startLogging(StartLoggingRequest startLoggingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the recording of Amazon Web Services API calls and log file delivery for a trail. For a trail that is
     * enabled in all regions, this operation must be called from the region in which the trail was created. This
     * operation cannot be called on the shadow trails (replicated trails in other regions) of a trail that is enabled
     * in all regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartLoggingRequest.Builder} avoiding the need to
     * create one manually via {@link StartLoggingRequest#builder()}
     * </p>
     *
     * @param startLoggingRequest
     *        A {@link Consumer} that will call methods on {@link StartLoggingRequest.Builder} to create a request. The
     *        request to CloudTrail to start logging Amazon Web Services API calls for an account.
     * @return A Java Future containing the result of the StartLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         region other than the region in which the trail was created.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartLogging" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartLoggingResponse> startLogging(Consumer<StartLoggingRequest.Builder> startLoggingRequest) {
        return startLogging(StartLoggingRequest.builder().applyMutation(startLoggingRequest).build());
    }

    /**
     * <p>
     * Starts a CloudTrail Lake query. The required <code>QueryStatement</code> parameter provides your SQL query,
     * enclosed in single quotation marks. Use the optional <code>DeliveryS3Uri</code> parameter to deliver the query
     * results to an S3 bucket.
     * </p>
     *
     * @param startQueryRequest
     * @return A Java Future containing the result of the StartQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidQueryStatementException The query that was submitted has validation errors, or uses incorrect
     *         syntax or unsupported keywords. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>MaxConcurrentQueriesException You are already running the maximum number of concurrent queries. Wait
     *         a minute for some queries to finish, and then run the query again.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>InvalidS3PrefixException This exception is thrown when the provided S3 prefix is not valid.</li>
     *         <li>InvalidS3BucketNameException This exception is thrown when the provided S3 bucket name is not valid.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartQueryResponse> startQuery(StartQueryRequest startQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a CloudTrail Lake query. The required <code>QueryStatement</code> parameter provides your SQL query,
     * enclosed in single quotation marks. Use the optional <code>DeliveryS3Uri</code> parameter to deliver the query
     * results to an S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartQueryRequest.Builder} avoiding the need to
     * create one manually via {@link StartQueryRequest#builder()}
     * </p>
     *
     * @param startQueryRequest
     *        A {@link Consumer} that will call methods on {@link StartQueryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>InvalidQueryStatementException The query that was submitted has validation errors, or uses incorrect
     *         syntax or unsupported keywords. For more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.</li>
     *         <li>MaxConcurrentQueriesException You are already running the maximum number of concurrent queries. Wait
     *         a minute for some queries to finish, and then run the query again.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>InvalidS3PrefixException This exception is thrown when the provided S3 prefix is not valid.</li>
     *         <li>InvalidS3BucketNameException This exception is thrown when the provided S3 bucket name is not valid.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StartQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartQueryResponse> startQuery(Consumer<StartQueryRequest.Builder> startQueryRequest) {
        return startQuery(StartQueryRequest.builder().applyMutation(startQueryRequest).build());
    }

    /**
     * <p>
     * Stops a specified import.
     * </p>
     *
     * @param stopImportRequest
     * @return A Java Future containing the result of the StopImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StopImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopImportResponse> stopImport(StopImportRequest stopImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a specified import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopImportRequest.Builder} avoiding the need to
     * create one manually via {@link StopImportRequest#builder()}
     * </p>
     *
     * @param stopImportRequest
     *        A {@link Consumer} that will call methods on {@link StopImportRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ImportNotFoundException The specified import was not found.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StopImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopImportResponse> stopImport(Consumer<StopImportRequest.Builder> stopImportRequest) {
        return stopImport(StopImportRequest.builder().applyMutation(stopImportRequest).build());
    }

    /**
     * <p>
     * Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail. Under most
     * circumstances, there is no need to use this action. You can update a trail without stopping it first. This action
     * is the only way to stop recording. For a trail enabled in all regions, this operation must be called from the
     * region in which the trail was created, or an <code>InvalidHomeRegionException</code> will occur. This operation
     * cannot be called on the shadow trails (replicated trails in other regions) of a trail enabled in all regions.
     * </p>
     *
     * @param stopLoggingRequest
     *        Passes the request to CloudTrail to stop logging Amazon Web Services API calls for the specified account.
     * @return A Java Future containing the result of the StopLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         region other than the region in which the trail was created.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StopLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopLogging" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopLoggingResponse> stopLogging(StopLoggingRequest stopLoggingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail. Under most
     * circumstances, there is no need to use this action. You can update a trail without stopping it first. This action
     * is the only way to stop recording. For a trail enabled in all regions, this operation must be called from the
     * region in which the trail was created, or an <code>InvalidHomeRegionException</code> will occur. This operation
     * cannot be called on the shadow trails (replicated trails in other regions) of a trail enabled in all regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopLoggingRequest.Builder} avoiding the need to
     * create one manually via {@link StopLoggingRequest#builder()}
     * </p>
     *
     * @param stopLoggingRequest
     *        A {@link Consumer} that will call methods on {@link StopLoggingRequest.Builder} to create a request.
     *        Passes the request to CloudTrail to stop logging Amazon Web Services API calls for the specified account.
     * @return A Java Future containing the result of the StopLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         region other than the region in which the trail was created.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.StopLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopLogging" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopLoggingResponse> stopLogging(Consumer<StopLoggingRequest.Builder> stopLoggingRequest) {
        return stopLogging(StopLoggingRequest.builder().applyMutation(stopLoggingRequest).build());
    }

    /**
     * <p>
     * Updates an event data store. The required <code>EventDataStore</code> value is an ARN or the ID portion of the
     * ARN. Other parameters are optional, but at least one optional parameter must be specified, or CloudTrail throws
     * an error. <code>RetentionPeriod</code> is in days, and valid values are integers between 90 and 2557. By default,
     * <code>TerminationProtection</code> is enabled. <code>AdvancedEventSelectors</code> includes or excludes
     * management and data events in your event data store; for more information about
     * <code>AdvancedEventSelectors</code>, see <a>PutEventSelectorsRequest&#36AdvancedEventSelectors</a>.
     * </p>
     *
     * @param updateEventDataStoreRequest
     * @return A Java Future containing the result of the UpdateEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>EventDataStoreHasOngoingImportException This exception is thrown when you try to update or delete an
     *         event data store that currently has an import in progress.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.UpdateEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventDataStoreResponse> updateEventDataStore(
            UpdateEventDataStoreRequest updateEventDataStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an event data store. The required <code>EventDataStore</code> value is an ARN or the ID portion of the
     * ARN. Other parameters are optional, but at least one optional parameter must be specified, or CloudTrail throws
     * an error. <code>RetentionPeriod</code> is in days, and valid values are integers between 90 and 2557. By default,
     * <code>TerminationProtection</code> is enabled. <code>AdvancedEventSelectors</code> includes or excludes
     * management and data events in your event data store; for more information about
     * <code>AdvancedEventSelectors</code>, see <a>PutEventSelectorsRequest&#36AdvancedEventSelectors</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventDataStoreRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEventDataStoreRequest#builder()}
     * </p>
     *
     * @param updateEventDataStoreRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEventDataStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEventDataStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventDataStoreArnInvalidException The specified event data store ARN is not valid or does not map to
     *         an event data store in your account.</li>
     *         <li>EventDataStoreNotFoundException The specified event data store was not found.</li>
     *         <li>EventDataStoreHasOngoingImportException This exception is thrown when you try to update or delete an
     *         event data store that currently has an import in progress.</li>
     *         <li>InactiveEventDataStoreException The event data store is inactive.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.UpdateEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventDataStoreResponse> updateEventDataStore(
            Consumer<UpdateEventDataStoreRequest.Builder> updateEventDataStoreRequest) {
        return updateEventDataStore(UpdateEventDataStoreRequest.builder().applyMutation(updateEventDataStoreRequest).build());
    }

    /**
     * <p>
     * Updates trail settings that control what events you are logging, and how to handle log files. Changes to a trail
     * do not require stopping the CloudTrail service. Use this action to designate an existing bucket for log delivery.
     * If the existing bucket has previously been a target for CloudTrail log files, an IAM policy exists for the
     * bucket. <code>UpdateTrail</code> must be called from the region in which the trail was created; otherwise, an
     * <code>InvalidHomeRegionException</code> is thrown.
     * </p>
     *
     * @param updateTrailRequest
     *        Specifies settings to update for the trail.
     * @return A Java Future containing the result of the UpdateTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>InsufficientSnsTopicPolicyException This exception is thrown when the policy on the Amazon SNS topic
     *         is not sufficient.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidS3BucketNameException This exception is thrown when the provided S3 bucket name is not valid.</li>
     *         <li>InvalidS3PrefixException This exception is thrown when the provided S3 prefix is not valid.</li>
     *         <li>InvalidSnsTopicNameException This exception is thrown when the provided SNS topic name is not valid.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>TrailNotProvidedException This exception is no longer in use.</li>
     *         <li>InvalidEventSelectorsException This exception is thrown when the <code>PutEventSelectors</code>
     *         operation is called with a number of event selectors, advanced event selectors, or data resources that is
     *         not valid. The combination of event selectors or advanced event selectors and data resources is not
     *         valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of
     *         500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250
     *         data resources. These data resources can be distributed across event selectors, but the overall total
     *         cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterCombinationException This exception is thrown when the combination of parameters
     *         provided is not valid.</li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         region other than the region in which the trail was created.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>InvalidCloudWatchLogsLogGroupArnException This exception is thrown when the provided CloudWatch Logs
     *         log group is not valid.</li>
     *         <li>InvalidCloudWatchLogsRoleArnException This exception is thrown when the provided role is not valid.</li>
     *         <li>CloudWatchLogsDeliveryUnavailableException Cannot set a CloudWatch Logs delivery for this region.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>CloudTrailInvalidClientTokenIdException This exception is thrown when a call results in the
     *         <code>InvalidClientTokenId</code> error code. This can occur when you are creating or updating a trail to
     *         send notifications to an Amazon SNS topic that is in a suspended Amazon Web Services account.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.UpdateTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateTrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTrailResponse> updateTrail(UpdateTrailRequest updateTrailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates trail settings that control what events you are logging, and how to handle log files. Changes to a trail
     * do not require stopping the CloudTrail service. Use this action to designate an existing bucket for log delivery.
     * If the existing bucket has previously been a target for CloudTrail log files, an IAM policy exists for the
     * bucket. <code>UpdateTrail</code> must be called from the region in which the trail was created; otherwise, an
     * <code>InvalidHomeRegionException</code> is thrown.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTrailRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTrailRequest#builder()}
     * </p>
     *
     * @param updateTrailRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTrailRequest.Builder} to create a request.
     *        Specifies settings to update for the trail.
     * @return A Java Future containing the result of the UpdateTrail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>S3BucketDoesNotExistException This exception is thrown when the specified S3 bucket does not exist.</li>
     *         <li>InsufficientS3BucketPolicyException This exception is thrown when the policy on the S3 bucket is not
     *         sufficient.</li>
     *         <li>InsufficientSnsTopicPolicyException This exception is thrown when the policy on the Amazon SNS topic
     *         is not sufficient.</li>
     *         <li>InsufficientEncryptionPolicyException This exception is thrown when the policy on the S3 bucket or
     *         KMS key does not have sufficient permissions for the operation.</li>
     *         <li>TrailNotFoundException This exception is thrown when the trail with the given name is not found.</li>
     *         <li>InvalidS3BucketNameException This exception is thrown when the provided S3 bucket name is not valid.</li>
     *         <li>InvalidS3PrefixException This exception is thrown when the provided S3 prefix is not valid.</li>
     *         <li>InvalidSnsTopicNameException This exception is thrown when the provided SNS topic name is not valid.</li>
     *         <li>InvalidKmsKeyIdException This exception is thrown when the KMS key ARN is not valid.</li>
     *         <li>InvalidTrailNameException This exception is thrown when the provided trail name is not valid. Trail
     *         names must meet the following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li></li>
     *         <li>TrailNotProvidedException This exception is no longer in use.</li>
     *         <li>InvalidEventSelectorsException This exception is thrown when the <code>PutEventSelectors</code>
     *         operation is called with a number of event selectors, advanced event selectors, or data resources that is
     *         not valid. The combination of event selectors or advanced event selectors and data resources is not
     *         valid. A trail can have up to 5 event selectors. If a trail uses advanced event selectors, a maximum of
     *         500 total values for all conditions in all advanced event selectors is allowed. A trail is limited to 250
     *         data resources. These data resources can be distributed across event selectors, but the overall total
     *         cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterCombinationException This exception is thrown when the combination of parameters
     *         provided is not valid.</li>
     *         <li>InvalidHomeRegionException This exception is thrown when an operation is called on a trail from a
     *         region other than the region in which the trail was created.</li>
     *         <li>KmsKeyNotFoundException This exception is thrown when the KMS key does not exist, when the S3 bucket
     *         and the KMS key are not in the same region, or when the KMS key associated with the Amazon SNS topic
     *         either does not exist or is not in the same region.</li>
     *         <li>KmsException This exception is thrown when there is an issue with the specified KMS key and the trail
     *         or event data store can't be updated.</li>
     *         <li>InvalidCloudWatchLogsLogGroupArnException This exception is thrown when the provided CloudWatch Logs
     *         log group is not valid.</li>
     *         <li>InvalidCloudWatchLogsRoleArnException This exception is thrown when the provided role is not valid.</li>
     *         <li>CloudWatchLogsDeliveryUnavailableException Cannot set a CloudWatch Logs delivery for this region.</li>
     *         <li>UnsupportedOperationException This exception is thrown when the requested operation is not supported.
     *         </li>
     *         <li>OperationNotPermittedException This exception is thrown when the requested operation is not
     *         permitted.</li>
     *         <li>CloudTrailAccessNotEnabledException This exception is thrown when trusted access has not been enabled
     *         between CloudTrail and Organizations. For more information, see <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html">Enabling
     *         Trusted Access with Other Amazon Web Services Services</a> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a>.</li>
     *         <li>InsufficientDependencyServiceAccessPermissionException This exception is thrown when the IAM user or
     *         role that is used to create the organization resource lacks one or more required permissions for creating
     *         an organization resource in a required service.</li>
     *         <li>OrganizationsNotInUseException This exception is thrown when the request is made from an Amazon Web
     *         Services account that is not a member of an organization. To make this request, sign in using the
     *         credentials of an account that belongs to an organization.</li>
     *         <li>NotOrganizationMasterAccountException This exception is thrown when the Amazon Web Services account
     *         making the request to create or update an organization trail or event data store is not the management
     *         account for an organization in Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store.html">Create an
     *         event data store</a>.</li>
     *         <li>OrganizationNotInAllFeaturesModeException This exception is thrown when Organizations is not
     *         configured to support all features. All features must be enabled in Organizations to support creating an
     *         organization trail or event data store.</li>
     *         <li>NoManagementAccountSlrExistsException This exception is thrown when the management account does not
     *         have a service-linked role.</li>
     *         <li>CloudTrailInvalidClientTokenIdException This exception is thrown when a call results in the
     *         <code>InvalidClientTokenId</code> error code. This can occur when you are creating or updating a trail to
     *         send notifications to an Amazon SNS topic that is in a suspended Amazon Web Services account.</li>
     *         <li>InvalidParameterException The request includes a parameter that is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudTrailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudTrailAsyncClient.UpdateTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateTrail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTrailResponse> updateTrail(Consumer<UpdateTrailRequest.Builder> updateTrailRequest) {
        return updateTrail(UpdateTrailRequest.builder().applyMutation(updateTrailRequest).build());
    }
}
