/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnomaliesRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<ListAnomaliesRequest.Builder, ListAnomaliesRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("anomalyDetectorArn").getter(getter(ListAnomaliesRequest::anomalyDetectorArn))
            .setter(setter(Builder::anomalyDetectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyDetectorArn").build())
            .build();

    private static final SdkField<String> SUPPRESSION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suppressionState").getter(getter(ListAnomaliesRequest::suppressionStateAsString))
            .setter(setter(Builder::suppressionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressionState").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(ListAnomaliesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAnomaliesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD,
            SUPPRESSION_STATE_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private final String anomalyDetectorArn;

    private final String suppressionState;

    private final Integer limit;

    private final String nextToken;

    private ListAnomaliesRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.suppressionState = builder.suppressionState;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Use this to optionally limit the results to only the anomalies found by a certain anomaly detector.
     * </p>
     * 
     * @return Use this to optionally limit the results to only the anomalies found by a certain anomaly detector.
     */
    public final String anomalyDetectorArn() {
        return anomalyDetectorArn;
    }

    /**
     * <p>
     * You can specify this parameter if you want to the operation to return only anomalies that are currently either
     * suppressed or unsuppressed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #suppressionState}
     * will return {@link SuppressionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #suppressionStateAsString}.
     * </p>
     * 
     * @return You can specify this parameter if you want to the operation to return only anomalies that are currently
     *         either suppressed or unsuppressed.
     * @see SuppressionState
     */
    public final SuppressionState suppressionState() {
        return SuppressionState.fromValue(suppressionState);
    }

    /**
     * <p>
     * You can specify this parameter if you want to the operation to return only anomalies that are currently either
     * suppressed or unsuppressed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #suppressionState}
     * will return {@link SuppressionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #suppressionStateAsString}.
     * </p>
     * 
     * @return You can specify this parameter if you want to the operation to return only anomalies that are currently
     *         either suppressed or unsuppressed.
     * @see SuppressionState
     */
    public final String suppressionStateAsString() {
        return suppressionState;
    }

    /**
     * <p>
     * The maximum number of items to return. If you don't specify a value, the default maximum value of 50 items is
     * used.
     * </p>
     * 
     * @return The maximum number of items to return. If you don't specify a value, the default maximum value of 50
     *         items is used.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(suppressionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomaliesRequest)) {
            return false;
        }
        ListAnomaliesRequest other = (ListAnomaliesRequest) obj;
        return Objects.equals(anomalyDetectorArn(), other.anomalyDetectorArn())
                && Objects.equals(suppressionStateAsString(), other.suppressionStateAsString())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnomaliesRequest").add("AnomalyDetectorArn", anomalyDetectorArn())
                .add("SuppressionState", suppressionStateAsString()).add("Limit", limit()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "anomalyDetectorArn":
            return Optional.ofNullable(clazz.cast(anomalyDetectorArn()));
        case "suppressionState":
            return Optional.ofNullable(clazz.cast(suppressionStateAsString()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnomaliesRequest, T> g) {
        return obj -> g.apply((ListAnomaliesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAnomaliesRequest> {
        /**
         * <p>
         * Use this to optionally limit the results to only the anomalies found by a certain anomaly detector.
         * </p>
         * 
         * @param anomalyDetectorArn
         *        Use this to optionally limit the results to only the anomalies found by a certain anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorArn(String anomalyDetectorArn);

        /**
         * <p>
         * You can specify this parameter if you want to the operation to return only anomalies that are currently
         * either suppressed or unsuppressed.
         * </p>
         * 
         * @param suppressionState
         *        You can specify this parameter if you want to the operation to return only anomalies that are
         *        currently either suppressed or unsuppressed.
         * @see SuppressionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuppressionState
         */
        Builder suppressionState(String suppressionState);

        /**
         * <p>
         * You can specify this parameter if you want to the operation to return only anomalies that are currently
         * either suppressed or unsuppressed.
         * </p>
         * 
         * @param suppressionState
         *        You can specify this parameter if you want to the operation to return only anomalies that are
         *        currently either suppressed or unsuppressed.
         * @see SuppressionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuppressionState
         */
        Builder suppressionState(SuppressionState suppressionState);

        /**
         * <p>
         * The maximum number of items to return. If you don't specify a value, the default maximum value of 50 items is
         * used.
         * </p>
         * 
         * @param limit
         *        The maximum number of items to return. If you don't specify a value, the default maximum value of 50
         *        items is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String anomalyDetectorArn;

        private String suppressionState;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomaliesRequest model) {
            super(model);
            anomalyDetectorArn(model.anomalyDetectorArn);
            suppressionState(model.suppressionState);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getAnomalyDetectorArn() {
            return anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getSuppressionState() {
            return suppressionState;
        }

        public final void setSuppressionState(String suppressionState) {
            this.suppressionState = suppressionState;
        }

        @Override
        public final Builder suppressionState(String suppressionState) {
            this.suppressionState = suppressionState;
            return this;
        }

        @Override
        public final Builder suppressionState(SuppressionState suppressionState) {
            this.suppressionState(suppressionState == null ? null : suppressionState.toString());
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAnomaliesRequest build() {
            return new ListAnomaliesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
