/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object contains the metadata for one <code>LiveTailSessionUpdate</code> structure. It indicates whether that
 * update includes only a sample of 500 log events out of a larger number of ingested log events, or if it contains all
 * of the matching log events ingested during that second of time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LiveTailSessionMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<LiveTailSessionMetadata.Builder, LiveTailSessionMetadata> {
    private static final SdkField<Boolean> SAMPLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("sampled").getter(getter(LiveTailSessionMetadata::sampled)).setter(setter(Builder::sampled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean sampled;

    private LiveTailSessionMetadata(BuilderImpl builder) {
        this.sampled = builder.sampled;
    }

    /**
     * <p>
     * If this is <code>true</code>, then more than 500 log events matched the request for this update, and the
     * <code>sessionResults</code> includes a sample of 500 of those events.
     * </p>
     * <p>
     * If this is <code>false</code>, then 500 or fewer log events matched the request for this update, so no sampling
     * was necessary. In this case, the <code>sessionResults</code> array includes all log events that matched your
     * request during this time.
     * </p>
     * 
     * @return If this is <code>true</code>, then more than 500 log events matched the request for this update, and the
     *         <code>sessionResults</code> includes a sample of 500 of those events.</p>
     *         <p>
     *         If this is <code>false</code>, then 500 or fewer log events matched the request for this update, so no
     *         sampling was necessary. In this case, the <code>sessionResults</code> array includes all log events that
     *         matched your request during this time.
     */
    public final Boolean sampled() {
        return sampled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sampled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiveTailSessionMetadata)) {
            return false;
        }
        LiveTailSessionMetadata other = (LiveTailSessionMetadata) obj;
        return Objects.equals(sampled(), other.sampled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LiveTailSessionMetadata").add("Sampled", sampled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sampled":
            return Optional.ofNullable(clazz.cast(sampled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LiveTailSessionMetadata, T> g) {
        return obj -> g.apply((LiveTailSessionMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LiveTailSessionMetadata> {
        /**
         * <p>
         * If this is <code>true</code>, then more than 500 log events matched the request for this update, and the
         * <code>sessionResults</code> includes a sample of 500 of those events.
         * </p>
         * <p>
         * If this is <code>false</code>, then 500 or fewer log events matched the request for this update, so no
         * sampling was necessary. In this case, the <code>sessionResults</code> array includes all log events that
         * matched your request during this time.
         * </p>
         * 
         * @param sampled
         *        If this is <code>true</code>, then more than 500 log events matched the request for this update, and
         *        the <code>sessionResults</code> includes a sample of 500 of those events.</p>
         *        <p>
         *        If this is <code>false</code>, then 500 or fewer log events matched the request for this update, so no
         *        sampling was necessary. In this case, the <code>sessionResults</code> array includes all log events
         *        that matched your request during this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampled(Boolean sampled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean sampled;

        private BuilderImpl() {
        }

        private BuilderImpl(LiveTailSessionMetadata model) {
            sampled(model.sampled);
        }

        public final Boolean getSampled() {
            return sampled;
        }

        public final void setSampled(Boolean sampled) {
            this.sampled = sampled;
        }

        @Override
        public final Builder sampled(Boolean sampled) {
            this.sampled = sampled;
            return this;
        }

        @Override
        public LiveTailSessionMetadata build() {
            return new LiveTailSessionMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
