/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDeliveryDestinationPolicyRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<PutDeliveryDestinationPolicyRequest.Builder, PutDeliveryDestinationPolicyRequest> {
    private static final SdkField<String> DELIVERY_DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deliveryDestinationName").getter(getter(PutDeliveryDestinationPolicyRequest::deliveryDestinationName))
            .setter(setter(Builder::deliveryDestinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestinationName").build())
            .build();

    private static final SdkField<String> DELIVERY_DESTINATION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deliveryDestinationPolicy")
            .getter(getter(PutDeliveryDestinationPolicyRequest::deliveryDestinationPolicy))
            .setter(setter(Builder::deliveryDestinationPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestinationPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DELIVERY_DESTINATION_NAME_FIELD, DELIVERY_DESTINATION_POLICY_FIELD));

    private final String deliveryDestinationName;

    private final String deliveryDestinationPolicy;

    private PutDeliveryDestinationPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryDestinationName = builder.deliveryDestinationName;
        this.deliveryDestinationPolicy = builder.deliveryDestinationPolicy;
    }

    /**
     * <p>
     * The name of the delivery destination to assign this policy to.
     * </p>
     * 
     * @return The name of the delivery destination to assign this policy to.
     */
    public final String deliveryDestinationName() {
        return deliveryDestinationName;
    }

    /**
     * <p>
     * The contents of the policy.
     * </p>
     * 
     * @return The contents of the policy.
     */
    public final String deliveryDestinationPolicy() {
        return deliveryDestinationPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deliveryDestinationName());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryDestinationPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDeliveryDestinationPolicyRequest)) {
            return false;
        }
        PutDeliveryDestinationPolicyRequest other = (PutDeliveryDestinationPolicyRequest) obj;
        return Objects.equals(deliveryDestinationName(), other.deliveryDestinationName())
                && Objects.equals(deliveryDestinationPolicy(), other.deliveryDestinationPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDeliveryDestinationPolicyRequest").add("DeliveryDestinationName", deliveryDestinationName())
                .add("DeliveryDestinationPolicy", deliveryDestinationPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deliveryDestinationName":
            return Optional.ofNullable(clazz.cast(deliveryDestinationName()));
        case "deliveryDestinationPolicy":
            return Optional.ofNullable(clazz.cast(deliveryDestinationPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDeliveryDestinationPolicyRequest, T> g) {
        return obj -> g.apply((PutDeliveryDestinationPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDeliveryDestinationPolicyRequest> {
        /**
         * <p>
         * The name of the delivery destination to assign this policy to.
         * </p>
         * 
         * @param deliveryDestinationName
         *        The name of the delivery destination to assign this policy to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryDestinationName(String deliveryDestinationName);

        /**
         * <p>
         * The contents of the policy.
         * </p>
         * 
         * @param deliveryDestinationPolicy
         *        The contents of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryDestinationPolicy(String deliveryDestinationPolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String deliveryDestinationName;

        private String deliveryDestinationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDeliveryDestinationPolicyRequest model) {
            super(model);
            deliveryDestinationName(model.deliveryDestinationName);
            deliveryDestinationPolicy(model.deliveryDestinationPolicy);
        }

        public final String getDeliveryDestinationName() {
            return deliveryDestinationName;
        }

        public final void setDeliveryDestinationName(String deliveryDestinationName) {
            this.deliveryDestinationName = deliveryDestinationName;
        }

        @Override
        public final Builder deliveryDestinationName(String deliveryDestinationName) {
            this.deliveryDestinationName = deliveryDestinationName;
            return this;
        }

        public final String getDeliveryDestinationPolicy() {
            return deliveryDestinationPolicy;
        }

        public final void setDeliveryDestinationPolicy(String deliveryDestinationPolicy) {
            this.deliveryDestinationPolicy = deliveryDestinationPolicy;
        }

        @Override
        public final Builder deliveryDestinationPolicy(String deliveryDestinationPolicy) {
            this.deliveryDestinationPolicy = deliveryDestinationPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDeliveryDestinationPolicyRequest build() {
            return new PutDeliveryDestinationPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
