/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetBuildsResponse extends CodeBuildResponse implements
        ToCopyableBuilder<BatchGetBuildsResponse.Builder, BatchGetBuildsResponse> {
    private static final SdkField<List<Build>> BUILDS_FIELD = SdkField
            .<List<Build>> builder(MarshallingType.LIST)
            .memberName("builds")
            .getter(getter(BatchGetBuildsResponse::builds))
            .setter(setter(Builder::builds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("builds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Build> builder(MarshallingType.SDK_POJO)
                                            .constructor(Build::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BUILDS_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("buildsNotFound")
            .getter(getter(BatchGetBuildsResponse::buildsNotFound))
            .setter(setter(Builder::buildsNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildsNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILDS_FIELD,
            BUILDS_NOT_FOUND_FIELD));

    private final List<Build> builds;

    private final List<String> buildsNotFound;

    private BatchGetBuildsResponse(BuilderImpl builder) {
        super(builder);
        this.builds = builder.builds;
        this.buildsNotFound = builder.buildsNotFound;
    }

    /**
     * For responses, this returns true if the service returned a value for the Builds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBuilds() {
        return builds != null && !(builds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the requested builds.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBuilds} method.
     * </p>
     * 
     * @return Information about the requested builds.
     */
    public final List<Build> builds() {
        return builds;
    }

    /**
     * For responses, this returns true if the service returned a value for the BuildsNotFound property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBuildsNotFound() {
        return buildsNotFound != null && !(buildsNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of builds for which information could not be found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBuildsNotFound} method.
     * </p>
     * 
     * @return The IDs of builds for which information could not be found.
     */
    public final List<String> buildsNotFound() {
        return buildsNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBuilds() ? builds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBuildsNotFound() ? buildsNotFound() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetBuildsResponse)) {
            return false;
        }
        BatchGetBuildsResponse other = (BatchGetBuildsResponse) obj;
        return hasBuilds() == other.hasBuilds() && Objects.equals(builds(), other.builds())
                && hasBuildsNotFound() == other.hasBuildsNotFound() && Objects.equals(buildsNotFound(), other.buildsNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetBuildsResponse").add("Builds", hasBuilds() ? builds() : null)
                .add("BuildsNotFound", hasBuildsNotFound() ? buildsNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "builds":
            return Optional.ofNullable(clazz.cast(builds()));
        case "buildsNotFound":
            return Optional.ofNullable(clazz.cast(buildsNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetBuildsResponse, T> g) {
        return obj -> g.apply((BatchGetBuildsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetBuildsResponse> {
        /**
         * <p>
         * Information about the requested builds.
         * </p>
         * 
         * @param builds
         *        Information about the requested builds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder builds(Collection<Build> builds);

        /**
         * <p>
         * Information about the requested builds.
         * </p>
         * 
         * @param builds
         *        Information about the requested builds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder builds(Build... builds);

        /**
         * <p>
         * Information about the requested builds.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.Build.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codebuild.model.Build#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.Build.Builder#build()} is called immediately and its
         * result is passed to {@link #builds(List<Build>)}.
         * 
         * @param builds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.Build.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #builds(java.util.Collection<Build>)
         */
        Builder builds(Consumer<Build.Builder>... builds);

        /**
         * <p>
         * The IDs of builds for which information could not be found.
         * </p>
         * 
         * @param buildsNotFound
         *        The IDs of builds for which information could not be found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildsNotFound(Collection<String> buildsNotFound);

        /**
         * <p>
         * The IDs of builds for which information could not be found.
         * </p>
         * 
         * @param buildsNotFound
         *        The IDs of builds for which information could not be found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildsNotFound(String... buildsNotFound);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private List<Build> builds = DefaultSdkAutoConstructList.getInstance();

        private List<String> buildsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetBuildsResponse model) {
            super(model);
            builds(model.builds);
            buildsNotFound(model.buildsNotFound);
        }

        public final List<Build.Builder> getBuilds() {
            List<Build.Builder> result = BuildsCopier.copyToBuilder(this.builds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuilds(Collection<Build.BuilderImpl> builds) {
            this.builds = BuildsCopier.copyFromBuilder(builds);
        }

        @Override
        public final Builder builds(Collection<Build> builds) {
            this.builds = BuildsCopier.copy(builds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builds(Build... builds) {
            builds(Arrays.asList(builds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builds(Consumer<Build.Builder>... builds) {
            builds(Stream.of(builds).map(c -> Build.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getBuildsNotFound() {
            if (buildsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return buildsNotFound;
        }

        public final void setBuildsNotFound(Collection<String> buildsNotFound) {
            this.buildsNotFound = BuildIdsCopier.copy(buildsNotFound);
        }

        @Override
        public final Builder buildsNotFound(Collection<String> buildsNotFound) {
            this.buildsNotFound = BuildIdsCopier.copy(buildsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsNotFound(String... buildsNotFound) {
            buildsNotFound(Arrays.asList(buildsNotFound));
            return this;
        }

        @Override
        public BatchGetBuildsResponse build() {
            return new BatchGetBuildsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
