/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a delete branch operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBranchResponse extends CodeCommitResponse implements
        ToCopyableBuilder<DeleteBranchResponse.Builder, DeleteBranchResponse> {
    private static final SdkField<BranchInfo> DELETED_BRANCH_FIELD = SdkField.<BranchInfo> builder(MarshallingType.SDK_POJO)
            .memberName("deletedBranch").getter(getter(DeleteBranchResponse::deletedBranch))
            .setter(setter(Builder::deletedBranch)).constructor(BranchInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletedBranch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETED_BRANCH_FIELD));

    private final BranchInfo deletedBranch;

    private DeleteBranchResponse(BuilderImpl builder) {
        super(builder);
        this.deletedBranch = builder.deletedBranch;
    }

    /**
     * <p>
     * Information about the branch deleted by the operation, including the branch name and the commit ID that was the
     * tip of the branch.
     * </p>
     * 
     * @return Information about the branch deleted by the operation, including the branch name and the commit ID that
     *         was the tip of the branch.
     */
    public final BranchInfo deletedBranch() {
        return deletedBranch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deletedBranch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBranchResponse)) {
            return false;
        }
        DeleteBranchResponse other = (DeleteBranchResponse) obj;
        return Objects.equals(deletedBranch(), other.deletedBranch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBranchResponse").add("DeletedBranch", deletedBranch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deletedBranch":
            return Optional.ofNullable(clazz.cast(deletedBranch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteBranchResponse, T> g) {
        return obj -> g.apply((DeleteBranchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteBranchResponse> {
        /**
         * <p>
         * Information about the branch deleted by the operation, including the branch name and the commit ID that was
         * the tip of the branch.
         * </p>
         * 
         * @param deletedBranch
         *        Information about the branch deleted by the operation, including the branch name and the commit ID
         *        that was the tip of the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedBranch(BranchInfo deletedBranch);

        /**
         * <p>
         * Information about the branch deleted by the operation, including the branch name and the commit ID that was
         * the tip of the branch.
         * </p>
         * This is a convenience method that creates an instance of the {@link BranchInfo.Builder} avoiding the need to
         * create one manually via {@link BranchInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BranchInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #deletedBranch(BranchInfo)}.
         * 
         * @param deletedBranch
         *        a consumer that will call methods on {@link BranchInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deletedBranch(BranchInfo)
         */
        default Builder deletedBranch(Consumer<BranchInfo.Builder> deletedBranch) {
            return deletedBranch(BranchInfo.builder().applyMutation(deletedBranch).build());
        }
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private BranchInfo deletedBranch;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBranchResponse model) {
            super(model);
            deletedBranch(model.deletedBranch);
        }

        public final BranchInfo.Builder getDeletedBranch() {
            return deletedBranch != null ? deletedBranch.toBuilder() : null;
        }

        public final void setDeletedBranch(BranchInfo.BuilderImpl deletedBranch) {
            this.deletedBranch = deletedBranch != null ? deletedBranch.build() : null;
        }

        @Override
        public final Builder deletedBranch(BranchInfo deletedBranch) {
            this.deletedBranch = deletedBranch;
            return this;
        }

        @Override
        public DeleteBranchResponse build() {
            return new DeleteBranchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
