/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFileCommitHistoryRequest extends CodeCommitRequest implements
        ToCopyableBuilder<ListFileCommitHistoryRequest.Builder, ListFileCommitHistoryRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(ListFileCommitHistoryRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> COMMIT_SPECIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitSpecifier").getter(getter(ListFileCommitHistoryRequest::commitSpecifier))
            .setter(setter(Builder::commitSpecifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitSpecifier").build()).build();

    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filePath").getter(getter(ListFileCommitHistoryRequest::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListFileCommitHistoryRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFileCommitHistoryRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            COMMIT_SPECIFIER_FIELD, FILE_PATH_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String repositoryName;

    private final String commitSpecifier;

    private final String filePath;

    private final Integer maxResults;

    private final String nextToken;

    private ListFileCommitHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.commitSpecifier = builder.commitSpecifier;
        this.filePath = builder.filePath;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the repository that contains the file.
     * </p>
     * 
     * @return The name of the repository that contains the file.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The fully quaified reference that identifies the commit that contains the file. For example, you can specify a
     * full commit ID, a tag, a branch name, or a reference such as <code>refs/heads/main</code>. If none is provided,
     * the head commit is used.
     * </p>
     * 
     * @return The fully quaified reference that identifies the commit that contains the file. For example, you can
     *         specify a full commit ID, a tag, a branch name, or a reference such as <code>refs/heads/main</code>. If
     *         none is provided, the head commit is used.
     */
    public final String commitSpecifier() {
        return commitSpecifier;
    }

    /**
     * <p>
     * The full path of the file whose history you want to retrieve, including the name of the file.
     * </p>
     * 
     * @return The full path of the file whose history you want to retrieve, including the name of the file.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * A non-zero, non-negative integer used to limit the number of returned results.
     * </p>
     * 
     * @return A non-zero, non-negative integer used to limit the number of returned results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An enumeration token that allows the operation to batch the results.
     * </p>
     * 
     * @return An enumeration token that allows the operation to batch the results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(commitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFileCommitHistoryRequest)) {
            return false;
        }
        ListFileCommitHistoryRequest other = (ListFileCommitHistoryRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(commitSpecifier(), other.commitSpecifier()) && Objects.equals(filePath(), other.filePath())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFileCommitHistoryRequest").add("RepositoryName", repositoryName())
                .add("CommitSpecifier", commitSpecifier()).add("FilePath", filePath()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "commitSpecifier":
            return Optional.ofNullable(clazz.cast(commitSpecifier()));
        case "filePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFileCommitHistoryRequest, T> g) {
        return obj -> g.apply((ListFileCommitHistoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListFileCommitHistoryRequest> {
        /**
         * <p>
         * The name of the repository that contains the file.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that contains the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The fully quaified reference that identifies the commit that contains the file. For example, you can specify
         * a full commit ID, a tag, a branch name, or a reference such as <code>refs/heads/main</code>. If none is
         * provided, the head commit is used.
         * </p>
         * 
         * @param commitSpecifier
         *        The fully quaified reference that identifies the commit that contains the file. For example, you can
         *        specify a full commit ID, a tag, a branch name, or a reference such as <code>refs/heads/main</code>.
         *        If none is provided, the head commit is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitSpecifier(String commitSpecifier);

        /**
         * <p>
         * The full path of the file whose history you want to retrieve, including the name of the file.
         * </p>
         * 
         * @param filePath
         *        The full path of the file whose history you want to retrieve, including the name of the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * A non-zero, non-negative integer used to limit the number of returned results.
         * </p>
         * 
         * @param maxResults
         *        A non-zero, non-negative integer used to limit the number of returned results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An enumeration token that allows the operation to batch the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that allows the operation to batch the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private String commitSpecifier;

        private String filePath;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFileCommitHistoryRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            commitSpecifier(model.commitSpecifier);
            filePath(model.filePath);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getCommitSpecifier() {
            return commitSpecifier;
        }

        public final void setCommitSpecifier(String commitSpecifier) {
            this.commitSpecifier = commitSpecifier;
        }

        @Override
        public final Builder commitSpecifier(String commitSpecifier) {
            this.commitSpecifier = commitSpecifier;
            return this;
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFileCommitHistoryRequest build() {
            return new ListFileCommitHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
