/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TargetLabel {
    BLUE("Blue"),
    GREEN("Green"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetLabel> VALUE_MAP;
    private final String value;

    private TargetLabel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetLabel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetLabel> knownValues() {
        EnumSet<TargetLabel> knownValues = EnumSet.allOf(TargetLabel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TargetLabel.class, TargetLabel::toString);
    }
}

