/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TriggerEventType {
    DEPLOYMENT_START("DeploymentStart"),
    DEPLOYMENT_SUCCESS("DeploymentSuccess"),
    DEPLOYMENT_FAILURE("DeploymentFailure"),
    DEPLOYMENT_STOP("DeploymentStop"),
    DEPLOYMENT_ROLLBACK("DeploymentRollback"),
    DEPLOYMENT_READY("DeploymentReady"),
    INSTANCE_START("InstanceStart"),
    INSTANCE_SUCCESS("InstanceSuccess"),
    INSTANCE_FAILURE("InstanceFailure"),
    INSTANCE_READY("InstanceReady"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TriggerEventType> VALUE_MAP;
    private final String value;

    private TriggerEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TriggerEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TriggerEventType> knownValues() {
        EnumSet<TriggerEventType> knownValues = EnumSet.allOf(TriggerEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TriggerEventType.class, TriggerEventType::toString);
    }
}

