/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The specific duration in which the metric is flagged as anomalous.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalyInstance implements SdkPojo, Serializable, ToCopyableBuilder<AnomalyInstance.Builder, AnomalyInstance> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(AnomalyInstance::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AnomalyInstance::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(AnomalyInstance::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<UserFeedback> USER_FEEDBACK_FIELD = SdkField.<UserFeedback> builder(MarshallingType.SDK_POJO)
            .memberName("userFeedback").getter(getter(AnomalyInstance::userFeedback)).setter(setter(Builder::userFeedback))
            .constructor(UserFeedback::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userFeedback").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, ID_FIELD,
            START_TIME_FIELD, USER_FEEDBACK_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant endTime;

    private final String id;

    private final Instant startTime;

    private final UserFeedback userFeedback;

    private AnomalyInstance(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.id = builder.id;
        this.startTime = builder.startTime;
        this.userFeedback = builder.userFeedback;
    }

    /**
     * <p>
     * The end time of the period during which the metric is flagged as anomalous. This is specified using the ISO 8601
     * format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * 
     * @return The end time of the period during which the metric is flagged as anomalous. This is specified using the
     *         ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02
     *         PM UTC.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The universally unique identifier (UUID) of an instance of an anomaly in a metric.
     * </p>
     * 
     * @return The universally unique identifier (UUID) of an instance of an anomaly in a metric.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The start time of the period during which the metric is flagged as anomalous. This is specified using the ISO
     * 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * 
     * @return The start time of the period during which the metric is flagged as anomalous. This is specified using the
     *         ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02
     *         PM UTC.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Feedback type on a specific instance of anomaly submitted by the user.
     * </p>
     * 
     * @return Feedback type on a specific instance of anomaly submitted by the user.
     */
    public final UserFeedback userFeedback() {
        return userFeedback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(userFeedback());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyInstance)) {
            return false;
        }
        AnomalyInstance other = (AnomalyInstance) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(id(), other.id())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(userFeedback(), other.userFeedback());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalyInstance").add("EndTime", endTime()).add("Id", id()).add("StartTime", startTime())
                .add("UserFeedback", userFeedback()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "userFeedback":
            return Optional.ofNullable(clazz.cast(userFeedback()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyInstance, T> g) {
        return obj -> g.apply((AnomalyInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalyInstance> {
        /**
         * <p>
         * The end time of the period during which the metric is flagged as anomalous. This is specified using the ISO
         * 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * @param endTime
         *        The end time of the period during which the metric is flagged as anomalous. This is specified using
         *        the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020
         *        1:15:02 PM UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The universally unique identifier (UUID) of an instance of an anomaly in a metric.
         * </p>
         * 
         * @param id
         *        The universally unique identifier (UUID) of an instance of an anomaly in a metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The start time of the period during which the metric is flagged as anomalous. This is specified using the ISO
         * 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * @param startTime
         *        The start time of the period during which the metric is flagged as anomalous. This is specified using
         *        the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020
         *        1:15:02 PM UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Feedback type on a specific instance of anomaly submitted by the user.
         * </p>
         * 
         * @param userFeedback
         *        Feedback type on a specific instance of anomaly submitted by the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userFeedback(UserFeedback userFeedback);

        /**
         * <p>
         * Feedback type on a specific instance of anomaly submitted by the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserFeedback.Builder} avoiding the need
         * to create one manually via {@link UserFeedback#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserFeedback.Builder#build()} is called immediately and its
         * result is passed to {@link #userFeedback(UserFeedback)}.
         * 
         * @param userFeedback
         *        a consumer that will call methods on {@link UserFeedback.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userFeedback(UserFeedback)
         */
        default Builder userFeedback(Consumer<UserFeedback.Builder> userFeedback) {
            return userFeedback(UserFeedback.builder().applyMutation(userFeedback).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant endTime;

        private String id;

        private Instant startTime;

        private UserFeedback userFeedback;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyInstance model) {
            endTime(model.endTime);
            id(model.id);
            startTime(model.startTime);
            userFeedback(model.userFeedback);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final UserFeedback.Builder getUserFeedback() {
            return userFeedback != null ? userFeedback.toBuilder() : null;
        }

        public final void setUserFeedback(UserFeedback.BuilderImpl userFeedback) {
            this.userFeedback = userFeedback != null ? userFeedback.build() : null;
        }

        @Override
        public final Builder userFeedback(UserFeedback userFeedback) {
            this.userFeedback = userFeedback;
            return this;
        }

        @Override
        public AnomalyInstance build() {
            return new AnomalyInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
