/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about potential recommendations that might be created from the analysis of profiling data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingsReportSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingsReportSummary.Builder, FindingsReportSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(FindingsReportSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> PROFILE_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("profileEndTime")
            .getter(getter(FindingsReportSummary::profileEndTime))
            .setter(setter(Builder::profileEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileEndTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> PROFILE_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("profileStartTime")
            .getter(getter(FindingsReportSummary::profileStartTime))
            .setter(setter(Builder::profileStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profilingGroupName").getter(getter(FindingsReportSummary::profilingGroupName))
            .setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profilingGroupName").build())
            .build();

    private static final SdkField<Integer> TOTAL_NUMBER_OF_FINDINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalNumberOfFindings").getter(getter(FindingsReportSummary::totalNumberOfFindings))
            .setter(setter(Builder::totalNumberOfFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalNumberOfFindings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            PROFILE_END_TIME_FIELD, PROFILE_START_TIME_FIELD, PROFILING_GROUP_NAME_FIELD, TOTAL_NUMBER_OF_FINDINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Instant profileEndTime;

    private final Instant profileStartTime;

    private final String profilingGroupName;

    private final Integer totalNumberOfFindings;

    private FindingsReportSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.profileEndTime = builder.profileEndTime;
        this.profileStartTime = builder.profileStartTime;
        this.profilingGroupName = builder.profilingGroupName;
        this.totalNumberOfFindings = builder.totalNumberOfFindings;
    }

    /**
     * <p>
     * The universally unique identifier (UUID) of the recommendation report.
     * </p>
     * 
     * @return The universally unique identifier (UUID) of the recommendation report.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The end time of the period during which the metric is flagged as anomalous. This is specified using the ISO 8601
     * format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * 
     * @return The end time of the period during which the metric is flagged as anomalous. This is specified using the
     *         ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02
     *         PM UTC.
     */
    public final Instant profileEndTime() {
        return profileEndTime;
    }

    /**
     * <p>
     * The start time of the profile the analysis data is about. This is specified using the ISO 8601 format. For
     * example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * </p>
     * 
     * @return The start time of the profile the analysis data is about. This is specified using the ISO 8601 format.
     *         For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public final Instant profileStartTime() {
        return profileStartTime;
    }

    /**
     * <p>
     * The name of the profiling group that is associated with the analysis data.
     * </p>
     * 
     * @return The name of the profiling group that is associated with the analysis data.
     */
    public final String profilingGroupName() {
        return profilingGroupName;
    }

    /**
     * <p>
     * The total number of different recommendations that were found by the analysis.
     * </p>
     * 
     * @return The total number of different recommendations that were found by the analysis.
     */
    public final Integer totalNumberOfFindings() {
        return totalNumberOfFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(profileEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(profileStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfFindings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingsReportSummary)) {
            return false;
        }
        FindingsReportSummary other = (FindingsReportSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(profileEndTime(), other.profileEndTime())
                && Objects.equals(profileStartTime(), other.profileStartTime())
                && Objects.equals(profilingGroupName(), other.profilingGroupName())
                && Objects.equals(totalNumberOfFindings(), other.totalNumberOfFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingsReportSummary").add("Id", id()).add("ProfileEndTime", profileEndTime())
                .add("ProfileStartTime", profileStartTime()).add("ProfilingGroupName", profilingGroupName())
                .add("TotalNumberOfFindings", totalNumberOfFindings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "profileEndTime":
            return Optional.ofNullable(clazz.cast(profileEndTime()));
        case "profileStartTime":
            return Optional.ofNullable(clazz.cast(profileStartTime()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        case "totalNumberOfFindings":
            return Optional.ofNullable(clazz.cast(totalNumberOfFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingsReportSummary, T> g) {
        return obj -> g.apply((FindingsReportSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingsReportSummary> {
        /**
         * <p>
         * The universally unique identifier (UUID) of the recommendation report.
         * </p>
         * 
         * @param id
         *        The universally unique identifier (UUID) of the recommendation report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The end time of the period during which the metric is flagged as anomalous. This is specified using the ISO
         * 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * @param profileEndTime
         *        The end time of the period during which the metric is flagged as anomalous. This is specified using
         *        the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020
         *        1:15:02 PM UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileEndTime(Instant profileEndTime);

        /**
         * <p>
         * The start time of the profile the analysis data is about. This is specified using the ISO 8601 format. For
         * example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * </p>
         * 
         * @param profileStartTime
         *        The start time of the profile the analysis data is about. This is specified using the ISO 8601 format.
         *        For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileStartTime(Instant profileStartTime);

        /**
         * <p>
         * The name of the profiling group that is associated with the analysis data.
         * </p>
         * 
         * @param profilingGroupName
         *        The name of the profiling group that is associated with the analysis data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        /**
         * <p>
         * The total number of different recommendations that were found by the analysis.
         * </p>
         * 
         * @param totalNumberOfFindings
         *        The total number of different recommendations that were found by the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfFindings(Integer totalNumberOfFindings);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Instant profileEndTime;

        private Instant profileStartTime;

        private String profilingGroupName;

        private Integer totalNumberOfFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingsReportSummary model) {
            id(model.id);
            profileEndTime(model.profileEndTime);
            profileStartTime(model.profileStartTime);
            profilingGroupName(model.profilingGroupName);
            totalNumberOfFindings(model.totalNumberOfFindings);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getProfileEndTime() {
            return profileEndTime;
        }

        public final void setProfileEndTime(Instant profileEndTime) {
            this.profileEndTime = profileEndTime;
        }

        @Override
        public final Builder profileEndTime(Instant profileEndTime) {
            this.profileEndTime = profileEndTime;
            return this;
        }

        public final Instant getProfileStartTime() {
            return profileStartTime;
        }

        public final void setProfileStartTime(Instant profileStartTime) {
            this.profileStartTime = profileStartTime;
        }

        @Override
        public final Builder profileStartTime(Instant profileStartTime) {
            this.profileStartTime = profileStartTime;
            return this;
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final Integer getTotalNumberOfFindings() {
            return totalNumberOfFindings;
        }

        public final void setTotalNumberOfFindings(Integer totalNumberOfFindings) {
            this.totalNumberOfFindings = totalNumberOfFindings;
        }

        @Override
        public final Builder totalNumberOfFindings(Integer totalNumberOfFindings) {
            this.totalNumberOfFindings = totalNumberOfFindings;
            return this;
        }

        @Override
        public FindingsReportSummary build() {
            return new FindingsReportSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
