/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class FindingIdentifiersCopier {
    static List<FindingIdentifier> copy(Collection<? extends FindingIdentifier> findingIdentifiersParam) {
        List<FindingIdentifier> list;
        if (findingIdentifiersParam == null || findingIdentifiersParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FindingIdentifier> modifiableList = new ArrayList<>();
            findingIdentifiersParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<FindingIdentifier> copyFromBuilder(Collection<? extends FindingIdentifier.Builder> findingIdentifiersParam) {
        List<FindingIdentifier> list;
        if (findingIdentifiersParam == null || findingIdentifiersParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FindingIdentifier> modifiableList = new ArrayList<>();
            findingIdentifiersParam.forEach(entry -> {
                FindingIdentifier member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<FindingIdentifier.Builder> copyToBuilder(Collection<? extends FindingIdentifier> findingIdentifiersParam) {
        List<FindingIdentifier.Builder> list;
        if (findingIdentifiersParam == null || findingIdentifiersParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FindingIdentifier.Builder> modifiableList = new ArrayList<>();
            findingIdentifiersParam.forEach(entry -> {
                FindingIdentifier.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
