/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetricsSummaryRequest extends CodeGuruSecurityRequest implements
        ToCopyableBuilder<GetMetricsSummaryRequest.Builder, GetMetricsSummaryRequest> {
    private static final SdkField<Instant> DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("date")
            .getter(getter(GetMetricsSummaryRequest::date)).setter(setter(Builder::date))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("date").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_FIELD));

    private final Instant date;

    private GetMetricsSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.date = builder.date;
    }

    /**
     * <p>
     * The date you want to retrieve summary metrics from, rounded to the nearest day. The date must be within the past
     * two years since metrics data is only stored for two years. If a date outside of this range is passed, the
     * response will be empty.
     * </p>
     * 
     * @return The date you want to retrieve summary metrics from, rounded to the nearest day. The date must be within
     *         the past two years since metrics data is only stored for two years. If a date outside of this range is
     *         passed, the response will be empty.
     */
    public final Instant date() {
        return date;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(date());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricsSummaryRequest)) {
            return false;
        }
        GetMetricsSummaryRequest other = (GetMetricsSummaryRequest) obj;
        return Objects.equals(date(), other.date());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMetricsSummaryRequest").add("Date", date()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "date":
            return Optional.ofNullable(clazz.cast(date()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricsSummaryRequest, T> g) {
        return obj -> g.apply((GetMetricsSummaryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruSecurityRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMetricsSummaryRequest> {
        /**
         * <p>
         * The date you want to retrieve summary metrics from, rounded to the nearest day. The date must be within the
         * past two years since metrics data is only stored for two years. If a date outside of this range is passed,
         * the response will be empty.
         * </p>
         * 
         * @param date
         *        The date you want to retrieve summary metrics from, rounded to the nearest day. The date must be
         *        within the past two years since metrics data is only stored for two years. If a date outside of this
         *        range is passed, the response will be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(Instant date);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruSecurityRequest.BuilderImpl implements Builder {
        private Instant date;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricsSummaryRequest model) {
            super(model);
            date(model.date);
        }

        public final Instant getDate() {
            return date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMetricsSummaryRequest build() {
            return new GetMetricsSummaryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
