/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents revision details of an artifact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArtifactRevision implements SdkPojo, Serializable,
        ToCopyableBuilder<ArtifactRevision.Builder, ArtifactRevision> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ArtifactRevision::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(ArtifactRevision::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final SdkField<String> REVISION_CHANGE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionChangeIdentifier").getter(getter(ArtifactRevision::revisionChangeIdentifier))
            .setter(setter(Builder::revisionChangeIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionChangeIdentifier").build())
            .build();

    private static final SdkField<String> REVISION_SUMMARY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionSummary").getter(getter(ArtifactRevision::revisionSummary))
            .setter(setter(Builder::revisionSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionSummary").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("created").getter(getter(ArtifactRevision::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final SdkField<String> REVISION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionUrl").getter(getter(ArtifactRevision::revisionUrl)).setter(setter(Builder::revisionUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REVISION_ID_FIELD,
            REVISION_CHANGE_IDENTIFIER_FIELD, REVISION_SUMMARY_FIELD, CREATED_FIELD, REVISION_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String revisionId;

    private final String revisionChangeIdentifier;

    private final String revisionSummary;

    private final Instant created;

    private final String revisionUrl;

    private ArtifactRevision(BuilderImpl builder) {
        this.name = builder.name;
        this.revisionId = builder.revisionId;
        this.revisionChangeIdentifier = builder.revisionChangeIdentifier;
        this.revisionSummary = builder.revisionSummary;
        this.created = builder.created;
        this.revisionUrl = builder.revisionUrl;
    }

    /**
     * <p>
     * The name of an artifact. This name might be system-generated, such as "MyApp", or defined by the user when an
     * action is created.
     * </p>
     * 
     * @return The name of an artifact. This name might be system-generated, such as "MyApp", or defined by the user
     *         when an action is created.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The revision ID of the artifact.
     * </p>
     * 
     * @return The revision ID of the artifact.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * An additional identifier for a revision, such as a commit date or, for artifacts stored in Amazon S3 buckets, the
     * ETag value.
     * </p>
     * 
     * @return An additional identifier for a revision, such as a commit date or, for artifacts stored in Amazon S3
     *         buckets, the ETag value.
     */
    public final String revisionChangeIdentifier() {
        return revisionChangeIdentifier;
    }

    /**
     * <p>
     * Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit repositories,
     * the commit message. For Amazon S3 buckets or actions, the user-provided content of a
     * <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.
     * </p>
     * 
     * @return Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit
     *         repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a
     *         <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.
     */
    public final String revisionSummary() {
        return revisionSummary;
    }

    /**
     * <p>
     * The date and time when the most recent revision of the artifact was created, in timestamp format.
     * </p>
     * 
     * @return The date and time when the most recent revision of the artifact was created, in timestamp format.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the
     * commit ID is linked to a commit details page.
     * </p>
     * 
     * @return The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories,
     *         the commit ID is linked to a commit details page.
     */
    public final String revisionUrl() {
        return revisionUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(revisionChangeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(revisionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(revisionUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactRevision)) {
            return false;
        }
        ArtifactRevision other = (ArtifactRevision) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(revisionId(), other.revisionId())
                && Objects.equals(revisionChangeIdentifier(), other.revisionChangeIdentifier())
                && Objects.equals(revisionSummary(), other.revisionSummary()) && Objects.equals(created(), other.created())
                && Objects.equals(revisionUrl(), other.revisionUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArtifactRevision").add("Name", name()).add("RevisionId", revisionId())
                .add("RevisionChangeIdentifier", revisionChangeIdentifier()).add("RevisionSummary", revisionSummary())
                .add("Created", created()).add("RevisionUrl", revisionUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "revisionChangeIdentifier":
            return Optional.ofNullable(clazz.cast(revisionChangeIdentifier()));
        case "revisionSummary":
            return Optional.ofNullable(clazz.cast(revisionSummary()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "revisionUrl":
            return Optional.ofNullable(clazz.cast(revisionUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArtifactRevision, T> g) {
        return obj -> g.apply((ArtifactRevision) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArtifactRevision> {
        /**
         * <p>
         * The name of an artifact. This name might be system-generated, such as "MyApp", or defined by the user when an
         * action is created.
         * </p>
         * 
         * @param name
         *        The name of an artifact. This name might be system-generated, such as "MyApp", or defined by the user
         *        when an action is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The revision ID of the artifact.
         * </p>
         * 
         * @param revisionId
         *        The revision ID of the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * An additional identifier for a revision, such as a commit date or, for artifacts stored in Amazon S3 buckets,
         * the ETag value.
         * </p>
         * 
         * @param revisionChangeIdentifier
         *        An additional identifier for a revision, such as a commit date or, for artifacts stored in Amazon S3
         *        buckets, the ETag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionChangeIdentifier(String revisionChangeIdentifier);

        /**
         * <p>
         * Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit
         * repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a
         * <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.
         * </p>
         * 
         * @param revisionSummary
         *        Summary information about the most recent revision of the artifact. For GitHub and AWS CodeCommit
         *        repositories, the commit message. For Amazon S3 buckets or actions, the user-provided content of a
         *        <code>codepipeline-artifact-revision-summary</code> key specified in the object metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionSummary(String revisionSummary);

        /**
         * <p>
         * The date and time when the most recent revision of the artifact was created, in timestamp format.
         * </p>
         * 
         * @param created
         *        The date and time when the most recent revision of the artifact was created, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit repositories, the
         * commit ID is linked to a commit details page.
         * </p>
         * 
         * @param revisionUrl
         *        The commit ID for the artifact revision. For artifacts stored in GitHub or AWS CodeCommit
         *        repositories, the commit ID is linked to a commit details page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionUrl(String revisionUrl);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String revisionId;

        private String revisionChangeIdentifier;

        private String revisionSummary;

        private Instant created;

        private String revisionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactRevision model) {
            name(model.name);
            revisionId(model.revisionId);
            revisionChangeIdentifier(model.revisionChangeIdentifier);
            revisionSummary(model.revisionSummary);
            created(model.created);
            revisionUrl(model.revisionUrl);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getRevisionChangeIdentifier() {
            return revisionChangeIdentifier;
        }

        public final void setRevisionChangeIdentifier(String revisionChangeIdentifier) {
            this.revisionChangeIdentifier = revisionChangeIdentifier;
        }

        @Override
        public final Builder revisionChangeIdentifier(String revisionChangeIdentifier) {
            this.revisionChangeIdentifier = revisionChangeIdentifier;
            return this;
        }

        public final String getRevisionSummary() {
            return revisionSummary;
        }

        public final void setRevisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
        }

        @Override
        public final Builder revisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getRevisionUrl() {
            return revisionUrl;
        }

        public final void setRevisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
        }

        @Override
        public final Builder revisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
            return this;
        }

        @Override
        public ArtifactRevision build() {
            return new ArtifactRevision(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
