/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a job sent in response to a <code>GetThirdPartyJobDetails</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThirdPartyJobDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ThirdPartyJobDetails.Builder, ThirdPartyJobDetails> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ThirdPartyJobDetails::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<ThirdPartyJobData> DATA_FIELD = SdkField.<ThirdPartyJobData> builder(MarshallingType.SDK_POJO)
            .memberName("data").getter(getter(ThirdPartyJobDetails::data)).setter(setter(Builder::data))
            .constructor(ThirdPartyJobData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final SdkField<String> NONCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("nonce")
            .getter(getter(ThirdPartyJobDetails::nonce)).setter(setter(Builder::nonce))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonce").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DATA_FIELD,
            NONCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final ThirdPartyJobData data;

    private final String nonce;

    private ThirdPartyJobDetails(BuilderImpl builder) {
        this.id = builder.id;
        this.data = builder.data;
        this.nonce = builder.nonce;
    }

    /**
     * <p>
     * The identifier used to identify the job details in AWS CodePipeline.
     * </p>
     * 
     * @return The identifier used to identify the job details in AWS CodePipeline.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The data to be returned by the third party job worker.
     * </p>
     * 
     * @return The data to be returned by the third party job worker.
     */
    public final ThirdPartyJobData data() {
        return data;
    }

    /**
     * <p>
     * A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one
     * job worker. Use this number in an <a>AcknowledgeThirdPartyJob</a> request.
     * </p>
     * 
     * @return A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by
     *         only one job worker. Use this number in an <a>AcknowledgeThirdPartyJob</a> request.
     */
    public final String nonce() {
        return nonce;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(nonce());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThirdPartyJobDetails)) {
            return false;
        }
        ThirdPartyJobDetails other = (ThirdPartyJobDetails) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(data(), other.data()) && Objects.equals(nonce(), other.nonce());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThirdPartyJobDetails").add("Id", id()).add("Data", data()).add("Nonce", nonce()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "nonce":
            return Optional.ofNullable(clazz.cast(nonce()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThirdPartyJobDetails, T> g) {
        return obj -> g.apply((ThirdPartyJobDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThirdPartyJobDetails> {
        /**
         * <p>
         * The identifier used to identify the job details in AWS CodePipeline.
         * </p>
         * 
         * @param id
         *        The identifier used to identify the job details in AWS CodePipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The data to be returned by the third party job worker.
         * </p>
         * 
         * @param data
         *        The data to be returned by the third party job worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(ThirdPartyJobData data);

        /**
         * <p>
         * The data to be returned by the third party job worker.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThirdPartyJobData.Builder} avoiding the
         * need to create one manually via {@link ThirdPartyJobData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ThirdPartyJobData.Builder#build()} is called immediately and its
         * result is passed to {@link #data(ThirdPartyJobData)}.
         * 
         * @param data
         *        a consumer that will call methods on {@link ThirdPartyJobData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #data(ThirdPartyJobData)
         */
        default Builder data(Consumer<ThirdPartyJobData.Builder> data) {
            return data(ThirdPartyJobData.builder().applyMutation(data).build());
        }

        /**
         * <p>
         * A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only
         * one job worker. Use this number in an <a>AcknowledgeThirdPartyJob</a> request.
         * </p>
         * 
         * @param nonce
         *        A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on
         *        by only one job worker. Use this number in an <a>AcknowledgeThirdPartyJob</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonce(String nonce);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private ThirdPartyJobData data;

        private String nonce;

        private BuilderImpl() {
        }

        private BuilderImpl(ThirdPartyJobDetails model) {
            id(model.id);
            data(model.data);
            nonce(model.nonce);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ThirdPartyJobData.Builder getData() {
            return data != null ? data.toBuilder() : null;
        }

        public final void setData(ThirdPartyJobData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(ThirdPartyJobData data) {
            this.data = data;
            return this;
        }

        public final String getNonce() {
            return nonce;
        }

        public final void setNonce(String nonce) {
            this.nonce = nonce;
        }

        @Override
        public final Builder nonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        @Override
        public ThirdPartyJobDetails build() {
            return new ThirdPartyJobDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
