/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The event criteria that specify when a specified repository event will start the pipeline for the specified trigger
 * configuration, such as the lists of Git tags to include and exclude.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GitPushFilter implements SdkPojo, Serializable, ToCopyableBuilder<GitPushFilter.Builder, GitPushFilter> {
    private static final SdkField<GitTagFilterCriteria> TAGS_FIELD = SdkField
            .<GitTagFilterCriteria> builder(MarshallingType.SDK_POJO).memberName("tags").getter(getter(GitPushFilter::tags))
            .setter(setter(Builder::tags)).constructor(GitTagFilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final GitTagFilterCriteria tags;

    private GitPushFilter(BuilderImpl builder) {
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The field that contains the details for the Git tags trigger configuration.
     * </p>
     * 
     * @return The field that contains the details for the Git tags trigger configuration.
     */
    public final GitTagFilterCriteria tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitPushFilter)) {
            return false;
        }
        GitPushFilter other = (GitPushFilter) obj;
        return Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GitPushFilter").add("Tags", tags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GitPushFilter, T> g) {
        return obj -> g.apply((GitPushFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GitPushFilter> {
        /**
         * <p>
         * The field that contains the details for the Git tags trigger configuration.
         * </p>
         * 
         * @param tags
         *        The field that contains the details for the Git tags trigger configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(GitTagFilterCriteria tags);

        /**
         * <p>
         * The field that contains the details for the Git tags trigger configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link GitTagFilterCriteria.Builder} avoiding
         * the need to create one manually via {@link GitTagFilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GitTagFilterCriteria.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(GitTagFilterCriteria)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link GitTagFilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(GitTagFilterCriteria)
         */
        default Builder tags(Consumer<GitTagFilterCriteria.Builder> tags) {
            return tags(GitTagFilterCriteria.builder().applyMutation(tags).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GitTagFilterCriteria tags;

        private BuilderImpl() {
        }

        private BuilderImpl(GitPushFilter model) {
            tags(model.tags);
        }

        public final GitTagFilterCriteria.Builder getTags() {
            return tags != null ? tags.toBuilder() : null;
        }

        public final void setTags(GitTagFilterCriteria.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(GitTagFilterCriteria tags) {
            this.tags = tags;
            return this;
        }

        @Override
        public GitPushFilter build() {
            return new GitPushFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
