/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTeamMemberRequest extends CodeStarRequest implements
        ToCopyableBuilder<UpdateTeamMemberRequest.Builder, UpdateTeamMemberRequest> {
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectId").getter(getter(UpdateTeamMemberRequest::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();

    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userArn").getter(getter(UpdateTeamMemberRequest::userArn)).setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()).build();

    private static final SdkField<String> PROJECT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectRole").getter(getter(UpdateTeamMemberRequest::projectRole)).setter(setter(Builder::projectRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectRole").build()).build();

    private static final SdkField<Boolean> REMOTE_ACCESS_ALLOWED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("remoteAccessAllowed").getter(getter(UpdateTeamMemberRequest::remoteAccessAllowed))
            .setter(setter(Builder::remoteAccessAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccessAllowed").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ID_FIELD,
            USER_ARN_FIELD, PROJECT_ROLE_FIELD, REMOTE_ACCESS_ALLOWED_FIELD));

    private final String projectId;

    private final String userArn;

    private final String projectRole;

    private final Boolean remoteAccessAllowed;

    private UpdateTeamMemberRequest(BuilderImpl builder) {
        super(builder);
        this.projectId = builder.projectId;
        this.userArn = builder.userArn;
        this.projectRole = builder.projectRole;
        this.remoteAccessAllowed = builder.remoteAccessAllowed;
    }

    /**
     * <p>
     * The ID of the project.
     * </p>
     * 
     * @return The ID of the project.
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user for whom you want to change team membership attributes.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user for whom you want to change team membership attributes.
     */
    public final String userArn() {
        return userArn;
    }

    /**
     * <p>
     * The role assigned to the user in the project. Project roles have different levels of access. For more
     * information, see <a href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working
     * with Teams</a> in the <i>AWS CodeStar User Guide</i>.
     * </p>
     * 
     * @return The role assigned to the user in the project. Project roles have different levels of access. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with
     *         Teams</a> in the <i>AWS CodeStar User Guide</i>.
     */
    public final String projectRole() {
        return projectRole;
    }

    /**
     * <p>
     * Whether a team member is allowed to remotely access project resources using the SSH public key associated with
     * the user's profile. Even if this is set to True, the user must associate a public key with their profile before
     * the user can access resources.
     * </p>
     * 
     * @return Whether a team member is allowed to remotely access project resources using the SSH public key associated
     *         with the user's profile. Even if this is set to True, the user must associate a public key with their
     *         profile before the user can access resources.
     */
    public final Boolean remoteAccessAllowed() {
        return remoteAccessAllowed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(projectRole());
        hashCode = 31 * hashCode + Objects.hashCode(remoteAccessAllowed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTeamMemberRequest)) {
            return false;
        }
        UpdateTeamMemberRequest other = (UpdateTeamMemberRequest) obj;
        return Objects.equals(projectId(), other.projectId()) && Objects.equals(userArn(), other.userArn())
                && Objects.equals(projectRole(), other.projectRole())
                && Objects.equals(remoteAccessAllowed(), other.remoteAccessAllowed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTeamMemberRequest").add("ProjectId", projectId()).add("UserArn", userArn())
                .add("ProjectRole", projectRole()).add("RemoteAccessAllowed", remoteAccessAllowed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "userArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        case "projectRole":
            return Optional.ofNullable(clazz.cast(projectRole()));
        case "remoteAccessAllowed":
            return Optional.ofNullable(clazz.cast(remoteAccessAllowed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTeamMemberRequest, T> g) {
        return obj -> g.apply((UpdateTeamMemberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTeamMemberRequest> {
        /**
         * <p>
         * The ID of the project.
         * </p>
         * 
         * @param projectId
         *        The ID of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user for whom you want to change team membership attributes.
         * </p>
         * 
         * @param userArn
         *        The Amazon Resource Name (ARN) of the user for whom you want to change team membership attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * The role assigned to the user in the project. Project roles have different levels of access. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with Teams</a> in
         * the <i>AWS CodeStar User Guide</i>.
         * </p>
         * 
         * @param projectRole
         *        The role assigned to the user in the project. Project roles have different levels of access. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html">Working with
         *        Teams</a> in the <i>AWS CodeStar User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectRole(String projectRole);

        /**
         * <p>
         * Whether a team member is allowed to remotely access project resources using the SSH public key associated
         * with the user's profile. Even if this is set to True, the user must associate a public key with their profile
         * before the user can access resources.
         * </p>
         * 
         * @param remoteAccessAllowed
         *        Whether a team member is allowed to remotely access project resources using the SSH public key
         *        associated with the user's profile. Even if this is set to True, the user must associate a public key
         *        with their profile before the user can access resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteAccessAllowed(Boolean remoteAccessAllowed);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeStarRequest.BuilderImpl implements Builder {
        private String projectId;

        private String userArn;

        private String projectRole;

        private Boolean remoteAccessAllowed;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTeamMemberRequest model) {
            super(model);
            projectId(model.projectId);
            userArn(model.userArn);
            projectRole(model.projectRole);
            remoteAccessAllowed(model.remoteAccessAllowed);
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getUserArn() {
            return userArn;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final String getProjectRole() {
            return projectRole;
        }

        public final void setProjectRole(String projectRole) {
            this.projectRole = projectRole;
        }

        @Override
        public final Builder projectRole(String projectRole) {
            this.projectRole = projectRole;
            return this;
        }

        public final Boolean getRemoteAccessAllowed() {
            return remoteAccessAllowed;
        }

        public final void setRemoteAccessAllowed(Boolean remoteAccessAllowed) {
            this.remoteAccessAllowed = remoteAccessAllowed;
        }

        @Override
        public final Builder remoteAccessAllowed(Boolean remoteAccessAllowed) {
            this.remoteAccessAllowed = remoteAccessAllowed;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTeamMemberRequest build() {
            return new UpdateTeamMemberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
