/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input properties for an inference job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDataConfig implements SdkPojo, Serializable, ToCopyableBuilder<InputDataConfig.Builder, InputDataConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(InputDataConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<String> INPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputFormat").getter(getter(InputDataConfig::inputFormatAsString)).setter(setter(Builder::inputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormat").build()).build();

    private static final SdkField<DocumentReaderConfig> DOCUMENT_READER_CONFIG_FIELD = SdkField
            .<DocumentReaderConfig> builder(MarshallingType.SDK_POJO).memberName("DocumentReaderConfig")
            .getter(getter(InputDataConfig::documentReaderConfig)).setter(setter(Builder::documentReaderConfig))
            .constructor(DocumentReaderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentReaderConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            INPUT_FORMAT_FIELD, DOCUMENT_READER_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String inputFormat;

    private final DocumentReaderConfig documentReaderConfig;

    private InputDataConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.inputFormat = builder.inputFormat;
        this.documentReaderConfig = builder.documentReaderConfig;
    }

    /**
     * <p>
     * The Amazon S3 URI for the input data. The URI must be in same region as the API endpoint that you are calling.
     * The URI can point to a single input file or it can provide the prefix for a collection of data files.
     * </p>
     * <p>
     * For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a single file, Amazon
     * Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of
     * them as input.
     * </p>
     * 
     * @return The Amazon S3 URI for the input data. The URI must be in same region as the API endpoint that you are
     *         calling. The URI can point to a single input file or it can provide the prefix for a collection of data
     *         files. </p>
     *         <p>
     *         For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a single file,
     *         Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon
     *         Comprehend uses all of them as input.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * Specifies how the text in an input file should be processed:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ONE_DOC_PER_FILE</code> - Each file is considered a separate document. Use this option when you are
     * processing large documents, such as newspaper articles or scientific papers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ONE_DOC_PER_LINE</code> - Each line in a file is considered a separate document. Use this option when you
     * are processing many short documents, such as text messages.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputFormat} will
     * return {@link InputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputFormatAsString}.
     * </p>
     * 
     * @return Specifies how the text in an input file should be processed:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ONE_DOC_PER_FILE</code> - Each file is considered a separate document. Use this option when you are
     *         processing large documents, such as newspaper articles or scientific papers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ONE_DOC_PER_LINE</code> - Each line in a file is considered a separate document. Use this option
     *         when you are processing many short documents, such as text messages.
     *         </p>
     *         </li>
     * @see InputFormat
     */
    public final InputFormat inputFormat() {
        return InputFormat.fromValue(inputFormat);
    }

    /**
     * <p>
     * Specifies how the text in an input file should be processed:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ONE_DOC_PER_FILE</code> - Each file is considered a separate document. Use this option when you are
     * processing large documents, such as newspaper articles or scientific papers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ONE_DOC_PER_LINE</code> - Each line in a file is considered a separate document. Use this option when you
     * are processing many short documents, such as text messages.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputFormat} will
     * return {@link InputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputFormatAsString}.
     * </p>
     * 
     * @return Specifies how the text in an input file should be processed:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ONE_DOC_PER_FILE</code> - Each file is considered a separate document. Use this option when you are
     *         processing large documents, such as newspaper articles or scientific papers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ONE_DOC_PER_LINE</code> - Each line in a file is considered a separate document. Use this option
     *         when you are processing many short documents, such as text messages.
     *         </p>
     *         </li>
     * @see InputFormat
     */
    public final String inputFormatAsString() {
        return inputFormat;
    }

    /**
     * <p>
     * The document reader config field applies only for InputDataConfig of StartEntitiesDetectionJob.
     * </p>
     * <p>
     * Use DocumentReaderConfig to provide specifications about how you want your inference documents read. Currently it
     * applies for PDF documents in StartEntitiesDetectionJob custom inference.
     * </p>
     * 
     * @return The document reader config field applies only for InputDataConfig of StartEntitiesDetectionJob. </p>
     *         <p>
     *         Use DocumentReaderConfig to provide specifications about how you want your inference documents read.
     *         Currently it applies for PDF documents in StartEntitiesDetectionJob custom inference.
     */
    public final DocumentReaderConfig documentReaderConfig() {
        return documentReaderConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(inputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(documentReaderConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDataConfig)) {
            return false;
        }
        InputDataConfig other = (InputDataConfig) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(inputFormatAsString(), other.inputFormatAsString())
                && Objects.equals(documentReaderConfig(), other.documentReaderConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDataConfig").add("S3Uri", s3Uri()).add("InputFormat", inputFormatAsString())
                .add("DocumentReaderConfig", documentReaderConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "InputFormat":
            return Optional.ofNullable(clazz.cast(inputFormatAsString()));
        case "DocumentReaderConfig":
            return Optional.ofNullable(clazz.cast(documentReaderConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDataConfig, T> g) {
        return obj -> g.apply((InputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDataConfig> {
        /**
         * <p>
         * The Amazon S3 URI for the input data. The URI must be in same region as the API endpoint that you are
         * calling. The URI can point to a single input file or it can provide the prefix for a collection of data
         * files.
         * </p>
         * <p>
         * For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a single file, Amazon
         * Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all
         * of them as input.
         * </p>
         * 
         * @param s3Uri
         *        The Amazon S3 URI for the input data. The URI must be in same region as the API endpoint that you are
         *        calling. The URI can point to a single input file or it can provide the prefix for a collection of
         *        data files. </p>
         *        <p>
         *        For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a single file,
         *        Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon
         *        Comprehend uses all of them as input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * Specifies how the text in an input file should be processed:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ONE_DOC_PER_FILE</code> - Each file is considered a separate document. Use this option when you are
         * processing large documents, such as newspaper articles or scientific papers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ONE_DOC_PER_LINE</code> - Each line in a file is considered a separate document. Use this option when
         * you are processing many short documents, such as text messages.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputFormat
         *        Specifies how the text in an input file should be processed:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ONE_DOC_PER_FILE</code> - Each file is considered a separate document. Use this option when you
         *        are processing large documents, such as newspaper articles or scientific papers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ONE_DOC_PER_LINE</code> - Each line in a file is considered a separate document. Use this option
         *        when you are processing many short documents, such as text messages.
         *        </p>
         *        </li>
         * @see InputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputFormat
         */
        Builder inputFormat(String inputFormat);

        /**
         * <p>
         * Specifies how the text in an input file should be processed:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ONE_DOC_PER_FILE</code> - Each file is considered a separate document. Use this option when you are
         * processing large documents, such as newspaper articles or scientific papers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ONE_DOC_PER_LINE</code> - Each line in a file is considered a separate document. Use this option when
         * you are processing many short documents, such as text messages.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputFormat
         *        Specifies how the text in an input file should be processed:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ONE_DOC_PER_FILE</code> - Each file is considered a separate document. Use this option when you
         *        are processing large documents, such as newspaper articles or scientific papers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ONE_DOC_PER_LINE</code> - Each line in a file is considered a separate document. Use this option
         *        when you are processing many short documents, such as text messages.
         *        </p>
         *        </li>
         * @see InputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputFormat
         */
        Builder inputFormat(InputFormat inputFormat);

        /**
         * <p>
         * The document reader config field applies only for InputDataConfig of StartEntitiesDetectionJob.
         * </p>
         * <p>
         * Use DocumentReaderConfig to provide specifications about how you want your inference documents read.
         * Currently it applies for PDF documents in StartEntitiesDetectionJob custom inference.
         * </p>
         * 
         * @param documentReaderConfig
         *        The document reader config field applies only for InputDataConfig of StartEntitiesDetectionJob. </p>
         *        <p>
         *        Use DocumentReaderConfig to provide specifications about how you want your inference documents read.
         *        Currently it applies for PDF documents in StartEntitiesDetectionJob custom inference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentReaderConfig(DocumentReaderConfig documentReaderConfig);

        /**
         * <p>
         * The document reader config field applies only for InputDataConfig of StartEntitiesDetectionJob.
         * </p>
         * <p>
         * Use DocumentReaderConfig to provide specifications about how you want your inference documents read.
         * Currently it applies for PDF documents in StartEntitiesDetectionJob custom inference.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentReaderConfig.Builder} avoiding
         * the need to create one manually via {@link DocumentReaderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentReaderConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #documentReaderConfig(DocumentReaderConfig)}.
         * 
         * @param documentReaderConfig
         *        a consumer that will call methods on {@link DocumentReaderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentReaderConfig(DocumentReaderConfig)
         */
        default Builder documentReaderConfig(Consumer<DocumentReaderConfig.Builder> documentReaderConfig) {
            return documentReaderConfig(DocumentReaderConfig.builder().applyMutation(documentReaderConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String inputFormat;

        private DocumentReaderConfig documentReaderConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDataConfig model) {
            s3Uri(model.s3Uri);
            inputFormat(model.inputFormat);
            documentReaderConfig(model.documentReaderConfig);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getInputFormat() {
            return inputFormat;
        }

        public final void setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        @Override
        public final Builder inputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        @Override
        public final Builder inputFormat(InputFormat inputFormat) {
            this.inputFormat(inputFormat == null ? null : inputFormat.toString());
            return this;
        }

        public final DocumentReaderConfig.Builder getDocumentReaderConfig() {
            return documentReaderConfig != null ? documentReaderConfig.toBuilder() : null;
        }

        public final void setDocumentReaderConfig(DocumentReaderConfig.BuilderImpl documentReaderConfig) {
            this.documentReaderConfig = documentReaderConfig != null ? documentReaderConfig.build() : null;
        }

        @Override
        public final Builder documentReaderConfig(DocumentReaderConfig documentReaderConfig) {
            this.documentReaderConfig = documentReaderConfig;
            return this;
        }

        @Override
        public InputDataConfig build() {
            return new InputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
