/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEndpointRequest extends ComprehendRequest implements
        ToCopyableBuilder<UpdateEndpointRequest.Builder, UpdateEndpointRequest> {
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointArn").getter(getter(UpdateEndpointRequest::endpointArn)).setter(setter(Builder::endpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()).build();

    private static final SdkField<String> DESIRED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredModelArn").getter(getter(UpdateEndpointRequest::desiredModelArn))
            .setter(setter(Builder::desiredModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredModelArn").build()).build();

    private static final SdkField<Integer> DESIRED_INFERENCE_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredInferenceUnits").getter(getter(UpdateEndpointRequest::desiredInferenceUnits))
            .setter(setter(Builder::desiredInferenceUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInferenceUnits").build())
            .build();

    private static final SdkField<String> DESIRED_DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredDataAccessRoleArn").getter(getter(UpdateEndpointRequest::desiredDataAccessRoleArn))
            .setter(setter(Builder::desiredDataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredDataAccessRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ARN_FIELD,
            DESIRED_MODEL_ARN_FIELD, DESIRED_INFERENCE_UNITS_FIELD, DESIRED_DATA_ACCESS_ROLE_ARN_FIELD));

    private final String endpointArn;

    private final String desiredModelArn;

    private final Integer desiredInferenceUnits;

    private final String desiredDataAccessRoleArn;

    private UpdateEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointArn = builder.endpointArn;
        this.desiredModelArn = builder.desiredModelArn;
        this.desiredInferenceUnits = builder.desiredInferenceUnits;
        this.desiredDataAccessRoleArn = builder.desiredDataAccessRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the endpoint being updated.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the endpoint being updated.
     */
    public final String endpointArn() {
        return endpointArn;
    }

    /**
     * <p>
     * The ARN of the new model to use when updating an existing endpoint.
     * </p>
     * 
     * @return The ARN of the new model to use when updating an existing endpoint.
     */
    public final String desiredModelArn() {
        return desiredModelArn;
    }

    /**
     * <p>
     * The desired number of inference units to be used by the model using this endpoint. Each inference unit represents
     * of a throughput of 100 characters per second.
     * </p>
     * 
     * @return The desired number of inference units to be used by the model using this endpoint. Each inference unit
     *         represents of a throughput of 100 characters per second.
     */
    public final Integer desiredInferenceUnits() {
        return desiredInferenceUnits;
    }

    /**
     * <p>
     * Data access role ARN to use in case the new model is encrypted with a customer CMK.
     * </p>
     * 
     * @return Data access role ARN to use in case the new model is encrypted with a customer CMK.
     */
    public final String desiredDataAccessRoleArn() {
        return desiredDataAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(desiredModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(desiredInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(desiredDataAccessRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointRequest)) {
            return false;
        }
        UpdateEndpointRequest other = (UpdateEndpointRequest) obj;
        return Objects.equals(endpointArn(), other.endpointArn()) && Objects.equals(desiredModelArn(), other.desiredModelArn())
                && Objects.equals(desiredInferenceUnits(), other.desiredInferenceUnits())
                && Objects.equals(desiredDataAccessRoleArn(), other.desiredDataAccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEndpointRequest").add("EndpointArn", endpointArn())
                .add("DesiredModelArn", desiredModelArn()).add("DesiredInferenceUnits", desiredInferenceUnits())
                .add("DesiredDataAccessRoleArn", desiredDataAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointArn":
            return Optional.ofNullable(clazz.cast(endpointArn()));
        case "DesiredModelArn":
            return Optional.ofNullable(clazz.cast(desiredModelArn()));
        case "DesiredInferenceUnits":
            return Optional.ofNullable(clazz.cast(desiredInferenceUnits()));
        case "DesiredDataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(desiredDataAccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointRequest, T> g) {
        return obj -> g.apply((UpdateEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEndpointRequest> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the endpoint being updated.
         * </p>
         * 
         * @param endpointArn
         *        The Amazon Resource Number (ARN) of the endpoint being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);

        /**
         * <p>
         * The ARN of the new model to use when updating an existing endpoint.
         * </p>
         * 
         * @param desiredModelArn
         *        The ARN of the new model to use when updating an existing endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredModelArn(String desiredModelArn);

        /**
         * <p>
         * The desired number of inference units to be used by the model using this endpoint. Each inference unit
         * represents of a throughput of 100 characters per second.
         * </p>
         * 
         * @param desiredInferenceUnits
         *        The desired number of inference units to be used by the model using this endpoint. Each inference unit
         *        represents of a throughput of 100 characters per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredInferenceUnits(Integer desiredInferenceUnits);

        /**
         * <p>
         * Data access role ARN to use in case the new model is encrypted with a customer CMK.
         * </p>
         * 
         * @param desiredDataAccessRoleArn
         *        Data access role ARN to use in case the new model is encrypted with a customer CMK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredDataAccessRoleArn(String desiredDataAccessRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComprehendRequest.BuilderImpl implements Builder {
        private String endpointArn;

        private String desiredModelArn;

        private Integer desiredInferenceUnits;

        private String desiredDataAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointRequest model) {
            super(model);
            endpointArn(model.endpointArn);
            desiredModelArn(model.desiredModelArn);
            desiredInferenceUnits(model.desiredInferenceUnits);
            desiredDataAccessRoleArn(model.desiredDataAccessRoleArn);
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final String getDesiredModelArn() {
            return desiredModelArn;
        }

        public final void setDesiredModelArn(String desiredModelArn) {
            this.desiredModelArn = desiredModelArn;
        }

        @Override
        public final Builder desiredModelArn(String desiredModelArn) {
            this.desiredModelArn = desiredModelArn;
            return this;
        }

        public final Integer getDesiredInferenceUnits() {
            return desiredInferenceUnits;
        }

        public final void setDesiredInferenceUnits(Integer desiredInferenceUnits) {
            this.desiredInferenceUnits = desiredInferenceUnits;
        }

        @Override
        public final Builder desiredInferenceUnits(Integer desiredInferenceUnits) {
            this.desiredInferenceUnits = desiredInferenceUnits;
            return this;
        }

        public final String getDesiredDataAccessRoleArn() {
            return desiredDataAccessRoleArn;
        }

        public final void setDesiredDataAccessRoleArn(String desiredDataAccessRoleArn) {
            this.desiredDataAccessRoleArn = desiredDataAccessRoleArn;
        }

        @Override
        public final Builder desiredDataAccessRoleArn(String desiredDataAccessRoleArn) {
            this.desiredDataAccessRoleArn = desiredDataAccessRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointRequest build() {
            return new UpdateEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
