/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFlywheelIterationResponse extends ComprehendResponse implements
        ToCopyableBuilder<DescribeFlywheelIterationResponse.Builder, DescribeFlywheelIterationResponse> {
    private static final SdkField<FlywheelIterationProperties> FLYWHEEL_ITERATION_PROPERTIES_FIELD = SdkField
            .<FlywheelIterationProperties> builder(MarshallingType.SDK_POJO)
            .memberName("FlywheelIterationProperties")
            .getter(getter(DescribeFlywheelIterationResponse::flywheelIterationProperties))
            .setter(setter(Builder::flywheelIterationProperties))
            .constructor(FlywheelIterationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelIterationProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FLYWHEEL_ITERATION_PROPERTIES_FIELD));

    private final FlywheelIterationProperties flywheelIterationProperties;

    private DescribeFlywheelIterationResponse(BuilderImpl builder) {
        super(builder);
        this.flywheelIterationProperties = builder.flywheelIterationProperties;
    }

    /**
     * <p>
     * The configuration properties of a flywheel iteration.
     * </p>
     * 
     * @return The configuration properties of a flywheel iteration.
     */
    public final FlywheelIterationProperties flywheelIterationProperties() {
        return flywheelIterationProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flywheelIterationProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlywheelIterationResponse)) {
            return false;
        }
        DescribeFlywheelIterationResponse other = (DescribeFlywheelIterationResponse) obj;
        return Objects.equals(flywheelIterationProperties(), other.flywheelIterationProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFlywheelIterationResponse")
                .add("FlywheelIterationProperties", flywheelIterationProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlywheelIterationProperties":
            return Optional.ofNullable(clazz.cast(flywheelIterationProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFlywheelIterationResponse, T> g) {
        return obj -> g.apply((DescribeFlywheelIterationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFlywheelIterationResponse> {
        /**
         * <p>
         * The configuration properties of a flywheel iteration.
         * </p>
         * 
         * @param flywheelIterationProperties
         *        The configuration properties of a flywheel iteration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flywheelIterationProperties(FlywheelIterationProperties flywheelIterationProperties);

        /**
         * <p>
         * The configuration properties of a flywheel iteration.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlywheelIterationProperties.Builder}
         * avoiding the need to create one manually via {@link FlywheelIterationProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlywheelIterationProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #flywheelIterationProperties(FlywheelIterationProperties)}.
         * 
         * @param flywheelIterationProperties
         *        a consumer that will call methods on {@link FlywheelIterationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flywheelIterationProperties(FlywheelIterationProperties)
         */
        default Builder flywheelIterationProperties(Consumer<FlywheelIterationProperties.Builder> flywheelIterationProperties) {
            return flywheelIterationProperties(FlywheelIterationProperties.builder().applyMutation(flywheelIterationProperties)
                    .build());
        }
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private FlywheelIterationProperties flywheelIterationProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlywheelIterationResponse model) {
            super(model);
            flywheelIterationProperties(model.flywheelIterationProperties);
        }

        public final FlywheelIterationProperties.Builder getFlywheelIterationProperties() {
            return flywheelIterationProperties != null ? flywheelIterationProperties.toBuilder() : null;
        }

        public final void setFlywheelIterationProperties(FlywheelIterationProperties.BuilderImpl flywheelIterationProperties) {
            this.flywheelIterationProperties = flywheelIterationProperties != null ? flywheelIterationProperties.build() : null;
        }

        @Override
        public final Builder flywheelIterationProperties(FlywheelIterationProperties flywheelIterationProperties) {
            this.flywheelIterationProperties = flywheelIterationProperties;
            return this;
        }

        @Override
        public DescribeFlywheelIterationResponse build() {
            return new DescribeFlywheelIterationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
