/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the information about an entity recognizer and its versions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityRecognizerSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityRecognizerSummary.Builder, EntityRecognizerSummary> {
    private static final SdkField<String> RECOGNIZER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecognizerName").getter(getter(EntityRecognizerSummary::recognizerName))
            .setter(setter(Builder::recognizerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecognizerName").build()).build();

    private static final SdkField<Integer> NUMBER_OF_VERSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfVersions").getter(getter(EntityRecognizerSummary::numberOfVersions))
            .setter(setter(Builder::numberOfVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfVersions").build()).build();

    private static final SdkField<Instant> LATEST_VERSION_CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestVersionCreatedAt").getter(getter(EntityRecognizerSummary::latestVersionCreatedAt))
            .setter(setter(Builder::latestVersionCreatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionCreatedAt").build())
            .build();

    private static final SdkField<String> LATEST_VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestVersionName").getter(getter(EntityRecognizerSummary::latestVersionName))
            .setter(setter(Builder::latestVersionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionName").build()).build();

    private static final SdkField<String> LATEST_VERSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestVersionStatus").getter(getter(EntityRecognizerSummary::latestVersionStatusAsString))
            .setter(setter(Builder::latestVersionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOGNIZER_NAME_FIELD,
            NUMBER_OF_VERSIONS_FIELD, LATEST_VERSION_CREATED_AT_FIELD, LATEST_VERSION_NAME_FIELD, LATEST_VERSION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recognizerName;

    private final Integer numberOfVersions;

    private final Instant latestVersionCreatedAt;

    private final String latestVersionName;

    private final String latestVersionStatus;

    private EntityRecognizerSummary(BuilderImpl builder) {
        this.recognizerName = builder.recognizerName;
        this.numberOfVersions = builder.numberOfVersions;
        this.latestVersionCreatedAt = builder.latestVersionCreatedAt;
        this.latestVersionName = builder.latestVersionName;
        this.latestVersionStatus = builder.latestVersionStatus;
    }

    /**
     * <p>
     * The name that you assigned the entity recognizer.
     * </p>
     * 
     * @return The name that you assigned the entity recognizer.
     */
    public final String recognizerName() {
        return recognizerName;
    }

    /**
     * <p>
     * The number of versions you created.
     * </p>
     * 
     * @return The number of versions you created.
     */
    public final Integer numberOfVersions() {
        return numberOfVersions;
    }

    /**
     * <p>
     * The time that the latest entity recognizer version was submitted for processing.
     * </p>
     * 
     * @return The time that the latest entity recognizer version was submitted for processing.
     */
    public final Instant latestVersionCreatedAt() {
        return latestVersionCreatedAt;
    }

    /**
     * <p>
     * The version name you assigned to the latest entity recognizer version.
     * </p>
     * 
     * @return The version name you assigned to the latest entity recognizer version.
     */
    public final String latestVersionName() {
        return latestVersionName;
    }

    /**
     * <p>
     * Provides the status of the latest entity recognizer version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestVersionStatus} will return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #latestVersionStatusAsString}.
     * </p>
     * 
     * @return Provides the status of the latest entity recognizer version.
     * @see ModelStatus
     */
    public final ModelStatus latestVersionStatus() {
        return ModelStatus.fromValue(latestVersionStatus);
    }

    /**
     * <p>
     * Provides the status of the latest entity recognizer version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestVersionStatus} will return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #latestVersionStatusAsString}.
     * </p>
     * 
     * @return Provides the status of the latest entity recognizer version.
     * @see ModelStatus
     */
    public final String latestVersionStatusAsString() {
        return latestVersionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recognizerName());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfVersions());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionName());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognizerSummary)) {
            return false;
        }
        EntityRecognizerSummary other = (EntityRecognizerSummary) obj;
        return Objects.equals(recognizerName(), other.recognizerName())
                && Objects.equals(numberOfVersions(), other.numberOfVersions())
                && Objects.equals(latestVersionCreatedAt(), other.latestVersionCreatedAt())
                && Objects.equals(latestVersionName(), other.latestVersionName())
                && Objects.equals(latestVersionStatusAsString(), other.latestVersionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityRecognizerSummary").add("RecognizerName", recognizerName())
                .add("NumberOfVersions", numberOfVersions()).add("LatestVersionCreatedAt", latestVersionCreatedAt())
                .add("LatestVersionName", latestVersionName()).add("LatestVersionStatus", latestVersionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecognizerName":
            return Optional.ofNullable(clazz.cast(recognizerName()));
        case "NumberOfVersions":
            return Optional.ofNullable(clazz.cast(numberOfVersions()));
        case "LatestVersionCreatedAt":
            return Optional.ofNullable(clazz.cast(latestVersionCreatedAt()));
        case "LatestVersionName":
            return Optional.ofNullable(clazz.cast(latestVersionName()));
        case "LatestVersionStatus":
            return Optional.ofNullable(clazz.cast(latestVersionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityRecognizerSummary, T> g) {
        return obj -> g.apply((EntityRecognizerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityRecognizerSummary> {
        /**
         * <p>
         * The name that you assigned the entity recognizer.
         * </p>
         * 
         * @param recognizerName
         *        The name that you assigned the entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recognizerName(String recognizerName);

        /**
         * <p>
         * The number of versions you created.
         * </p>
         * 
         * @param numberOfVersions
         *        The number of versions you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfVersions(Integer numberOfVersions);

        /**
         * <p>
         * The time that the latest entity recognizer version was submitted for processing.
         * </p>
         * 
         * @param latestVersionCreatedAt
         *        The time that the latest entity recognizer version was submitted for processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionCreatedAt(Instant latestVersionCreatedAt);

        /**
         * <p>
         * The version name you assigned to the latest entity recognizer version.
         * </p>
         * 
         * @param latestVersionName
         *        The version name you assigned to the latest entity recognizer version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionName(String latestVersionName);

        /**
         * <p>
         * Provides the status of the latest entity recognizer version.
         * </p>
         * 
         * @param latestVersionStatus
         *        Provides the status of the latest entity recognizer version.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder latestVersionStatus(String latestVersionStatus);

        /**
         * <p>
         * Provides the status of the latest entity recognizer version.
         * </p>
         * 
         * @param latestVersionStatus
         *        Provides the status of the latest entity recognizer version.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder latestVersionStatus(ModelStatus latestVersionStatus);
    }

    static final class BuilderImpl implements Builder {
        private String recognizerName;

        private Integer numberOfVersions;

        private Instant latestVersionCreatedAt;

        private String latestVersionName;

        private String latestVersionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityRecognizerSummary model) {
            recognizerName(model.recognizerName);
            numberOfVersions(model.numberOfVersions);
            latestVersionCreatedAt(model.latestVersionCreatedAt);
            latestVersionName(model.latestVersionName);
            latestVersionStatus(model.latestVersionStatus);
        }

        public final String getRecognizerName() {
            return recognizerName;
        }

        public final void setRecognizerName(String recognizerName) {
            this.recognizerName = recognizerName;
        }

        @Override
        public final Builder recognizerName(String recognizerName) {
            this.recognizerName = recognizerName;
            return this;
        }

        public final Integer getNumberOfVersions() {
            return numberOfVersions;
        }

        public final void setNumberOfVersions(Integer numberOfVersions) {
            this.numberOfVersions = numberOfVersions;
        }

        @Override
        public final Builder numberOfVersions(Integer numberOfVersions) {
            this.numberOfVersions = numberOfVersions;
            return this;
        }

        public final Instant getLatestVersionCreatedAt() {
            return latestVersionCreatedAt;
        }

        public final void setLatestVersionCreatedAt(Instant latestVersionCreatedAt) {
            this.latestVersionCreatedAt = latestVersionCreatedAt;
        }

        @Override
        public final Builder latestVersionCreatedAt(Instant latestVersionCreatedAt) {
            this.latestVersionCreatedAt = latestVersionCreatedAt;
            return this;
        }

        public final String getLatestVersionName() {
            return latestVersionName;
        }

        public final void setLatestVersionName(String latestVersionName) {
            this.latestVersionName = latestVersionName;
        }

        @Override
        public final Builder latestVersionName(String latestVersionName) {
            this.latestVersionName = latestVersionName;
            return this;
        }

        public final String getLatestVersionStatus() {
            return latestVersionStatus;
        }

        public final void setLatestVersionStatus(String latestVersionStatus) {
            this.latestVersionStatus = latestVersionStatus;
        }

        @Override
        public final Builder latestVersionStatus(String latestVersionStatus) {
            this.latestVersionStatus = latestVersionStatus;
            return this;
        }

        @Override
        public final Builder latestVersionStatus(ModelStatus latestVersionStatus) {
            this.latestVersionStatus(latestVersionStatus == null ? null : latestVersionStatus.toString());
            return this;
        }

        @Override
        public EntityRecognizerSummary build() {
            return new EntityRecognizerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
