/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRecommendationPreferencesRequest extends ComputeOptimizerRequest implements
        ToCopyableBuilder<DeleteRecommendationPreferencesRequest.Builder, DeleteRecommendationPreferencesRequest> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(DeleteRecommendationPreferencesRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<Scope> SCOPE_FIELD = SdkField.<Scope> builder(MarshallingType.SDK_POJO).memberName("scope")
            .getter(getter(DeleteRecommendationPreferencesRequest::scope)).setter(setter(Builder::scope))
            .constructor(Scope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final SdkField<List<String>> RECOMMENDATION_PREFERENCE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("recommendationPreferenceNames")
            .getter(getter(DeleteRecommendationPreferencesRequest::recommendationPreferenceNamesAsStrings))
            .setter(setter(Builder::recommendationPreferenceNamesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationPreferenceNames")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            SCOPE_FIELD, RECOMMENDATION_PREFERENCE_NAMES_FIELD));

    private final String resourceType;

    private final Scope scope;

    private final List<String> recommendationPreferenceNames;

    private DeleteRecommendationPreferencesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.scope = builder.scope;
        this.recommendationPreferenceNames = builder.recommendationPreferenceNames;
    }

    /**
     * <p>
     * The target resource type of the recommendation preference to delete.
     * </p>
     * <p>
     * The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto Scaling
     * groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an Auto Scaling
     * group.
     * </p>
     * <note>
     * <p>
     * The valid values for this parameter are <code>Ec2Instance</code> and <code>AutoScalingGroup</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The target resource type of the recommendation preference to delete.</p>
     *         <p>
     *         The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto
     *         Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an
     *         Auto Scaling group.
     *         </p>
     *         <note>
     *         <p>
     *         The valid values for this parameter are <code>Ec2Instance</code> and <code>AutoScalingGroup</code>.
     *         </p>
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The target resource type of the recommendation preference to delete.
     * </p>
     * <p>
     * The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto Scaling
     * groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an Auto Scaling
     * group.
     * </p>
     * <note>
     * <p>
     * The valid values for this parameter are <code>Ec2Instance</code> and <code>AutoScalingGroup</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The target resource type of the recommendation preference to delete.</p>
     *         <p>
     *         The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto
     *         Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an
     *         Auto Scaling group.
     *         </p>
     *         <note>
     *         <p>
     *         The valid values for this parameter are <code>Ec2Instance</code> and <code>AutoScalingGroup</code>.
     *         </p>
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * An object that describes the scope of the recommendation preference to delete.
     * </p>
     * <p>
     * You can delete recommendation preferences that are created at the organization level (for management accounts of
     * an organization only), account level, and resource level. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating
     * enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * 
     * @return An object that describes the scope of the recommendation preference to delete.</p>
     *         <p>
     *         You can delete recommendation preferences that are created at the organization level (for management
     *         accounts of an organization only), account level, and resource level. For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
     *         >Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     */
    public final Scope scope() {
        return scope;
    }

    /**
     * <p>
     * The name of the recommendation preference to delete.
     * </p>
     * <p>
     * Enhanced infrastructure metrics (<code>EnhancedInfrastructureMetrics</code>) is the only feature that can be
     * activated through preferences. Therefore, it is also the only recommendation preference that can be deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendationPreferenceNames} method.
     * </p>
     * 
     * @return The name of the recommendation preference to delete.</p>
     *         <p>
     *         Enhanced infrastructure metrics (<code>EnhancedInfrastructureMetrics</code>) is the only feature that can
     *         be activated through preferences. Therefore, it is also the only recommendation preference that can be
     *         deleted.
     */
    public final List<RecommendationPreferenceName> recommendationPreferenceNames() {
        return RecommendationPreferenceNamesCopier.copyStringToEnum(recommendationPreferenceNames);
    }

    /**
     * For responses, this returns true if the service returned a value for the RecommendationPreferenceNames property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRecommendationPreferenceNames() {
        return recommendationPreferenceNames != null && !(recommendationPreferenceNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the recommendation preference to delete.
     * </p>
     * <p>
     * Enhanced infrastructure metrics (<code>EnhancedInfrastructureMetrics</code>) is the only feature that can be
     * activated through preferences. Therefore, it is also the only recommendation preference that can be deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendationPreferenceNames} method.
     * </p>
     * 
     * @return The name of the recommendation preference to delete.</p>
     *         <p>
     *         Enhanced infrastructure metrics (<code>EnhancedInfrastructureMetrics</code>) is the only feature that can
     *         be activated through preferences. Therefore, it is also the only recommendation preference that can be
     *         deleted.
     */
    public final List<String> recommendationPreferenceNamesAsStrings() {
        return recommendationPreferenceNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRecommendationPreferenceNames() ? recommendationPreferenceNamesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRecommendationPreferencesRequest)) {
            return false;
        }
        DeleteRecommendationPreferencesRequest other = (DeleteRecommendationPreferencesRequest) obj;
        return Objects.equals(resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(scope(), other.scope())
                && hasRecommendationPreferenceNames() == other.hasRecommendationPreferenceNames()
                && Objects.equals(recommendationPreferenceNamesAsStrings(), other.recommendationPreferenceNamesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DeleteRecommendationPreferencesRequest")
                .add("ResourceType", resourceTypeAsString())
                .add("Scope", scope())
                .add("RecommendationPreferenceNames",
                        hasRecommendationPreferenceNames() ? recommendationPreferenceNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "recommendationPreferenceNames":
            return Optional.ofNullable(clazz.cast(recommendationPreferenceNamesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRecommendationPreferencesRequest, T> g) {
        return obj -> g.apply((DeleteRecommendationPreferencesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteRecommendationPreferencesRequest> {
        /**
         * <p>
         * The target resource type of the recommendation preference to delete.
         * </p>
         * <p>
         * The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto
         * Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an Auto
         * Scaling group.
         * </p>
         * <note>
         * <p>
         * The valid values for this parameter are <code>Ec2Instance</code> and <code>AutoScalingGroup</code>.
         * </p>
         * </note>
         * 
         * @param resourceType
         *        The target resource type of the recommendation preference to delete.</p>
         *        <p>
         *        The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of
         *        Auto Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part
         *        of an Auto Scaling group.
         *        </p>
         *        <note>
         *        <p>
         *        The valid values for this parameter are <code>Ec2Instance</code> and <code>AutoScalingGroup</code>.
         *        </p>
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The target resource type of the recommendation preference to delete.
         * </p>
         * <p>
         * The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto
         * Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an Auto
         * Scaling group.
         * </p>
         * <note>
         * <p>
         * The valid values for this parameter are <code>Ec2Instance</code> and <code>AutoScalingGroup</code>.
         * </p>
         * </note>
         * 
         * @param resourceType
         *        The target resource type of the recommendation preference to delete.</p>
         *        <p>
         *        The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of
         *        Auto Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part
         *        of an Auto Scaling group.
         *        </p>
         *        <note>
         *        <p>
         *        The valid values for this parameter are <code>Ec2Instance</code> and <code>AutoScalingGroup</code>.
         *        </p>
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * An object that describes the scope of the recommendation preference to delete.
         * </p>
         * <p>
         * You can delete recommendation preferences that are created at the organization level (for management accounts
         * of an organization only), account level, and resource level. For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         * >Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param scope
         *        An object that describes the scope of the recommendation preference to delete.</p>
         *        <p>
         *        You can delete recommendation preferences that are created at the organization level (for management
         *        accounts of an organization only), account level, and resource level. For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">
         *        Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * An object that describes the scope of the recommendation preference to delete.
         * </p>
         * <p>
         * You can delete recommendation preferences that are created at the organization level (for management accounts
         * of an organization only), account level, and resource level. For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         * >Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Scope.Builder} avoiding the need to
         * create one manually via {@link Scope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Scope.Builder#build()} is called immediately and its result is
         * passed to {@link #scope(Scope)}.
         * 
         * @param scope
         *        a consumer that will call methods on {@link Scope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scope(Scope)
         */
        default Builder scope(Consumer<Scope.Builder> scope) {
            return scope(Scope.builder().applyMutation(scope).build());
        }

        /**
         * <p>
         * The name of the recommendation preference to delete.
         * </p>
         * <p>
         * Enhanced infrastructure metrics (<code>EnhancedInfrastructureMetrics</code>) is the only feature that can be
         * activated through preferences. Therefore, it is also the only recommendation preference that can be deleted.
         * </p>
         * 
         * @param recommendationPreferenceNames
         *        The name of the recommendation preference to delete.</p>
         *        <p>
         *        Enhanced infrastructure metrics (<code>EnhancedInfrastructureMetrics</code>) is the only feature that
         *        can be activated through preferences. Therefore, it is also the only recommendation preference that
         *        can be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationPreferenceNamesWithStrings(Collection<String> recommendationPreferenceNames);

        /**
         * <p>
         * The name of the recommendation preference to delete.
         * </p>
         * <p>
         * Enhanced infrastructure metrics (<code>EnhancedInfrastructureMetrics</code>) is the only feature that can be
         * activated through preferences. Therefore, it is also the only recommendation preference that can be deleted.
         * </p>
         * 
         * @param recommendationPreferenceNames
         *        The name of the recommendation preference to delete.</p>
         *        <p>
         *        Enhanced infrastructure metrics (<code>EnhancedInfrastructureMetrics</code>) is the only feature that
         *        can be activated through preferences. Therefore, it is also the only recommendation preference that
         *        can be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationPreferenceNamesWithStrings(String... recommendationPreferenceNames);

        /**
         * <p>
         * The name of the recommendation preference to delete.
         * </p>
         * <p>
         * Enhanced infrastructure metrics (<code>EnhancedInfrastructureMetrics</code>) is the only feature that can be
         * activated through preferences. Therefore, it is also the only recommendation preference that can be deleted.
         * </p>
         * 
         * @param recommendationPreferenceNames
         *        The name of the recommendation preference to delete.</p>
         *        <p>
         *        Enhanced infrastructure metrics (<code>EnhancedInfrastructureMetrics</code>) is the only feature that
         *        can be activated through preferences. Therefore, it is also the only recommendation preference that
         *        can be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationPreferenceNames(Collection<RecommendationPreferenceName> recommendationPreferenceNames);

        /**
         * <p>
         * The name of the recommendation preference to delete.
         * </p>
         * <p>
         * Enhanced infrastructure metrics (<code>EnhancedInfrastructureMetrics</code>) is the only feature that can be
         * activated through preferences. Therefore, it is also the only recommendation preference that can be deleted.
         * </p>
         * 
         * @param recommendationPreferenceNames
         *        The name of the recommendation preference to delete.</p>
         *        <p>
         *        Enhanced infrastructure metrics (<code>EnhancedInfrastructureMetrics</code>) is the only feature that
         *        can be activated through preferences. Therefore, it is also the only recommendation preference that
         *        can be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationPreferenceNames(RecommendationPreferenceName... recommendationPreferenceNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComputeOptimizerRequest.BuilderImpl implements Builder {
        private String resourceType;

        private Scope scope;

        private List<String> recommendationPreferenceNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRecommendationPreferencesRequest model) {
            super(model);
            resourceType(model.resourceType);
            scope(model.scope);
            recommendationPreferenceNamesWithStrings(model.recommendationPreferenceNames);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Scope.Builder getScope() {
            return scope != null ? scope.toBuilder() : null;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final Collection<String> getRecommendationPreferenceNames() {
            if (recommendationPreferenceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return recommendationPreferenceNames;
        }

        public final void setRecommendationPreferenceNames(Collection<String> recommendationPreferenceNames) {
            this.recommendationPreferenceNames = RecommendationPreferenceNamesCopier.copy(recommendationPreferenceNames);
        }

        @Override
        public final Builder recommendationPreferenceNamesWithStrings(Collection<String> recommendationPreferenceNames) {
            this.recommendationPreferenceNames = RecommendationPreferenceNamesCopier.copy(recommendationPreferenceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationPreferenceNamesWithStrings(String... recommendationPreferenceNames) {
            recommendationPreferenceNamesWithStrings(Arrays.asList(recommendationPreferenceNames));
            return this;
        }

        @Override
        public final Builder recommendationPreferenceNames(Collection<RecommendationPreferenceName> recommendationPreferenceNames) {
            this.recommendationPreferenceNames = RecommendationPreferenceNamesCopier
                    .copyEnumToString(recommendationPreferenceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationPreferenceNames(RecommendationPreferenceName... recommendationPreferenceNames) {
            recommendationPreferenceNames(Arrays.asList(recommendationPreferenceNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRecommendationPreferencesRequest build() {
            return new DeleteRecommendationPreferencesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
