/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the effective recommendation preferences for a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EffectiveRecommendationPreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<EffectiveRecommendationPreferences.Builder, EffectiveRecommendationPreferences> {
    private static final SdkField<List<String>> CPU_VENDOR_ARCHITECTURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("cpuVendorArchitectures")
            .getter(getter(EffectiveRecommendationPreferences::cpuVendorArchitecturesAsStrings))
            .setter(setter(Builder::cpuVendorArchitecturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuVendorArchitectures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENHANCED_INFRASTRUCTURE_METRICS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("enhancedInfrastructureMetrics")
            .getter(getter(EffectiveRecommendationPreferences::enhancedInfrastructureMetricsAsString))
            .setter(setter(Builder::enhancedInfrastructureMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedInfrastructureMetrics")
                    .build()).build();

    private static final SdkField<String> INFERRED_WORKLOAD_TYPES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inferredWorkloadTypes")
            .getter(getter(EffectiveRecommendationPreferences::inferredWorkloadTypesAsString))
            .setter(setter(Builder::inferredWorkloadTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferredWorkloadTypes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CPU_VENDOR_ARCHITECTURES_FIELD, ENHANCED_INFRASTRUCTURE_METRICS_FIELD, INFERRED_WORKLOAD_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> cpuVendorArchitectures;

    private final String enhancedInfrastructureMetrics;

    private final String inferredWorkloadTypes;

    private EffectiveRecommendationPreferences(BuilderImpl builder) {
        this.cpuVendorArchitectures = builder.cpuVendorArchitectures;
        this.enhancedInfrastructureMetrics = builder.enhancedInfrastructureMetrics;
        this.inferredWorkloadTypes = builder.inferredWorkloadTypes;
    }

    /**
     * <p>
     * Describes the CPU vendor and architecture for an instance or Auto Scaling group recommendations.
     * </p>
     * <p>
     * For example, when you specify <code>AWS_ARM64</code> with:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute Optimizer
     * returns recommendations that consist of Graviton2 instance types only.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization metrics
     * for Graviton2 instance type recommendations only.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute
     * Optimizer exports recommendations that consist of Graviton2 instance types only.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCpuVendorArchitectures} method.
     * </p>
     * 
     * @return Describes the CPU vendor and architecture for an instance or Auto Scaling group recommendations.</p>
     *         <p>
     *         For example, when you specify <code>AWS_ARM64</code> with:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
     *         Optimizer returns recommendations that consist of Graviton2 instance types only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
     *         metrics for Graviton2 instance type recommendations only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request,
     *         Compute Optimizer exports recommendations that consist of Graviton2 instance types only.
     *         </p>
     *         </li>
     */
    public final List<CpuVendorArchitecture> cpuVendorArchitectures() {
        return CpuVendorArchitecturesCopier.copyStringToEnum(cpuVendorArchitectures);
    }

    /**
     * For responses, this returns true if the service returned a value for the CpuVendorArchitectures property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCpuVendorArchitectures() {
        return cpuVendorArchitectures != null && !(cpuVendorArchitectures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the CPU vendor and architecture for an instance or Auto Scaling group recommendations.
     * </p>
     * <p>
     * For example, when you specify <code>AWS_ARM64</code> with:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute Optimizer
     * returns recommendations that consist of Graviton2 instance types only.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization metrics
     * for Graviton2 instance type recommendations only.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute
     * Optimizer exports recommendations that consist of Graviton2 instance types only.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCpuVendorArchitectures} method.
     * </p>
     * 
     * @return Describes the CPU vendor and architecture for an instance or Auto Scaling group recommendations.</p>
     *         <p>
     *         For example, when you specify <code>AWS_ARM64</code> with:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
     *         Optimizer returns recommendations that consist of Graviton2 instance types only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
     *         metrics for Graviton2 instance type recommendations only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request,
     *         Compute Optimizer exports recommendations that consist of Graviton2 instance types only.
     *         </p>
     *         </li>
     */
    public final List<String> cpuVendorArchitecturesAsStrings() {
        return cpuVendorArchitectures;
    }

    /**
     * <p>
     * Describes the activation status of the enhanced infrastructure metrics preference.
     * </p>
     * <p>
     * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh, and
     * a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
     * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedInfrastructureMetrics} will return {@link EnhancedInfrastructureMetrics#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #enhancedInfrastructureMetricsAsString}.
     * </p>
     * 
     * @return Describes the activation status of the enhanced infrastructure metrics preference.</p>
     *         <p>
     *         A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
     *         refresh, and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
     *         >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * @see EnhancedInfrastructureMetrics
     */
    public final EnhancedInfrastructureMetrics enhancedInfrastructureMetrics() {
        return EnhancedInfrastructureMetrics.fromValue(enhancedInfrastructureMetrics);
    }

    /**
     * <p>
     * Describes the activation status of the enhanced infrastructure metrics preference.
     * </p>
     * <p>
     * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh, and
     * a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
     * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedInfrastructureMetrics} will return {@link EnhancedInfrastructureMetrics#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #enhancedInfrastructureMetricsAsString}.
     * </p>
     * 
     * @return Describes the activation status of the enhanced infrastructure metrics preference.</p>
     *         <p>
     *         A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
     *         refresh, and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
     *         >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * @see EnhancedInfrastructureMetrics
     */
    public final String enhancedInfrastructureMetricsAsString() {
        return enhancedInfrastructureMetrics;
    }

    /**
     * <p>
     * Describes the activation status of the inferred workload types preference.
     * </p>
     * <p>
     * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh. A
     * status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inferredWorkloadTypes} will return {@link InferredWorkloadTypesPreference#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #inferredWorkloadTypesAsString}.
     * </p>
     * 
     * @return Describes the activation status of the inferred workload types preference.</p>
     *         <p>
     *         A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
     *         refresh. A status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     * @see InferredWorkloadTypesPreference
     */
    public final InferredWorkloadTypesPreference inferredWorkloadTypes() {
        return InferredWorkloadTypesPreference.fromValue(inferredWorkloadTypes);
    }

    /**
     * <p>
     * Describes the activation status of the inferred workload types preference.
     * </p>
     * <p>
     * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh. A
     * status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inferredWorkloadTypes} will return {@link InferredWorkloadTypesPreference#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #inferredWorkloadTypesAsString}.
     * </p>
     * 
     * @return Describes the activation status of the inferred workload types preference.</p>
     *         <p>
     *         A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
     *         refresh. A status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     * @see InferredWorkloadTypesPreference
     */
    public final String inferredWorkloadTypesAsString() {
        return inferredWorkloadTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCpuVendorArchitectures() ? cpuVendorArchitecturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enhancedInfrastructureMetricsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inferredWorkloadTypesAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectiveRecommendationPreferences)) {
            return false;
        }
        EffectiveRecommendationPreferences other = (EffectiveRecommendationPreferences) obj;
        return hasCpuVendorArchitectures() == other.hasCpuVendorArchitectures()
                && Objects.equals(cpuVendorArchitecturesAsStrings(), other.cpuVendorArchitecturesAsStrings())
                && Objects.equals(enhancedInfrastructureMetricsAsString(), other.enhancedInfrastructureMetricsAsString())
                && Objects.equals(inferredWorkloadTypesAsString(), other.inferredWorkloadTypesAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EffectiveRecommendationPreferences")
                .add("CpuVendorArchitectures", hasCpuVendorArchitectures() ? cpuVendorArchitecturesAsStrings() : null)
                .add("EnhancedInfrastructureMetrics", enhancedInfrastructureMetricsAsString())
                .add("InferredWorkloadTypes", inferredWorkloadTypesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cpuVendorArchitectures":
            return Optional.ofNullable(clazz.cast(cpuVendorArchitecturesAsStrings()));
        case "enhancedInfrastructureMetrics":
            return Optional.ofNullable(clazz.cast(enhancedInfrastructureMetricsAsString()));
        case "inferredWorkloadTypes":
            return Optional.ofNullable(clazz.cast(inferredWorkloadTypesAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EffectiveRecommendationPreferences, T> g) {
        return obj -> g.apply((EffectiveRecommendationPreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EffectiveRecommendationPreferences> {
        /**
         * <p>
         * Describes the CPU vendor and architecture for an instance or Auto Scaling group recommendations.
         * </p>
         * <p>
         * For example, when you specify <code>AWS_ARM64</code> with:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
         * Optimizer returns recommendations that consist of Graviton2 instance types only.
         * </p>
         * </li>
         * <li>
         * <p>
         * A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
         * metrics for Graviton2 instance type recommendations only.
         * </p>
         * </li>
         * <li>
         * <p>
         * A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute
         * Optimizer exports recommendations that consist of Graviton2 instance types only.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cpuVendorArchitectures
         *        Describes the CPU vendor and architecture for an instance or Auto Scaling group recommendations.</p>
         *        <p>
         *        For example, when you specify <code>AWS_ARM64</code> with:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
         *        Optimizer returns recommendations that consist of Graviton2 instance types only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
         *        metrics for Graviton2 instance type recommendations only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request,
         *        Compute Optimizer exports recommendations that consist of Graviton2 instance types only.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuVendorArchitecturesWithStrings(Collection<String> cpuVendorArchitectures);

        /**
         * <p>
         * Describes the CPU vendor and architecture for an instance or Auto Scaling group recommendations.
         * </p>
         * <p>
         * For example, when you specify <code>AWS_ARM64</code> with:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
         * Optimizer returns recommendations that consist of Graviton2 instance types only.
         * </p>
         * </li>
         * <li>
         * <p>
         * A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
         * metrics for Graviton2 instance type recommendations only.
         * </p>
         * </li>
         * <li>
         * <p>
         * A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute
         * Optimizer exports recommendations that consist of Graviton2 instance types only.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cpuVendorArchitectures
         *        Describes the CPU vendor and architecture for an instance or Auto Scaling group recommendations.</p>
         *        <p>
         *        For example, when you specify <code>AWS_ARM64</code> with:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
         *        Optimizer returns recommendations that consist of Graviton2 instance types only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
         *        metrics for Graviton2 instance type recommendations only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request,
         *        Compute Optimizer exports recommendations that consist of Graviton2 instance types only.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuVendorArchitecturesWithStrings(String... cpuVendorArchitectures);

        /**
         * <p>
         * Describes the CPU vendor and architecture for an instance or Auto Scaling group recommendations.
         * </p>
         * <p>
         * For example, when you specify <code>AWS_ARM64</code> with:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
         * Optimizer returns recommendations that consist of Graviton2 instance types only.
         * </p>
         * </li>
         * <li>
         * <p>
         * A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
         * metrics for Graviton2 instance type recommendations only.
         * </p>
         * </li>
         * <li>
         * <p>
         * A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute
         * Optimizer exports recommendations that consist of Graviton2 instance types only.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cpuVendorArchitectures
         *        Describes the CPU vendor and architecture for an instance or Auto Scaling group recommendations.</p>
         *        <p>
         *        For example, when you specify <code>AWS_ARM64</code> with:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
         *        Optimizer returns recommendations that consist of Graviton2 instance types only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
         *        metrics for Graviton2 instance type recommendations only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request,
         *        Compute Optimizer exports recommendations that consist of Graviton2 instance types only.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuVendorArchitectures(Collection<CpuVendorArchitecture> cpuVendorArchitectures);

        /**
         * <p>
         * Describes the CPU vendor and architecture for an instance or Auto Scaling group recommendations.
         * </p>
         * <p>
         * For example, when you specify <code>AWS_ARM64</code> with:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
         * Optimizer returns recommendations that consist of Graviton2 instance types only.
         * </p>
         * </li>
         * <li>
         * <p>
         * A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
         * metrics for Graviton2 instance type recommendations only.
         * </p>
         * </li>
         * <li>
         * <p>
         * A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute
         * Optimizer exports recommendations that consist of Graviton2 instance types only.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cpuVendorArchitectures
         *        Describes the CPU vendor and architecture for an instance or Auto Scaling group recommendations.</p>
         *        <p>
         *        For example, when you specify <code>AWS_ARM64</code> with:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute
         *        Optimizer returns recommendations that consist of Graviton2 instance types only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization
         *        metrics for Graviton2 instance type recommendations only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request,
         *        Compute Optimizer exports recommendations that consist of Graviton2 instance types only.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuVendorArchitectures(CpuVendorArchitecture... cpuVendorArchitectures);

        /**
         * <p>
         * Describes the activation status of the enhanced infrastructure metrics preference.
         * </p>
         * <p>
         * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh,
         * and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
         * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param enhancedInfrastructureMetrics
         *        Describes the activation status of the enhanced infrastructure metrics preference.</p>
         *        <p>
         *        A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
         *        refresh, and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         *        >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * @see EnhancedInfrastructureMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedInfrastructureMetrics
         */
        Builder enhancedInfrastructureMetrics(String enhancedInfrastructureMetrics);

        /**
         * <p>
         * Describes the activation status of the enhanced infrastructure metrics preference.
         * </p>
         * <p>
         * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh,
         * and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
         * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param enhancedInfrastructureMetrics
         *        Describes the activation status of the enhanced infrastructure metrics preference.</p>
         *        <p>
         *        A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
         *        refresh, and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         *        >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * @see EnhancedInfrastructureMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedInfrastructureMetrics
         */
        Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics);

        /**
         * <p>
         * Describes the activation status of the inferred workload types preference.
         * </p>
         * <p>
         * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh.
         * A status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         * </p>
         * 
         * @param inferredWorkloadTypes
         *        Describes the activation status of the inferred workload types preference.</p>
         *        <p>
         *        A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
         *        refresh. A status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         * @see InferredWorkloadTypesPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferredWorkloadTypesPreference
         */
        Builder inferredWorkloadTypes(String inferredWorkloadTypes);

        /**
         * <p>
         * Describes the activation status of the inferred workload types preference.
         * </p>
         * <p>
         * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh.
         * A status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         * </p>
         * 
         * @param inferredWorkloadTypes
         *        Describes the activation status of the inferred workload types preference.</p>
         *        <p>
         *        A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
         *        refresh. A status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         * @see InferredWorkloadTypesPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferredWorkloadTypesPreference
         */
        Builder inferredWorkloadTypes(InferredWorkloadTypesPreference inferredWorkloadTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> cpuVendorArchitectures = DefaultSdkAutoConstructList.getInstance();

        private String enhancedInfrastructureMetrics;

        private String inferredWorkloadTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(EffectiveRecommendationPreferences model) {
            cpuVendorArchitecturesWithStrings(model.cpuVendorArchitectures);
            enhancedInfrastructureMetrics(model.enhancedInfrastructureMetrics);
            inferredWorkloadTypes(model.inferredWorkloadTypes);
        }

        public final Collection<String> getCpuVendorArchitectures() {
            if (cpuVendorArchitectures instanceof SdkAutoConstructList) {
                return null;
            }
            return cpuVendorArchitectures;
        }

        public final void setCpuVendorArchitectures(Collection<String> cpuVendorArchitectures) {
            this.cpuVendorArchitectures = CpuVendorArchitecturesCopier.copy(cpuVendorArchitectures);
        }

        @Override
        public final Builder cpuVendorArchitecturesWithStrings(Collection<String> cpuVendorArchitectures) {
            this.cpuVendorArchitectures = CpuVendorArchitecturesCopier.copy(cpuVendorArchitectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cpuVendorArchitecturesWithStrings(String... cpuVendorArchitectures) {
            cpuVendorArchitecturesWithStrings(Arrays.asList(cpuVendorArchitectures));
            return this;
        }

        @Override
        public final Builder cpuVendorArchitectures(Collection<CpuVendorArchitecture> cpuVendorArchitectures) {
            this.cpuVendorArchitectures = CpuVendorArchitecturesCopier.copyEnumToString(cpuVendorArchitectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cpuVendorArchitectures(CpuVendorArchitecture... cpuVendorArchitectures) {
            cpuVendorArchitectures(Arrays.asList(cpuVendorArchitectures));
            return this;
        }

        public final String getEnhancedInfrastructureMetrics() {
            return enhancedInfrastructureMetrics;
        }

        public final void setEnhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
        }

        @Override
        public final Builder enhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
            return this;
        }

        @Override
        public final Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics(enhancedInfrastructureMetrics == null ? null : enhancedInfrastructureMetrics
                    .toString());
            return this;
        }

        public final String getInferredWorkloadTypes() {
            return inferredWorkloadTypes;
        }

        public final void setInferredWorkloadTypes(String inferredWorkloadTypes) {
            this.inferredWorkloadTypes = inferredWorkloadTypes;
        }

        @Override
        public final Builder inferredWorkloadTypes(String inferredWorkloadTypes) {
            this.inferredWorkloadTypes = inferredWorkloadTypes;
            return this;
        }

        @Override
        public final Builder inferredWorkloadTypes(InferredWorkloadTypesPreference inferredWorkloadTypes) {
            this.inferredWorkloadTypes(inferredWorkloadTypes == null ? null : inferredWorkloadTypes.toString());
            return this;
        }

        @Override
        public EffectiveRecommendationPreferences build() {
            return new EffectiveRecommendationPreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
