/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ExportableVolumeField {
    ACCOUNT_ID("AccountId"),

    VOLUME_ARN("VolumeArn"),

    FINDING("Finding"),

    UTILIZATION_METRICS_VOLUME_READ_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsVolumeReadOpsPerSecondMaximum"),

    UTILIZATION_METRICS_VOLUME_WRITE_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsVolumeWriteOpsPerSecondMaximum"),

    UTILIZATION_METRICS_VOLUME_READ_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsVolumeReadBytesPerSecondMaximum"),

    UTILIZATION_METRICS_VOLUME_WRITE_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsVolumeWriteBytesPerSecondMaximum"),

    LOOKBACK_PERIOD_IN_DAYS("LookbackPeriodInDays"),

    CURRENT_CONFIGURATION_VOLUME_TYPE("CurrentConfigurationVolumeType"),

    CURRENT_CONFIGURATION_VOLUME_BASELINE_IOPS("CurrentConfigurationVolumeBaselineIOPS"),

    CURRENT_CONFIGURATION_VOLUME_BASELINE_THROUGHPUT("CurrentConfigurationVolumeBaselineThroughput"),

    CURRENT_CONFIGURATION_VOLUME_BURST_IOPS("CurrentConfigurationVolumeBurstIOPS"),

    CURRENT_CONFIGURATION_VOLUME_BURST_THROUGHPUT("CurrentConfigurationVolumeBurstThroughput"),

    CURRENT_CONFIGURATION_VOLUME_SIZE("CurrentConfigurationVolumeSize"),

    CURRENT_MONTHLY_PRICE("CurrentMonthlyPrice"),

    RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_TYPE("RecommendationOptionsConfigurationVolumeType"),

    RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_BASELINE_IOPS("RecommendationOptionsConfigurationVolumeBaselineIOPS"),

    RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_BASELINE_THROUGHPUT("RecommendationOptionsConfigurationVolumeBaselineThroughput"),

    RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_BURST_IOPS("RecommendationOptionsConfigurationVolumeBurstIOPS"),

    RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_BURST_THROUGHPUT("RecommendationOptionsConfigurationVolumeBurstThroughput"),

    RECOMMENDATION_OPTIONS_CONFIGURATION_VOLUME_SIZE("RecommendationOptionsConfigurationVolumeSize"),

    RECOMMENDATION_OPTIONS_MONTHLY_PRICE("RecommendationOptionsMonthlyPrice"),

    RECOMMENDATION_OPTIONS_PERFORMANCE_RISK("RecommendationOptionsPerformanceRisk"),

    LAST_REFRESH_TIMESTAMP("LastRefreshTimestamp"),

    CURRENT_PERFORMANCE_RISK("CurrentPerformanceRisk"),

    RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE("RecommendationOptionsSavingsOpportunityPercentage"),

    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY("RecommendationOptionsEstimatedMonthlySavingsCurrency"),

    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE("RecommendationOptionsEstimatedMonthlySavingsValue"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportableVolumeField> VALUE_MAP = EnumUtils.uniqueIndex(ExportableVolumeField.class,
            ExportableVolumeField::toString);

    private final String value;

    private ExportableVolumeField(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ExportableVolumeField corresponding to the value
     */
    public static ExportableVolumeField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ExportableVolumeField}s
     */
    public static Set<ExportableVolumeField> knownValues() {
        Set<ExportableVolumeField> knownValues = EnumSet.allOf(ExportableVolumeField.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
