/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a recommendation preference.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationPreferencesDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationPreferencesDetail.Builder, RecommendationPreferencesDetail> {
    private static final SdkField<Scope> SCOPE_FIELD = SdkField.<Scope> builder(MarshallingType.SDK_POJO).memberName("scope")
            .getter(getter(RecommendationPreferencesDetail::scope)).setter(setter(Builder::scope)).constructor(Scope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(RecommendationPreferencesDetail::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> ENHANCED_INFRASTRUCTURE_METRICS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("enhancedInfrastructureMetrics")
            .getter(getter(RecommendationPreferencesDetail::enhancedInfrastructureMetricsAsString))
            .setter(setter(Builder::enhancedInfrastructureMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedInfrastructureMetrics")
                    .build()).build();

    private static final SdkField<String> INFERRED_WORKLOAD_TYPES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inferredWorkloadTypes").getter(getter(RecommendationPreferencesDetail::inferredWorkloadTypesAsString))
            .setter(setter(Builder::inferredWorkloadTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferredWorkloadTypes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD,
            RESOURCE_TYPE_FIELD, ENHANCED_INFRASTRUCTURE_METRICS_FIELD, INFERRED_WORKLOAD_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Scope scope;

    private final String resourceType;

    private final String enhancedInfrastructureMetrics;

    private final String inferredWorkloadTypes;

    private RecommendationPreferencesDetail(BuilderImpl builder) {
        this.scope = builder.scope;
        this.resourceType = builder.resourceType;
        this.enhancedInfrastructureMetrics = builder.enhancedInfrastructureMetrics;
        this.inferredWorkloadTypes = builder.inferredWorkloadTypes;
    }

    /**
     * <p>
     * An object that describes the scope of the recommendation preference.
     * </p>
     * <p>
     * Recommendation preferences can be created at the organization level (for management accounts of an organization
     * only), account level, and resource level. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating
     * enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * 
     * @return An object that describes the scope of the recommendation preference.</p>
     *         <p>
     *         Recommendation preferences can be created at the organization level (for management accounts of an
     *         organization only), account level, and resource level. For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
     *         >Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     */
    public final Scope scope() {
        return scope;
    }

    /**
     * <p>
     * The target resource type of the recommendation preference to create.
     * </p>
     * <p>
     * The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto Scaling
     * groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an Auto Scaling
     * group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The target resource type of the recommendation preference to create.</p>
     *         <p>
     *         The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto
     *         Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an
     *         Auto Scaling group.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The target resource type of the recommendation preference to create.
     * </p>
     * <p>
     * The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto Scaling
     * groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an Auto Scaling
     * group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The target resource type of the recommendation preference to create.</p>
     *         <p>
     *         The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto
     *         Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an
     *         Auto Scaling group.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The status of the enhanced infrastructure metrics recommendation preference.
     * </p>
     * <p>
     * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh, and
     * a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
     * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedInfrastructureMetrics} will return {@link EnhancedInfrastructureMetrics#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #enhancedInfrastructureMetricsAsString}.
     * </p>
     * 
     * @return The status of the enhanced infrastructure metrics recommendation preference.</p>
     *         <p>
     *         A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
     *         refresh, and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
     *         >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * @see EnhancedInfrastructureMetrics
     */
    public final EnhancedInfrastructureMetrics enhancedInfrastructureMetrics() {
        return EnhancedInfrastructureMetrics.fromValue(enhancedInfrastructureMetrics);
    }

    /**
     * <p>
     * The status of the enhanced infrastructure metrics recommendation preference.
     * </p>
     * <p>
     * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh, and
     * a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
     * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enhancedInfrastructureMetrics} will return {@link EnhancedInfrastructureMetrics#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #enhancedInfrastructureMetricsAsString}.
     * </p>
     * 
     * @return The status of the enhanced infrastructure metrics recommendation preference.</p>
     *         <p>
     *         A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
     *         refresh, and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
     *         >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
     * @see EnhancedInfrastructureMetrics
     */
    public final String enhancedInfrastructureMetricsAsString() {
        return enhancedInfrastructureMetrics;
    }

    /**
     * <p>
     * The status of the inferred workload types recommendation preference.
     * </p>
     * <p>
     * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh. A
     * status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inferredWorkloadTypes} will return {@link InferredWorkloadTypesPreference#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #inferredWorkloadTypesAsString}.
     * </p>
     * 
     * @return The status of the inferred workload types recommendation preference.</p>
     *         <p>
     *         A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
     *         refresh. A status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     * @see InferredWorkloadTypesPreference
     */
    public final InferredWorkloadTypesPreference inferredWorkloadTypes() {
        return InferredWorkloadTypesPreference.fromValue(inferredWorkloadTypes);
    }

    /**
     * <p>
     * The status of the inferred workload types recommendation preference.
     * </p>
     * <p>
     * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh. A
     * status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inferredWorkloadTypes} will return {@link InferredWorkloadTypesPreference#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #inferredWorkloadTypesAsString}.
     * </p>
     * 
     * @return The status of the inferred workload types recommendation preference.</p>
     *         <p>
     *         A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
     *         refresh. A status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
     * @see InferredWorkloadTypesPreference
     */
    public final String inferredWorkloadTypesAsString() {
        return inferredWorkloadTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedInfrastructureMetricsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inferredWorkloadTypesAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationPreferencesDetail)) {
            return false;
        }
        RecommendationPreferencesDetail other = (RecommendationPreferencesDetail) obj;
        return Objects.equals(scope(), other.scope()) && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(enhancedInfrastructureMetricsAsString(), other.enhancedInfrastructureMetricsAsString())
                && Objects.equals(inferredWorkloadTypesAsString(), other.inferredWorkloadTypesAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationPreferencesDetail").add("Scope", scope())
                .add("ResourceType", resourceTypeAsString())
                .add("EnhancedInfrastructureMetrics", enhancedInfrastructureMetricsAsString())
                .add("InferredWorkloadTypes", inferredWorkloadTypesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "enhancedInfrastructureMetrics":
            return Optional.ofNullable(clazz.cast(enhancedInfrastructureMetricsAsString()));
        case "inferredWorkloadTypes":
            return Optional.ofNullable(clazz.cast(inferredWorkloadTypesAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationPreferencesDetail, T> g) {
        return obj -> g.apply((RecommendationPreferencesDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationPreferencesDetail> {
        /**
         * <p>
         * An object that describes the scope of the recommendation preference.
         * </p>
         * <p>
         * Recommendation preferences can be created at the organization level (for management accounts of an
         * organization only), account level, and resource level. For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         * >Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param scope
         *        An object that describes the scope of the recommendation preference.</p>
         *        <p>
         *        Recommendation preferences can be created at the organization level (for management accounts of an
         *        organization only), account level, and resource level. For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         *        >Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(Scope scope);

        /**
         * <p>
         * An object that describes the scope of the recommendation preference.
         * </p>
         * <p>
         * Recommendation preferences can be created at the organization level (for management accounts of an
         * organization only), account level, and resource level. For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         * >Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Scope.Builder} avoiding the need to
         * create one manually via {@link Scope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Scope.Builder#build()} is called immediately and its result is
         * passed to {@link #scope(Scope)}.
         * 
         * @param scope
         *        a consumer that will call methods on {@link Scope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scope(Scope)
         */
        default Builder scope(Consumer<Scope.Builder> scope) {
            return scope(Scope.builder().applyMutation(scope).build());
        }

        /**
         * <p>
         * The target resource type of the recommendation preference to create.
         * </p>
         * <p>
         * The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto
         * Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an Auto
         * Scaling group.
         * </p>
         * 
         * @param resourceType
         *        The target resource type of the recommendation preference to create.</p>
         *        <p>
         *        The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of
         *        Auto Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part
         *        of an Auto Scaling group.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The target resource type of the recommendation preference to create.
         * </p>
         * <p>
         * The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto
         * Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an Auto
         * Scaling group.
         * </p>
         * 
         * @param resourceType
         *        The target resource type of the recommendation preference to create.</p>
         *        <p>
         *        The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of
         *        Auto Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part
         *        of an Auto Scaling group.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The status of the enhanced infrastructure metrics recommendation preference.
         * </p>
         * <p>
         * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh,
         * and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
         * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param enhancedInfrastructureMetrics
         *        The status of the enhanced infrastructure metrics recommendation preference.</p>
         *        <p>
         *        A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
         *        refresh, and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         *        >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * @see EnhancedInfrastructureMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedInfrastructureMetrics
         */
        Builder enhancedInfrastructureMetrics(String enhancedInfrastructureMetrics);

        /**
         * <p>
         * The status of the enhanced infrastructure metrics recommendation preference.
         * </p>
         * <p>
         * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh,
         * and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced
         * infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param enhancedInfrastructureMetrics
         *        The status of the enhanced infrastructure metrics recommendation preference.</p>
         *        <p>
         *        A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
         *        refresh, and a status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html"
         *        >Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.
         * @see EnhancedInfrastructureMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnhancedInfrastructureMetrics
         */
        Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics);

        /**
         * <p>
         * The status of the inferred workload types recommendation preference.
         * </p>
         * <p>
         * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh.
         * A status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         * </p>
         * 
         * @param inferredWorkloadTypes
         *        The status of the inferred workload types recommendation preference.</p>
         *        <p>
         *        A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
         *        refresh. A status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         * @see InferredWorkloadTypesPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferredWorkloadTypesPreference
         */
        Builder inferredWorkloadTypes(String inferredWorkloadTypes);

        /**
         * <p>
         * The status of the inferred workload types recommendation preference.
         * </p>
         * <p>
         * A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh.
         * A status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         * </p>
         * 
         * @param inferredWorkloadTypes
         *        The status of the inferred workload types recommendation preference.</p>
         *        <p>
         *        A status of <code>Active</code> confirms that the preference is applied in the latest recommendation
         *        refresh. A status of <code>Inactive</code> confirms that it's not yet applied to recommendations.
         * @see InferredWorkloadTypesPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferredWorkloadTypesPreference
         */
        Builder inferredWorkloadTypes(InferredWorkloadTypesPreference inferredWorkloadTypes);
    }

    static final class BuilderImpl implements Builder {
        private Scope scope;

        private String resourceType;

        private String enhancedInfrastructureMetrics;

        private String inferredWorkloadTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationPreferencesDetail model) {
            scope(model.scope);
            resourceType(model.resourceType);
            enhancedInfrastructureMetrics(model.enhancedInfrastructureMetrics);
            inferredWorkloadTypes(model.inferredWorkloadTypes);
        }

        public final Scope.Builder getScope() {
            return scope != null ? scope.toBuilder() : null;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getEnhancedInfrastructureMetrics() {
            return enhancedInfrastructureMetrics;
        }

        public final void setEnhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
        }

        @Override
        public final Builder enhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
            return this;
        }

        @Override
        public final Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics(enhancedInfrastructureMetrics == null ? null : enhancedInfrastructureMetrics
                    .toString());
            return this;
        }

        public final String getInferredWorkloadTypes() {
            return inferredWorkloadTypes;
        }

        public final void setInferredWorkloadTypes(String inferredWorkloadTypes) {
            this.inferredWorkloadTypes = inferredWorkloadTypes;
        }

        @Override
        public final Builder inferredWorkloadTypes(String inferredWorkloadTypes) {
            this.inferredWorkloadTypes = inferredWorkloadTypes;
            return this;
        }

        @Override
        public final Builder inferredWorkloadTypes(InferredWorkloadTypesPreference inferredWorkloadTypes) {
            this.inferredWorkloadTypes(inferredWorkloadTypes == null ? null : inferredWorkloadTypes.toString());
            return this;
        }

        @Override
        public RecommendationPreferencesDetail build() {
            return new RecommendationPreferencesDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
