/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the savings opportunity for recommendations of a given resource type or for the recommendation option of an
 * individual resource.
 * </p>
 * <p>
 * Savings opportunity represents the estimated monthly savings you can achieve by implementing a given Compute
 * Optimizer recommendation.
 * </p>
 * <important>
 * <p>
 * Savings opportunity data requires that you opt in to Cost Explorer, as well as activate <b>Receive Amazon EC2
 * resource recommendations</b> in the Cost Explorer preferences page. That creates a connection between Cost Explorer
 * and Compute Optimizer. With this connection, Cost Explorer generates savings estimates considering the price of
 * existing resources, the price of recommended resources, and historical usage data. Estimated monthly savings reflects
 * the projected dollar savings associated with each of the recommendations generated. For more information, see <a
 * href="https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html">Enabling Cost Explorer</a> and <a
 * href="https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html">Optimizing your cost with
 * Rightsizing Recommendations</a> in the <i>Cost Management User Guide</i>.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsOpportunity implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsOpportunity.Builder, SavingsOpportunity> {
    private static final SdkField<Double> SAVINGS_OPPORTUNITY_PERCENTAGE_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("savingsOpportunityPercentage")
            .getter(getter(SavingsOpportunity::savingsOpportunityPercentage))
            .setter(setter(Builder::savingsOpportunityPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunityPercentage")
                    .build()).build();

    private static final SdkField<EstimatedMonthlySavings> ESTIMATED_MONTHLY_SAVINGS_FIELD = SdkField
            .<EstimatedMonthlySavings> builder(MarshallingType.SDK_POJO).memberName("estimatedMonthlySavings")
            .getter(getter(SavingsOpportunity::estimatedMonthlySavings)).setter(setter(Builder::estimatedMonthlySavings))
            .constructor(EstimatedMonthlySavings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlySavings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SAVINGS_OPPORTUNITY_PERCENTAGE_FIELD, ESTIMATED_MONTHLY_SAVINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double savingsOpportunityPercentage;

    private final EstimatedMonthlySavings estimatedMonthlySavings;

    private SavingsOpportunity(BuilderImpl builder) {
        this.savingsOpportunityPercentage = builder.savingsOpportunityPercentage;
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
    }

    /**
     * <p>
     * The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer
     * recommendations for a given resource.
     * </p>
     * 
     * @return The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer
     *         recommendations for a given resource.
     */
    public final Double savingsOpportunityPercentage() {
        return savingsOpportunityPercentage;
    }

    /**
     * <p>
     * An object that describes the estimated monthly savings amount possible, based on On-Demand instance pricing, by
     * adopting Compute Optimizer recommendations for a given resource.
     * </p>
     * 
     * @return An object that describes the estimated monthly savings amount possible, based on On-Demand instance
     *         pricing, by adopting Compute Optimizer recommendations for a given resource.
     */
    public final EstimatedMonthlySavings estimatedMonthlySavings() {
        return estimatedMonthlySavings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(savingsOpportunityPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlySavings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsOpportunity)) {
            return false;
        }
        SavingsOpportunity other = (SavingsOpportunity) obj;
        return Objects.equals(savingsOpportunityPercentage(), other.savingsOpportunityPercentage())
                && Objects.equals(estimatedMonthlySavings(), other.estimatedMonthlySavings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsOpportunity").add("SavingsOpportunityPercentage", savingsOpportunityPercentage())
                .add("EstimatedMonthlySavings", estimatedMonthlySavings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "savingsOpportunityPercentage":
            return Optional.ofNullable(clazz.cast(savingsOpportunityPercentage()));
        case "estimatedMonthlySavings":
            return Optional.ofNullable(clazz.cast(estimatedMonthlySavings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsOpportunity, T> g) {
        return obj -> g.apply((SavingsOpportunity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsOpportunity> {
        /**
         * <p>
         * The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer
         * recommendations for a given resource.
         * </p>
         * 
         * @param savingsOpportunityPercentage
         *        The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer
         *        recommendations for a given resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsOpportunityPercentage(Double savingsOpportunityPercentage);

        /**
         * <p>
         * An object that describes the estimated monthly savings amount possible, based on On-Demand instance pricing,
         * by adopting Compute Optimizer recommendations for a given resource.
         * </p>
         * 
         * @param estimatedMonthlySavings
         *        An object that describes the estimated monthly savings amount possible, based on On-Demand instance
         *        pricing, by adopting Compute Optimizer recommendations for a given resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlySavings(EstimatedMonthlySavings estimatedMonthlySavings);

        /**
         * <p>
         * An object that describes the estimated monthly savings amount possible, based on On-Demand instance pricing,
         * by adopting Compute Optimizer recommendations for a given resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link EstimatedMonthlySavings.Builder} avoiding
         * the need to create one manually via {@link EstimatedMonthlySavings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EstimatedMonthlySavings.Builder#build()} is called immediately
         * and its result is passed to {@link #estimatedMonthlySavings(EstimatedMonthlySavings)}.
         * 
         * @param estimatedMonthlySavings
         *        a consumer that will call methods on {@link EstimatedMonthlySavings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #estimatedMonthlySavings(EstimatedMonthlySavings)
         */
        default Builder estimatedMonthlySavings(Consumer<EstimatedMonthlySavings.Builder> estimatedMonthlySavings) {
            return estimatedMonthlySavings(EstimatedMonthlySavings.builder().applyMutation(estimatedMonthlySavings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Double savingsOpportunityPercentage;

        private EstimatedMonthlySavings estimatedMonthlySavings;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsOpportunity model) {
            savingsOpportunityPercentage(model.savingsOpportunityPercentage);
            estimatedMonthlySavings(model.estimatedMonthlySavings);
        }

        public final Double getSavingsOpportunityPercentage() {
            return savingsOpportunityPercentage;
        }

        public final void setSavingsOpportunityPercentage(Double savingsOpportunityPercentage) {
            this.savingsOpportunityPercentage = savingsOpportunityPercentage;
        }

        @Override
        public final Builder savingsOpportunityPercentage(Double savingsOpportunityPercentage) {
            this.savingsOpportunityPercentage = savingsOpportunityPercentage;
            return this;
        }

        public final EstimatedMonthlySavings.Builder getEstimatedMonthlySavings() {
            return estimatedMonthlySavings != null ? estimatedMonthlySavings.toBuilder() : null;
        }

        public final void setEstimatedMonthlySavings(EstimatedMonthlySavings.BuilderImpl estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings != null ? estimatedMonthlySavings.build() : null;
        }

        @Override
        public final Builder estimatedMonthlySavings(EstimatedMonthlySavings estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        @Override
        public SavingsOpportunity build() {
            return new SavingsOpportunity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
