/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of an Amazon Elastic Block Store (Amazon EBS) volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VolumeConfiguration.Builder, VolumeConfiguration> {
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeType").getter(getter(VolumeConfiguration::volumeType)).setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeType").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("volumeSize").getter(getter(VolumeConfiguration::volumeSize)).setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeSize").build()).build();

    private static final SdkField<Integer> VOLUME_BASELINE_IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("volumeBaselineIOPS").getter(getter(VolumeConfiguration::volumeBaselineIOPS))
            .setter(setter(Builder::volumeBaselineIOPS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeBaselineIOPS").build())
            .build();

    private static final SdkField<Integer> VOLUME_BURST_IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("volumeBurstIOPS").getter(getter(VolumeConfiguration::volumeBurstIOPS))
            .setter(setter(Builder::volumeBurstIOPS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeBurstIOPS").build()).build();

    private static final SdkField<Integer> VOLUME_BASELINE_THROUGHPUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("volumeBaselineThroughput").getter(getter(VolumeConfiguration::volumeBaselineThroughput))
            .setter(setter(Builder::volumeBaselineThroughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeBaselineThroughput").build())
            .build();

    private static final SdkField<Integer> VOLUME_BURST_THROUGHPUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("volumeBurstThroughput").getter(getter(VolumeConfiguration::volumeBurstThroughput))
            .setter(setter(Builder::volumeBurstThroughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeBurstThroughput").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_TYPE_FIELD,
            VOLUME_SIZE_FIELD, VOLUME_BASELINE_IOPS_FIELD, VOLUME_BURST_IOPS_FIELD, VOLUME_BASELINE_THROUGHPUT_FIELD,
            VOLUME_BURST_THROUGHPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String volumeType;

    private final Integer volumeSize;

    private final Integer volumeBaselineIOPS;

    private final Integer volumeBurstIOPS;

    private final Integer volumeBaselineThroughput;

    private final Integer volumeBurstThroughput;

    private VolumeConfiguration(BuilderImpl builder) {
        this.volumeType = builder.volumeType;
        this.volumeSize = builder.volumeSize;
        this.volumeBaselineIOPS = builder.volumeBaselineIOPS;
        this.volumeBurstIOPS = builder.volumeBurstIOPS;
        this.volumeBaselineThroughput = builder.volumeBaselineThroughput;
        this.volumeBurstThroughput = builder.volumeBurstThroughput;
    }

    /**
     * <p>
     * The volume type.
     * </p>
     * <p>
     * This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> or <code>io2</code> for Provisioned IOPS
     * SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or <code>standard</code> for
     * Magnetic volumes.
     * </p>
     * 
     * @return The volume type.</p>
     *         <p>
     *         This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> or <code>io2</code> for
     *         Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or
     *         <code>standard</code> for Magnetic volumes.
     */
    public final String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * The size of the volume, in GiB.
     * </p>
     * 
     * @return The size of the volume, in GiB.
     */
    public final Integer volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * The baseline IOPS of the volume.
     * </p>
     * 
     * @return The baseline IOPS of the volume.
     */
    public final Integer volumeBaselineIOPS() {
        return volumeBaselineIOPS;
    }

    /**
     * <p>
     * The burst IOPS of the volume.
     * </p>
     * 
     * @return The burst IOPS of the volume.
     */
    public final Integer volumeBurstIOPS() {
        return volumeBurstIOPS;
    }

    /**
     * <p>
     * The baseline throughput of the volume.
     * </p>
     * 
     * @return The baseline throughput of the volume.
     */
    public final Integer volumeBaselineThroughput() {
        return volumeBaselineThroughput;
    }

    /**
     * <p>
     * The burst throughput of the volume.
     * </p>
     * 
     * @return The burst throughput of the volume.
     */
    public final Integer volumeBurstThroughput() {
        return volumeBurstThroughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(volumeBaselineIOPS());
        hashCode = 31 * hashCode + Objects.hashCode(volumeBurstIOPS());
        hashCode = 31 * hashCode + Objects.hashCode(volumeBaselineThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(volumeBurstThroughput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeConfiguration)) {
            return false;
        }
        VolumeConfiguration other = (VolumeConfiguration) obj;
        return Objects.equals(volumeType(), other.volumeType()) && Objects.equals(volumeSize(), other.volumeSize())
                && Objects.equals(volumeBaselineIOPS(), other.volumeBaselineIOPS())
                && Objects.equals(volumeBurstIOPS(), other.volumeBurstIOPS())
                && Objects.equals(volumeBaselineThroughput(), other.volumeBaselineThroughput())
                && Objects.equals(volumeBurstThroughput(), other.volumeBurstThroughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VolumeConfiguration").add("VolumeType", volumeType()).add("VolumeSize", volumeSize())
                .add("VolumeBaselineIOPS", volumeBaselineIOPS()).add("VolumeBurstIOPS", volumeBurstIOPS())
                .add("VolumeBaselineThroughput", volumeBaselineThroughput())
                .add("VolumeBurstThroughput", volumeBurstThroughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "volumeType":
            return Optional.ofNullable(clazz.cast(volumeType()));
        case "volumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        case "volumeBaselineIOPS":
            return Optional.ofNullable(clazz.cast(volumeBaselineIOPS()));
        case "volumeBurstIOPS":
            return Optional.ofNullable(clazz.cast(volumeBurstIOPS()));
        case "volumeBaselineThroughput":
            return Optional.ofNullable(clazz.cast(volumeBaselineThroughput()));
        case "volumeBurstThroughput":
            return Optional.ofNullable(clazz.cast(volumeBurstThroughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeConfiguration, T> g) {
        return obj -> g.apply((VolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VolumeConfiguration> {
        /**
         * <p>
         * The volume type.
         * </p>
         * <p>
         * This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> or <code>io2</code> for Provisioned
         * IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or
         * <code>standard</code> for Magnetic volumes.
         * </p>
         * 
         * @param volumeType
         *        The volume type.</p>
         *        <p>
         *        This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> or <code>io2</code> for
         *        Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or
         *        <code>standard</code> for Magnetic volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The size of the volume, in GiB.
         * </p>
         * 
         * @param volumeSize
         *        The size of the volume, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);

        /**
         * <p>
         * The baseline IOPS of the volume.
         * </p>
         * 
         * @param volumeBaselineIOPS
         *        The baseline IOPS of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeBaselineIOPS(Integer volumeBaselineIOPS);

        /**
         * <p>
         * The burst IOPS of the volume.
         * </p>
         * 
         * @param volumeBurstIOPS
         *        The burst IOPS of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeBurstIOPS(Integer volumeBurstIOPS);

        /**
         * <p>
         * The baseline throughput of the volume.
         * </p>
         * 
         * @param volumeBaselineThroughput
         *        The baseline throughput of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeBaselineThroughput(Integer volumeBaselineThroughput);

        /**
         * <p>
         * The burst throughput of the volume.
         * </p>
         * 
         * @param volumeBurstThroughput
         *        The burst throughput of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeBurstThroughput(Integer volumeBurstThroughput);
    }

    static final class BuilderImpl implements Builder {
        private String volumeType;

        private Integer volumeSize;

        private Integer volumeBaselineIOPS;

        private Integer volumeBurstIOPS;

        private Integer volumeBaselineThroughput;

        private Integer volumeBurstThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeConfiguration model) {
            volumeType(model.volumeType);
            volumeSize(model.volumeSize);
            volumeBaselineIOPS(model.volumeBaselineIOPS);
            volumeBurstIOPS(model.volumeBurstIOPS);
            volumeBaselineThroughput(model.volumeBaselineThroughput);
            volumeBurstThroughput(model.volumeBurstThroughput);
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final Integer getVolumeBaselineIOPS() {
            return volumeBaselineIOPS;
        }

        public final void setVolumeBaselineIOPS(Integer volumeBaselineIOPS) {
            this.volumeBaselineIOPS = volumeBaselineIOPS;
        }

        @Override
        public final Builder volumeBaselineIOPS(Integer volumeBaselineIOPS) {
            this.volumeBaselineIOPS = volumeBaselineIOPS;
            return this;
        }

        public final Integer getVolumeBurstIOPS() {
            return volumeBurstIOPS;
        }

        public final void setVolumeBurstIOPS(Integer volumeBurstIOPS) {
            this.volumeBurstIOPS = volumeBurstIOPS;
        }

        @Override
        public final Builder volumeBurstIOPS(Integer volumeBurstIOPS) {
            this.volumeBurstIOPS = volumeBurstIOPS;
            return this;
        }

        public final Integer getVolumeBaselineThroughput() {
            return volumeBaselineThroughput;
        }

        public final void setVolumeBaselineThroughput(Integer volumeBaselineThroughput) {
            this.volumeBaselineThroughput = volumeBaselineThroughput;
        }

        @Override
        public final Builder volumeBaselineThroughput(Integer volumeBaselineThroughput) {
            this.volumeBaselineThroughput = volumeBaselineThroughput;
            return this;
        }

        public final Integer getVolumeBurstThroughput() {
            return volumeBurstThroughput;
        }

        public final void setVolumeBurstThroughput(Integer volumeBurstThroughput) {
            this.volumeBurstThroughput = volumeBurstThroughput;
        }

        @Override
        public final Builder volumeBurstThroughput(Integer volumeBurstThroughput) {
            this.volumeBurstThroughput = volumeBurstThroughput;
            return this;
        }

        @Override
        public VolumeConfiguration build() {
            return new VolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
