/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the effective preferred resources that Compute Optimizer considers as rightsizing recommendation
 * candidates.
 * </p>
 * <note>
 * <p>
 * Compute Optimizer only supports Amazon EC2 instance types.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EffectivePreferredResource implements SdkPojo, Serializable,
        ToCopyableBuilder<EffectivePreferredResource.Builder, EffectivePreferredResource> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EffectivePreferredResource::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> INCLUDE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("includeList")
            .getter(getter(EffectivePreferredResource::includeList))
            .setter(setter(Builder::includeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EFFECTIVE_INCLUDE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("effectiveIncludeList")
            .getter(getter(EffectivePreferredResource::effectiveIncludeList))
            .setter(setter(Builder::effectiveIncludeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveIncludeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("excludeList")
            .getter(getter(EffectivePreferredResource::excludeList))
            .setter(setter(Builder::excludeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            INCLUDE_LIST_FIELD, EFFECTIVE_INCLUDE_LIST_FIELD, EXCLUDE_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> includeList;

    private final List<String> effectiveIncludeList;

    private final List<String> excludeList;

    private EffectivePreferredResource(BuilderImpl builder) {
        this.name = builder.name;
        this.includeList = builder.includeList;
        this.effectiveIncludeList = builder.effectiveIncludeList;
        this.excludeList = builder.excludeList;
    }

    /**
     * <p>
     * The name of the preferred resource list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link PreferredResourceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the preferred resource list.
     * @see PreferredResourceName
     */
    public final PreferredResourceName name() {
        return PreferredResourceName.fromValue(name);
    }

    /**
     * <p>
     * The name of the preferred resource list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link PreferredResourceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the preferred resource list.
     * @see PreferredResourceName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludeList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncludeList() {
        return includeList != null && !(includeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of preferred resource values that you want considered as rightsizing recommendation candidates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludeList} method.
     * </p>
     * 
     * @return The list of preferred resource values that you want considered as rightsizing recommendation candidates.
     */
    public final List<String> includeList() {
        return includeList;
    }

    /**
     * For responses, this returns true if the service returned a value for the EffectiveIncludeList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEffectiveIncludeList() {
        return effectiveIncludeList != null && !(effectiveIncludeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The expanded version of your preferred resource's include list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEffectiveIncludeList} method.
     * </p>
     * 
     * @return The expanded version of your preferred resource's include list.
     */
    public final List<String> effectiveIncludeList() {
        return effectiveIncludeList;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludeList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludeList() {
        return excludeList != null && !(excludeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of preferred resources values that you want excluded from rightsizing recommendation candidates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeList} method.
     * </p>
     * 
     * @return The list of preferred resources values that you want excluded from rightsizing recommendation candidates.
     */
    public final List<String> excludeList() {
        return excludeList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludeList() ? includeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEffectiveIncludeList() ? effectiveIncludeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeList() ? excludeList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectivePreferredResource)) {
            return false;
        }
        EffectivePreferredResource other = (EffectivePreferredResource) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && hasIncludeList() == other.hasIncludeList()
                && Objects.equals(includeList(), other.includeList())
                && hasEffectiveIncludeList() == other.hasEffectiveIncludeList()
                && Objects.equals(effectiveIncludeList(), other.effectiveIncludeList())
                && hasExcludeList() == other.hasExcludeList() && Objects.equals(excludeList(), other.excludeList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EffectivePreferredResource").add("Name", nameAsString())
                .add("IncludeList", hasIncludeList() ? includeList() : null)
                .add("EffectiveIncludeList", hasEffectiveIncludeList() ? effectiveIncludeList() : null)
                .add("ExcludeList", hasExcludeList() ? excludeList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "includeList":
            return Optional.ofNullable(clazz.cast(includeList()));
        case "effectiveIncludeList":
            return Optional.ofNullable(clazz.cast(effectiveIncludeList()));
        case "excludeList":
            return Optional.ofNullable(clazz.cast(excludeList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EffectivePreferredResource, T> g) {
        return obj -> g.apply((EffectivePreferredResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EffectivePreferredResource> {
        /**
         * <p>
         * The name of the preferred resource list.
         * </p>
         * 
         * @param name
         *        The name of the preferred resource list.
         * @see PreferredResourceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreferredResourceName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the preferred resource list.
         * </p>
         * 
         * @param name
         *        The name of the preferred resource list.
         * @see PreferredResourceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreferredResourceName
         */
        Builder name(PreferredResourceName name);

        /**
         * <p>
         * The list of preferred resource values that you want considered as rightsizing recommendation candidates.
         * </p>
         * 
         * @param includeList
         *        The list of preferred resource values that you want considered as rightsizing recommendation
         *        candidates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeList(Collection<String> includeList);

        /**
         * <p>
         * The list of preferred resource values that you want considered as rightsizing recommendation candidates.
         * </p>
         * 
         * @param includeList
         *        The list of preferred resource values that you want considered as rightsizing recommendation
         *        candidates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeList(String... includeList);

        /**
         * <p>
         * The expanded version of your preferred resource's include list.
         * </p>
         * 
         * @param effectiveIncludeList
         *        The expanded version of your preferred resource's include list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveIncludeList(Collection<String> effectiveIncludeList);

        /**
         * <p>
         * The expanded version of your preferred resource's include list.
         * </p>
         * 
         * @param effectiveIncludeList
         *        The expanded version of your preferred resource's include list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveIncludeList(String... effectiveIncludeList);

        /**
         * <p>
         * The list of preferred resources values that you want excluded from rightsizing recommendation candidates.
         * </p>
         * 
         * @param excludeList
         *        The list of preferred resources values that you want excluded from rightsizing recommendation
         *        candidates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeList(Collection<String> excludeList);

        /**
         * <p>
         * The list of preferred resources values that you want excluded from rightsizing recommendation candidates.
         * </p>
         * 
         * @param excludeList
         *        The list of preferred resources values that you want excluded from rightsizing recommendation
         *        candidates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeList(String... excludeList);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> includeList = DefaultSdkAutoConstructList.getInstance();

        private List<String> effectiveIncludeList = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludeList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EffectivePreferredResource model) {
            name(model.name);
            includeList(model.includeList);
            effectiveIncludeList(model.effectiveIncludeList);
            excludeList(model.excludeList);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(PreferredResourceName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Collection<String> getIncludeList() {
            if (includeList instanceof SdkAutoConstructList) {
                return null;
            }
            return includeList;
        }

        public final void setIncludeList(Collection<String> includeList) {
            this.includeList = PreferredResourceValuesCopier.copy(includeList);
        }

        @Override
        public final Builder includeList(Collection<String> includeList) {
            this.includeList = PreferredResourceValuesCopier.copy(includeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeList(String... includeList) {
            includeList(Arrays.asList(includeList));
            return this;
        }

        public final Collection<String> getEffectiveIncludeList() {
            if (effectiveIncludeList instanceof SdkAutoConstructList) {
                return null;
            }
            return effectiveIncludeList;
        }

        public final void setEffectiveIncludeList(Collection<String> effectiveIncludeList) {
            this.effectiveIncludeList = PreferredResourceValuesCopier.copy(effectiveIncludeList);
        }

        @Override
        public final Builder effectiveIncludeList(Collection<String> effectiveIncludeList) {
            this.effectiveIncludeList = PreferredResourceValuesCopier.copy(effectiveIncludeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectiveIncludeList(String... effectiveIncludeList) {
            effectiveIncludeList(Arrays.asList(effectiveIncludeList));
            return this;
        }

        public final Collection<String> getExcludeList() {
            if (excludeList instanceof SdkAutoConstructList) {
                return null;
            }
            return excludeList;
        }

        public final void setExcludeList(Collection<String> excludeList) {
            this.excludeList = PreferredResourceValuesCopier.copy(excludeList);
        }

        @Override
        public final Builder excludeList(Collection<String> excludeList) {
            this.excludeList = PreferredResourceValuesCopier.copy(excludeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeList(String... excludeList) {
            excludeList(Arrays.asList(excludeList));
            return this;
        }

        @Override
        public EffectivePreferredResource build() {
            return new EffectivePreferredResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
