/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportLicenseRecommendationsRequest extends ComputeOptimizerRequest implements
        ToCopyableBuilder<ExportLicenseRecommendationsRequest.Builder, ExportLicenseRecommendationsRequest> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(ExportLicenseRecommendationsRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LicenseRecommendationFilter>> FILTERS_FIELD = SdkField
            .<List<LicenseRecommendationFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ExportLicenseRecommendationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LicenseRecommendationFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(LicenseRecommendationFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FIELDS_TO_EXPORT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("fieldsToExport")
            .getter(getter(ExportLicenseRecommendationsRequest::fieldsToExportAsStrings))
            .setter(setter(Builder::fieldsToExportWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldsToExport").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<S3DestinationConfig> S3_DESTINATION_CONFIG_FIELD = SdkField
            .<S3DestinationConfig> builder(MarshallingType.SDK_POJO).memberName("s3DestinationConfig")
            .getter(getter(ExportLicenseRecommendationsRequest::s3DestinationConfig))
            .setter(setter(Builder::s3DestinationConfig)).constructor(S3DestinationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DestinationConfig").build())
            .build();

    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileFormat").getter(getter(ExportLicenseRecommendationsRequest::fileFormatAsString))
            .setter(setter(Builder::fileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()).build();

    private static final SdkField<Boolean> INCLUDE_MEMBER_ACCOUNTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeMemberAccounts").getter(getter(ExportLicenseRecommendationsRequest::includeMemberAccounts))
            .setter(setter(Builder::includeMemberAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeMemberAccounts").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, FILTERS_FIELD, FIELDS_TO_EXPORT_FIELD,
                    S3_DESTINATION_CONFIG_FIELD, FILE_FORMAT_FIELD, INCLUDE_MEMBER_ACCOUNTS_FIELD));

    private final List<String> accountIds;

    private final List<LicenseRecommendationFilter> filters;

    private final List<String> fieldsToExport;

    private final S3DestinationConfig s3DestinationConfig;

    private final String fileFormat;

    private final Boolean includeMemberAccounts;

    private ExportLicenseRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.filters = builder.filters;
        this.fieldsToExport = builder.fieldsToExport;
        this.s3DestinationConfig = builder.s3DestinationConfig;
        this.fileFormat = builder.fileFormat;
        this.includeMemberAccounts = builder.includeMemberAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Amazon Web Services accounts for which to export license recommendations.
     * </p>
     * <p>
     * If your account is the management account of an organization, use this parameter to specify the member account
     * for which you want to export recommendations.
     * </p>
     * <p>
     * This parameter can't be specified together with the include member accounts parameter. The parameters are
     * mutually exclusive.
     * </p>
     * <p>
     * If this parameter is omitted, recommendations for member accounts aren't included in the export.
     * </p>
     * <p>
     * You can specify multiple account IDs per request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return The IDs of the Amazon Web Services accounts for which to export license recommendations.</p>
     *         <p>
     *         If your account is the management account of an organization, use this parameter to specify the member
     *         account for which you want to export recommendations.
     *         </p>
     *         <p>
     *         This parameter can't be specified together with the include member accounts parameter. The parameters are
     *         mutually exclusive.
     *         </p>
     *         <p>
     *         If this parameter is omitted, recommendations for member accounts aren't included in the export.
     *         </p>
     *         <p>
     *         You can specify multiple account IDs per request.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects to specify a filter that exports a more specific set of license recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return An array of objects to specify a filter that exports a more specific set of license recommendations.
     */
    public final List<LicenseRecommendationFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The recommendations data to include in the export file. For more information about the fields that can be
     * exported, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
     * >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldsToExport} method.
     * </p>
     * 
     * @return The recommendations data to include in the export file. For more information about the fields that can be
     *         exported, see <a href=
     *         "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
     *         >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
     */
    public final List<ExportableLicenseField> fieldsToExport() {
        return ExportableLicenseFieldsCopier.copyStringToEnum(fieldsToExport);
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldsToExport property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldsToExport() {
        return fieldsToExport != null && !(fieldsToExport instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recommendations data to include in the export file. For more information about the fields that can be
     * exported, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
     * >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldsToExport} method.
     * </p>
     * 
     * @return The recommendations data to include in the export file. For more information about the fields that can be
     *         exported, see <a href=
     *         "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
     *         >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
     */
    public final List<String> fieldsToExportAsStrings() {
        return fieldsToExport;
    }

    /**
     * Returns the value of the S3DestinationConfig property for this object.
     * 
     * @return The value of the S3DestinationConfig property for this object.
     */
    public final S3DestinationConfig s3DestinationConfig() {
        return s3DestinationConfig;
    }

    /**
     * <p>
     * The format of the export file.
     * </p>
     * <p>
     * A CSV file is the only export format currently supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The format of the export file.</p>
     *         <p>
     *         A CSV file is the only export format currently supported.
     * @see FileFormat
     */
    public final FileFormat fileFormat() {
        return FileFormat.fromValue(fileFormat);
    }

    /**
     * <p>
     * The format of the export file.
     * </p>
     * <p>
     * A CSV file is the only export format currently supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileFormat} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileFormatAsString}.
     * </p>
     * 
     * @return The format of the export file.</p>
     *         <p>
     *         A CSV file is the only export format currently supported.
     * @see FileFormat
     */
    public final String fileFormatAsString() {
        return fileFormat;
    }

    /**
     * <p>
     * Indicates whether to include recommendations for resources in all member accounts of the organization if your
     * account is the management account of an organization.
     * </p>
     * <p>
     * The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer must be
     * enabled in the organization account. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute
     * Optimizer and Amazon Web Services Organizations trusted access</a> in the <i>Compute Optimizer User Guide</i>.
     * </p>
     * <p>
     * If this parameter is omitted, recommendations for member accounts of the organization aren't included in the
     * export file .
     * </p>
     * <p>
     * This parameter cannot be specified together with the account IDs parameter. The parameters are mutually
     * exclusive.
     * </p>
     * 
     * @return Indicates whether to include recommendations for resources in all member accounts of the organization if
     *         your account is the management account of an organization.</p>
     *         <p>
     *         The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer
     *         must be enabled in the organization account. For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access"
     *         >Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the <i>Compute Optimizer
     *         User Guide</i>.
     *         </p>
     *         <p>
     *         If this parameter is omitted, recommendations for member accounts of the organization aren't included in
     *         the export file .
     *         </p>
     *         <p>
     *         This parameter cannot be specified together with the account IDs parameter. The parameters are mutually
     *         exclusive.
     */
    public final Boolean includeMemberAccounts() {
        return includeMemberAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldsToExport() ? fieldsToExportAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(s3DestinationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeMemberAccounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportLicenseRecommendationsRequest)) {
            return false;
        }
        ExportLicenseRecommendationsRequest other = (ExportLicenseRecommendationsRequest) obj;
        return hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && hasFieldsToExport() == other.hasFieldsToExport()
                && Objects.equals(fieldsToExportAsStrings(), other.fieldsToExportAsStrings())
                && Objects.equals(s3DestinationConfig(), other.s3DestinationConfig())
                && Objects.equals(fileFormatAsString(), other.fileFormatAsString())
                && Objects.equals(includeMemberAccounts(), other.includeMemberAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportLicenseRecommendationsRequest").add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("Filters", hasFilters() ? filters() : null)
                .add("FieldsToExport", hasFieldsToExport() ? fieldsToExportAsStrings() : null)
                .add("S3DestinationConfig", s3DestinationConfig()).add("FileFormat", fileFormatAsString())
                .add("IncludeMemberAccounts", includeMemberAccounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "fieldsToExport":
            return Optional.ofNullable(clazz.cast(fieldsToExportAsStrings()));
        case "s3DestinationConfig":
            return Optional.ofNullable(clazz.cast(s3DestinationConfig()));
        case "fileFormat":
            return Optional.ofNullable(clazz.cast(fileFormatAsString()));
        case "includeMemberAccounts":
            return Optional.ofNullable(clazz.cast(includeMemberAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportLicenseRecommendationsRequest, T> g) {
        return obj -> g.apply((ExportLicenseRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ExportLicenseRecommendationsRequest> {
        /**
         * <p>
         * The IDs of the Amazon Web Services accounts for which to export license recommendations.
         * </p>
         * <p>
         * If your account is the management account of an organization, use this parameter to specify the member
         * account for which you want to export recommendations.
         * </p>
         * <p>
         * This parameter can't be specified together with the include member accounts parameter. The parameters are
         * mutually exclusive.
         * </p>
         * <p>
         * If this parameter is omitted, recommendations for member accounts aren't included in the export.
         * </p>
         * <p>
         * You can specify multiple account IDs per request.
         * </p>
         * 
         * @param accountIds
         *        The IDs of the Amazon Web Services accounts for which to export license recommendations.</p>
         *        <p>
         *        If your account is the management account of an organization, use this parameter to specify the member
         *        account for which you want to export recommendations.
         *        </p>
         *        <p>
         *        This parameter can't be specified together with the include member accounts parameter. The parameters
         *        are mutually exclusive.
         *        </p>
         *        <p>
         *        If this parameter is omitted, recommendations for member accounts aren't included in the export.
         *        </p>
         *        <p>
         *        You can specify multiple account IDs per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The IDs of the Amazon Web Services accounts for which to export license recommendations.
         * </p>
         * <p>
         * If your account is the management account of an organization, use this parameter to specify the member
         * account for which you want to export recommendations.
         * </p>
         * <p>
         * This parameter can't be specified together with the include member accounts parameter. The parameters are
         * mutually exclusive.
         * </p>
         * <p>
         * If this parameter is omitted, recommendations for member accounts aren't included in the export.
         * </p>
         * <p>
         * You can specify multiple account IDs per request.
         * </p>
         * 
         * @param accountIds
         *        The IDs of the Amazon Web Services accounts for which to export license recommendations.</p>
         *        <p>
         *        If your account is the management account of an organization, use this parameter to specify the member
         *        account for which you want to export recommendations.
         *        </p>
         *        <p>
         *        This parameter can't be specified together with the include member accounts parameter. The parameters
         *        are mutually exclusive.
         *        </p>
         *        <p>
         *        If this parameter is omitted, recommendations for member accounts aren't included in the export.
         *        </p>
         *        <p>
         *        You can specify multiple account IDs per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * An array of objects to specify a filter that exports a more specific set of license recommendations.
         * </p>
         * 
         * @param filters
         *        An array of objects to specify a filter that exports a more specific set of license recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<LicenseRecommendationFilter> filters);

        /**
         * <p>
         * An array of objects to specify a filter that exports a more specific set of license recommendations.
         * </p>
         * 
         * @param filters
         *        An array of objects to specify a filter that exports a more specific set of license recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(LicenseRecommendationFilter... filters);

        /**
         * <p>
         * An array of objects to specify a filter that exports a more specific set of license recommendations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilter.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilter.Builder#build()} is
         * called immediately and its result is passed to {@link #filters(List<LicenseRecommendationFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.LicenseRecommendationFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<LicenseRecommendationFilter>)
         */
        Builder filters(Consumer<LicenseRecommendationFilter.Builder>... filters);

        /**
         * <p>
         * The recommendations data to include in the export file. For more information about the fields that can be
         * exported, see <a href=
         * "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
         * >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param fieldsToExport
         *        The recommendations data to include in the export file. For more information about the fields that can
         *        be exported, see <a href=
         *        "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
         *        >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldsToExportWithStrings(Collection<String> fieldsToExport);

        /**
         * <p>
         * The recommendations data to include in the export file. For more information about the fields that can be
         * exported, see <a href=
         * "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
         * >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param fieldsToExport
         *        The recommendations data to include in the export file. For more information about the fields that can
         *        be exported, see <a href=
         *        "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
         *        >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldsToExportWithStrings(String... fieldsToExport);

        /**
         * <p>
         * The recommendations data to include in the export file. For more information about the fields that can be
         * exported, see <a href=
         * "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
         * >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param fieldsToExport
         *        The recommendations data to include in the export file. For more information about the fields that can
         *        be exported, see <a href=
         *        "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
         *        >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldsToExport(Collection<ExportableLicenseField> fieldsToExport);

        /**
         * <p>
         * The recommendations data to include in the export file. For more information about the fields that can be
         * exported, see <a href=
         * "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
         * >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
         * </p>
         * 
         * @param fieldsToExport
         *        The recommendations data to include in the export file. For more information about the fields that can
         *        be exported, see <a href=
         *        "https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files"
         *        >Exported files</a> in the <i>Compute Optimizer User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldsToExport(ExportableLicenseField... fieldsToExport);

        /**
         * Sets the value of the S3DestinationConfig property for this object.
         *
         * @param s3DestinationConfig
         *        The new value for the S3DestinationConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DestinationConfig(S3DestinationConfig s3DestinationConfig);

        /**
         * Sets the value of the S3DestinationConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3DestinationConfig.Builder} avoiding the
         * need to create one manually via {@link S3DestinationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DestinationConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #s3DestinationConfig(S3DestinationConfig)}.
         * 
         * @param s3DestinationConfig
         *        a consumer that will call methods on {@link S3DestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DestinationConfig(S3DestinationConfig)
         */
        default Builder s3DestinationConfig(Consumer<S3DestinationConfig.Builder> s3DestinationConfig) {
            return s3DestinationConfig(S3DestinationConfig.builder().applyMutation(s3DestinationConfig).build());
        }

        /**
         * <p>
         * The format of the export file.
         * </p>
         * <p>
         * A CSV file is the only export format currently supported.
         * </p>
         * 
         * @param fileFormat
         *        The format of the export file.</p>
         *        <p>
         *        A CSV file is the only export format currently supported.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         */
        Builder fileFormat(String fileFormat);

        /**
         * <p>
         * The format of the export file.
         * </p>
         * <p>
         * A CSV file is the only export format currently supported.
         * </p>
         * 
         * @param fileFormat
         *        The format of the export file.</p>
         *        <p>
         *        A CSV file is the only export format currently supported.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         */
        Builder fileFormat(FileFormat fileFormat);

        /**
         * <p>
         * Indicates whether to include recommendations for resources in all member accounts of the organization if your
         * account is the management account of an organization.
         * </p>
         * <p>
         * The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer must
         * be enabled in the organization account. For more information, see <a
         * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access"
         * >Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the <i>Compute Optimizer User
         * Guide</i>.
         * </p>
         * <p>
         * If this parameter is omitted, recommendations for member accounts of the organization aren't included in the
         * export file .
         * </p>
         * <p>
         * This parameter cannot be specified together with the account IDs parameter. The parameters are mutually
         * exclusive.
         * </p>
         * 
         * @param includeMemberAccounts
         *        Indicates whether to include recommendations for resources in all member accounts of the organization
         *        if your account is the management account of an organization.</p>
         *        <p>
         *        The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute
         *        Optimizer must be enabled in the organization account. For more information, see <a href=
         *        "https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access"
         *        >Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the <i>Compute
         *        Optimizer User Guide</i>.
         *        </p>
         *        <p>
         *        If this parameter is omitted, recommendations for member accounts of the organization aren't included
         *        in the export file .
         *        </p>
         *        <p>
         *        This parameter cannot be specified together with the account IDs parameter. The parameters are
         *        mutually exclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeMemberAccounts(Boolean includeMemberAccounts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComputeOptimizerRequest.BuilderImpl implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<LicenseRecommendationFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> fieldsToExport = DefaultSdkAutoConstructList.getInstance();

        private S3DestinationConfig s3DestinationConfig;

        private String fileFormat;

        private Boolean includeMemberAccounts;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportLicenseRecommendationsRequest model) {
            super(model);
            accountIds(model.accountIds);
            filters(model.filters);
            fieldsToExportWithStrings(model.fieldsToExport);
            s3DestinationConfig(model.s3DestinationConfig);
            fileFormat(model.fileFormat);
            includeMemberAccounts(model.includeMemberAccounts);
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final List<LicenseRecommendationFilter.Builder> getFilters() {
            List<LicenseRecommendationFilter.Builder> result = LicenseRecommendationFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<LicenseRecommendationFilter.BuilderImpl> filters) {
            this.filters = LicenseRecommendationFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<LicenseRecommendationFilter> filters) {
            this.filters = LicenseRecommendationFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(LicenseRecommendationFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<LicenseRecommendationFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> LicenseRecommendationFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getFieldsToExport() {
            if (fieldsToExport instanceof SdkAutoConstructList) {
                return null;
            }
            return fieldsToExport;
        }

        public final void setFieldsToExport(Collection<String> fieldsToExport) {
            this.fieldsToExport = ExportableLicenseFieldsCopier.copy(fieldsToExport);
        }

        @Override
        public final Builder fieldsToExportWithStrings(Collection<String> fieldsToExport) {
            this.fieldsToExport = ExportableLicenseFieldsCopier.copy(fieldsToExport);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldsToExportWithStrings(String... fieldsToExport) {
            fieldsToExportWithStrings(Arrays.asList(fieldsToExport));
            return this;
        }

        @Override
        public final Builder fieldsToExport(Collection<ExportableLicenseField> fieldsToExport) {
            this.fieldsToExport = ExportableLicenseFieldsCopier.copyEnumToString(fieldsToExport);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldsToExport(ExportableLicenseField... fieldsToExport) {
            fieldsToExport(Arrays.asList(fieldsToExport));
            return this;
        }

        public final S3DestinationConfig.Builder getS3DestinationConfig() {
            return s3DestinationConfig != null ? s3DestinationConfig.toBuilder() : null;
        }

        public final void setS3DestinationConfig(S3DestinationConfig.BuilderImpl s3DestinationConfig) {
            this.s3DestinationConfig = s3DestinationConfig != null ? s3DestinationConfig.build() : null;
        }

        @Override
        public final Builder s3DestinationConfig(S3DestinationConfig s3DestinationConfig) {
            this.s3DestinationConfig = s3DestinationConfig;
            return this;
        }

        public final String getFileFormat() {
            return fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final Boolean getIncludeMemberAccounts() {
            return includeMemberAccounts;
        }

        public final void setIncludeMemberAccounts(Boolean includeMemberAccounts) {
            this.includeMemberAccounts = includeMemberAccounts;
        }

        @Override
        public final Builder includeMemberAccounts(Boolean includeMemberAccounts) {
            this.includeMemberAccounts = includeMemberAccounts;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportLicenseRecommendationsRequest build() {
            return new ExportLicenseRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
