/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the GPU accelerators for the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Gpu implements SdkPojo, Serializable, ToCopyableBuilder<Gpu.Builder, Gpu> {
    private static final SdkField<Integer> GPU_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("gpuCount").getter(getter(Gpu::gpuCount)).setter(setter(Builder::gpuCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gpuCount").build()).build();

    private static final SdkField<Integer> GPU_MEMORY_SIZE_IN_MIB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("gpuMemorySizeInMiB").getter(getter(Gpu::gpuMemorySizeInMiB)).setter(setter(Builder::gpuMemorySizeInMiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gpuMemorySizeInMiB").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GPU_COUNT_FIELD,
            GPU_MEMORY_SIZE_IN_MIB_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer gpuCount;

    private final Integer gpuMemorySizeInMiB;

    private Gpu(BuilderImpl builder) {
        this.gpuCount = builder.gpuCount;
        this.gpuMemorySizeInMiB = builder.gpuMemorySizeInMiB;
    }

    /**
     * <p>
     * The number of GPUs for the instance type.
     * </p>
     * 
     * @return The number of GPUs for the instance type.
     */
    public final Integer gpuCount() {
        return gpuCount;
    }

    /**
     * <p>
     * The total size of the memory for the GPU accelerators for the instance type, in MiB.
     * </p>
     * 
     * @return The total size of the memory for the GPU accelerators for the instance type, in MiB.
     */
    public final Integer gpuMemorySizeInMiB() {
        return gpuMemorySizeInMiB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(gpuMemorySizeInMiB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Gpu)) {
            return false;
        }
        Gpu other = (Gpu) obj;
        return Objects.equals(gpuCount(), other.gpuCount()) && Objects.equals(gpuMemorySizeInMiB(), other.gpuMemorySizeInMiB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Gpu").add("GpuCount", gpuCount()).add("GpuMemorySizeInMiB", gpuMemorySizeInMiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gpuCount":
            return Optional.ofNullable(clazz.cast(gpuCount()));
        case "gpuMemorySizeInMiB":
            return Optional.ofNullable(clazz.cast(gpuMemorySizeInMiB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Gpu, T> g) {
        return obj -> g.apply((Gpu) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Gpu> {
        /**
         * <p>
         * The number of GPUs for the instance type.
         * </p>
         * 
         * @param gpuCount
         *        The number of GPUs for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gpuCount(Integer gpuCount);

        /**
         * <p>
         * The total size of the memory for the GPU accelerators for the instance type, in MiB.
         * </p>
         * 
         * @param gpuMemorySizeInMiB
         *        The total size of the memory for the GPU accelerators for the instance type, in MiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gpuMemorySizeInMiB(Integer gpuMemorySizeInMiB);
    }

    static final class BuilderImpl implements Builder {
        private Integer gpuCount;

        private Integer gpuMemorySizeInMiB;

        private BuilderImpl() {
        }

        private BuilderImpl(Gpu model) {
            gpuCount(model.gpuCount);
            gpuMemorySizeInMiB(model.gpuMemorySizeInMiB);
        }

        public final Integer getGpuCount() {
            return gpuCount;
        }

        public final void setGpuCount(Integer gpuCount) {
            this.gpuCount = gpuCount;
        }

        @Override
        public final Builder gpuCount(Integer gpuCount) {
            this.gpuCount = gpuCount;
            return this;
        }

        public final Integer getGpuMemorySizeInMiB() {
            return gpuMemorySizeInMiB;
        }

        public final void setGpuMemorySizeInMiB(Integer gpuMemorySizeInMiB) {
            this.gpuMemorySizeInMiB = gpuMemorySizeInMiB;
        }

        @Override
        public final Builder gpuMemorySizeInMiB(Integer gpuMemorySizeInMiB) {
            this.gpuMemorySizeInMiB = gpuMemorySizeInMiB;
            return this;
        }

        @Override
        public Gpu build() {
            return new Gpu(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
