/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationSummary.Builder, RecommendationSummary> {
    private static final SdkField<List<Summary>> SUMMARIES_FIELD = SdkField
            .<List<Summary>> builder(MarshallingType.LIST)
            .memberName("summaries")
            .getter(getter(RecommendationSummary::summaries))
            .setter(setter(Builder::summaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Summary> builder(MarshallingType.SDK_POJO)
                                            .constructor(Summary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RECOMMENDATION_RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("recommendationResourceType")
            .getter(getter(RecommendationSummary::recommendationResourceTypeAsString))
            .setter(setter(Builder::recommendationResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationResourceType").build())
            .build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(RecommendationSummary::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<SavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField
            .<SavingsOpportunity> builder(MarshallingType.SDK_POJO).memberName("savingsOpportunity")
            .getter(getter(RecommendationSummary::savingsOpportunity)).setter(setter(Builder::savingsOpportunity))
            .constructor(SavingsOpportunity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build())
            .build();

    private static final SdkField<CurrentPerformanceRiskRatings> CURRENT_PERFORMANCE_RISK_RATINGS_FIELD = SdkField
            .<CurrentPerformanceRiskRatings> builder(MarshallingType.SDK_POJO)
            .memberName("currentPerformanceRiskRatings")
            .getter(getter(RecommendationSummary::currentPerformanceRiskRatings))
            .setter(setter(Builder::currentPerformanceRiskRatings))
            .constructor(CurrentPerformanceRiskRatings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPerformanceRiskRatings")
                    .build()).build();

    private static final SdkField<List<InferredWorkloadSaving>> INFERRED_WORKLOAD_SAVINGS_FIELD = SdkField
            .<List<InferredWorkloadSaving>> builder(MarshallingType.LIST)
            .memberName("inferredWorkloadSavings")
            .getter(getter(RecommendationSummary::inferredWorkloadSavings))
            .setter(setter(Builder::inferredWorkloadSavings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferredWorkloadSavings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InferredWorkloadSaving> builder(MarshallingType.SDK_POJO)
                                            .constructor(InferredWorkloadSaving::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARIES_FIELD,
            RECOMMENDATION_RESOURCE_TYPE_FIELD, ACCOUNT_ID_FIELD, SAVINGS_OPPORTUNITY_FIELD,
            CURRENT_PERFORMANCE_RISK_RATINGS_FIELD, INFERRED_WORKLOAD_SAVINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Summary> summaries;

    private final String recommendationResourceType;

    private final String accountId;

    private final SavingsOpportunity savingsOpportunity;

    private final CurrentPerformanceRiskRatings currentPerformanceRiskRatings;

    private final List<InferredWorkloadSaving> inferredWorkloadSavings;

    private RecommendationSummary(BuilderImpl builder) {
        this.summaries = builder.summaries;
        this.recommendationResourceType = builder.recommendationResourceType;
        this.accountId = builder.accountId;
        this.savingsOpportunity = builder.savingsOpportunity;
        this.currentPerformanceRiskRatings = builder.currentPerformanceRiskRatings;
        this.inferredWorkloadSavings = builder.inferredWorkloadSavings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Summaries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSummaries() {
        return summaries != null && !(summaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe a recommendation summary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSummaries} method.
     * </p>
     * 
     * @return An array of objects that describe a recommendation summary.
     */
    public final List<Summary> summaries() {
        return summaries;
    }

    /**
     * <p>
     * The resource type that the recommendation summary applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationResourceType} will return {@link RecommendationSourceType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #recommendationResourceTypeAsString}.
     * </p>
     * 
     * @return The resource type that the recommendation summary applies to.
     * @see RecommendationSourceType
     */
    public final RecommendationSourceType recommendationResourceType() {
        return RecommendationSourceType.fromValue(recommendationResourceType);
    }

    /**
     * <p>
     * The resource type that the recommendation summary applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationResourceType} will return {@link RecommendationSourceType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #recommendationResourceTypeAsString}.
     * </p>
     * 
     * @return The resource type that the recommendation summary applies to.
     * @see RecommendationSourceType
     */
    public final String recommendationResourceTypeAsString() {
        return recommendationResourceType;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the recommendation summary.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the recommendation summary.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * An object that describes the savings opportunity for a given resource type. Savings opportunity includes the
     * estimated monthly savings amount and percentage.
     * </p>
     * 
     * @return An object that describes the savings opportunity for a given resource type. Savings opportunity includes
     *         the estimated monthly savings amount and percentage.
     */
    public final SavingsOpportunity savingsOpportunity() {
        return savingsOpportunity;
    }

    /**
     * <p>
     * An object that describes the performance risk ratings for a given resource type.
     * </p>
     * 
     * @return An object that describes the performance risk ratings for a given resource type.
     */
    public final CurrentPerformanceRiskRatings currentPerformanceRiskRatings() {
        return currentPerformanceRiskRatings;
    }

    /**
     * For responses, this returns true if the service returned a value for the InferredWorkloadSavings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInferredWorkloadSavings() {
        return inferredWorkloadSavings != null && !(inferredWorkloadSavings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describes the estimated monthly saving amounts for the instances running on the
     * specified <code>inferredWorkloadTypes</code>. The array contains the top five savings opportunites for the
     * instances that run inferred workload types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInferredWorkloadSavings} method.
     * </p>
     * 
     * @return An array of objects that describes the estimated monthly saving amounts for the instances running on the
     *         specified <code>inferredWorkloadTypes</code>. The array contains the top five savings opportunites for
     *         the instances that run inferred workload types.
     */
    public final List<InferredWorkloadSaving> inferredWorkloadSavings() {
        return inferredWorkloadSavings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSummaries() ? summaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recommendationResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(savingsOpportunity());
        hashCode = 31 * hashCode + Objects.hashCode(currentPerformanceRiskRatings());
        hashCode = 31 * hashCode + Objects.hashCode(hasInferredWorkloadSavings() ? inferredWorkloadSavings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSummary)) {
            return false;
        }
        RecommendationSummary other = (RecommendationSummary) obj;
        return hasSummaries() == other.hasSummaries() && Objects.equals(summaries(), other.summaries())
                && Objects.equals(recommendationResourceTypeAsString(), other.recommendationResourceTypeAsString())
                && Objects.equals(accountId(), other.accountId())
                && Objects.equals(savingsOpportunity(), other.savingsOpportunity())
                && Objects.equals(currentPerformanceRiskRatings(), other.currentPerformanceRiskRatings())
                && hasInferredWorkloadSavings() == other.hasInferredWorkloadSavings()
                && Objects.equals(inferredWorkloadSavings(), other.inferredWorkloadSavings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationSummary").add("Summaries", hasSummaries() ? summaries() : null)
                .add("RecommendationResourceType", recommendationResourceTypeAsString()).add("AccountId", accountId())
                .add("SavingsOpportunity", savingsOpportunity())
                .add("CurrentPerformanceRiskRatings", currentPerformanceRiskRatings())
                .add("InferredWorkloadSavings", hasInferredWorkloadSavings() ? inferredWorkloadSavings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "summaries":
            return Optional.ofNullable(clazz.cast(summaries()));
        case "recommendationResourceType":
            return Optional.ofNullable(clazz.cast(recommendationResourceTypeAsString()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "savingsOpportunity":
            return Optional.ofNullable(clazz.cast(savingsOpportunity()));
        case "currentPerformanceRiskRatings":
            return Optional.ofNullable(clazz.cast(currentPerformanceRiskRatings()));
        case "inferredWorkloadSavings":
            return Optional.ofNullable(clazz.cast(inferredWorkloadSavings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSummary, T> g) {
        return obj -> g.apply((RecommendationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationSummary> {
        /**
         * <p>
         * An array of objects that describe a recommendation summary.
         * </p>
         * 
         * @param summaries
         *        An array of objects that describe a recommendation summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(Collection<Summary> summaries);

        /**
         * <p>
         * An array of objects that describe a recommendation summary.
         * </p>
         * 
         * @param summaries
         *        An array of objects that describe a recommendation summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaries(Summary... summaries);

        /**
         * <p>
         * An array of objects that describe a recommendation summary.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.Summary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.computeoptimizer.model.Summary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.Summary.Builder#build()} is called immediately
         * and its result is passed to {@link #summaries(List<Summary>)}.
         * 
         * @param summaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.Summary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaries(java.util.Collection<Summary>)
         */
        Builder summaries(Consumer<Summary.Builder>... summaries);

        /**
         * <p>
         * The resource type that the recommendation summary applies to.
         * </p>
         * 
         * @param recommendationResourceType
         *        The resource type that the recommendation summary applies to.
         * @see RecommendationSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationSourceType
         */
        Builder recommendationResourceType(String recommendationResourceType);

        /**
         * <p>
         * The resource type that the recommendation summary applies to.
         * </p>
         * 
         * @param recommendationResourceType
         *        The resource type that the recommendation summary applies to.
         * @see RecommendationSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationSourceType
         */
        Builder recommendationResourceType(RecommendationSourceType recommendationResourceType);

        /**
         * <p>
         * The Amazon Web Services account ID of the recommendation summary.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the recommendation summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * An object that describes the savings opportunity for a given resource type. Savings opportunity includes the
         * estimated monthly savings amount and percentage.
         * </p>
         * 
         * @param savingsOpportunity
         *        An object that describes the savings opportunity for a given resource type. Savings opportunity
         *        includes the estimated monthly savings amount and percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsOpportunity(SavingsOpportunity savingsOpportunity);

        /**
         * <p>
         * An object that describes the savings opportunity for a given resource type. Savings opportunity includes the
         * estimated monthly savings amount and percentage.
         * </p>
         * This is a convenience method that creates an instance of the {@link SavingsOpportunity.Builder} avoiding the
         * need to create one manually via {@link SavingsOpportunity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SavingsOpportunity.Builder#build()} is called immediately and its
         * result is passed to {@link #savingsOpportunity(SavingsOpportunity)}.
         * 
         * @param savingsOpportunity
         *        a consumer that will call methods on {@link SavingsOpportunity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsOpportunity(SavingsOpportunity)
         */
        default Builder savingsOpportunity(Consumer<SavingsOpportunity.Builder> savingsOpportunity) {
            return savingsOpportunity(SavingsOpportunity.builder().applyMutation(savingsOpportunity).build());
        }

        /**
         * <p>
         * An object that describes the performance risk ratings for a given resource type.
         * </p>
         * 
         * @param currentPerformanceRiskRatings
         *        An object that describes the performance risk ratings for a given resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentPerformanceRiskRatings(CurrentPerformanceRiskRatings currentPerformanceRiskRatings);

        /**
         * <p>
         * An object that describes the performance risk ratings for a given resource type.
         * </p>
         * This is a convenience method that creates an instance of the {@link CurrentPerformanceRiskRatings.Builder}
         * avoiding the need to create one manually via {@link CurrentPerformanceRiskRatings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CurrentPerformanceRiskRatings.Builder#build()} is called
         * immediately and its result is passed to {@link #currentPerformanceRiskRatings(CurrentPerformanceRiskRatings)}.
         * 
         * @param currentPerformanceRiskRatings
         *        a consumer that will call methods on {@link CurrentPerformanceRiskRatings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentPerformanceRiskRatings(CurrentPerformanceRiskRatings)
         */
        default Builder currentPerformanceRiskRatings(
                Consumer<CurrentPerformanceRiskRatings.Builder> currentPerformanceRiskRatings) {
            return currentPerformanceRiskRatings(CurrentPerformanceRiskRatings.builder()
                    .applyMutation(currentPerformanceRiskRatings).build());
        }

        /**
         * <p>
         * An array of objects that describes the estimated monthly saving amounts for the instances running on the
         * specified <code>inferredWorkloadTypes</code>. The array contains the top five savings opportunites for the
         * instances that run inferred workload types.
         * </p>
         * 
         * @param inferredWorkloadSavings
         *        An array of objects that describes the estimated monthly saving amounts for the instances running on
         *        the specified <code>inferredWorkloadTypes</code>. The array contains the top five savings opportunites
         *        for the instances that run inferred workload types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferredWorkloadSavings(Collection<InferredWorkloadSaving> inferredWorkloadSavings);

        /**
         * <p>
         * An array of objects that describes the estimated monthly saving amounts for the instances running on the
         * specified <code>inferredWorkloadTypes</code>. The array contains the top five savings opportunites for the
         * instances that run inferred workload types.
         * </p>
         * 
         * @param inferredWorkloadSavings
         *        An array of objects that describes the estimated monthly saving amounts for the instances running on
         *        the specified <code>inferredWorkloadTypes</code>. The array contains the top five savings opportunites
         *        for the instances that run inferred workload types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferredWorkloadSavings(InferredWorkloadSaving... inferredWorkloadSavings);

        /**
         * <p>
         * An array of objects that describes the estimated monthly saving amounts for the instances running on the
         * specified <code>inferredWorkloadTypes</code>. The array contains the top five savings opportunites for the
         * instances that run inferred workload types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadSaving.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadSaving#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadSaving.Builder#build()} is
         * called immediately and its result is passed to {@link #inferredWorkloadSavings(List<InferredWorkloadSaving>)}.
         * 
         * @param inferredWorkloadSavings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadSaving.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferredWorkloadSavings(java.util.Collection<InferredWorkloadSaving>)
         */
        Builder inferredWorkloadSavings(Consumer<InferredWorkloadSaving.Builder>... inferredWorkloadSavings);
    }

    static final class BuilderImpl implements Builder {
        private List<Summary> summaries = DefaultSdkAutoConstructList.getInstance();

        private String recommendationResourceType;

        private String accountId;

        private SavingsOpportunity savingsOpportunity;

        private CurrentPerformanceRiskRatings currentPerformanceRiskRatings;

        private List<InferredWorkloadSaving> inferredWorkloadSavings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSummary model) {
            summaries(model.summaries);
            recommendationResourceType(model.recommendationResourceType);
            accountId(model.accountId);
            savingsOpportunity(model.savingsOpportunity);
            currentPerformanceRiskRatings(model.currentPerformanceRiskRatings);
            inferredWorkloadSavings(model.inferredWorkloadSavings);
        }

        public final List<Summary.Builder> getSummaries() {
            List<Summary.Builder> result = SummariesCopier.copyToBuilder(this.summaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaries(Collection<Summary.BuilderImpl> summaries) {
            this.summaries = SummariesCopier.copyFromBuilder(summaries);
        }

        @Override
        public final Builder summaries(Collection<Summary> summaries) {
            this.summaries = SummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Summary... summaries) {
            summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Consumer<Summary.Builder>... summaries) {
            summaries(Stream.of(summaries).map(c -> Summary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRecommendationResourceType() {
            return recommendationResourceType;
        }

        public final void setRecommendationResourceType(String recommendationResourceType) {
            this.recommendationResourceType = recommendationResourceType;
        }

        @Override
        public final Builder recommendationResourceType(String recommendationResourceType) {
            this.recommendationResourceType = recommendationResourceType;
            return this;
        }

        @Override
        public final Builder recommendationResourceType(RecommendationSourceType recommendationResourceType) {
            this.recommendationResourceType(recommendationResourceType == null ? null : recommendationResourceType.toString());
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final SavingsOpportunity.Builder getSavingsOpportunity() {
            return savingsOpportunity != null ? savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(SavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        public final Builder savingsOpportunity(SavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        public final CurrentPerformanceRiskRatings.Builder getCurrentPerformanceRiskRatings() {
            return currentPerformanceRiskRatings != null ? currentPerformanceRiskRatings.toBuilder() : null;
        }

        public final void setCurrentPerformanceRiskRatings(CurrentPerformanceRiskRatings.BuilderImpl currentPerformanceRiskRatings) {
            this.currentPerformanceRiskRatings = currentPerformanceRiskRatings != null ? currentPerformanceRiskRatings.build()
                    : null;
        }

        @Override
        public final Builder currentPerformanceRiskRatings(CurrentPerformanceRiskRatings currentPerformanceRiskRatings) {
            this.currentPerformanceRiskRatings = currentPerformanceRiskRatings;
            return this;
        }

        public final List<InferredWorkloadSaving.Builder> getInferredWorkloadSavings() {
            List<InferredWorkloadSaving.Builder> result = InferredWorkloadSavingsCopier
                    .copyToBuilder(this.inferredWorkloadSavings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferredWorkloadSavings(Collection<InferredWorkloadSaving.BuilderImpl> inferredWorkloadSavings) {
            this.inferredWorkloadSavings = InferredWorkloadSavingsCopier.copyFromBuilder(inferredWorkloadSavings);
        }

        @Override
        public final Builder inferredWorkloadSavings(Collection<InferredWorkloadSaving> inferredWorkloadSavings) {
            this.inferredWorkloadSavings = InferredWorkloadSavingsCopier.copy(inferredWorkloadSavings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferredWorkloadSavings(InferredWorkloadSaving... inferredWorkloadSavings) {
            inferredWorkloadSavings(Arrays.asList(inferredWorkloadSavings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferredWorkloadSavings(Consumer<InferredWorkloadSaving.Builder>... inferredWorkloadSavings) {
            inferredWorkloadSavings(Stream.of(inferredWorkloadSavings)
                    .map(c -> InferredWorkloadSaving.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RecommendationSummary build() {
            return new RecommendationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
