/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ExportableLambdaFunctionField {
    ACCOUNT_ID("AccountId"),

    FUNCTION_ARN("FunctionArn"),

    FUNCTION_VERSION("FunctionVersion"),

    FINDING("Finding"),

    FINDING_REASON_CODES("FindingReasonCodes"),

    NUMBER_OF_INVOCATIONS("NumberOfInvocations"),

    UTILIZATION_METRICS_DURATION_MAXIMUM("UtilizationMetricsDurationMaximum"),

    UTILIZATION_METRICS_DURATION_AVERAGE("UtilizationMetricsDurationAverage"),

    UTILIZATION_METRICS_MEMORY_MAXIMUM("UtilizationMetricsMemoryMaximum"),

    UTILIZATION_METRICS_MEMORY_AVERAGE("UtilizationMetricsMemoryAverage"),

    LOOKBACK_PERIOD_IN_DAYS("LookbackPeriodInDays"),

    CURRENT_CONFIGURATION_MEMORY_SIZE("CurrentConfigurationMemorySize"),

    CURRENT_CONFIGURATION_TIMEOUT("CurrentConfigurationTimeout"),

    CURRENT_COST_TOTAL("CurrentCostTotal"),

    CURRENT_COST_AVERAGE("CurrentCostAverage"),

    RECOMMENDATION_OPTIONS_CONFIGURATION_MEMORY_SIZE("RecommendationOptionsConfigurationMemorySize"),

    RECOMMENDATION_OPTIONS_COST_LOW("RecommendationOptionsCostLow"),

    RECOMMENDATION_OPTIONS_COST_HIGH("RecommendationOptionsCostHigh"),

    RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_DURATION_LOWER_BOUND(
            "RecommendationOptionsProjectedUtilizationMetricsDurationLowerBound"),

    RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_DURATION_UPPER_BOUND(
            "RecommendationOptionsProjectedUtilizationMetricsDurationUpperBound"),

    RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_DURATION_EXPECTED(
            "RecommendationOptionsProjectedUtilizationMetricsDurationExpected"),

    LAST_REFRESH_TIMESTAMP("LastRefreshTimestamp"),

    CURRENT_PERFORMANCE_RISK("CurrentPerformanceRisk"),

    RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE("RecommendationOptionsSavingsOpportunityPercentage"),

    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY("RecommendationOptionsEstimatedMonthlySavingsCurrency"),

    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE("RecommendationOptionsEstimatedMonthlySavingsValue"),

    TAGS("Tags"),

    EFFECTIVE_RECOMMENDATION_PREFERENCES_SAVINGS_ESTIMATION_MODE("EffectiveRecommendationPreferencesSavingsEstimationMode"),

    RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_PERCENTAGE(
            "RecommendationOptionsSavingsOpportunityAfterDiscountsPercentage"),

    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY_AFTER_DISCOUNTS(
            "RecommendationOptionsEstimatedMonthlySavingsCurrencyAfterDiscounts"),

    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE_AFTER_DISCOUNTS(
            "RecommendationOptionsEstimatedMonthlySavingsValueAfterDiscounts"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportableLambdaFunctionField> VALUE_MAP = EnumUtils.uniqueIndex(
            ExportableLambdaFunctionField.class, ExportableLambdaFunctionField::toString);

    private final String value;

    private ExportableLambdaFunctionField(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ExportableLambdaFunctionField corresponding to the value
     */
    public static ExportableLambdaFunctionField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ExportableLambdaFunctionField}s
     */
    public static Set<ExportableLambdaFunctionField> knownValues() {
        Set<ExportableLambdaFunctionField> knownValues = EnumSet.allOf(ExportableLambdaFunctionField.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
