/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEc2RecommendationProjectedMetricsRequest extends ComputeOptimizerRequest implements
        ToCopyableBuilder<GetEc2RecommendationProjectedMetricsRequest.Builder, GetEc2RecommendationProjectedMetricsRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceArn").getter(getter(GetEc2RecommendationProjectedMetricsRequest::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()).build();

    private static final SdkField<String> STAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stat")
            .getter(getter(GetEc2RecommendationProjectedMetricsRequest::statAsString)).setter(setter(Builder::stat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stat").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("period").getter(getter(GetEc2RecommendationProjectedMetricsRequest::period))
            .setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(GetEc2RecommendationProjectedMetricsRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(GetEc2RecommendationProjectedMetricsRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<RecommendationPreferences> RECOMMENDATION_PREFERENCES_FIELD = SdkField
            .<RecommendationPreferences> builder(MarshallingType.SDK_POJO).memberName("recommendationPreferences")
            .getter(getter(GetEc2RecommendationProjectedMetricsRequest::recommendationPreferences))
            .setter(setter(Builder::recommendationPreferences)).constructor(RecommendationPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationPreferences").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD,
            STAT_FIELD, PERIOD_FIELD, START_TIME_FIELD, END_TIME_FIELD, RECOMMENDATION_PREFERENCES_FIELD));

    private final String instanceArn;

    private final String stat;

    private final Integer period;

    private final Instant startTime;

    private final Instant endTime;

    private final RecommendationPreferences recommendationPreferences;

    private GetEc2RecommendationProjectedMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.stat = builder.stat;
        this.period = builder.period;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.recommendationPreferences = builder.recommendationPreferences;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the instances for which to return recommendation projected metrics.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the instances for which to return recommendation projected metrics.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The statistic of the projected metrics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stat} will return
     * {@link MetricStatistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statAsString}.
     * </p>
     * 
     * @return The statistic of the projected metrics.
     * @see MetricStatistic
     */
    public final MetricStatistic stat() {
        return MetricStatistic.fromValue(stat);
    }

    /**
     * <p>
     * The statistic of the projected metrics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stat} will return
     * {@link MetricStatistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statAsString}.
     * </p>
     * 
     * @return The statistic of the projected metrics.
     * @see MetricStatistic
     */
    public final String statAsString() {
        return stat;
    }

    /**
     * <p>
     * The granularity, in seconds, of the projected metrics data points.
     * </p>
     * 
     * @return The granularity, in seconds, of the projected metrics data points.
     */
    public final Integer period() {
        return period;
    }

    /**
     * <p>
     * The timestamp of the first projected metrics data point to return.
     * </p>
     * 
     * @return The timestamp of the first projected metrics data point to return.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The timestamp of the last projected metrics data point to return.
     * </p>
     * 
     * @return The timestamp of the last projected metrics data point to return.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * An object to specify the preferences for the Amazon EC2 recommendation projected metrics to return in the
     * response.
     * </p>
     * 
     * @return An object to specify the preferences for the Amazon EC2 recommendation projected metrics to return in the
     *         response.
     */
    public final RecommendationPreferences recommendationPreferences() {
        return recommendationPreferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(statAsString());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationPreferences());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEc2RecommendationProjectedMetricsRequest)) {
            return false;
        }
        GetEc2RecommendationProjectedMetricsRequest other = (GetEc2RecommendationProjectedMetricsRequest) obj;
        return Objects.equals(instanceArn(), other.instanceArn()) && Objects.equals(statAsString(), other.statAsString())
                && Objects.equals(period(), other.period()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime())
                && Objects.equals(recommendationPreferences(), other.recommendationPreferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEc2RecommendationProjectedMetricsRequest").add("InstanceArn", instanceArn())
                .add("Stat", statAsString()).add("Period", period()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("RecommendationPreferences", recommendationPreferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "stat":
            return Optional.ofNullable(clazz.cast(statAsString()));
        case "period":
            return Optional.ofNullable(clazz.cast(period()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "recommendationPreferences":
            return Optional.ofNullable(clazz.cast(recommendationPreferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEc2RecommendationProjectedMetricsRequest, T> g) {
        return obj -> g.apply((GetEc2RecommendationProjectedMetricsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEc2RecommendationProjectedMetricsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the instances for which to return recommendation projected metrics.
         * </p>
         * 
         * @param instanceArn
         *        The Amazon Resource Name (ARN) of the instances for which to return recommendation projected metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The statistic of the projected metrics.
         * </p>
         * 
         * @param stat
         *        The statistic of the projected metrics.
         * @see MetricStatistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricStatistic
         */
        Builder stat(String stat);

        /**
         * <p>
         * The statistic of the projected metrics.
         * </p>
         * 
         * @param stat
         *        The statistic of the projected metrics.
         * @see MetricStatistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricStatistic
         */
        Builder stat(MetricStatistic stat);

        /**
         * <p>
         * The granularity, in seconds, of the projected metrics data points.
         * </p>
         * 
         * @param period
         *        The granularity, in seconds, of the projected metrics data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The timestamp of the first projected metrics data point to return.
         * </p>
         * 
         * @param startTime
         *        The timestamp of the first projected metrics data point to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The timestamp of the last projected metrics data point to return.
         * </p>
         * 
         * @param endTime
         *        The timestamp of the last projected metrics data point to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * An object to specify the preferences for the Amazon EC2 recommendation projected metrics to return in the
         * response.
         * </p>
         * 
         * @param recommendationPreferences
         *        An object to specify the preferences for the Amazon EC2 recommendation projected metrics to return in
         *        the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationPreferences(RecommendationPreferences recommendationPreferences);

        /**
         * <p>
         * An object to specify the preferences for the Amazon EC2 recommendation projected metrics to return in the
         * response.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationPreferences.Builder}
         * avoiding the need to create one manually via {@link RecommendationPreferences#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationPreferences.Builder#build()} is called immediately
         * and its result is passed to {@link #recommendationPreferences(RecommendationPreferences)}.
         * 
         * @param recommendationPreferences
         *        a consumer that will call methods on {@link RecommendationPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationPreferences(RecommendationPreferences)
         */
        default Builder recommendationPreferences(Consumer<RecommendationPreferences.Builder> recommendationPreferences) {
            return recommendationPreferences(RecommendationPreferences.builder().applyMutation(recommendationPreferences).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComputeOptimizerRequest.BuilderImpl implements Builder {
        private String instanceArn;

        private String stat;

        private Integer period;

        private Instant startTime;

        private Instant endTime;

        private RecommendationPreferences recommendationPreferences;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEc2RecommendationProjectedMetricsRequest model) {
            super(model);
            instanceArn(model.instanceArn);
            stat(model.stat);
            period(model.period);
            startTime(model.startTime);
            endTime(model.endTime);
            recommendationPreferences(model.recommendationPreferences);
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getStat() {
            return stat;
        }

        public final void setStat(String stat) {
            this.stat = stat;
        }

        @Override
        public final Builder stat(String stat) {
            this.stat = stat;
            return this;
        }

        @Override
        public final Builder stat(MetricStatistic stat) {
            this.stat(stat == null ? null : stat.toString());
            return this;
        }

        public final Integer getPeriod() {
            return period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final RecommendationPreferences.Builder getRecommendationPreferences() {
            return recommendationPreferences != null ? recommendationPreferences.toBuilder() : null;
        }

        public final void setRecommendationPreferences(RecommendationPreferences.BuilderImpl recommendationPreferences) {
            this.recommendationPreferences = recommendationPreferences != null ? recommendationPreferences.build() : null;
        }

        @Override
        public final Builder recommendationPreferences(RecommendationPreferences recommendationPreferences) {
            this.recommendationPreferences = recommendationPreferences;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEc2RecommendationProjectedMetricsRequest build() {
            return new GetEc2RecommendationProjectedMetricsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
