/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of a license for an Amazon EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LicenseConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LicenseConfiguration.Builder, LicenseConfiguration> {
    private static final SdkField<Integer> NUMBER_OF_CORES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfCores").getter(getter(LicenseConfiguration::numberOfCores))
            .setter(setter(Builder::numberOfCores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfCores").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(LicenseConfiguration::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operatingSystem").getter(getter(LicenseConfiguration::operatingSystem))
            .setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystem").build()).build();

    private static final SdkField<String> LICENSE_EDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseEdition").getter(getter(LicenseConfiguration::licenseEditionAsString))
            .setter(setter(Builder::licenseEdition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseEdition").build()).build();

    private static final SdkField<String> LICENSE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseName").getter(getter(LicenseConfiguration::licenseNameAsString))
            .setter(setter(Builder::licenseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseName").build()).build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseModel").getter(getter(LicenseConfiguration::licenseModelAsString))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseModel").build()).build();

    private static final SdkField<String> LICENSE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseVersion").getter(getter(LicenseConfiguration::licenseVersion))
            .setter(setter(Builder::licenseVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseVersion").build()).build();

    private static final SdkField<List<MetricSource>> METRICS_SOURCE_FIELD = SdkField
            .<List<MetricSource>> builder(MarshallingType.LIST)
            .memberName("metricsSource")
            .getter(getter(LicenseConfiguration::metricsSource))
            .setter(setter(Builder::metricsSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsSource").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_CORES_FIELD,
            INSTANCE_TYPE_FIELD, OPERATING_SYSTEM_FIELD, LICENSE_EDITION_FIELD, LICENSE_NAME_FIELD, LICENSE_MODEL_FIELD,
            LICENSE_VERSION_FIELD, METRICS_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer numberOfCores;

    private final String instanceType;

    private final String operatingSystem;

    private final String licenseEdition;

    private final String licenseName;

    private final String licenseModel;

    private final String licenseVersion;

    private final List<MetricSource> metricsSource;

    private LicenseConfiguration(BuilderImpl builder) {
        this.numberOfCores = builder.numberOfCores;
        this.instanceType = builder.instanceType;
        this.operatingSystem = builder.operatingSystem;
        this.licenseEdition = builder.licenseEdition;
        this.licenseName = builder.licenseName;
        this.licenseModel = builder.licenseModel;
        this.licenseVersion = builder.licenseVersion;
        this.metricsSource = builder.metricsSource;
    }

    /**
     * <p>
     * The current number of cores associated with the instance.
     * </p>
     * 
     * @return The current number of cores associated with the instance.
     */
    public final Integer numberOfCores() {
        return numberOfCores;
    }

    /**
     * <p>
     * The instance type used in the license.
     * </p>
     * 
     * @return The instance type used in the license.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The operating system of the instance.
     * </p>
     * 
     * @return The operating system of the instance.
     */
    public final String operatingSystem() {
        return operatingSystem;
    }

    /**
     * <p>
     * The edition of the license for the application that runs on the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseEdition}
     * will return {@link LicenseEdition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #licenseEditionAsString}.
     * </p>
     * 
     * @return The edition of the license for the application that runs on the instance.
     * @see LicenseEdition
     */
    public final LicenseEdition licenseEdition() {
        return LicenseEdition.fromValue(licenseEdition);
    }

    /**
     * <p>
     * The edition of the license for the application that runs on the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseEdition}
     * will return {@link LicenseEdition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #licenseEditionAsString}.
     * </p>
     * 
     * @return The edition of the license for the application that runs on the instance.
     * @see LicenseEdition
     */
    public final String licenseEditionAsString() {
        return licenseEdition;
    }

    /**
     * <p>
     * The name of the license for the application that runs on the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseName} will
     * return {@link LicenseName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseNameAsString}.
     * </p>
     * 
     * @return The name of the license for the application that runs on the instance.
     * @see LicenseName
     */
    public final LicenseName licenseName() {
        return LicenseName.fromValue(licenseName);
    }

    /**
     * <p>
     * The name of the license for the application that runs on the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseName} will
     * return {@link LicenseName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseNameAsString}.
     * </p>
     * 
     * @return The name of the license for the application that runs on the instance.
     * @see LicenseName
     */
    public final String licenseNameAsString() {
        return licenseName;
    }

    /**
     * <p>
     * The license type associated with the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseModel} will
     * return {@link LicenseModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseModelAsString}.
     * </p>
     * 
     * @return The license type associated with the instance.
     * @see LicenseModel
     */
    public final LicenseModel licenseModel() {
        return LicenseModel.fromValue(licenseModel);
    }

    /**
     * <p>
     * The license type associated with the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseModel} will
     * return {@link LicenseModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseModelAsString}.
     * </p>
     * 
     * @return The license type associated with the instance.
     * @see LicenseModel
     */
    public final String licenseModelAsString() {
        return licenseModel;
    }

    /**
     * <p>
     * The version of the license for the application that runs on the instance.
     * </p>
     * 
     * @return The version of the license for the application that runs on the instance.
     */
    public final String licenseVersion() {
        return licenseVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricsSource property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricsSource() {
        return metricsSource != null && !(metricsSource instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of metric sources required to generate recommendations for commercial software licenses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricsSource} method.
     * </p>
     * 
     * @return The list of metric sources required to generate recommendations for commercial software licenses.
     */
    public final List<MetricSource> metricsSource() {
        return metricsSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfCores());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystem());
        hashCode = 31 * hashCode + Objects.hashCode(licenseEditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(licenseNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(licenseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricsSource() ? metricsSource() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseConfiguration)) {
            return false;
        }
        LicenseConfiguration other = (LicenseConfiguration) obj;
        return Objects.equals(numberOfCores(), other.numberOfCores()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(operatingSystem(), other.operatingSystem())
                && Objects.equals(licenseEditionAsString(), other.licenseEditionAsString())
                && Objects.equals(licenseNameAsString(), other.licenseNameAsString())
                && Objects.equals(licenseModelAsString(), other.licenseModelAsString())
                && Objects.equals(licenseVersion(), other.licenseVersion()) && hasMetricsSource() == other.hasMetricsSource()
                && Objects.equals(metricsSource(), other.metricsSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LicenseConfiguration").add("NumberOfCores", numberOfCores()).add("InstanceType", instanceType())
                .add("OperatingSystem", operatingSystem()).add("LicenseEdition", licenseEditionAsString())
                .add("LicenseName", licenseNameAsString()).add("LicenseModel", licenseModelAsString())
                .add("LicenseVersion", licenseVersion()).add("MetricsSource", hasMetricsSource() ? metricsSource() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "numberOfCores":
            return Optional.ofNullable(clazz.cast(numberOfCores()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "operatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystem()));
        case "licenseEdition":
            return Optional.ofNullable(clazz.cast(licenseEditionAsString()));
        case "licenseName":
            return Optional.ofNullable(clazz.cast(licenseNameAsString()));
        case "licenseModel":
            return Optional.ofNullable(clazz.cast(licenseModelAsString()));
        case "licenseVersion":
            return Optional.ofNullable(clazz.cast(licenseVersion()));
        case "metricsSource":
            return Optional.ofNullable(clazz.cast(metricsSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LicenseConfiguration, T> g) {
        return obj -> g.apply((LicenseConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LicenseConfiguration> {
        /**
         * <p>
         * The current number of cores associated with the instance.
         * </p>
         * 
         * @param numberOfCores
         *        The current number of cores associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfCores(Integer numberOfCores);

        /**
         * <p>
         * The instance type used in the license.
         * </p>
         * 
         * @param instanceType
         *        The instance type used in the license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The operating system of the instance.
         * </p>
         * 
         * @param operatingSystem
         *        The operating system of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * The edition of the license for the application that runs on the instance.
         * </p>
         * 
         * @param licenseEdition
         *        The edition of the license for the application that runs on the instance.
         * @see LicenseEdition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseEdition
         */
        Builder licenseEdition(String licenseEdition);

        /**
         * <p>
         * The edition of the license for the application that runs on the instance.
         * </p>
         * 
         * @param licenseEdition
         *        The edition of the license for the application that runs on the instance.
         * @see LicenseEdition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseEdition
         */
        Builder licenseEdition(LicenseEdition licenseEdition);

        /**
         * <p>
         * The name of the license for the application that runs on the instance.
         * </p>
         * 
         * @param licenseName
         *        The name of the license for the application that runs on the instance.
         * @see LicenseName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseName
         */
        Builder licenseName(String licenseName);

        /**
         * <p>
         * The name of the license for the application that runs on the instance.
         * </p>
         * 
         * @param licenseName
         *        The name of the license for the application that runs on the instance.
         * @see LicenseName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseName
         */
        Builder licenseName(LicenseName licenseName);

        /**
         * <p>
         * The license type associated with the instance.
         * </p>
         * 
         * @param licenseModel
         *        The license type associated with the instance.
         * @see LicenseModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseModel
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The license type associated with the instance.
         * </p>
         * 
         * @param licenseModel
         *        The license type associated with the instance.
         * @see LicenseModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseModel
         */
        Builder licenseModel(LicenseModel licenseModel);

        /**
         * <p>
         * The version of the license for the application that runs on the instance.
         * </p>
         * 
         * @param licenseVersion
         *        The version of the license for the application that runs on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseVersion(String licenseVersion);

        /**
         * <p>
         * The list of metric sources required to generate recommendations for commercial software licenses.
         * </p>
         * 
         * @param metricsSource
         *        The list of metric sources required to generate recommendations for commercial software licenses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsSource(Collection<MetricSource> metricsSource);

        /**
         * <p>
         * The list of metric sources required to generate recommendations for commercial software licenses.
         * </p>
         * 
         * @param metricsSource
         *        The list of metric sources required to generate recommendations for commercial software licenses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsSource(MetricSource... metricsSource);

        /**
         * <p>
         * The list of metric sources required to generate recommendations for commercial software licenses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.computeoptimizer.model.MetricSource.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.computeoptimizer.model.MetricSource#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.computeoptimizer.model.MetricSource.Builder#build()} is called
         * immediately and its result is passed to {@link #metricsSource(List<MetricSource>)}.
         * 
         * @param metricsSource
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.computeoptimizer.model.MetricSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsSource(java.util.Collection<MetricSource>)
         */
        Builder metricsSource(Consumer<MetricSource.Builder>... metricsSource);
    }

    static final class BuilderImpl implements Builder {
        private Integer numberOfCores;

        private String instanceType;

        private String operatingSystem;

        private String licenseEdition;

        private String licenseName;

        private String licenseModel;

        private String licenseVersion;

        private List<MetricSource> metricsSource = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseConfiguration model) {
            numberOfCores(model.numberOfCores);
            instanceType(model.instanceType);
            operatingSystem(model.operatingSystem);
            licenseEdition(model.licenseEdition);
            licenseName(model.licenseName);
            licenseModel(model.licenseModel);
            licenseVersion(model.licenseVersion);
            metricsSource(model.metricsSource);
        }

        public final Integer getNumberOfCores() {
            return numberOfCores;
        }

        public final void setNumberOfCores(Integer numberOfCores) {
            this.numberOfCores = numberOfCores;
        }

        @Override
        public final Builder numberOfCores(Integer numberOfCores) {
            this.numberOfCores = numberOfCores;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public final String getLicenseEdition() {
            return licenseEdition;
        }

        public final void setLicenseEdition(String licenseEdition) {
            this.licenseEdition = licenseEdition;
        }

        @Override
        public final Builder licenseEdition(String licenseEdition) {
            this.licenseEdition = licenseEdition;
            return this;
        }

        @Override
        public final Builder licenseEdition(LicenseEdition licenseEdition) {
            this.licenseEdition(licenseEdition == null ? null : licenseEdition.toString());
            return this;
        }

        public final String getLicenseName() {
            return licenseName;
        }

        public final void setLicenseName(String licenseName) {
            this.licenseName = licenseName;
        }

        @Override
        public final Builder licenseName(String licenseName) {
            this.licenseName = licenseName;
            return this;
        }

        @Override
        public final Builder licenseName(LicenseName licenseName) {
            this.licenseName(licenseName == null ? null : licenseName.toString());
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        @Override
        public final Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel(licenseModel == null ? null : licenseModel.toString());
            return this;
        }

        public final String getLicenseVersion() {
            return licenseVersion;
        }

        public final void setLicenseVersion(String licenseVersion) {
            this.licenseVersion = licenseVersion;
        }

        @Override
        public final Builder licenseVersion(String licenseVersion) {
            this.licenseVersion = licenseVersion;
            return this;
        }

        public final List<MetricSource.Builder> getMetricsSource() {
            List<MetricSource.Builder> result = MetricsSourceCopier.copyToBuilder(this.metricsSource);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricsSource(Collection<MetricSource.BuilderImpl> metricsSource) {
            this.metricsSource = MetricsSourceCopier.copyFromBuilder(metricsSource);
        }

        @Override
        public final Builder metricsSource(Collection<MetricSource> metricsSource) {
            this.metricsSource = MetricsSourceCopier.copy(metricsSource);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsSource(MetricSource... metricsSource) {
            metricsSource(Arrays.asList(metricsSource));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsSource(Consumer<MetricSource.Builder>... metricsSource) {
            metricsSource(Stream.of(metricsSource).map(c -> MetricSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public LicenseConfiguration build() {
            return new LicenseConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
