/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The memory size configurations of a container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemorySizeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MemorySizeConfiguration.Builder, MemorySizeConfiguration> {
    private static final SdkField<Integer> MEMORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memory").getter(getter(MemorySizeConfiguration::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<Integer> MEMORY_RESERVATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memoryReservation").getter(getter(MemorySizeConfiguration::memoryReservation))
            .setter(setter(Builder::memoryReservation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryReservation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_FIELD,
            MEMORY_RESERVATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer memory;

    private final Integer memoryReservation;

    private MemorySizeConfiguration(BuilderImpl builder) {
        this.memory = builder.memory;
        this.memoryReservation = builder.memoryReservation;
    }

    /**
     * <p>
     * The amount of memory in the container.
     * </p>
     * 
     * @return The amount of memory in the container.
     */
    public final Integer memory() {
        return memory;
    }

    /**
     * <p>
     * The limit of memory reserve for the container.
     * </p>
     * 
     * @return The limit of memory reserve for the container.
     */
    public final Integer memoryReservation() {
        return memoryReservation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(memoryReservation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemorySizeConfiguration)) {
            return false;
        }
        MemorySizeConfiguration other = (MemorySizeConfiguration) obj;
        return Objects.equals(memory(), other.memory()) && Objects.equals(memoryReservation(), other.memoryReservation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemorySizeConfiguration").add("Memory", memory()).add("MemoryReservation", memoryReservation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "memoryReservation":
            return Optional.ofNullable(clazz.cast(memoryReservation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemorySizeConfiguration, T> g) {
        return obj -> g.apply((MemorySizeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemorySizeConfiguration> {
        /**
         * <p>
         * The amount of memory in the container.
         * </p>
         * 
         * @param memory
         *        The amount of memory in the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(Integer memory);

        /**
         * <p>
         * The limit of memory reserve for the container.
         * </p>
         * 
         * @param memoryReservation
         *        The limit of memory reserve for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryReservation(Integer memoryReservation);
    }

    static final class BuilderImpl implements Builder {
        private Integer memory;

        private Integer memoryReservation;

        private BuilderImpl() {
        }

        private BuilderImpl(MemorySizeConfiguration model) {
            memory(model.memory);
            memoryReservation(model.memoryReservation);
        }

        public final Integer getMemory() {
            return memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Integer getMemoryReservation() {
            return memoryReservation;
        }

        public final void setMemoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
        }

        @Override
        public final Builder memoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this;
        }

        @Override
        public MemorySizeConfiguration build() {
            return new MemorySizeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
