/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigException;
import software.amazon.awssdk.services.config.model.ConformancePackTemplateValidationException;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.DeleteConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteConformancePackResponse;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsResponse;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackResponse;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestResponse;
import software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.DeleteResourceConfigRequest;
import software.amazon.awssdk.services.config.model.DeleteResourceConfigResponse;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeleteStoredQueryRequest;
import software.amazon.awssdk.services.config.model.DeleteStoredQueryResponse;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeResponse;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetCustomRulePolicyRequest;
import software.amazon.awssdk.services.config.model.GetCustomRulePolicyResponse;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyResponse;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse;
import software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryRequest;
import software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryResponse;
import software.amazon.awssdk.services.config.model.GetStoredQueryRequest;
import software.amazon.awssdk.services.config.model.GetStoredQueryResponse;
import software.amazon.awssdk.services.config.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.config.model.InsufficientDeliveryPolicyException;
import software.amazon.awssdk.services.config.model.InsufficientPermissionsException;
import software.amazon.awssdk.services.config.model.InvalidConfigurationRecorderNameException;
import software.amazon.awssdk.services.config.model.InvalidDeliveryChannelNameException;
import software.amazon.awssdk.services.config.model.InvalidExpressionException;
import software.amazon.awssdk.services.config.model.InvalidLimitException;
import software.amazon.awssdk.services.config.model.InvalidNextTokenException;
import software.amazon.awssdk.services.config.model.InvalidParameterValueException;
import software.amazon.awssdk.services.config.model.InvalidRecordingGroupException;
import software.amazon.awssdk.services.config.model.InvalidResultTokenException;
import software.amazon.awssdk.services.config.model.InvalidRoleException;
import software.amazon.awssdk.services.config.model.InvalidS3KeyPrefixException;
import software.amazon.awssdk.services.config.model.InvalidS3KmsKeyArnException;
import software.amazon.awssdk.services.config.model.InvalidSnsTopicArnException;
import software.amazon.awssdk.services.config.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.config.model.LastDeliveryChannelDeleteFailedException;
import software.amazon.awssdk.services.config.model.LimitExceededException;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest;
import software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresResponse;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest;
import software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse;
import software.amazon.awssdk.services.config.model.ListStoredQueriesRequest;
import software.amazon.awssdk.services.config.model.ListStoredQueriesResponse;
import software.amazon.awssdk.services.config.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.config.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.config.model.MaxActiveResourcesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigRulesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigurationRecordersExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConformancePacksExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfDeliveryChannelsExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfOrganizationConfigRulesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfOrganizationConformancePacksExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfRetentionConfigurationsExceededException;
import software.amazon.awssdk.services.config.model.NoAvailableConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoAvailableDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoAvailableOrganizationException;
import software.amazon.awssdk.services.config.model.NoRunningConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchBucketException;
import software.amazon.awssdk.services.config.model.NoSuchConfigRuleException;
import software.amazon.awssdk.services.config.model.NoSuchConfigRuleInConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationAggregatorException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoSuchOrganizationConfigRuleException;
import software.amazon.awssdk.services.config.model.NoSuchOrganizationConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchRemediationConfigurationException;
import software.amazon.awssdk.services.config.model.NoSuchRemediationExceptionException;
import software.amazon.awssdk.services.config.model.NoSuchRetentionConfigurationException;
import software.amazon.awssdk.services.config.model.OrganizationAccessDeniedException;
import software.amazon.awssdk.services.config.model.OrganizationAllFeaturesNotEnabledException;
import software.amazon.awssdk.services.config.model.OrganizationConformancePackTemplateValidationException;
import software.amazon.awssdk.services.config.model.OversizedConfigurationItemException;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.PutConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.PutConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutConformancePackResponse;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.PutEvaluationsRequest;
import software.amazon.awssdk.services.config.model.PutEvaluationsResponse;
import software.amazon.awssdk.services.config.model.PutExternalEvaluationRequest;
import software.amazon.awssdk.services.config.model.PutExternalEvaluationResponse;
import software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutOrganizationConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutOrganizationConformancePackResponse;
import software.amazon.awssdk.services.config.model.PutRemediationConfigurationsRequest;
import software.amazon.awssdk.services.config.model.PutRemediationConfigurationsResponse;
import software.amazon.awssdk.services.config.model.PutRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.PutRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.PutResourceConfigRequest;
import software.amazon.awssdk.services.config.model.PutResourceConfigResponse;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.PutStoredQueryRequest;
import software.amazon.awssdk.services.config.model.PutStoredQueryResponse;
import software.amazon.awssdk.services.config.model.RemediationInProgressException;
import software.amazon.awssdk.services.config.model.ResourceConcurrentModificationException;
import software.amazon.awssdk.services.config.model.ResourceInUseException;
import software.amazon.awssdk.services.config.model.ResourceNotDiscoveredException;
import software.amazon.awssdk.services.config.model.ResourceNotFoundException;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.SelectResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectResourceConfigResponse;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationResponse;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.StartRemediationExecutionRequest;
import software.amazon.awssdk.services.config.model.StartRemediationExecutionResponse;
import software.amazon.awssdk.services.config.model.StartResourceEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartResourceEvaluationResponse;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.TagResourceRequest;
import software.amazon.awssdk.services.config.model.TagResourceResponse;
import software.amazon.awssdk.services.config.model.TooManyTagsException;
import software.amazon.awssdk.services.config.model.UntagResourceRequest;
import software.amazon.awssdk.services.config.model.UntagResourceResponse;
import software.amazon.awssdk.services.config.model.ValidationException;
import software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConfigRulesIterable;
import software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConformancePacksIterable;
import software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsIterable;
import software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRuleIterable;
import software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourceIterable;
import software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusIterable;
import software.amazon.awssdk.services.config.paginators.DescribeConfigRulesIterable;
import software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorSourcesStatusIterable;
import software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsIterable;
import software.amazon.awssdk.services.config.paginators.DescribeConformancePackComplianceIterable;
import software.amazon.awssdk.services.config.paginators.DescribeConformancePackStatusIterable;
import software.amazon.awssdk.services.config.paginators.DescribeConformancePacksIterable;
import software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRuleStatusesIterable;
import software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRulesIterable;
import software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePackStatusesIterable;
import software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePacksIterable;
import software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsIterable;
import software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsIterable;
import software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusIterable;
import software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsIterable;
import software.amazon.awssdk.services.config.paginators.GetAggregateComplianceDetailsByConfigRuleIterable;
import software.amazon.awssdk.services.config.paginators.GetAggregateConfigRuleComplianceSummaryIterable;
import software.amazon.awssdk.services.config.paginators.GetAggregateConformancePackComplianceSummaryIterable;
import software.amazon.awssdk.services.config.paginators.GetAggregateDiscoveredResourceCountsIterable;
import software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByConfigRuleIterable;
import software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByResourceIterable;
import software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceDetailsIterable;
import software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceSummaryIterable;
import software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsIterable;
import software.amazon.awssdk.services.config.paginators.GetOrganizationConfigRuleDetailedStatusIterable;
import software.amazon.awssdk.services.config.paginators.GetOrganizationConformancePackDetailedStatusIterable;
import software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryIterable;
import software.amazon.awssdk.services.config.paginators.ListAggregateDiscoveredResourcesIterable;
import software.amazon.awssdk.services.config.paginators.ListConformancePackComplianceScoresIterable;
import software.amazon.awssdk.services.config.paginators.ListDiscoveredResourcesIterable;
import software.amazon.awssdk.services.config.paginators.ListResourceEvaluationsIterable;
import software.amazon.awssdk.services.config.paginators.ListStoredQueriesIterable;
import software.amazon.awssdk.services.config.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.config.paginators.SelectAggregateResourceConfigIterable;
import software.amazon.awssdk.services.config.paginators.SelectResourceConfigIterable;

/**
 * Service client for accessing Config Service. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Config</fullname>
 * <p>
 * Config provides a way to keep track of the configurations of all the Amazon Web Services resources associated with
 * your Amazon Web Services account. You can use Config to get the current and historical configurations of each Amazon
 * Web Services resource and also to get information about the relationship between the resources. An Amazon Web
 * Services resource can be an Amazon Compute Cloud (Amazon EC2) instance, an Elastic Block Store (EBS) volume, an
 * elastic network Interface (ENI), or a security group. For a complete list of resources currently supported by Config,
 * see <a
 * href="https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources"
 * >Supported Amazon Web Services resources</a>.
 * </p>
 * <p>
 * You can access and manage Config through the Amazon Web Services Management Console, the Amazon Web Services Command
 * Line Interface (Amazon Web Services CLI), the Config API, or the Amazon Web Services SDKs for Config. This reference
 * guide contains documentation for the Config API and the Amazon Web Services CLI commands that you can use to manage
 * Config. The Config API uses the Signature Version 4 protocol for signing requests. For more information about how to
 * sign a request with this protocol, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing
 * Process</a>. For detailed information about Config features and their associated actions or commands, as well as how
 * to work with Amazon Web Services Management Console, see <a
 * href="https://docs.aws.amazon.com/config/latest/developerguide/WhatIsConfig.html">What Is Config</a> in the <i>Config
 * Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ConfigClient extends AwsClient {
    String SERVICE_NAME = "config";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "config";

    /**
     * <p>
     * Returns the current configuration items for resources that are present in your Config aggregator. The operation
     * also returns a list of resources that are not processed in the current request. If there are no unprocessed
     * resources, the operation returns an empty <code>unprocessedResourceIdentifiers</code> list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return tags and relationships.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param batchGetAggregateResourceConfigRequest
     * @return Result of the BatchGetAggregateResourceConfig operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.BatchGetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAggregateResourceConfigResponse batchGetAggregateResourceConfig(
            BatchGetAggregateResourceConfigRequest batchGetAggregateResourceConfigRequest) throws ValidationException,
            NoSuchConfigurationAggregatorException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current configuration items for resources that are present in your Config aggregator. The operation
     * also returns a list of resources that are not processed in the current request. If there are no unprocessed
     * resources, the operation returns an empty <code>unprocessedResourceIdentifiers</code> list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return tags and relationships.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAggregateResourceConfigRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetAggregateResourceConfigRequest#builder()}
     * </p>
     *
     * @param batchGetAggregateResourceConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigRequest.Builder} to
     *        create a request.
     * @return Result of the BatchGetAggregateResourceConfig operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.BatchGetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAggregateResourceConfigResponse batchGetAggregateResourceConfig(
            Consumer<BatchGetAggregateResourceConfigRequest.Builder> batchGetAggregateResourceConfigRequest)
            throws ValidationException, NoSuchConfigurationAggregatorException, AwsServiceException, SdkClientException,
            ConfigException {
        return batchGetAggregateResourceConfig(BatchGetAggregateResourceConfigRequest.builder()
                .applyMutation(batchGetAggregateResourceConfigRequest).build());
    }

    /**
     * <p>
     * Returns the <code>BaseConfigurationItem</code> for one or more requested resources. The operation also returns a
     * list of resources that are not processed in the current request. If there are no unprocessed resources, the
     * operation returns an empty unprocessedResourceKeys list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return any tags for the requested resources. This information is filtered out of the
     * supplementaryConfiguration section of the API response.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param batchGetResourceConfigRequest
     * @return Result of the BatchGetResourceConfig operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.BatchGetResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchGetResourceConfigResponse batchGetResourceConfig(BatchGetResourceConfigRequest batchGetResourceConfigRequest)
            throws ValidationException, NoAvailableConfigurationRecorderException, AwsServiceException, SdkClientException,
            ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <code>BaseConfigurationItem</code> for one or more requested resources. The operation also returns a
     * list of resources that are not processed in the current request. If there are no unprocessed resources, the
     * operation returns an empty unprocessedResourceKeys list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return any tags for the requested resources. This information is filtered out of the
     * supplementaryConfiguration section of the API response.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetResourceConfigRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetResourceConfigRequest#builder()}
     * </p>
     *
     * @param batchGetResourceConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetResourceConfig operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.BatchGetResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchGetResourceConfigResponse batchGetResourceConfig(
            Consumer<BatchGetResourceConfigRequest.Builder> batchGetResourceConfigRequest) throws ValidationException,
            NoAvailableConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        return batchGetResourceConfig(BatchGetResourceConfigRequest.builder().applyMutation(batchGetResourceConfigRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the authorization granted to the specified configuration aggregator account in a specified region.
     * </p>
     *
     * @param deleteAggregationAuthorizationRequest
     * @return Result of the DeleteAggregationAuthorization operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteAggregationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteAggregationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAggregationAuthorizationResponse deleteAggregationAuthorization(
            DeleteAggregationAuthorizationRequest deleteAggregationAuthorizationRequest) throws InvalidParameterValueException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the authorization granted to the specified configuration aggregator account in a specified region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAggregationAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAggregationAuthorizationRequest#builder()}
     * </p>
     *
     * @param deleteAggregationAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteAggregationAuthorization operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteAggregationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteAggregationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAggregationAuthorizationResponse deleteAggregationAuthorization(
            Consumer<DeleteAggregationAuthorizationRequest.Builder> deleteAggregationAuthorizationRequest)
            throws InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return deleteAggregationAuthorization(DeleteAggregationAuthorizationRequest.builder()
                .applyMutation(deleteAggregationAuthorizationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Config rule and all of its evaluation results.
     * </p>
     * <p>
     * Config sets the state of a rule to <code>DELETING</code> until the deletion is complete. You cannot update a rule
     * while it is in this state. If you make a <code>PutConfigRule</code> or <code>DeleteConfigRule</code> request for
     * the rule, you will receive a <code>ResourceInUseException</code>.
     * </p>
     * <p>
     * You can check the state of a rule by using the <code>DescribeConfigRules</code> request.
     * </p>
     *
     * @param deleteConfigRuleRequest
     * @return Result of the DeleteConfigRule operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteConfigRuleResponse deleteConfigRule(DeleteConfigRuleRequest deleteConfigRuleRequest)
            throws NoSuchConfigRuleException, ResourceInUseException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Config rule and all of its evaluation results.
     * </p>
     * <p>
     * Config sets the state of a rule to <code>DELETING</code> until the deletion is complete. You cannot update a rule
     * while it is in this state. If you make a <code>PutConfigRule</code> or <code>DeleteConfigRule</code> request for
     * the rule, you will receive a <code>ResourceInUseException</code>.
     * </p>
     * <p>
     * You can check the state of a rule by using the <code>DescribeConfigRules</code> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigRuleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConfigRuleRequest#builder()}
     * </p>
     *
     * @param deleteConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest.Builder} to create a request.
     * @return Result of the DeleteConfigRule operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteConfigRuleResponse deleteConfigRule(Consumer<DeleteConfigRuleRequest.Builder> deleteConfigRuleRequest)
            throws NoSuchConfigRuleException, ResourceInUseException, AwsServiceException, SdkClientException, ConfigException {
        return deleteConfigRule(DeleteConfigRuleRequest.builder().applyMutation(deleteConfigRuleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified configuration aggregator and the aggregated data associated with the aggregator.
     * </p>
     *
     * @param deleteConfigurationAggregatorRequest
     * @return Result of the DeleteConfigurationAggregator operation returned by the service.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteConfigurationAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationAggregatorResponse deleteConfigurationAggregator(
            DeleteConfigurationAggregatorRequest deleteConfigurationAggregatorRequest)
            throws NoSuchConfigurationAggregatorException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified configuration aggregator and the aggregated data associated with the aggregator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationAggregatorRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfigurationAggregatorRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationAggregatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteConfigurationAggregator operation returned by the service.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteConfigurationAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationAggregatorResponse deleteConfigurationAggregator(
            Consumer<DeleteConfigurationAggregatorRequest.Builder> deleteConfigurationAggregatorRequest)
            throws NoSuchConfigurationAggregatorException, AwsServiceException, SdkClientException, ConfigException {
        return deleteConfigurationAggregator(DeleteConfigurationAggregatorRequest.builder()
                .applyMutation(deleteConfigurationAggregatorRequest).build());
    }

    /**
     * <p>
     * Deletes the configuration recorder.
     * </p>
     * <p>
     * After the configuration recorder is deleted, Config will not record resource configuration changes until you
     * create a new configuration recorder.
     * </p>
     * <p>
     * This action does not delete the configuration information that was previously recorded. You will be able to
     * access the previously recorded information by using the <code>GetResourceConfigHistory</code> action, but you
     * will not be able to access this information in the Config console until you create a new configuration recorder.
     * </p>
     *
     * @param deleteConfigurationRecorderRequest
     *        The request object for the <code>DeleteConfigurationRecorder</code> action.
     * @return Result of the DeleteConfigurationRecorder operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationRecorderResponse deleteConfigurationRecorder(
            DeleteConfigurationRecorderRequest deleteConfigurationRecorderRequest) throws NoSuchConfigurationRecorderException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the configuration recorder.
     * </p>
     * <p>
     * After the configuration recorder is deleted, Config will not record resource configuration changes until you
     * create a new configuration recorder.
     * </p>
     * <p>
     * This action does not delete the configuration information that was previously recorded. You will be able to
     * access the previously recorded information by using the <code>GetResourceConfigHistory</code> action, but you
     * will not be able to access this information in the Config console until you create a new configuration recorder.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationRecorderRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfigurationRecorderRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationRecorderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest.Builder} to create
     *        a request. The request object for the <code>DeleteConfigurationRecorder</code> action.
     * @return Result of the DeleteConfigurationRecorder operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationRecorderResponse deleteConfigurationRecorder(
            Consumer<DeleteConfigurationRecorderRequest.Builder> deleteConfigurationRecorderRequest)
            throws NoSuchConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        return deleteConfigurationRecorder(DeleteConfigurationRecorderRequest.builder()
                .applyMutation(deleteConfigurationRecorderRequest).build());
    }

    /**
     * <p>
     * Deletes the specified conformance pack and all the Config rules, remediation actions, and all evaluation results
     * within that conformance pack.
     * </p>
     * <p>
     * Config sets the conformance pack to <code>DELETE_IN_PROGRESS</code> until the deletion is complete. You cannot
     * update a conformance pack while it is in this state.
     * </p>
     *
     * @param deleteConformancePackRequest
     * @return Result of the DeleteConformancePack operation returned by the service.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConformancePack" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteConformancePackResponse deleteConformancePack(DeleteConformancePackRequest deleteConformancePackRequest)
            throws NoSuchConformancePackException, ResourceInUseException, AwsServiceException, SdkClientException,
            ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified conformance pack and all the Config rules, remediation actions, and all evaluation results
     * within that conformance pack.
     * </p>
     * <p>
     * Config sets the conformance pack to <code>DELETE_IN_PROGRESS</code> until the deletion is complete. You cannot
     * update a conformance pack while it is in this state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConformancePackRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConformancePackRequest#builder()}
     * </p>
     *
     * @param deleteConformancePackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteConformancePackRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteConformancePack operation returned by the service.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConformancePack" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteConformancePackResponse deleteConformancePack(
            Consumer<DeleteConformancePackRequest.Builder> deleteConformancePackRequest) throws NoSuchConformancePackException,
            ResourceInUseException, AwsServiceException, SdkClientException, ConfigException {
        return deleteConformancePack(DeleteConformancePackRequest.builder().applyMutation(deleteConformancePackRequest).build());
    }

    /**
     * <p>
     * Deletes the delivery channel.
     * </p>
     * <p>
     * Before you can delete the delivery channel, you must stop the configuration recorder by using the
     * <a>StopConfigurationRecorder</a> action.
     * </p>
     *
     * @param deleteDeliveryChannelRequest
     *        The input for the <a>DeleteDeliveryChannel</a> action. The action accepts the following data, in JSON
     *        format.
     * @return Result of the DeleteDeliveryChannel operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws LastDeliveryChannelDeleteFailedException
     *         You cannot delete the delivery channel you specified because the configuration recorder is running.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteDeliveryChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteDeliveryChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDeliveryChannelResponse deleteDeliveryChannel(DeleteDeliveryChannelRequest deleteDeliveryChannelRequest)
            throws NoSuchDeliveryChannelException, LastDeliveryChannelDeleteFailedException, AwsServiceException,
            SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the delivery channel.
     * </p>
     * <p>
     * Before you can delete the delivery channel, you must stop the configuration recorder by using the
     * <a>StopConfigurationRecorder</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeliveryChannelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDeliveryChannelRequest#builder()}
     * </p>
     *
     * @param deleteDeliveryChannelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest.Builder} to create a
     *        request. The input for the <a>DeleteDeliveryChannel</a> action. The action accepts the following data, in
     *        JSON format.
     * @return Result of the DeleteDeliveryChannel operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws LastDeliveryChannelDeleteFailedException
     *         You cannot delete the delivery channel you specified because the configuration recorder is running.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteDeliveryChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteDeliveryChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDeliveryChannelResponse deleteDeliveryChannel(
            Consumer<DeleteDeliveryChannelRequest.Builder> deleteDeliveryChannelRequest) throws NoSuchDeliveryChannelException,
            LastDeliveryChannelDeleteFailedException, AwsServiceException, SdkClientException, ConfigException {
        return deleteDeliveryChannel(DeleteDeliveryChannelRequest.builder().applyMutation(deleteDeliveryChannelRequest).build());
    }

    /**
     * <p>
     * Deletes the evaluation results for the specified Config rule. You can specify one Config rule per request. After
     * you delete the evaluation results, you can call the <a>StartConfigRulesEvaluation</a> API to start evaluating
     * your Amazon Web Services resources against the rule.
     * </p>
     *
     * @param deleteEvaluationResultsRequest
     * @return Result of the DeleteEvaluationResults operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteEvaluationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEvaluationResultsResponse deleteEvaluationResults(DeleteEvaluationResultsRequest deleteEvaluationResultsRequest)
            throws NoSuchConfigRuleException, ResourceInUseException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the evaluation results for the specified Config rule. You can specify one Config rule per request. After
     * you delete the evaluation results, you can call the <a>StartConfigRulesEvaluation</a> API to start evaluating
     * your Amazon Web Services resources against the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEvaluationResultsRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEvaluationResultsRequest#builder()}
     * </p>
     *
     * @param deleteEvaluationResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEvaluationResults operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteEvaluationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEvaluationResultsResponse deleteEvaluationResults(
            Consumer<DeleteEvaluationResultsRequest.Builder> deleteEvaluationResultsRequest) throws NoSuchConfigRuleException,
            ResourceInUseException, AwsServiceException, SdkClientException, ConfigException {
        return deleteEvaluationResults(DeleteEvaluationResultsRequest.builder().applyMutation(deleteEvaluationResultsRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified organization Config rule and all of its evaluation results from all member accounts in that
     * organization.
     * </p>
     * <p>
     * Only a management account and a delegated administrator account can delete an organization Config rule. When
     * calling this API with a delegated administrator, you must ensure Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * Config sets the state of a rule to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a rule
     * while it is in this state.
     * </p>
     *
     * @param deleteOrganizationConfigRuleRequest
     * @return Result of the DeleteOrganizationConfigRule operation returned by the service.
     * @throws NoSuchOrganizationConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check
     *         rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying
     *         again.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteOrganizationConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOrganizationConfigRuleResponse deleteOrganizationConfigRule(
            DeleteOrganizationConfigRuleRequest deleteOrganizationConfigRuleRequest)
            throws NoSuchOrganizationConfigRuleException, ResourceInUseException, OrganizationAccessDeniedException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified organization Config rule and all of its evaluation results from all member accounts in that
     * organization.
     * </p>
     * <p>
     * Only a management account and a delegated administrator account can delete an organization Config rule. When
     * calling this API with a delegated administrator, you must ensure Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * Config sets the state of a rule to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a rule
     * while it is in this state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOrganizationConfigRuleRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteOrganizationConfigRuleRequest#builder()}
     * </p>
     *
     * @param deleteOrganizationConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteOrganizationConfigRule operation returned by the service.
     * @throws NoSuchOrganizationConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check
     *         rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying
     *         again.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteOrganizationConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOrganizationConfigRuleResponse deleteOrganizationConfigRule(
            Consumer<DeleteOrganizationConfigRuleRequest.Builder> deleteOrganizationConfigRuleRequest)
            throws NoSuchOrganizationConfigRuleException, ResourceInUseException, OrganizationAccessDeniedException,
            AwsServiceException, SdkClientException, ConfigException {
        return deleteOrganizationConfigRule(DeleteOrganizationConfigRuleRequest.builder()
                .applyMutation(deleteOrganizationConfigRuleRequest).build());
    }

    /**
     * <p>
     * Deletes the specified organization conformance pack and all of the Config rules and remediation actions from all
     * member accounts in that organization.
     * </p>
     * <p>
     * Only a management account or a delegated administrator account can delete an organization conformance pack. When
     * calling this API with a delegated administrator, you must ensure Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * Config sets the state of a conformance pack to DELETE_IN_PROGRESS until the deletion is complete. You cannot
     * update a conformance pack while it is in this state.
     * </p>
     *
     * @param deleteOrganizationConformancePackRequest
     * @return Result of the DeleteOrganizationConformancePack operation returned by the service.
     * @throws NoSuchOrganizationConformancePackException
     *         Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws ResourceInUseException
     *         You see this exception in the following cases:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteOrganizationConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConformancePack"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOrganizationConformancePackResponse deleteOrganizationConformancePack(
            DeleteOrganizationConformancePackRequest deleteOrganizationConformancePackRequest)
            throws NoSuchOrganizationConformancePackException, ResourceInUseException, OrganizationAccessDeniedException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified organization conformance pack and all of the Config rules and remediation actions from all
     * member accounts in that organization.
     * </p>
     * <p>
     * Only a management account or a delegated administrator account can delete an organization conformance pack. When
     * calling this API with a delegated administrator, you must ensure Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * Config sets the state of a conformance pack to DELETE_IN_PROGRESS until the deletion is complete. You cannot
     * update a conformance pack while it is in this state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOrganizationConformancePackRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteOrganizationConformancePackRequest#builder()}
     * </p>
     *
     * @param deleteOrganizationConformancePackRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteOrganizationConformancePack operation returned by the service.
     * @throws NoSuchOrganizationConformancePackException
     *         Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws ResourceInUseException
     *         You see this exception in the following cases:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteOrganizationConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConformancePack"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOrganizationConformancePackResponse deleteOrganizationConformancePack(
            Consumer<DeleteOrganizationConformancePackRequest.Builder> deleteOrganizationConformancePackRequest)
            throws NoSuchOrganizationConformancePackException, ResourceInUseException, OrganizationAccessDeniedException,
            AwsServiceException, SdkClientException, ConfigException {
        return deleteOrganizationConformancePack(DeleteOrganizationConformancePackRequest.builder()
                .applyMutation(deleteOrganizationConformancePackRequest).build());
    }

    /**
     * <p>
     * Deletes pending authorization requests for a specified aggregator account in a specified region.
     * </p>
     *
     * @param deletePendingAggregationRequestRequest
     * @return Result of the DeletePendingAggregationRequest operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeletePendingAggregationRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeletePendingAggregationRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePendingAggregationRequestResponse deletePendingAggregationRequest(
            DeletePendingAggregationRequestRequest deletePendingAggregationRequestRequest) throws InvalidParameterValueException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes pending authorization requests for a specified aggregator account in a specified region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePendingAggregationRequestRequest.Builder}
     * avoiding the need to create one manually via {@link DeletePendingAggregationRequestRequest#builder()}
     * </p>
     *
     * @param deletePendingAggregationRequestRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest.Builder} to
     *        create a request.
     * @return Result of the DeletePendingAggregationRequest operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeletePendingAggregationRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeletePendingAggregationRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePendingAggregationRequestResponse deletePendingAggregationRequest(
            Consumer<DeletePendingAggregationRequestRequest.Builder> deletePendingAggregationRequestRequest)
            throws InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return deletePendingAggregationRequest(DeletePendingAggregationRequestRequest.builder()
                .applyMutation(deletePendingAggregationRequestRequest).build());
    }

    /**
     * <p>
     * Deletes the remediation configuration.
     * </p>
     *
     * @param deleteRemediationConfigurationRequest
     * @return Result of the DeleteRemediationConfiguration operation returned by the service.
     * @throws NoSuchRemediationConfigurationException
     *         You specified an Config rule without a remediation configuration.
     * @throws RemediationInProgressException
     *         Remediation action is in progress. You can either cancel execution in Amazon Web Services Systems Manager
     *         or wait and try again later.
     * @throws InsufficientPermissionsException
     *         Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions
     *         to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have the following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteRemediationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRemediationConfigurationResponse deleteRemediationConfiguration(
            DeleteRemediationConfigurationRequest deleteRemediationConfigurationRequest)
            throws NoSuchRemediationConfigurationException, RemediationInProgressException, InsufficientPermissionsException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the remediation configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRemediationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRemediationConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteRemediationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteRemediationConfiguration operation returned by the service.
     * @throws NoSuchRemediationConfigurationException
     *         You specified an Config rule without a remediation configuration.
     * @throws RemediationInProgressException
     *         Remediation action is in progress. You can either cancel execution in Amazon Web Services Systems Manager
     *         or wait and try again later.
     * @throws InsufficientPermissionsException
     *         Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions
     *         to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have the following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteRemediationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRemediationConfigurationResponse deleteRemediationConfiguration(
            Consumer<DeleteRemediationConfigurationRequest.Builder> deleteRemediationConfigurationRequest)
            throws NoSuchRemediationConfigurationException, RemediationInProgressException, InsufficientPermissionsException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return deleteRemediationConfiguration(DeleteRemediationConfigurationRequest.builder()
                .applyMutation(deleteRemediationConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes one or more remediation exceptions mentioned in the resource keys.
     * </p>
     * <note>
     * <p>
     * Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * </note>
     *
     * @param deleteRemediationExceptionsRequest
     * @return Result of the DeleteRemediationExceptions operation returned by the service.
     * @throws NoSuchRemediationExceptionException
     *         You tried to delete a remediation exception that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRemediationExceptionsResponse deleteRemediationExceptions(
            DeleteRemediationExceptionsRequest deleteRemediationExceptionsRequest) throws NoSuchRemediationExceptionException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more remediation exceptions mentioned in the resource keys.
     * </p>
     * <note>
     * <p>
     * Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRemediationExceptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRemediationExceptionsRequest#builder()}
     * </p>
     *
     * @param deleteRemediationExceptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteRemediationExceptions operation returned by the service.
     * @throws NoSuchRemediationExceptionException
     *         You tried to delete a remediation exception that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRemediationExceptionsResponse deleteRemediationExceptions(
            Consumer<DeleteRemediationExceptionsRequest.Builder> deleteRemediationExceptionsRequest)
            throws NoSuchRemediationExceptionException, AwsServiceException, SdkClientException, ConfigException {
        return deleteRemediationExceptions(DeleteRemediationExceptionsRequest.builder()
                .applyMutation(deleteRemediationExceptionsRequest).build());
    }

    /**
     * <p>
     * Records the configuration state for a custom resource that has been deleted. This API records a new
     * ConfigurationItem with a ResourceDeleted status. You can retrieve the ConfigurationItems recorded for this
     * resource in your Config History.
     * </p>
     *
     * @param deleteResourceConfigRequest
     * @return Result of the DeleteResourceConfig operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws NoRunningConfigurationRecorderException
     *         There is no configuration recorder running.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteResourceConfigResponse deleteResourceConfig(DeleteResourceConfigRequest deleteResourceConfigRequest)
            throws ValidationException, NoRunningConfigurationRecorderException, AwsServiceException, SdkClientException,
            ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Records the configuration state for a custom resource that has been deleted. This API records a new
     * ConfigurationItem with a ResourceDeleted status. You can retrieve the ConfigurationItems recorded for this
     * resource in your Config History.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourceConfigRequest#builder()}
     * </p>
     *
     * @param deleteResourceConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteResourceConfigRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourceConfig operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws NoRunningConfigurationRecorderException
     *         There is no configuration recorder running.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteResourceConfigResponse deleteResourceConfig(
            Consumer<DeleteResourceConfigRequest.Builder> deleteResourceConfigRequest) throws ValidationException,
            NoRunningConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        return deleteResourceConfig(DeleteResourceConfigRequest.builder().applyMutation(deleteResourceConfigRequest).build());
    }

    /**
     * <p>
     * Deletes the retention configuration.
     * </p>
     *
     * @param deleteRetentionConfigurationRequest
     * @return Result of the DeleteRetentionConfiguration operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchRetentionConfigurationException
     *         You have specified a retention configuration that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteRetentionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRetentionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRetentionConfigurationResponse deleteRetentionConfiguration(
            DeleteRetentionConfigurationRequest deleteRetentionConfigurationRequest) throws InvalidParameterValueException,
            NoSuchRetentionConfigurationException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the retention configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRetentionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRetentionConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteRetentionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteRetentionConfiguration operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchRetentionConfigurationException
     *         You have specified a retention configuration that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteRetentionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRetentionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRetentionConfigurationResponse deleteRetentionConfiguration(
            Consumer<DeleteRetentionConfigurationRequest.Builder> deleteRetentionConfigurationRequest)
            throws InvalidParameterValueException, NoSuchRetentionConfigurationException, AwsServiceException,
            SdkClientException, ConfigException {
        return deleteRetentionConfiguration(DeleteRetentionConfigurationRequest.builder()
                .applyMutation(deleteRetentionConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the stored query for a single Amazon Web Services account and a single Amazon Web Services Region.
     * </p>
     *
     * @param deleteStoredQueryRequest
     * @return Result of the DeleteStoredQuery operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws ResourceNotFoundException
     *         You have specified a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteStoredQueryResponse deleteStoredQuery(DeleteStoredQueryRequest deleteStoredQueryRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the stored query for a single Amazon Web Services account and a single Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStoredQueryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteStoredQueryRequest#builder()}
     * </p>
     *
     * @param deleteStoredQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeleteStoredQueryRequest.Builder} to create a request.
     * @return Result of the DeleteStoredQuery operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws ResourceNotFoundException
     *         You have specified a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeleteStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteStoredQueryResponse deleteStoredQuery(Consumer<DeleteStoredQueryRequest.Builder> deleteStoredQueryRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, ConfigException {
        return deleteStoredQuery(DeleteStoredQueryRequest.builder().applyMutation(deleteStoredQueryRequest).build());
    }

    /**
     * <p>
     * Schedules delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel. After
     * the delivery has started, Config sends the following notifications using an Amazon SNS topic that you have
     * specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Notification of the start of the delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of the completion of the delivery, if the delivery was successfully completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of delivery failure, if the delivery failed.
     * </p>
     * </li>
     * </ul>
     *
     * @param deliverConfigSnapshotRequest
     *        The input for the <a>DeliverConfigSnapshot</a> action.
     * @return Result of the DeliverConfigSnapshot operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws NoRunningConfigurationRecorderException
     *         There is no configuration recorder running.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeliverConfigSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default DeliverConfigSnapshotResponse deliverConfigSnapshot(DeliverConfigSnapshotRequest deliverConfigSnapshotRequest)
            throws NoSuchDeliveryChannelException, NoAvailableConfigurationRecorderException,
            NoRunningConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Schedules delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel. After
     * the delivery has started, Config sends the following notifications using an Amazon SNS topic that you have
     * specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Notification of the start of the delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of the completion of the delivery, if the delivery was successfully completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of delivery failure, if the delivery failed.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeliverConfigSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link DeliverConfigSnapshotRequest#builder()}
     * </p>
     *
     * @param deliverConfigSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest.Builder} to create a
     *        request. The input for the <a>DeliverConfigSnapshot</a> action.
     * @return Result of the DeliverConfigSnapshot operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws NoRunningConfigurationRecorderException
     *         There is no configuration recorder running.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DeliverConfigSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default DeliverConfigSnapshotResponse deliverConfigSnapshot(
            Consumer<DeliverConfigSnapshotRequest.Builder> deliverConfigSnapshotRequest) throws NoSuchDeliveryChannelException,
            NoAvailableConfigurationRecorderException, NoRunningConfigurationRecorderException, AwsServiceException,
            SdkClientException, ConfigException {
        return deliverConfigSnapshot(DeliverConfigSnapshotRequest.builder().applyMutation(deliverConfigSnapshotRequest).build());
    }

    /**
     * <p>
     * Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant
     * rules. Does not display rules that do not have compliance results.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param describeAggregateComplianceByConfigRulesRequest
     * @return Result of the DescribeAggregateComplianceByConfigRules operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregateComplianceByConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregateComplianceByConfigRulesResponse describeAggregateComplianceByConfigRules(
            DescribeAggregateComplianceByConfigRulesRequest describeAggregateComplianceByConfigRulesRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant
     * rules. Does not display rules that do not have compliance results.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAggregateComplianceByConfigRulesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAggregateComplianceByConfigRulesRequest#builder()}
     * </p>
     *
     * @param describeAggregateComplianceByConfigRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeAggregateComplianceByConfigRules operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregateComplianceByConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregateComplianceByConfigRulesResponse describeAggregateComplianceByConfigRules(
            Consumer<DescribeAggregateComplianceByConfigRulesRequest.Builder> describeAggregateComplianceByConfigRulesRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return describeAggregateComplianceByConfigRules(DescribeAggregateComplianceByConfigRulesRequest.builder()
                .applyMutation(describeAggregateComplianceByConfigRulesRequest).build());
    }

    /**
     * <p>
     * Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant
     * rules. Does not display rules that do not have compliance results.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeAggregateComplianceByConfigRules(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConfigRulesIterable responses = client.describeAggregateComplianceByConfigRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConfigRulesIterable responses = client
     *             .describeAggregateComplianceByConfigRulesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConfigRulesIterable responses = client.describeAggregateComplianceByConfigRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregateComplianceByConfigRules(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAggregateComplianceByConfigRulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregateComplianceByConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregateComplianceByConfigRulesIterable describeAggregateComplianceByConfigRulesPaginator(
            DescribeAggregateComplianceByConfigRulesRequest describeAggregateComplianceByConfigRulesRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return new DescribeAggregateComplianceByConfigRulesIterable(this, describeAggregateComplianceByConfigRulesRequest);
    }

    /**
     * <p>
     * Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant
     * rules. Does not display rules that do not have compliance results.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeAggregateComplianceByConfigRules(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConfigRulesIterable responses = client.describeAggregateComplianceByConfigRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConfigRulesIterable responses = client
     *             .describeAggregateComplianceByConfigRulesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConfigRulesIterable responses = client.describeAggregateComplianceByConfigRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregateComplianceByConfigRules(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAggregateComplianceByConfigRulesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAggregateComplianceByConfigRulesRequest#builder()}
     * </p>
     *
     * @param describeAggregateComplianceByConfigRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregateComplianceByConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregateComplianceByConfigRulesIterable describeAggregateComplianceByConfigRulesPaginator(
            Consumer<DescribeAggregateComplianceByConfigRulesRequest.Builder> describeAggregateComplianceByConfigRulesRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return describeAggregateComplianceByConfigRulesPaginator(DescribeAggregateComplianceByConfigRulesRequest.builder()
                .applyMutation(describeAggregateComplianceByConfigRulesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the conformance packs and their associated compliance status with the count of compliant and
     * noncompliant Config rules within each conformance pack. Also returns the total rule count which includes
     * compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param describeAggregateComplianceByConformancePacksRequest
     * @return Result of the DescribeAggregateComplianceByConformancePacks operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregateComplianceByConformancePacks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregateComplianceByConformancePacksResponse describeAggregateComplianceByConformancePacks(
            DescribeAggregateComplianceByConformancePacksRequest describeAggregateComplianceByConformancePacksRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the conformance packs and their associated compliance status with the count of compliant and
     * noncompliant Config rules within each conformance pack. Also returns the total rule count which includes
     * compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAggregateComplianceByConformancePacksRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAggregateComplianceByConformancePacksRequest#builder()}
     * </p>
     *
     * @param describeAggregateComplianceByConformancePacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeAggregateComplianceByConformancePacks operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregateComplianceByConformancePacks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregateComplianceByConformancePacksResponse describeAggregateComplianceByConformancePacks(
            Consumer<DescribeAggregateComplianceByConformancePacksRequest.Builder> describeAggregateComplianceByConformancePacksRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return describeAggregateComplianceByConformancePacks(DescribeAggregateComplianceByConformancePacksRequest.builder()
                .applyMutation(describeAggregateComplianceByConformancePacksRequest).build());
    }

    /**
     * <p>
     * Returns a list of the conformance packs and their associated compliance status with the count of compliant and
     * noncompliant Config rules within each conformance pack. Also returns the total rule count which includes
     * compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeAggregateComplianceByConformancePacks(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConformancePacksIterable responses = client.describeAggregateComplianceByConformancePacksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConformancePacksIterable responses = client
     *             .describeAggregateComplianceByConformancePacksPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConformancePacksIterable responses = client.describeAggregateComplianceByConformancePacksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregateComplianceByConformancePacks(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAggregateComplianceByConformancePacksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregateComplianceByConformancePacks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregateComplianceByConformancePacksIterable describeAggregateComplianceByConformancePacksPaginator(
            DescribeAggregateComplianceByConformancePacksRequest describeAggregateComplianceByConformancePacksRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return new DescribeAggregateComplianceByConformancePacksIterable(this,
                describeAggregateComplianceByConformancePacksRequest);
    }

    /**
     * <p>
     * Returns a list of the conformance packs and their associated compliance status with the count of compliant and
     * noncompliant Config rules within each conformance pack. Also returns the total rule count which includes
     * compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeAggregateComplianceByConformancePacks(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConformancePacksIterable responses = client.describeAggregateComplianceByConformancePacksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConformancePacksIterable responses = client
     *             .describeAggregateComplianceByConformancePacksPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregateComplianceByConformancePacksIterable responses = client.describeAggregateComplianceByConformancePacksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregateComplianceByConformancePacks(software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeAggregateComplianceByConformancePacksRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeAggregateComplianceByConformancePacksRequest#builder()}
     * </p>
     *
     * @param describeAggregateComplianceByConformancePacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregateComplianceByConformancePacks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregateComplianceByConformancePacksIterable describeAggregateComplianceByConformancePacksPaginator(
            Consumer<DescribeAggregateComplianceByConformancePacksRequest.Builder> describeAggregateComplianceByConformancePacksRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return describeAggregateComplianceByConformancePacksPaginator(DescribeAggregateComplianceByConformancePacksRequest
                .builder().applyMutation(describeAggregateComplianceByConformancePacksRequest).build());
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     *
     * @param describeAggregationAuthorizationsRequest
     * @return Result of the DescribeAggregationAuthorizations operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregationAuthorizationsResponse describeAggregationAuthorizations(
            DescribeAggregationAuthorizationsRequest describeAggregationAuthorizationsRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException,
            SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAggregationAuthorizationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAggregationAuthorizationsRequest#builder()}
     * </p>
     *
     * @param describeAggregationAuthorizationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeAggregationAuthorizations operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregationAuthorizationsResponse describeAggregationAuthorizations(
            Consumer<DescribeAggregationAuthorizationsRequest.Builder> describeAggregationAuthorizationsRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException,
            SdkClientException, ConfigException {
        return describeAggregationAuthorizations(DescribeAggregationAuthorizationsRequest.builder()
                .applyMutation(describeAggregationAuthorizationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     *
     * @return Result of the DescribeAggregationAuthorizations operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregationAuthorizations
     * @see #describeAggregationAuthorizations(DescribeAggregationAuthorizationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregationAuthorizationsResponse describeAggregationAuthorizations() throws InvalidParameterValueException,
            InvalidNextTokenException, InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        return describeAggregationAuthorizations(DescribeAggregationAuthorizationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAggregationAuthorizations(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsIterable responses = client.describeAggregationAuthorizationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsIterable responses = client
     *             .describeAggregationAuthorizationsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsIterable responses = client.describeAggregationAuthorizationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregationAuthorizations(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregationAuthorizations
     * @see #describeAggregationAuthorizationsPaginator(DescribeAggregationAuthorizationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregationAuthorizationsIterable describeAggregationAuthorizationsPaginator()
            throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException,
            SdkClientException, ConfigException {
        return describeAggregationAuthorizationsPaginator(DescribeAggregationAuthorizationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAggregationAuthorizations(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsIterable responses = client.describeAggregationAuthorizationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsIterable responses = client
     *             .describeAggregationAuthorizationsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsIterable responses = client.describeAggregationAuthorizationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregationAuthorizations(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAggregationAuthorizationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregationAuthorizationsIterable describeAggregationAuthorizationsPaginator(
            DescribeAggregationAuthorizationsRequest describeAggregationAuthorizationsRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException,
            SdkClientException, ConfigException {
        return new DescribeAggregationAuthorizationsIterable(this, describeAggregationAuthorizationsRequest);
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAggregationAuthorizations(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsIterable responses = client.describeAggregationAuthorizationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsIterable responses = client
     *             .describeAggregationAuthorizationsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeAggregationAuthorizationsIterable responses = client.describeAggregationAuthorizationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAggregationAuthorizations(software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAggregationAuthorizationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAggregationAuthorizationsRequest#builder()}
     * </p>
     *
     * @param describeAggregationAuthorizationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAggregationAuthorizationsIterable describeAggregationAuthorizationsPaginator(
            Consumer<DescribeAggregationAuthorizationsRequest.Builder> describeAggregationAuthorizationsRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException,
            SdkClientException, ConfigException {
        return describeAggregationAuthorizationsPaginator(DescribeAggregationAuthorizationsRequest.builder()
                .applyMutation(describeAggregationAuthorizationsRequest).build());
    }

    /**
     * <p>
     * Indicates whether the specified Config rules are compliant. If a rule is noncompliant, this action returns the
     * number of Amazon Web Services resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This result
     * might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role you assigned to
     * your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule is a custom
     * rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeComplianceByConfigRuleRequest
     * @return Result of the DescribeComplianceByConfigRule operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByConfigRuleResponse describeComplianceByConfigRule(
            DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) throws InvalidParameterValueException,
            NoSuchConfigRuleException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Indicates whether the specified Config rules are compliant. If a rule is noncompliant, this action returns the
     * number of Amazon Web Services resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This result
     * might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role you assigned to
     * your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule is a custom
     * rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComplianceByConfigRuleRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeComplianceByConfigRuleRequest#builder()}
     * </p>
     *
     * @param describeComplianceByConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeComplianceByConfigRule operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByConfigRuleResponse describeComplianceByConfigRule(
            Consumer<DescribeComplianceByConfigRuleRequest.Builder> describeComplianceByConfigRuleRequest)
            throws InvalidParameterValueException, NoSuchConfigRuleException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        return describeComplianceByConfigRule(DescribeComplianceByConfigRuleRequest.builder()
                .applyMutation(describeComplianceByConfigRuleRequest).build());
    }

    /**
     * <p>
     * Indicates whether the specified Config rules are compliant. If a rule is noncompliant, this action returns the
     * number of Amazon Web Services resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This result
     * might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role you assigned to
     * your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule is a custom
     * rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @return Result of the DescribeComplianceByConfigRule operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeComplianceByConfigRule
     * @see #describeComplianceByConfigRule(DescribeComplianceByConfigRuleRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByConfigRuleResponse describeComplianceByConfigRule() throws InvalidParameterValueException,
            NoSuchConfigRuleException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        return describeComplianceByConfigRule(DescribeComplianceByConfigRuleRequest.builder().build());
    }

    /**
     * <p>
     * Indicates whether the specified Config rules are compliant. If a rule is noncompliant, this action returns the
     * number of Amazon Web Services resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This result
     * might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role you assigned to
     * your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule is a custom
     * rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeComplianceByConfigRule(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRuleIterable responses = client.describeComplianceByConfigRulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRuleIterable responses = client
     *             .describeComplianceByConfigRulePaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRuleIterable responses = client.describeComplianceByConfigRulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComplianceByConfigRule(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeComplianceByConfigRule
     * @see #describeComplianceByConfigRulePaginator(DescribeComplianceByConfigRuleRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByConfigRuleIterable describeComplianceByConfigRulePaginator()
            throws InvalidParameterValueException, NoSuchConfigRuleException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        return describeComplianceByConfigRulePaginator(DescribeComplianceByConfigRuleRequest.builder().build());
    }

    /**
     * <p>
     * Indicates whether the specified Config rules are compliant. If a rule is noncompliant, this action returns the
     * number of Amazon Web Services resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This result
     * might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role you assigned to
     * your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule is a custom
     * rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeComplianceByConfigRule(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRuleIterable responses = client.describeComplianceByConfigRulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRuleIterable responses = client
     *             .describeComplianceByConfigRulePaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRuleIterable responses = client.describeComplianceByConfigRulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComplianceByConfigRule(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeComplianceByConfigRuleRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByConfigRuleIterable describeComplianceByConfigRulePaginator(
            DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) throws InvalidParameterValueException,
            NoSuchConfigRuleException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        return new DescribeComplianceByConfigRuleIterable(this, describeComplianceByConfigRuleRequest);
    }

    /**
     * <p>
     * Indicates whether the specified Config rules are compliant. If a rule is noncompliant, this action returns the
     * number of Amazon Web Services resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This result
     * might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role you assigned to
     * your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule is a custom
     * rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeComplianceByConfigRule(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRuleIterable responses = client.describeComplianceByConfigRulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRuleIterable responses = client
     *             .describeComplianceByConfigRulePaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByConfigRuleIterable responses = client.describeComplianceByConfigRulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComplianceByConfigRule(software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComplianceByConfigRuleRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeComplianceByConfigRuleRequest#builder()}
     * </p>
     *
     * @param describeComplianceByConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByConfigRuleIterable describeComplianceByConfigRulePaginator(
            Consumer<DescribeComplianceByConfigRuleRequest.Builder> describeComplianceByConfigRuleRequest)
            throws InvalidParameterValueException, NoSuchConfigRuleException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        return describeComplianceByConfigRulePaginator(DescribeComplianceByConfigRuleRequest.builder()
                .applyMutation(describeComplianceByConfigRuleRequest).build());
    }

    /**
     * <p>
     * Indicates whether the specified Amazon Web Services resources are compliant. If a resource is noncompliant, this
     * action returns the number of Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the Config rules that evaluate it. It is noncompliant if it does
     * not comply with one or more of these rules.
     * </p>
     * <p>
     * If Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeComplianceByResourceRequest
     * @return Result of the DescribeComplianceByResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByResourceResponse describeComplianceByResource(
            DescribeComplianceByResourceRequest describeComplianceByResourceRequest) throws InvalidParameterValueException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Indicates whether the specified Amazon Web Services resources are compliant. If a resource is noncompliant, this
     * action returns the number of Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the Config rules that evaluate it. It is noncompliant if it does
     * not comply with one or more of these rules.
     * </p>
     * <p>
     * If Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComplianceByResourceRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeComplianceByResourceRequest#builder()}
     * </p>
     *
     * @param describeComplianceByResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeComplianceByResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByResourceResponse describeComplianceByResource(
            Consumer<DescribeComplianceByResourceRequest.Builder> describeComplianceByResourceRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            ConfigException {
        return describeComplianceByResource(DescribeComplianceByResourceRequest.builder()
                .applyMutation(describeComplianceByResourceRequest).build());
    }

    /**
     * <p>
     * Indicates whether the specified Amazon Web Services resources are compliant. If a resource is noncompliant, this
     * action returns the number of Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the Config rules that evaluate it. It is noncompliant if it does
     * not comply with one or more of these rules.
     * </p>
     * <p>
     * If Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @return Result of the DescribeComplianceByResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeComplianceByResource
     * @see #describeComplianceByResource(DescribeComplianceByResourceRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByResourceResponse describeComplianceByResource() throws InvalidParameterValueException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        return describeComplianceByResource(DescribeComplianceByResourceRequest.builder().build());
    }

    /**
     * <p>
     * Indicates whether the specified Amazon Web Services resources are compliant. If a resource is noncompliant, this
     * action returns the number of Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the Config rules that evaluate it. It is noncompliant if it does
     * not comply with one or more of these rules.
     * </p>
     * <p>
     * If Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeComplianceByResource(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourceIterable responses = client.describeComplianceByResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourceIterable responses = client
     *             .describeComplianceByResourcePaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourceIterable responses = client.describeComplianceByResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComplianceByResource(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeComplianceByResource
     * @see #describeComplianceByResourcePaginator(DescribeComplianceByResourceRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByResourceIterable describeComplianceByResourcePaginator() throws InvalidParameterValueException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        return describeComplianceByResourcePaginator(DescribeComplianceByResourceRequest.builder().build());
    }

    /**
     * <p>
     * Indicates whether the specified Amazon Web Services resources are compliant. If a resource is noncompliant, this
     * action returns the number of Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the Config rules that evaluate it. It is noncompliant if it does
     * not comply with one or more of these rules.
     * </p>
     * <p>
     * If Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeComplianceByResource(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourceIterable responses = client.describeComplianceByResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourceIterable responses = client
     *             .describeComplianceByResourcePaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourceIterable responses = client.describeComplianceByResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComplianceByResource(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeComplianceByResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByResourceIterable describeComplianceByResourcePaginator(
            DescribeComplianceByResourceRequest describeComplianceByResourceRequest) throws InvalidParameterValueException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        return new DescribeComplianceByResourceIterable(this, describeComplianceByResourceRequest);
    }

    /**
     * <p>
     * Indicates whether the specified Amazon Web Services resources are compliant. If a resource is noncompliant, this
     * action returns the number of Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the Config rules that evaluate it. It is noncompliant if it does
     * not comply with one or more of these rules.
     * </p>
     * <p>
     * If Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeComplianceByResource(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourceIterable responses = client.describeComplianceByResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourceIterable responses = client
     *             .describeComplianceByResourcePaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeComplianceByResourceIterable responses = client.describeComplianceByResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeComplianceByResource(software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComplianceByResourceRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeComplianceByResourceRequest#builder()}
     * </p>
     *
     * @param describeComplianceByResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeComplianceByResourceIterable describeComplianceByResourcePaginator(
            Consumer<DescribeComplianceByResourceRequest.Builder> describeComplianceByResourceRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            ConfigException {
        return describeComplianceByResourcePaginator(DescribeComplianceByResourceRequest.builder()
                .applyMutation(describeComplianceByResourceRequest).build());
    }

    /**
     * <p>
     * Returns status information for each of your Config managed rules. The status includes information such as the
     * last time Config invoked the rule, the last time Config failed to invoke the rule, and the related error for the
     * last failure.
     * </p>
     *
     * @param describeConfigRuleEvaluationStatusRequest
     * @return Result of the DescribeConfigRuleEvaluationStatus operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigRuleEvaluationStatusResponse describeConfigRuleEvaluationStatus(
            DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest)
            throws NoSuchConfigRuleException, InvalidParameterValueException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns status information for each of your Config managed rules. The status includes information such as the
     * last time Config invoked the rule, the last time Config failed to invoke the rule, and the related error for the
     * last failure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigRuleEvaluationStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigRuleEvaluationStatusRequest#builder()}
     * </p>
     *
     * @param describeConfigRuleEvaluationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeConfigRuleEvaluationStatus operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigRuleEvaluationStatusResponse describeConfigRuleEvaluationStatus(
            Consumer<DescribeConfigRuleEvaluationStatusRequest.Builder> describeConfigRuleEvaluationStatusRequest)
            throws NoSuchConfigRuleException, InvalidParameterValueException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        return describeConfigRuleEvaluationStatus(DescribeConfigRuleEvaluationStatusRequest.builder()
                .applyMutation(describeConfigRuleEvaluationStatusRequest).build());
    }

    /**
     * <p>
     * Returns status information for each of your Config managed rules. The status includes information such as the
     * last time Config invoked the rule, the last time Config failed to invoke the rule, and the related error for the
     * last failure.
     * </p>
     *
     * @return Result of the DescribeConfigRuleEvaluationStatus operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigRuleEvaluationStatus
     * @see #describeConfigRuleEvaluationStatus(DescribeConfigRuleEvaluationStatusRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigRuleEvaluationStatusResponse describeConfigRuleEvaluationStatus() throws NoSuchConfigRuleException,
            InvalidParameterValueException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        return describeConfigRuleEvaluationStatus(DescribeConfigRuleEvaluationStatusRequest.builder().build());
    }

    /**
     * <p>
     * Returns status information for each of your Config managed rules. The status includes information such as the
     * last time Config invoked the rule, the last time Config failed to invoke the rule, and the related error for the
     * last failure.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConfigRuleEvaluationStatus(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusIterable responses = client.describeConfigRuleEvaluationStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusIterable responses = client
     *             .describeConfigRuleEvaluationStatusPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusIterable responses = client.describeConfigRuleEvaluationStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigRuleEvaluationStatus(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigRuleEvaluationStatus
     * @see #describeConfigRuleEvaluationStatusPaginator(DescribeConfigRuleEvaluationStatusRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigRuleEvaluationStatusIterable describeConfigRuleEvaluationStatusPaginator()
            throws NoSuchConfigRuleException, InvalidParameterValueException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        return describeConfigRuleEvaluationStatusPaginator(DescribeConfigRuleEvaluationStatusRequest.builder().build());
    }

    /**
     * <p>
     * Returns status information for each of your Config managed rules. The status includes information such as the
     * last time Config invoked the rule, the last time Config failed to invoke the rule, and the related error for the
     * last failure.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConfigRuleEvaluationStatus(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusIterable responses = client.describeConfigRuleEvaluationStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusIterable responses = client
     *             .describeConfigRuleEvaluationStatusPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusIterable responses = client.describeConfigRuleEvaluationStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigRuleEvaluationStatus(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConfigRuleEvaluationStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigRuleEvaluationStatusIterable describeConfigRuleEvaluationStatusPaginator(
            DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest)
            throws NoSuchConfigRuleException, InvalidParameterValueException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        return new DescribeConfigRuleEvaluationStatusIterable(this, describeConfigRuleEvaluationStatusRequest);
    }

    /**
     * <p>
     * Returns status information for each of your Config managed rules. The status includes information such as the
     * last time Config invoked the rule, the last time Config failed to invoke the rule, and the related error for the
     * last failure.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConfigRuleEvaluationStatus(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusIterable responses = client.describeConfigRuleEvaluationStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusIterable responses = client
     *             .describeConfigRuleEvaluationStatusPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRuleEvaluationStatusIterable responses = client.describeConfigRuleEvaluationStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigRuleEvaluationStatus(software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigRuleEvaluationStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigRuleEvaluationStatusRequest#builder()}
     * </p>
     *
     * @param describeConfigRuleEvaluationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigRuleEvaluationStatusIterable describeConfigRuleEvaluationStatusPaginator(
            Consumer<DescribeConfigRuleEvaluationStatusRequest.Builder> describeConfigRuleEvaluationStatusRequest)
            throws NoSuchConfigRuleException, InvalidParameterValueException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        return describeConfigRuleEvaluationStatusPaginator(DescribeConfigRuleEvaluationStatusRequest.builder()
                .applyMutation(describeConfigRuleEvaluationStatusRequest).build());
    }

    /**
     * <p>
     * Returns details about your Config rules.
     * </p>
     *
     * @param describeConfigRulesRequest
     * @return Result of the DescribeConfigRules operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConfigRulesResponse describeConfigRules(DescribeConfigRulesRequest describeConfigRulesRequest)
            throws NoSuchConfigRuleException, InvalidNextTokenException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about your Config rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigRulesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConfigRulesRequest#builder()}
     * </p>
     *
     * @param describeConfigRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeConfigRules operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConfigRulesResponse describeConfigRules(
            Consumer<DescribeConfigRulesRequest.Builder> describeConfigRulesRequest) throws NoSuchConfigRuleException,
            InvalidNextTokenException, InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return describeConfigRules(DescribeConfigRulesRequest.builder().applyMutation(describeConfigRulesRequest).build());
    }

    /**
     * <p>
     * Returns details about your Config rules.
     * </p>
     *
     * @return Result of the DescribeConfigRules operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigRules
     * @see #describeConfigRules(DescribeConfigRulesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConfigRulesResponse describeConfigRules() throws NoSuchConfigRuleException, InvalidNextTokenException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return describeConfigRules(DescribeConfigRulesRequest.builder().build());
    }

    /**
     * <p>
     * Returns details about your Config rules.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConfigRules(software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRulesIterable responses = client.describeConfigRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConfigRulesIterable responses = client
     *             .describeConfigRulesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRulesIterable responses = client.describeConfigRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigRules(software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigRules
     * @see #describeConfigRulesPaginator(DescribeConfigRulesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConfigRulesIterable describeConfigRulesPaginator() throws NoSuchConfigRuleException,
            InvalidNextTokenException, InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return describeConfigRulesPaginator(DescribeConfigRulesRequest.builder().build());
    }

    /**
     * <p>
     * Returns details about your Config rules.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConfigRules(software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRulesIterable responses = client.describeConfigRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConfigRulesIterable responses = client
     *             .describeConfigRulesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRulesIterable responses = client.describeConfigRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigRules(software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConfigRulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConfigRulesIterable describeConfigRulesPaginator(DescribeConfigRulesRequest describeConfigRulesRequest)
            throws NoSuchConfigRuleException, InvalidNextTokenException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, ConfigException {
        return new DescribeConfigRulesIterable(this, describeConfigRulesRequest);
    }

    /**
     * <p>
     * Returns details about your Config rules.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConfigRules(software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRulesIterable responses = client.describeConfigRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConfigRulesIterable responses = client
     *             .describeConfigRulesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigRulesIterable responses = client.describeConfigRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigRules(software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigRulesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConfigRulesRequest#builder()}
     * </p>
     *
     * @param describeConfigRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConfigRulesIterable describeConfigRulesPaginator(
            Consumer<DescribeConfigRulesRequest.Builder> describeConfigRulesRequest) throws NoSuchConfigRuleException,
            InvalidNextTokenException, InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return describeConfigRulesPaginator(DescribeConfigRulesRequest.builder().applyMutation(describeConfigRulesRequest)
                .build());
    }

    /**
     * <p>
     * Returns status information for sources within an aggregator. The status includes information about the last time
     * Config verified authorization between the source account and an aggregator account. In case of a failure, the
     * status contains the related error code or message.
     * </p>
     *
     * @param describeConfigurationAggregatorSourcesStatusRequest
     * @return Result of the DescribeConfigurationAggregatorSourcesStatus operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationAggregatorSourcesStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationAggregatorSourcesStatusResponse describeConfigurationAggregatorSourcesStatus(
            DescribeConfigurationAggregatorSourcesStatusRequest describeConfigurationAggregatorSourcesStatusRequest)
            throws InvalidParameterValueException, NoSuchConfigurationAggregatorException, InvalidNextTokenException,
            InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns status information for sources within an aggregator. The status includes information about the last time
     * Config verified authorization between the source account and an aggregator account. In case of a failure, the
     * status contains the related error code or message.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeConfigurationAggregatorSourcesStatusRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeConfigurationAggregatorSourcesStatusRequest#builder()}
     * </p>
     *
     * @param describeConfigurationAggregatorSourcesStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeConfigurationAggregatorSourcesStatus operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationAggregatorSourcesStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationAggregatorSourcesStatusResponse describeConfigurationAggregatorSourcesStatus(
            Consumer<DescribeConfigurationAggregatorSourcesStatusRequest.Builder> describeConfigurationAggregatorSourcesStatusRequest)
            throws InvalidParameterValueException, NoSuchConfigurationAggregatorException, InvalidNextTokenException,
            InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        return describeConfigurationAggregatorSourcesStatus(DescribeConfigurationAggregatorSourcesStatusRequest.builder()
                .applyMutation(describeConfigurationAggregatorSourcesStatusRequest).build());
    }

    /**
     * <p>
     * Returns status information for sources within an aggregator. The status includes information about the last time
     * Config verified authorization between the source account and an aggregator account. In case of a failure, the
     * status contains the related error code or message.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConfigurationAggregatorSourcesStatus(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorSourcesStatusIterable responses = client.describeConfigurationAggregatorSourcesStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorSourcesStatusIterable responses = client
     *             .describeConfigurationAggregatorSourcesStatusPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorSourcesStatusIterable responses = client.describeConfigurationAggregatorSourcesStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationAggregatorSourcesStatus(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConfigurationAggregatorSourcesStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationAggregatorSourcesStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationAggregatorSourcesStatusIterable describeConfigurationAggregatorSourcesStatusPaginator(
            DescribeConfigurationAggregatorSourcesStatusRequest describeConfigurationAggregatorSourcesStatusRequest)
            throws InvalidParameterValueException, NoSuchConfigurationAggregatorException, InvalidNextTokenException,
            InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        return new DescribeConfigurationAggregatorSourcesStatusIterable(this, describeConfigurationAggregatorSourcesStatusRequest);
    }

    /**
     * <p>
     * Returns status information for sources within an aggregator. The status includes information about the last time
     * Config verified authorization between the source account and an aggregator account. In case of a failure, the
     * status contains the related error code or message.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConfigurationAggregatorSourcesStatus(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorSourcesStatusIterable responses = client.describeConfigurationAggregatorSourcesStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorSourcesStatusIterable responses = client
     *             .describeConfigurationAggregatorSourcesStatusPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorSourcesStatusIterable responses = client.describeConfigurationAggregatorSourcesStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationAggregatorSourcesStatus(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeConfigurationAggregatorSourcesStatusRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeConfigurationAggregatorSourcesStatusRequest#builder()}
     * </p>
     *
     * @param describeConfigurationAggregatorSourcesStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationAggregatorSourcesStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationAggregatorSourcesStatusIterable describeConfigurationAggregatorSourcesStatusPaginator(
            Consumer<DescribeConfigurationAggregatorSourcesStatusRequest.Builder> describeConfigurationAggregatorSourcesStatusRequest)
            throws InvalidParameterValueException, NoSuchConfigurationAggregatorException, InvalidNextTokenException,
            InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        return describeConfigurationAggregatorSourcesStatusPaginator(DescribeConfigurationAggregatorSourcesStatusRequest
                .builder().applyMutation(describeConfigurationAggregatorSourcesStatusRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified,
     * this action returns the details for all the configuration aggregators associated with the account.
     * </p>
     *
     * @param describeConfigurationAggregatorsRequest
     * @return Result of the DescribeConfigurationAggregators operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationAggregatorsResponse describeConfigurationAggregators(
            DescribeConfigurationAggregatorsRequest describeConfigurationAggregatorsRequest)
            throws InvalidParameterValueException, NoSuchConfigurationAggregatorException, InvalidNextTokenException,
            InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified,
     * this action returns the details for all the configuration aggregators associated with the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationAggregatorsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationAggregatorsRequest#builder()}
     * </p>
     *
     * @param describeConfigurationAggregatorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeConfigurationAggregators operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationAggregatorsResponse describeConfigurationAggregators(
            Consumer<DescribeConfigurationAggregatorsRequest.Builder> describeConfigurationAggregatorsRequest)
            throws InvalidParameterValueException, NoSuchConfigurationAggregatorException, InvalidNextTokenException,
            InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        return describeConfigurationAggregators(DescribeConfigurationAggregatorsRequest.builder()
                .applyMutation(describeConfigurationAggregatorsRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified,
     * this action returns the details for all the configuration aggregators associated with the account.
     * </p>
     *
     * @return Result of the DescribeConfigurationAggregators operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationAggregators
     * @see #describeConfigurationAggregators(DescribeConfigurationAggregatorsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationAggregatorsResponse describeConfigurationAggregators() throws InvalidParameterValueException,
            NoSuchConfigurationAggregatorException, InvalidNextTokenException, InvalidLimitException, AwsServiceException,
            SdkClientException, ConfigException {
        return describeConfigurationAggregators(DescribeConfigurationAggregatorsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified,
     * this action returns the details for all the configuration aggregators associated with the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConfigurationAggregators(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsIterable responses = client.describeConfigurationAggregatorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsIterable responses = client
     *             .describeConfigurationAggregatorsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsIterable responses = client.describeConfigurationAggregatorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationAggregators(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationAggregators
     * @see #describeConfigurationAggregatorsPaginator(DescribeConfigurationAggregatorsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationAggregatorsIterable describeConfigurationAggregatorsPaginator()
            throws InvalidParameterValueException, NoSuchConfigurationAggregatorException, InvalidNextTokenException,
            InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        return describeConfigurationAggregatorsPaginator(DescribeConfigurationAggregatorsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified,
     * this action returns the details for all the configuration aggregators associated with the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConfigurationAggregators(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsIterable responses = client.describeConfigurationAggregatorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsIterable responses = client
     *             .describeConfigurationAggregatorsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsIterable responses = client.describeConfigurationAggregatorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationAggregators(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConfigurationAggregatorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationAggregatorsIterable describeConfigurationAggregatorsPaginator(
            DescribeConfigurationAggregatorsRequest describeConfigurationAggregatorsRequest)
            throws InvalidParameterValueException, NoSuchConfigurationAggregatorException, InvalidNextTokenException,
            InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        return new DescribeConfigurationAggregatorsIterable(this, describeConfigurationAggregatorsRequest);
    }

    /**
     * <p>
     * Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified,
     * this action returns the details for all the configuration aggregators associated with the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConfigurationAggregators(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsIterable responses = client.describeConfigurationAggregatorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsIterable responses = client
     *             .describeConfigurationAggregatorsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConfigurationAggregatorsIterable responses = client.describeConfigurationAggregatorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConfigurationAggregators(software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationAggregatorsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationAggregatorsRequest#builder()}
     * </p>
     *
     * @param describeConfigurationAggregatorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationAggregatorsIterable describeConfigurationAggregatorsPaginator(
            Consumer<DescribeConfigurationAggregatorsRequest.Builder> describeConfigurationAggregatorsRequest)
            throws InvalidParameterValueException, NoSuchConfigurationAggregatorException, InvalidNextTokenException,
            InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        return describeConfigurationAggregatorsPaginator(DescribeConfigurationAggregatorsRequest.builder()
                .applyMutation(describeConfigurationAggregatorsRequest).build());
    }

    /**
     * <p>
     * Returns the current status of the specified configuration recorder as well as the status of the last recording
     * event for the recorder. If a configuration recorder is not specified, this action returns the status of all
     * configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * &gt;You can specify only one configuration recorder for each Amazon Web Services Region for each account. For a
     * detailed status of recording events over time, add your Config events to Amazon CloudWatch metrics and use
     * CloudWatch metrics.
     * </p>
     * </note>
     *
     * @param describeConfigurationRecorderStatusRequest
     *        The input for the <a>DescribeConfigurationRecorderStatus</a> action.
     * @return Result of the DescribeConfigurationRecorderStatus operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationRecorderStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationRecorderStatusResponse describeConfigurationRecorderStatus(
            DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest)
            throws NoSuchConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current status of the specified configuration recorder as well as the status of the last recording
     * event for the recorder. If a configuration recorder is not specified, this action returns the status of all
     * configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * &gt;You can specify only one configuration recorder for each Amazon Web Services Region for each account. For a
     * detailed status of recording events over time, add your Config events to Amazon CloudWatch metrics and use
     * CloudWatch metrics.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationRecorderStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationRecorderStatusRequest#builder()}
     * </p>
     *
     * @param describeConfigurationRecorderStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest.Builder} to
     *        create a request. The input for the <a>DescribeConfigurationRecorderStatus</a> action.
     * @return Result of the DescribeConfigurationRecorderStatus operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationRecorderStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationRecorderStatusResponse describeConfigurationRecorderStatus(
            Consumer<DescribeConfigurationRecorderStatusRequest.Builder> describeConfigurationRecorderStatusRequest)
            throws NoSuchConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        return describeConfigurationRecorderStatus(DescribeConfigurationRecorderStatusRequest.builder()
                .applyMutation(describeConfigurationRecorderStatusRequest).build());
    }

    /**
     * <p>
     * Returns the current status of the specified configuration recorder as well as the status of the last recording
     * event for the recorder. If a configuration recorder is not specified, this action returns the status of all
     * configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * &gt;You can specify only one configuration recorder for each Amazon Web Services Region for each account. For a
     * detailed status of recording events over time, add your Config events to Amazon CloudWatch metrics and use
     * CloudWatch metrics.
     * </p>
     * </note>
     *
     * @return Result of the DescribeConfigurationRecorderStatus operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationRecorderStatus
     * @see #describeConfigurationRecorderStatus(DescribeConfigurationRecorderStatusRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationRecorderStatusResponse describeConfigurationRecorderStatus()
            throws NoSuchConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        return describeConfigurationRecorderStatus(DescribeConfigurationRecorderStatusRequest.builder().build());
    }

    /**
     * <p>
     * Returns the details for the specified configuration recorders. If the configuration recorder is not specified,
     * this action returns the details for all configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * You can specify only one configuration recorder for each Amazon Web Services Region for each account.
     * </p>
     * </note>
     *
     * @param describeConfigurationRecordersRequest
     *        The input for the <a>DescribeConfigurationRecorders</a> action.
     * @return Result of the DescribeConfigurationRecorders operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationRecorders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationRecordersResponse describeConfigurationRecorders(
            DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest)
            throws NoSuchConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details for the specified configuration recorders. If the configuration recorder is not specified,
     * this action returns the details for all configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * You can specify only one configuration recorder for each Amazon Web Services Region for each account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConfigurationRecordersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConfigurationRecordersRequest#builder()}
     * </p>
     *
     * @param describeConfigurationRecordersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest.Builder} to
     *        create a request. The input for the <a>DescribeConfigurationRecorders</a> action.
     * @return Result of the DescribeConfigurationRecorders operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationRecorders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationRecordersResponse describeConfigurationRecorders(
            Consumer<DescribeConfigurationRecordersRequest.Builder> describeConfigurationRecordersRequest)
            throws NoSuchConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        return describeConfigurationRecorders(DescribeConfigurationRecordersRequest.builder()
                .applyMutation(describeConfigurationRecordersRequest).build());
    }

    /**
     * <p>
     * Returns the details for the specified configuration recorders. If the configuration recorder is not specified,
     * this action returns the details for all configuration recorders associated with the account.
     * </p>
     * <note>
     * <p>
     * You can specify only one configuration recorder for each Amazon Web Services Region for each account.
     * </p>
     * </note>
     *
     * @return Result of the DescribeConfigurationRecorders operation returned by the service.
     * @throws NoSuchConfigurationRecorderException
     *         You have specified a configuration recorder that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConfigurationRecorders
     * @see #describeConfigurationRecorders(DescribeConfigurationRecordersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConfigurationRecordersResponse describeConfigurationRecorders() throws NoSuchConfigurationRecorderException,
            AwsServiceException, SdkClientException, ConfigException {
        return describeConfigurationRecorders(DescribeConfigurationRecordersRequest.builder().build());
    }

    /**
     * <p>
     * Returns compliance details for each rule in that conformance pack.
     * </p>
     * <note>
     * <p>
     * You must provide exact rule names.
     * </p>
     * </note>
     *
     * @param describeConformancePackComplianceRequest
     * @return Result of the DescribeConformancePackCompliance operation returned by the service.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigRuleInConformancePackException
     *         Config rule that you passed in the filter does not exist.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConformancePackCompliance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePackComplianceResponse describeConformancePackCompliance(
            DescribeConformancePackComplianceRequest describeConformancePackComplianceRequest) throws InvalidLimitException,
            InvalidNextTokenException, InvalidParameterValueException, NoSuchConfigRuleInConformancePackException,
            NoSuchConformancePackException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns compliance details for each rule in that conformance pack.
     * </p>
     * <note>
     * <p>
     * You must provide exact rule names.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConformancePackComplianceRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConformancePackComplianceRequest#builder()}
     * </p>
     *
     * @param describeConformancePackComplianceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeConformancePackCompliance operation returned by the service.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigRuleInConformancePackException
     *         Config rule that you passed in the filter does not exist.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConformancePackCompliance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePackComplianceResponse describeConformancePackCompliance(
            Consumer<DescribeConformancePackComplianceRequest.Builder> describeConformancePackComplianceRequest)
            throws InvalidLimitException, InvalidNextTokenException, InvalidParameterValueException,
            NoSuchConfigRuleInConformancePackException, NoSuchConformancePackException, AwsServiceException, SdkClientException,
            ConfigException {
        return describeConformancePackCompliance(DescribeConformancePackComplianceRequest.builder()
                .applyMutation(describeConformancePackComplianceRequest).build());
    }

    /**
     * <p>
     * Returns compliance details for each rule in that conformance pack.
     * </p>
     * <note>
     * <p>
     * You must provide exact rule names.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeConformancePackCompliance(software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackComplianceIterable responses = client.describeConformancePackCompliancePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConformancePackComplianceIterable responses = client
     *             .describeConformancePackCompliancePaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackComplianceIterable responses = client.describeConformancePackCompliancePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConformancePackCompliance(software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConformancePackComplianceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigRuleInConformancePackException
     *         Config rule that you passed in the filter does not exist.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConformancePackCompliance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePackComplianceIterable describeConformancePackCompliancePaginator(
            DescribeConformancePackComplianceRequest describeConformancePackComplianceRequest) throws InvalidLimitException,
            InvalidNextTokenException, InvalidParameterValueException, NoSuchConfigRuleInConformancePackException,
            NoSuchConformancePackException, AwsServiceException, SdkClientException, ConfigException {
        return new DescribeConformancePackComplianceIterable(this, describeConformancePackComplianceRequest);
    }

    /**
     * <p>
     * Returns compliance details for each rule in that conformance pack.
     * </p>
     * <note>
     * <p>
     * You must provide exact rule names.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeConformancePackCompliance(software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackComplianceIterable responses = client.describeConformancePackCompliancePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConformancePackComplianceIterable responses = client
     *             .describeConformancePackCompliancePaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackComplianceIterable responses = client.describeConformancePackCompliancePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConformancePackCompliance(software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConformancePackComplianceRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConformancePackComplianceRequest#builder()}
     * </p>
     *
     * @param describeConformancePackComplianceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchConfigRuleInConformancePackException
     *         Config rule that you passed in the filter does not exist.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConformancePackCompliance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePackComplianceIterable describeConformancePackCompliancePaginator(
            Consumer<DescribeConformancePackComplianceRequest.Builder> describeConformancePackComplianceRequest)
            throws InvalidLimitException, InvalidNextTokenException, InvalidParameterValueException,
            NoSuchConfigRuleInConformancePackException, NoSuchConformancePackException, AwsServiceException, SdkClientException,
            ConfigException {
        return describeConformancePackCompliancePaginator(DescribeConformancePackComplianceRequest.builder()
                .applyMutation(describeConformancePackComplianceRequest).build());
    }

    /**
     * <p>
     * Provides one or more conformance packs deployment status.
     * </p>
     * <note>
     * <p>
     * If there are no conformance packs then you will see an empty result.
     * </p>
     * </note>
     *
     * @param describeConformancePackStatusRequest
     * @return Result of the DescribeConformancePackStatus operation returned by the service.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConformancePackStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePackStatusResponse describeConformancePackStatus(
            DescribeConformancePackStatusRequest describeConformancePackStatusRequest) throws InvalidLimitException,
            InvalidNextTokenException, InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides one or more conformance packs deployment status.
     * </p>
     * <note>
     * <p>
     * If there are no conformance packs then you will see an empty result.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConformancePackStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConformancePackStatusRequest#builder()}
     * </p>
     *
     * @param describeConformancePackStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeConformancePackStatus operation returned by the service.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConformancePackStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePackStatusResponse describeConformancePackStatus(
            Consumer<DescribeConformancePackStatusRequest.Builder> describeConformancePackStatusRequest)
            throws InvalidLimitException, InvalidNextTokenException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, ConfigException {
        return describeConformancePackStatus(DescribeConformancePackStatusRequest.builder()
                .applyMutation(describeConformancePackStatusRequest).build());
    }

    /**
     * <p>
     * Provides one or more conformance packs deployment status.
     * </p>
     * <note>
     * <p>
     * If there are no conformance packs then you will see an empty result.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeConformancePackStatus(software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackStatusIterable responses = client.describeConformancePackStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConformancePackStatusIterable responses = client
     *             .describeConformancePackStatusPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackStatusIterable responses = client.describeConformancePackStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConformancePackStatus(software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConformancePackStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConformancePackStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePackStatusIterable describeConformancePackStatusPaginator(
            DescribeConformancePackStatusRequest describeConformancePackStatusRequest) throws InvalidLimitException,
            InvalidNextTokenException, InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return new DescribeConformancePackStatusIterable(this, describeConformancePackStatusRequest);
    }

    /**
     * <p>
     * Provides one or more conformance packs deployment status.
     * </p>
     * <note>
     * <p>
     * If there are no conformance packs then you will see an empty result.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeConformancePackStatus(software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackStatusIterable responses = client.describeConformancePackStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConformancePackStatusIterable responses = client
     *             .describeConformancePackStatusPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePackStatusIterable responses = client.describeConformancePackStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConformancePackStatus(software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConformancePackStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConformancePackStatusRequest#builder()}
     * </p>
     *
     * @param describeConformancePackStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConformancePackStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePackStatusIterable describeConformancePackStatusPaginator(
            Consumer<DescribeConformancePackStatusRequest.Builder> describeConformancePackStatusRequest)
            throws InvalidLimitException, InvalidNextTokenException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, ConfigException {
        return describeConformancePackStatusPaginator(DescribeConformancePackStatusRequest.builder()
                .applyMutation(describeConformancePackStatusRequest).build());
    }

    /**
     * <p>
     * Returns a list of one or more conformance packs.
     * </p>
     *
     * @param describeConformancePacksRequest
     * @return Result of the DescribeConformancePacks operation returned by the service.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePacksResponse describeConformancePacks(
            DescribeConformancePacksRequest describeConformancePacksRequest) throws NoSuchConformancePackException,
            InvalidLimitException, InvalidNextTokenException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of one or more conformance packs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConformancePacksRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConformancePacksRequest#builder()}
     * </p>
     *
     * @param describeConformancePacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeConformancePacks operation returned by the service.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePacksResponse describeConformancePacks(
            Consumer<DescribeConformancePacksRequest.Builder> describeConformancePacksRequest)
            throws NoSuchConformancePackException, InvalidLimitException, InvalidNextTokenException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return describeConformancePacks(DescribeConformancePacksRequest.builder().applyMutation(describeConformancePacksRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of one or more conformance packs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConformancePacks(software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePacksIterable responses = client.describeConformancePacksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConformancePacksIterable responses = client
     *             .describeConformancePacksPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePacksIterable responses = client.describeConformancePacksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConformancePacks(software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConformancePacksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePacksIterable describeConformancePacksPaginator(
            DescribeConformancePacksRequest describeConformancePacksRequest) throws NoSuchConformancePackException,
            InvalidLimitException, InvalidNextTokenException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, ConfigException {
        return new DescribeConformancePacksIterable(this, describeConformancePacksRequest);
    }

    /**
     * <p>
     * Returns a list of one or more conformance packs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConformancePacks(software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePacksIterable responses = client.describeConformancePacksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeConformancePacksIterable responses = client
     *             .describeConformancePacksPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeConformancePacksIterable responses = client.describeConformancePacksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConformancePacks(software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConformancePacksRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeConformancePacksRequest#builder()}
     * </p>
     *
     * @param describeConformancePacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeConformancePacksIterable describeConformancePacksPaginator(
            Consumer<DescribeConformancePacksRequest.Builder> describeConformancePacksRequest)
            throws NoSuchConformancePackException, InvalidLimitException, InvalidNextTokenException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return describeConformancePacksPaginator(DescribeConformancePacksRequest.builder()
                .applyMutation(describeConformancePacksRequest).build());
    }

    /**
     * <p>
     * Returns the current status of the specified delivery channel. If a delivery channel is not specified, this action
     * returns the current status of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param describeDeliveryChannelStatusRequest
     *        The input for the <a>DeliveryChannelStatus</a> action.
     * @return Result of the DescribeDeliveryChannelStatus operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeDeliveryChannelStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDeliveryChannelStatusResponse describeDeliveryChannelStatus(
            DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest) throws NoSuchDeliveryChannelException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current status of the specified delivery channel. If a delivery channel is not specified, this action
     * returns the current status of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeliveryChannelStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDeliveryChannelStatusRequest#builder()}
     * </p>
     *
     * @param describeDeliveryChannelStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest.Builder} to
     *        create a request. The input for the <a>DeliveryChannelStatus</a> action.
     * @return Result of the DescribeDeliveryChannelStatus operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeDeliveryChannelStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDeliveryChannelStatusResponse describeDeliveryChannelStatus(
            Consumer<DescribeDeliveryChannelStatusRequest.Builder> describeDeliveryChannelStatusRequest)
            throws NoSuchDeliveryChannelException, AwsServiceException, SdkClientException, ConfigException {
        return describeDeliveryChannelStatus(DescribeDeliveryChannelStatusRequest.builder()
                .applyMutation(describeDeliveryChannelStatusRequest).build());
    }

    /**
     * <p>
     * Returns the current status of the specified delivery channel. If a delivery channel is not specified, this action
     * returns the current status of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @return Result of the DescribeDeliveryChannelStatus operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeDeliveryChannelStatus
     * @see #describeDeliveryChannelStatus(DescribeDeliveryChannelStatusRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDeliveryChannelStatusResponse describeDeliveryChannelStatus() throws NoSuchDeliveryChannelException,
            AwsServiceException, SdkClientException, ConfigException {
        return describeDeliveryChannelStatus(DescribeDeliveryChannelStatusRequest.builder().build());
    }

    /**
     * <p>
     * Returns details about the specified delivery channel. If a delivery channel is not specified, this action returns
     * the details of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param describeDeliveryChannelsRequest
     *        The input for the <a>DescribeDeliveryChannels</a> action.
     * @return Result of the DescribeDeliveryChannels operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeDeliveryChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDeliveryChannelsResponse describeDeliveryChannels(
            DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) throws NoSuchDeliveryChannelException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the specified delivery channel. If a delivery channel is not specified, this action returns
     * the details of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeliveryChannelsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDeliveryChannelsRequest#builder()}
     * </p>
     *
     * @param describeDeliveryChannelsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest.Builder} to create a
     *        request. The input for the <a>DescribeDeliveryChannels</a> action.
     * @return Result of the DescribeDeliveryChannels operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeDeliveryChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDeliveryChannelsResponse describeDeliveryChannels(
            Consumer<DescribeDeliveryChannelsRequest.Builder> describeDeliveryChannelsRequest)
            throws NoSuchDeliveryChannelException, AwsServiceException, SdkClientException, ConfigException {
        return describeDeliveryChannels(DescribeDeliveryChannelsRequest.builder().applyMutation(describeDeliveryChannelsRequest)
                .build());
    }

    /**
     * <p>
     * Returns details about the specified delivery channel. If a delivery channel is not specified, this action returns
     * the details of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @return Result of the DescribeDeliveryChannels operation returned by the service.
     * @throws NoSuchDeliveryChannelException
     *         You have specified a delivery channel that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeDeliveryChannels
     * @see #describeDeliveryChannels(DescribeDeliveryChannelsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDeliveryChannelsResponse describeDeliveryChannels() throws NoSuchDeliveryChannelException,
            AwsServiceException, SdkClientException, ConfigException {
        return describeDeliveryChannels(DescribeDeliveryChannelsRequest.builder().build());
    }

    /**
     * <p>
     * Provides organization Config rule deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization Config rule is successfully deployed in all the member
     * accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization Config rule names. It is only applicable, when you request all the
     * organization Config rules.
     * </p>
     * </note>
     *
     * @param describeOrganizationConfigRuleStatusesRequest
     * @return Result of the DescribeOrganizationConfigRuleStatuses operation returned by the service.
     * @throws NoSuchOrganizationConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check
     *         rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying
     *         again.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConfigRuleStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigRuleStatusesResponse describeOrganizationConfigRuleStatuses(
            DescribeOrganizationConfigRuleStatusesRequest describeOrganizationConfigRuleStatusesRequest)
            throws NoSuchOrganizationConfigRuleException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides organization Config rule deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization Config rule is successfully deployed in all the member
     * accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization Config rule names. It is only applicable, when you request all the
     * organization Config rules.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationConfigRuleStatusesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationConfigRuleStatusesRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigRuleStatusesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeOrganizationConfigRuleStatuses operation returned by the service.
     * @throws NoSuchOrganizationConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check
     *         rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying
     *         again.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConfigRuleStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigRuleStatusesResponse describeOrganizationConfigRuleStatuses(
            Consumer<DescribeOrganizationConfigRuleStatusesRequest.Builder> describeOrganizationConfigRuleStatusesRequest)
            throws NoSuchOrganizationConfigRuleException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return describeOrganizationConfigRuleStatuses(DescribeOrganizationConfigRuleStatusesRequest.builder()
                .applyMutation(describeOrganizationConfigRuleStatusesRequest).build());
    }

    /**
     * <p>
     * Provides organization Config rule deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization Config rule is successfully deployed in all the member
     * accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization Config rule names. It is only applicable, when you request all the
     * organization Config rules.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConfigRuleStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRuleStatusesIterable responses = client.describeOrganizationConfigRuleStatusesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRuleStatusesIterable responses = client
     *             .describeOrganizationConfigRuleStatusesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRuleStatusesIterable responses = client.describeOrganizationConfigRuleStatusesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConfigRuleStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrganizationConfigRuleStatusesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchOrganizationConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check
     *         rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying
     *         again.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConfigRuleStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigRuleStatusesIterable describeOrganizationConfigRuleStatusesPaginator(
            DescribeOrganizationConfigRuleStatusesRequest describeOrganizationConfigRuleStatusesRequest)
            throws NoSuchOrganizationConfigRuleException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return new DescribeOrganizationConfigRuleStatusesIterable(this, describeOrganizationConfigRuleStatusesRequest);
    }

    /**
     * <p>
     * Provides organization Config rule deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization Config rule is successfully deployed in all the member
     * accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization Config rule names. It is only applicable, when you request all the
     * organization Config rules.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConfigRuleStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRuleStatusesIterable responses = client.describeOrganizationConfigRuleStatusesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRuleStatusesIterable responses = client
     *             .describeOrganizationConfigRuleStatusesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRuleStatusesIterable responses = client.describeOrganizationConfigRuleStatusesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConfigRuleStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationConfigRuleStatusesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationConfigRuleStatusesRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigRuleStatusesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchOrganizationConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check
     *         rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying
     *         again.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConfigRuleStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigRuleStatusesIterable describeOrganizationConfigRuleStatusesPaginator(
            Consumer<DescribeOrganizationConfigRuleStatusesRequest.Builder> describeOrganizationConfigRuleStatusesRequest)
            throws NoSuchOrganizationConfigRuleException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return describeOrganizationConfigRuleStatusesPaginator(DescribeOrganizationConfigRuleStatusesRequest.builder()
                .applyMutation(describeOrganizationConfigRuleStatusesRequest).build());
    }

    /**
     * <p>
     * Returns a list of organization Config rules.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization Config rule names. It is only applicable,
     * when you request all the organization Config rules.
     * </p>
     * <p>
     * <i>For accounts within an organzation</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note>
     *
     * @param describeOrganizationConfigRulesRequest
     * @return Result of the DescribeOrganizationConfigRules operation returned by the service.
     * @throws NoSuchOrganizationConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check
     *         rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigRulesResponse describeOrganizationConfigRules(
            DescribeOrganizationConfigRulesRequest describeOrganizationConfigRulesRequest)
            throws NoSuchOrganizationConfigRuleException, InvalidNextTokenException, InvalidLimitException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of organization Config rules.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization Config rule names. It is only applicable,
     * when you request all the organization Config rules.
     * </p>
     * <p>
     * <i>For accounts within an organzation</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationConfigRulesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationConfigRulesRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeOrganizationConfigRules operation returned by the service.
     * @throws NoSuchOrganizationConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check
     *         rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigRulesResponse describeOrganizationConfigRules(
            Consumer<DescribeOrganizationConfigRulesRequest.Builder> describeOrganizationConfigRulesRequest)
            throws NoSuchOrganizationConfigRuleException, InvalidNextTokenException, InvalidLimitException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return describeOrganizationConfigRules(DescribeOrganizationConfigRulesRequest.builder()
                .applyMutation(describeOrganizationConfigRulesRequest).build());
    }

    /**
     * <p>
     * Returns a list of organization Config rules.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization Config rule names. It is only applicable,
     * when you request all the organization Config rules.
     * </p>
     * <p>
     * <i>For accounts within an organzation</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConfigRules(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRulesIterable responses = client.describeOrganizationConfigRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRulesIterable responses = client
     *             .describeOrganizationConfigRulesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRulesIterable responses = client.describeOrganizationConfigRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConfigRules(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrganizationConfigRulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchOrganizationConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check
     *         rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigRulesIterable describeOrganizationConfigRulesPaginator(
            DescribeOrganizationConfigRulesRequest describeOrganizationConfigRulesRequest)
            throws NoSuchOrganizationConfigRuleException, InvalidNextTokenException, InvalidLimitException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return new DescribeOrganizationConfigRulesIterable(this, describeOrganizationConfigRulesRequest);
    }

    /**
     * <p>
     * Returns a list of organization Config rules.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization Config rule names. It is only applicable,
     * when you request all the organization Config rules.
     * </p>
     * <p>
     * <i>For accounts within an organzation</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConfigRules(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRulesIterable responses = client.describeOrganizationConfigRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRulesIterable responses = client
     *             .describeOrganizationConfigRulesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConfigRulesIterable responses = client.describeOrganizationConfigRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConfigRules(software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationConfigRulesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationConfigRulesRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchOrganizationConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check
     *         rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigRulesIterable describeOrganizationConfigRulesPaginator(
            Consumer<DescribeOrganizationConfigRulesRequest.Builder> describeOrganizationConfigRulesRequest)
            throws NoSuchOrganizationConfigRuleException, InvalidNextTokenException, InvalidLimitException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return describeOrganizationConfigRulesPaginator(DescribeOrganizationConfigRulesRequest.builder()
                .applyMutation(describeOrganizationConfigRulesRequest).build());
    }

    /**
     * <p>
     * Provides organization conformance pack deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization conformance pack is successfully deployed in all the
     * member accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization conformance pack names. They are only applicable, when you request all the
     * organization conformance packs.
     * </p>
     * </note>
     *
     * @param describeOrganizationConformancePackStatusesRequest
     * @return Result of the DescribeOrganizationConformancePackStatuses operation returned by the service.
     * @throws NoSuchOrganizationConformancePackException
     *         Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConformancePackStatuses
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConformancePackStatusesResponse describeOrganizationConformancePackStatuses(
            DescribeOrganizationConformancePackStatusesRequest describeOrganizationConformancePackStatusesRequest)
            throws NoSuchOrganizationConformancePackException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides organization conformance pack deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization conformance pack is successfully deployed in all the
     * member accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization conformance pack names. They are only applicable, when you request all the
     * organization conformance packs.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationConformancePackStatusesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationConformancePackStatusesRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConformancePackStatusesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeOrganizationConformancePackStatuses operation returned by the service.
     * @throws NoSuchOrganizationConformancePackException
     *         Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConformancePackStatuses
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConformancePackStatusesResponse describeOrganizationConformancePackStatuses(
            Consumer<DescribeOrganizationConformancePackStatusesRequest.Builder> describeOrganizationConformancePackStatusesRequest)
            throws NoSuchOrganizationConformancePackException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return describeOrganizationConformancePackStatuses(DescribeOrganizationConformancePackStatusesRequest.builder()
                .applyMutation(describeOrganizationConformancePackStatusesRequest).build());
    }

    /**
     * <p>
     * Provides organization conformance pack deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization conformance pack is successfully deployed in all the
     * member accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization conformance pack names. They are only applicable, when you request all the
     * organization conformance packs.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConformancePackStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePackStatusesIterable responses = client.describeOrganizationConformancePackStatusesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePackStatusesIterable responses = client
     *             .describeOrganizationConformancePackStatusesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePackStatusesIterable responses = client.describeOrganizationConformancePackStatusesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConformancePackStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrganizationConformancePackStatusesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchOrganizationConformancePackException
     *         Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConformancePackStatuses
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConformancePackStatusesIterable describeOrganizationConformancePackStatusesPaginator(
            DescribeOrganizationConformancePackStatusesRequest describeOrganizationConformancePackStatusesRequest)
            throws NoSuchOrganizationConformancePackException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return new DescribeOrganizationConformancePackStatusesIterable(this, describeOrganizationConformancePackStatusesRequest);
    }

    /**
     * <p>
     * Provides organization conformance pack deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization conformance pack is successfully deployed in all the
     * member accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization conformance pack names. They are only applicable, when you request all the
     * organization conformance packs.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConformancePackStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePackStatusesIterable responses = client.describeOrganizationConformancePackStatusesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePackStatusesIterable responses = client
     *             .describeOrganizationConformancePackStatusesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePackStatusesIterable responses = client.describeOrganizationConformancePackStatusesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConformancePackStatuses(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationConformancePackStatusesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationConformancePackStatusesRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConformancePackStatusesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchOrganizationConformancePackException
     *         Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConformancePackStatuses
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConformancePackStatusesIterable describeOrganizationConformancePackStatusesPaginator(
            Consumer<DescribeOrganizationConformancePackStatusesRequest.Builder> describeOrganizationConformancePackStatusesRequest)
            throws NoSuchOrganizationConformancePackException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return describeOrganizationConformancePackStatusesPaginator(DescribeOrganizationConformancePackStatusesRequest.builder()
                .applyMutation(describeOrganizationConformancePackStatusesRequest).build());
    }

    /**
     * <p>
     * Returns a list of organization conformance packs.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization conformance packs names. They are only
     * applicable, when you request all the organization conformance packs.
     * </p>
     * <p>
     * <i>For accounts within an organzation</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note>
     *
     * @param describeOrganizationConformancePacksRequest
     * @return Result of the DescribeOrganizationConformancePacks operation returned by the service.
     * @throws NoSuchOrganizationConformancePackException
     *         Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConformancePacksResponse describeOrganizationConformancePacks(
            DescribeOrganizationConformancePacksRequest describeOrganizationConformancePacksRequest)
            throws NoSuchOrganizationConformancePackException, InvalidNextTokenException, InvalidLimitException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of organization conformance packs.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization conformance packs names. They are only
     * applicable, when you request all the organization conformance packs.
     * </p>
     * <p>
     * <i>For accounts within an organzation</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationConformancePacksRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationConformancePacksRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConformancePacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeOrganizationConformancePacks operation returned by the service.
     * @throws NoSuchOrganizationConformancePackException
     *         Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConformancePacksResponse describeOrganizationConformancePacks(
            Consumer<DescribeOrganizationConformancePacksRequest.Builder> describeOrganizationConformancePacksRequest)
            throws NoSuchOrganizationConformancePackException, InvalidNextTokenException, InvalidLimitException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return describeOrganizationConformancePacks(DescribeOrganizationConformancePacksRequest.builder()
                .applyMutation(describeOrganizationConformancePacksRequest).build());
    }

    /**
     * <p>
     * Returns a list of organization conformance packs.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization conformance packs names. They are only
     * applicable, when you request all the organization conformance packs.
     * </p>
     * <p>
     * <i>For accounts within an organzation</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConformancePacks(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePacksIterable responses = client.describeOrganizationConformancePacksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePacksIterable responses = client
     *             .describeOrganizationConformancePacksPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePacksIterable responses = client.describeOrganizationConformancePacksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConformancePacks(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrganizationConformancePacksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchOrganizationConformancePackException
     *         Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConformancePacksIterable describeOrganizationConformancePacksPaginator(
            DescribeOrganizationConformancePacksRequest describeOrganizationConformancePacksRequest)
            throws NoSuchOrganizationConformancePackException, InvalidNextTokenException, InvalidLimitException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return new DescribeOrganizationConformancePacksIterable(this, describeOrganizationConformancePacksRequest);
    }

    /**
     * <p>
     * Returns a list of organization conformance packs.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization conformance packs names. They are only
     * applicable, when you request all the organization conformance packs.
     * </p>
     * <p>
     * <i>For accounts within an organzation</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeOrganizationConformancePacks(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePacksIterable responses = client.describeOrganizationConformancePacksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePacksIterable responses = client
     *             .describeOrganizationConformancePacksPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeOrganizationConformancePacksIterable responses = client.describeOrganizationConformancePacksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrganizationConformancePacks(software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrganizationConformancePacksRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrganizationConformancePacksRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConformancePacksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchOrganizationConformancePackException
     *         Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeOrganizationConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConformancePacksIterable describeOrganizationConformancePacksPaginator(
            Consumer<DescribeOrganizationConformancePacksRequest.Builder> describeOrganizationConformancePacksRequest)
            throws NoSuchOrganizationConformancePackException, InvalidNextTokenException, InvalidLimitException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return describeOrganizationConformancePacksPaginator(DescribeOrganizationConformancePacksRequest.builder()
                .applyMutation(describeOrganizationConformancePacksRequest).build());
    }

    /**
     * <p>
     * Returns a list of all pending aggregation requests.
     * </p>
     *
     * @param describePendingAggregationRequestsRequest
     * @return Result of the DescribePendingAggregationRequests operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribePendingAggregationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingAggregationRequestsResponse describePendingAggregationRequests(
            DescribePendingAggregationRequestsRequest describePendingAggregationRequestsRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException,
            SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all pending aggregation requests.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingAggregationRequestsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingAggregationRequestsRequest#builder()}
     * </p>
     *
     * @param describePendingAggregationRequestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribePendingAggregationRequests operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribePendingAggregationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingAggregationRequestsResponse describePendingAggregationRequests(
            Consumer<DescribePendingAggregationRequestsRequest.Builder> describePendingAggregationRequestsRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException,
            SdkClientException, ConfigException {
        return describePendingAggregationRequests(DescribePendingAggregationRequestsRequest.builder()
                .applyMutation(describePendingAggregationRequestsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all pending aggregation requests.
     * </p>
     *
     * @return Result of the DescribePendingAggregationRequests operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribePendingAggregationRequests
     * @see #describePendingAggregationRequests(DescribePendingAggregationRequestsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingAggregationRequestsResponse describePendingAggregationRequests()
            throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException,
            SdkClientException, ConfigException {
        return describePendingAggregationRequests(DescribePendingAggregationRequestsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of all pending aggregation requests.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePendingAggregationRequests(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsIterable responses = client.describePendingAggregationRequestsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsIterable responses = client
     *             .describePendingAggregationRequestsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsIterable responses = client.describePendingAggregationRequestsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingAggregationRequests(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribePendingAggregationRequests
     * @see #describePendingAggregationRequestsPaginator(DescribePendingAggregationRequestsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingAggregationRequestsIterable describePendingAggregationRequestsPaginator()
            throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException,
            SdkClientException, ConfigException {
        return describePendingAggregationRequestsPaginator(DescribePendingAggregationRequestsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of all pending aggregation requests.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePendingAggregationRequests(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsIterable responses = client.describePendingAggregationRequestsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsIterable responses = client
     *             .describePendingAggregationRequestsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsIterable responses = client.describePendingAggregationRequestsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingAggregationRequests(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePendingAggregationRequestsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribePendingAggregationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingAggregationRequestsIterable describePendingAggregationRequestsPaginator(
            DescribePendingAggregationRequestsRequest describePendingAggregationRequestsRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException,
            SdkClientException, ConfigException {
        return new DescribePendingAggregationRequestsIterable(this, describePendingAggregationRequestsRequest);
    }

    /**
     * <p>
     * Returns a list of all pending aggregation requests.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePendingAggregationRequests(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsIterable responses = client.describePendingAggregationRequestsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsIterable responses = client
     *             .describePendingAggregationRequestsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribePendingAggregationRequestsIterable responses = client.describePendingAggregationRequestsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingAggregationRequests(software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingAggregationRequestsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingAggregationRequestsRequest#builder()}
     * </p>
     *
     * @param describePendingAggregationRequestsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribePendingAggregationRequests
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribePendingAggregationRequests"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingAggregationRequestsIterable describePendingAggregationRequestsPaginator(
            Consumer<DescribePendingAggregationRequestsRequest.Builder> describePendingAggregationRequestsRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException,
            SdkClientException, ConfigException {
        return describePendingAggregationRequestsPaginator(DescribePendingAggregationRequestsRequest.builder()
                .applyMutation(describePendingAggregationRequestsRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more remediation configurations.
     * </p>
     *
     * @param describeRemediationConfigurationsRequest
     * @return Result of the DescribeRemediationConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRemediationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationConfigurationsResponse describeRemediationConfigurations(
            DescribeRemediationConfigurationsRequest describeRemediationConfigurationsRequest) throws AwsServiceException,
            SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of one or more remediation configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRemediationConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRemediationConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeRemediationConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeRemediationConfigurations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRemediationConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationConfigurationsResponse describeRemediationConfigurations(
            Consumer<DescribeRemediationConfigurationsRequest.Builder> describeRemediationConfigurationsRequest)
            throws AwsServiceException, SdkClientException, ConfigException {
        return describeRemediationConfigurations(DescribeRemediationConfigurationsRequest.builder()
                .applyMutation(describeRemediationConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set
     * of resources that includes an explanation of an exception and the time when the exception will be deleted. When
     * you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <note>
     * <p>
     * Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you request resources in batch. It is only applicable, when you
     * request all resources.
     * </p>
     * </note>
     *
     * @param describeRemediationExceptionsRequest
     * @return Result of the DescribeRemediationExceptions operation returned by the service.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationExceptionsResponse describeRemediationExceptions(
            DescribeRemediationExceptionsRequest describeRemediationExceptionsRequest) throws InvalidNextTokenException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set
     * of resources that includes an explanation of an exception and the time when the exception will be deleted. When
     * you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <note>
     * <p>
     * Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you request resources in batch. It is only applicable, when you
     * request all resources.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRemediationExceptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRemediationExceptionsRequest#builder()}
     * </p>
     *
     * @param describeRemediationExceptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeRemediationExceptions operation returned by the service.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationExceptionsResponse describeRemediationExceptions(
            Consumer<DescribeRemediationExceptionsRequest.Builder> describeRemediationExceptionsRequest)
            throws InvalidNextTokenException, InvalidParameterValueException, AwsServiceException, SdkClientException,
            ConfigException {
        return describeRemediationExceptions(DescribeRemediationExceptionsRequest.builder()
                .applyMutation(describeRemediationExceptionsRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set
     * of resources that includes an explanation of an exception and the time when the exception will be deleted. When
     * you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <note>
     * <p>
     * Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you request resources in batch. It is only applicable, when you
     * request all resources.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeRemediationExceptions(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsIterable responses = client.describeRemediationExceptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsIterable responses = client
     *             .describeRemediationExceptionsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsIterable responses = client.describeRemediationExceptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRemediationExceptions(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRemediationExceptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationExceptionsIterable describeRemediationExceptionsPaginator(
            DescribeRemediationExceptionsRequest describeRemediationExceptionsRequest) throws InvalidNextTokenException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return new DescribeRemediationExceptionsIterable(this, describeRemediationExceptionsRequest);
    }

    /**
     * <p>
     * Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set
     * of resources that includes an explanation of an exception and the time when the exception will be deleted. When
     * you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <note>
     * <p>
     * Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you request resources in batch. It is only applicable, when you
     * request all resources.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeRemediationExceptions(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsIterable responses = client.describeRemediationExceptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsIterable responses = client
     *             .describeRemediationExceptionsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExceptionsIterable responses = client.describeRemediationExceptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRemediationExceptions(software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRemediationExceptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRemediationExceptionsRequest#builder()}
     * </p>
     *
     * @param describeRemediationExceptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationExceptionsIterable describeRemediationExceptionsPaginator(
            Consumer<DescribeRemediationExceptionsRequest.Builder> describeRemediationExceptionsRequest)
            throws InvalidNextTokenException, InvalidParameterValueException, AwsServiceException, SdkClientException,
            ConfigException {
        return describeRemediationExceptionsPaginator(DescribeRemediationExceptionsRequest.builder()
                .applyMutation(describeRemediationExceptionsRequest).build());
    }

    /**
     * <p>
     * Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when
     * steps for the remediation execution occur, and any error messages for steps that have failed. When you specify
     * the limit and the next token, you receive a paginated response.
     * </p>
     *
     * @param describeRemediationExecutionStatusRequest
     * @return Result of the DescribeRemediationExecutionStatus operation returned by the service.
     * @throws NoSuchRemediationConfigurationException
     *         You specified an Config rule without a remediation configuration.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRemediationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationExecutionStatusResponse describeRemediationExecutionStatus(
            DescribeRemediationExecutionStatusRequest describeRemediationExecutionStatusRequest)
            throws NoSuchRemediationConfigurationException, InvalidNextTokenException, InvalidParameterValueException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when
     * steps for the remediation execution occur, and any error messages for steps that have failed. When you specify
     * the limit and the next token, you receive a paginated response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRemediationExecutionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRemediationExecutionStatusRequest#builder()}
     * </p>
     *
     * @param describeRemediationExecutionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeRemediationExecutionStatus operation returned by the service.
     * @throws NoSuchRemediationConfigurationException
     *         You specified an Config rule without a remediation configuration.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRemediationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationExecutionStatusResponse describeRemediationExecutionStatus(
            Consumer<DescribeRemediationExecutionStatusRequest.Builder> describeRemediationExecutionStatusRequest)
            throws NoSuchRemediationConfigurationException, InvalidNextTokenException, InvalidParameterValueException,
            AwsServiceException, SdkClientException, ConfigException {
        return describeRemediationExecutionStatus(DescribeRemediationExecutionStatusRequest.builder()
                .applyMutation(describeRemediationExecutionStatusRequest).build());
    }

    /**
     * <p>
     * Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when
     * steps for the remediation execution occur, and any error messages for steps that have failed. When you specify
     * the limit and the next token, you receive a paginated response.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRemediationExecutionStatus(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusIterable responses = client.describeRemediationExecutionStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusIterable responses = client
     *             .describeRemediationExecutionStatusPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusIterable responses = client.describeRemediationExecutionStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRemediationExecutionStatus(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRemediationExecutionStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchRemediationConfigurationException
     *         You specified an Config rule without a remediation configuration.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRemediationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationExecutionStatusIterable describeRemediationExecutionStatusPaginator(
            DescribeRemediationExecutionStatusRequest describeRemediationExecutionStatusRequest)
            throws NoSuchRemediationConfigurationException, InvalidNextTokenException, InvalidParameterValueException,
            AwsServiceException, SdkClientException, ConfigException {
        return new DescribeRemediationExecutionStatusIterable(this, describeRemediationExecutionStatusRequest);
    }

    /**
     * <p>
     * Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when
     * steps for the remediation execution occur, and any error messages for steps that have failed. When you specify
     * the limit and the next token, you receive a paginated response.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeRemediationExecutionStatus(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusIterable responses = client.describeRemediationExecutionStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusIterable responses = client
     *             .describeRemediationExecutionStatusPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRemediationExecutionStatusIterable responses = client.describeRemediationExecutionStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRemediationExecutionStatus(software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRemediationExecutionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRemediationExecutionStatusRequest#builder()}
     * </p>
     *
     * @param describeRemediationExecutionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchRemediationConfigurationException
     *         You specified an Config rule without a remediation configuration.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRemediationExecutionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRemediationExecutionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRemediationExecutionStatusIterable describeRemediationExecutionStatusPaginator(
            Consumer<DescribeRemediationExecutionStatusRequest.Builder> describeRemediationExecutionStatusRequest)
            throws NoSuchRemediationConfigurationException, InvalidNextTokenException, InvalidParameterValueException,
            AwsServiceException, SdkClientException, ConfigException {
        return describeRemediationExecutionStatusPaginator(DescribeRemediationExecutionStatusRequest.builder()
                .applyMutation(describeRemediationExecutionStatusRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more retention configurations. If the retention configuration name is not
     * specified, this action returns the details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, Config supports only one retention configuration per region in your account.
     * </p>
     * </note>
     *
     * @param describeRetentionConfigurationsRequest
     * @return Result of the DescribeRetentionConfigurations operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchRetentionConfigurationException
     *         You have specified a retention configuration that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRetentionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRetentionConfigurationsResponse describeRetentionConfigurations(
            DescribeRetentionConfigurationsRequest describeRetentionConfigurationsRequest) throws InvalidParameterValueException,
            NoSuchRetentionConfigurationException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of one or more retention configurations. If the retention configuration name is not
     * specified, this action returns the details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, Config supports only one retention configuration per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRetentionConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRetentionConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeRetentionConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeRetentionConfigurations operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchRetentionConfigurationException
     *         You have specified a retention configuration that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRetentionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRetentionConfigurationsResponse describeRetentionConfigurations(
            Consumer<DescribeRetentionConfigurationsRequest.Builder> describeRetentionConfigurationsRequest)
            throws InvalidParameterValueException, NoSuchRetentionConfigurationException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, ConfigException {
        return describeRetentionConfigurations(DescribeRetentionConfigurationsRequest.builder()
                .applyMutation(describeRetentionConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns the details of one or more retention configurations. If the retention configuration name is not
     * specified, this action returns the details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, Config supports only one retention configuration per region in your account.
     * </p>
     * </note>
     *
     * @return Result of the DescribeRetentionConfigurations operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchRetentionConfigurationException
     *         You have specified a retention configuration that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRetentionConfigurations
     * @see #describeRetentionConfigurations(DescribeRetentionConfigurationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRetentionConfigurationsResponse describeRetentionConfigurations() throws InvalidParameterValueException,
            NoSuchRetentionConfigurationException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            ConfigException {
        return describeRetentionConfigurations(DescribeRetentionConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the details of one or more retention configurations. If the retention configuration name is not
     * specified, this action returns the details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, Config supports only one retention configuration per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeRetentionConfigurations(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsIterable responses = client.describeRetentionConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsIterable responses = client
     *             .describeRetentionConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsIterable responses = client.describeRetentionConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRetentionConfigurations(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchRetentionConfigurationException
     *         You have specified a retention configuration that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRetentionConfigurations
     * @see #describeRetentionConfigurationsPaginator(DescribeRetentionConfigurationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRetentionConfigurationsIterable describeRetentionConfigurationsPaginator()
            throws InvalidParameterValueException, NoSuchRetentionConfigurationException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, ConfigException {
        return describeRetentionConfigurationsPaginator(DescribeRetentionConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the details of one or more retention configurations. If the retention configuration name is not
     * specified, this action returns the details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, Config supports only one retention configuration per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeRetentionConfigurations(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsIterable responses = client.describeRetentionConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsIterable responses = client
     *             .describeRetentionConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsIterable responses = client.describeRetentionConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRetentionConfigurations(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRetentionConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchRetentionConfigurationException
     *         You have specified a retention configuration that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRetentionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRetentionConfigurationsIterable describeRetentionConfigurationsPaginator(
            DescribeRetentionConfigurationsRequest describeRetentionConfigurationsRequest) throws InvalidParameterValueException,
            NoSuchRetentionConfigurationException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            ConfigException {
        return new DescribeRetentionConfigurationsIterable(this, describeRetentionConfigurationsRequest);
    }

    /**
     * <p>
     * Returns the details of one or more retention configurations. If the retention configuration name is not
     * specified, this action returns the details for all the retention configurations for that account.
     * </p>
     * <note>
     * <p>
     * Currently, Config supports only one retention configuration per region in your account.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeRetentionConfigurations(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsIterable responses = client.describeRetentionConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsIterable responses = client
     *             .describeRetentionConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.DescribeRetentionConfigurationsIterable responses = client.describeRetentionConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRetentionConfigurations(software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRetentionConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRetentionConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeRetentionConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws NoSuchRetentionConfigurationException
     *         You have specified a retention configuration that does not exist.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.DescribeRetentionConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeRetentionConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRetentionConfigurationsIterable describeRetentionConfigurationsPaginator(
            Consumer<DescribeRetentionConfigurationsRequest.Builder> describeRetentionConfigurationsRequest)
            throws InvalidParameterValueException, NoSuchRetentionConfigurationException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, ConfigException {
        return describeRetentionConfigurationsPaginator(DescribeRetentionConfigurationsRequest.builder()
                .applyMutation(describeRetentionConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Config rule for a specific resource in a rule. The results
     * indicate which Amazon Web Services resources were evaluated by the rule, when each resource was last evaluated,
     * and whether each resource complies with the rule.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page. But if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param getAggregateComplianceDetailsByConfigRuleRequest
     * @return Result of the GetAggregateComplianceDetailsByConfigRule operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateComplianceDetailsByConfigRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateComplianceDetailsByConfigRuleResponse getAggregateComplianceDetailsByConfigRule(
            GetAggregateComplianceDetailsByConfigRuleRequest getAggregateComplianceDetailsByConfigRuleRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Config rule for a specific resource in a rule. The results
     * indicate which Amazon Web Services resources were evaluated by the rule, when each resource was last evaluated,
     * and whether each resource complies with the rule.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page. But if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateComplianceDetailsByConfigRuleRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateComplianceDetailsByConfigRuleRequest#builder()}
     * </p>
     *
     * @param getAggregateComplianceDetailsByConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest.Builder}
     *        to create a request.
     * @return Result of the GetAggregateComplianceDetailsByConfigRule operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateComplianceDetailsByConfigRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateComplianceDetailsByConfigRuleResponse getAggregateComplianceDetailsByConfigRule(
            Consumer<GetAggregateComplianceDetailsByConfigRuleRequest.Builder> getAggregateComplianceDetailsByConfigRuleRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return getAggregateComplianceDetailsByConfigRule(GetAggregateComplianceDetailsByConfigRuleRequest.builder()
                .applyMutation(getAggregateComplianceDetailsByConfigRuleRequest).build());
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Config rule for a specific resource in a rule. The results
     * indicate which Amazon Web Services resources were evaluated by the rule, when each resource was last evaluated,
     * and whether each resource complies with the rule.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page. But if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getAggregateComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateComplianceDetailsByConfigRuleIterable responses = client.getAggregateComplianceDetailsByConfigRulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetAggregateComplianceDetailsByConfigRuleIterable responses = client
     *             .getAggregateComplianceDetailsByConfigRulePaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateComplianceDetailsByConfigRuleIterable responses = client.getAggregateComplianceDetailsByConfigRulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAggregateComplianceDetailsByConfigRuleRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateComplianceDetailsByConfigRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateComplianceDetailsByConfigRuleIterable getAggregateComplianceDetailsByConfigRulePaginator(
            GetAggregateComplianceDetailsByConfigRuleRequest getAggregateComplianceDetailsByConfigRuleRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return new GetAggregateComplianceDetailsByConfigRuleIterable(this, getAggregateComplianceDetailsByConfigRuleRequest);
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Config rule for a specific resource in a rule. The results
     * indicate which Amazon Web Services resources were evaluated by the rule, when each resource was last evaluated,
     * and whether each resource complies with the rule.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page. But if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getAggregateComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateComplianceDetailsByConfigRuleIterable responses = client.getAggregateComplianceDetailsByConfigRulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetAggregateComplianceDetailsByConfigRuleIterable responses = client
     *             .getAggregateComplianceDetailsByConfigRulePaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateComplianceDetailsByConfigRuleIterable responses = client.getAggregateComplianceDetailsByConfigRulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateComplianceDetailsByConfigRuleRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateComplianceDetailsByConfigRuleRequest#builder()}
     * </p>
     *
     * @param getAggregateComplianceDetailsByConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateComplianceDetailsByConfigRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateComplianceDetailsByConfigRuleIterable getAggregateComplianceDetailsByConfigRulePaginator(
            Consumer<GetAggregateComplianceDetailsByConfigRuleRequest.Builder> getAggregateComplianceDetailsByConfigRuleRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return getAggregateComplianceDetailsByConfigRulePaginator(GetAggregateComplianceDetailsByConfigRuleRequest.builder()
                .applyMutation(getAggregateComplianceDetailsByConfigRuleRequest).build());
    }

    /**
     * <p>
     * Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note>
     *
     * @param getAggregateConfigRuleComplianceSummaryRequest
     * @return Result of the GetAggregateConfigRuleComplianceSummary operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateConfigRuleComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateConfigRuleComplianceSummaryResponse getAggregateConfigRuleComplianceSummary(
            GetAggregateConfigRuleComplianceSummaryRequest getAggregateConfigRuleComplianceSummaryRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateConfigRuleComplianceSummaryRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateConfigRuleComplianceSummaryRequest#builder()}
     * </p>
     *
     * @param getAggregateConfigRuleComplianceSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest.Builder}
     *        to create a request.
     * @return Result of the GetAggregateConfigRuleComplianceSummary operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateConfigRuleComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateConfigRuleComplianceSummaryResponse getAggregateConfigRuleComplianceSummary(
            Consumer<GetAggregateConfigRuleComplianceSummaryRequest.Builder> getAggregateConfigRuleComplianceSummaryRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return getAggregateConfigRuleComplianceSummary(GetAggregateConfigRuleComplianceSummaryRequest.builder()
                .applyMutation(getAggregateConfigRuleComplianceSummaryRequest).build());
    }

    /**
     * <p>
     * Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getAggregateConfigRuleComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConfigRuleComplianceSummaryIterable responses = client.getAggregateConfigRuleComplianceSummaryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetAggregateConfigRuleComplianceSummaryIterable responses = client
     *             .getAggregateConfigRuleComplianceSummaryPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConfigRuleComplianceSummaryIterable responses = client.getAggregateConfigRuleComplianceSummaryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateConfigRuleComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAggregateConfigRuleComplianceSummaryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateConfigRuleComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateConfigRuleComplianceSummaryIterable getAggregateConfigRuleComplianceSummaryPaginator(
            GetAggregateConfigRuleComplianceSummaryRequest getAggregateConfigRuleComplianceSummaryRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return new GetAggregateConfigRuleComplianceSummaryIterable(this, getAggregateConfigRuleComplianceSummaryRequest);
    }

    /**
     * <p>
     * Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getAggregateConfigRuleComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConfigRuleComplianceSummaryIterable responses = client.getAggregateConfigRuleComplianceSummaryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetAggregateConfigRuleComplianceSummaryIterable responses = client
     *             .getAggregateConfigRuleComplianceSummaryPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConfigRuleComplianceSummaryIterable responses = client.getAggregateConfigRuleComplianceSummaryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateConfigRuleComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateConfigRuleComplianceSummaryRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateConfigRuleComplianceSummaryRequest#builder()}
     * </p>
     *
     * @param getAggregateConfigRuleComplianceSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateConfigRuleComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateConfigRuleComplianceSummaryIterable getAggregateConfigRuleComplianceSummaryPaginator(
            Consumer<GetAggregateConfigRuleComplianceSummaryRequest.Builder> getAggregateConfigRuleComplianceSummaryRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return getAggregateConfigRuleComplianceSummaryPaginator(GetAggregateConfigRuleComplianceSummaryRequest.builder()
                .applyMutation(getAggregateConfigRuleComplianceSummaryRequest).build());
    }

    /**
     * <p>
     * Returns the count of compliant and noncompliant conformance packs across all Amazon Web Services accounts and
     * Amazon Web Services Regions in an aggregator. You can filter based on Amazon Web Services account ID or Amazon
     * Web Services Region.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note>
     *
     * @param getAggregateConformancePackComplianceSummaryRequest
     * @return Result of the GetAggregateConformancePackComplianceSummary operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateConformancePackComplianceSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateConformancePackComplianceSummaryResponse getAggregateConformancePackComplianceSummary(
            GetAggregateConformancePackComplianceSummaryRequest getAggregateConformancePackComplianceSummaryRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the count of compliant and noncompliant conformance packs across all Amazon Web Services accounts and
     * Amazon Web Services Regions in an aggregator. You can filter based on Amazon Web Services account ID or Amazon
     * Web Services Region.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateConformancePackComplianceSummaryRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateConformancePackComplianceSummaryRequest#builder()}
     * </p>
     *
     * @param getAggregateConformancePackComplianceSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest.Builder}
     *        to create a request.
     * @return Result of the GetAggregateConformancePackComplianceSummary operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateConformancePackComplianceSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateConformancePackComplianceSummaryResponse getAggregateConformancePackComplianceSummary(
            Consumer<GetAggregateConformancePackComplianceSummaryRequest.Builder> getAggregateConformancePackComplianceSummaryRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return getAggregateConformancePackComplianceSummary(GetAggregateConformancePackComplianceSummaryRequest.builder()
                .applyMutation(getAggregateConformancePackComplianceSummaryRequest).build());
    }

    /**
     * <p>
     * Returns the count of compliant and noncompliant conformance packs across all Amazon Web Services accounts and
     * Amazon Web Services Regions in an aggregator. You can filter based on Amazon Web Services account ID or Amazon
     * Web Services Region.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getAggregateConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConformancePackComplianceSummaryIterable responses = client.getAggregateConformancePackComplianceSummaryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetAggregateConformancePackComplianceSummaryIterable responses = client
     *             .getAggregateConformancePackComplianceSummaryPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConformancePackComplianceSummaryIterable responses = client.getAggregateConformancePackComplianceSummaryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAggregateConformancePackComplianceSummaryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateConformancePackComplianceSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateConformancePackComplianceSummaryIterable getAggregateConformancePackComplianceSummaryPaginator(
            GetAggregateConformancePackComplianceSummaryRequest getAggregateConformancePackComplianceSummaryRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return new GetAggregateConformancePackComplianceSummaryIterable(this, getAggregateConformancePackComplianceSummaryRequest);
    }

    /**
     * <p>
     * Returns the count of compliant and noncompliant conformance packs across all Amazon Web Services accounts and
     * Amazon Web Services Regions in an aggregator. You can filter based on Amazon Web Services account ID or Amazon
     * Web Services Region.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a nextToken, the results are displayed on the next
     * page.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getAggregateConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConformancePackComplianceSummaryIterable responses = client.getAggregateConformancePackComplianceSummaryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetAggregateConformancePackComplianceSummaryIterable responses = client
     *             .getAggregateConformancePackComplianceSummaryPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateConformancePackComplianceSummaryIterable responses = client.getAggregateConformancePackComplianceSummaryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateConformancePackComplianceSummaryRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateConformancePackComplianceSummaryRequest#builder()}
     * </p>
     *
     * @param getAggregateConformancePackComplianceSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateConformancePackComplianceSummary
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateConformancePackComplianceSummaryIterable getAggregateConformancePackComplianceSummaryPaginator(
            Consumer<GetAggregateConformancePackComplianceSummaryRequest.Builder> getAggregateConformancePackComplianceSummaryRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return getAggregateConformancePackComplianceSummaryPaginator(GetAggregateConformancePackComplianceSummaryRequest
                .builder().applyMutation(getAggregateConformancePackComplianceSummaryRequest).build());
    }

    /**
     * <p>
     * Returns the resource counts across accounts and regions that are present in your Config aggregator. You can
     * request the resource counts by providing filters and GroupByKey.
     * </p>
     * <p>
     * For example, if the input contains accountID 12345678910 and region us-east-1 in filters, the API returns the
     * count of resources in account ID 12345678910 and region us-east-1. If the input contains ACCOUNT_ID as a
     * GroupByKey, the API returns resource counts for all source accounts that are present in your aggregator.
     * </p>
     *
     * @param getAggregateDiscoveredResourceCountsRequest
     * @return Result of the GetAggregateDiscoveredResourceCounts operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateDiscoveredResourceCountsResponse getAggregateDiscoveredResourceCounts(
            GetAggregateDiscoveredResourceCountsRequest getAggregateDiscoveredResourceCountsRequest) throws ValidationException,
            InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException, AwsServiceException,
            SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the resource counts across accounts and regions that are present in your Config aggregator. You can
     * request the resource counts by providing filters and GroupByKey.
     * </p>
     * <p>
     * For example, if the input contains accountID 12345678910 and region us-east-1 in filters, the API returns the
     * count of resources in account ID 12345678910 and region us-east-1. If the input contains ACCOUNT_ID as a
     * GroupByKey, the API returns resource counts for all source accounts that are present in your aggregator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateDiscoveredResourceCountsRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateDiscoveredResourceCountsRequest#builder()}
     * </p>
     *
     * @param getAggregateDiscoveredResourceCountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest.Builder}
     *        to create a request.
     * @return Result of the GetAggregateDiscoveredResourceCounts operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateDiscoveredResourceCountsResponse getAggregateDiscoveredResourceCounts(
            Consumer<GetAggregateDiscoveredResourceCountsRequest.Builder> getAggregateDiscoveredResourceCountsRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return getAggregateDiscoveredResourceCounts(GetAggregateDiscoveredResourceCountsRequest.builder()
                .applyMutation(getAggregateDiscoveredResourceCountsRequest).build());
    }

    /**
     * <p>
     * Returns the resource counts across accounts and regions that are present in your Config aggregator. You can
     * request the resource counts by providing filters and GroupByKey.
     * </p>
     * <p>
     * For example, if the input contains accountID 12345678910 and region us-east-1 in filters, the API returns the
     * count of resources in account ID 12345678910 and region us-east-1. If the input contains ACCOUNT_ID as a
     * GroupByKey, the API returns resource counts for all source accounts that are present in your aggregator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getAggregateDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateDiscoveredResourceCountsIterable responses = client.getAggregateDiscoveredResourceCountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetAggregateDiscoveredResourceCountsIterable responses = client
     *             .getAggregateDiscoveredResourceCountsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateDiscoveredResourceCountsIterable responses = client.getAggregateDiscoveredResourceCountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAggregateDiscoveredResourceCountsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateDiscoveredResourceCountsIterable getAggregateDiscoveredResourceCountsPaginator(
            GetAggregateDiscoveredResourceCountsRequest getAggregateDiscoveredResourceCountsRequest) throws ValidationException,
            InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException, AwsServiceException,
            SdkClientException, ConfigException {
        return new GetAggregateDiscoveredResourceCountsIterable(this, getAggregateDiscoveredResourceCountsRequest);
    }

    /**
     * <p>
     * Returns the resource counts across accounts and regions that are present in your Config aggregator. You can
     * request the resource counts by providing filters and GroupByKey.
     * </p>
     * <p>
     * For example, if the input contains accountID 12345678910 and region us-east-1 in filters, the API returns the
     * count of resources in account ID 12345678910 and region us-east-1. If the input contains ACCOUNT_ID as a
     * GroupByKey, the API returns resource counts for all source accounts that are present in your aggregator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getAggregateDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateDiscoveredResourceCountsIterable responses = client.getAggregateDiscoveredResourceCountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetAggregateDiscoveredResourceCountsIterable responses = client
     *             .getAggregateDiscoveredResourceCountsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetAggregateDiscoveredResourceCountsIterable responses = client.getAggregateDiscoveredResourceCountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAggregateDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAggregateDiscoveredResourceCountsRequest.Builder} avoiding the need to create one manually via
     * {@link GetAggregateDiscoveredResourceCountsRequest#builder()}
     * </p>
     *
     * @param getAggregateDiscoveredResourceCountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateDiscoveredResourceCountsIterable getAggregateDiscoveredResourceCountsPaginator(
            Consumer<GetAggregateDiscoveredResourceCountsRequest.Builder> getAggregateDiscoveredResourceCountsRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return getAggregateDiscoveredResourceCountsPaginator(GetAggregateDiscoveredResourceCountsRequest.builder()
                .applyMutation(getAggregateDiscoveredResourceCountsRequest).build());
    }

    /**
     * <p>
     * Returns configuration item that is aggregated for your specific resource in a specific source account and region.
     * </p>
     *
     * @param getAggregateResourceConfigRequest
     * @return Result of the GetAggregateResourceConfig operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws OversizedConfigurationItemException
     *         The configuration item size is outside the allowable range.
     * @throws ResourceNotDiscoveredException
     *         You have specified a resource that is either unknown or has not been discovered.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateResourceConfigResponse getAggregateResourceConfig(
            GetAggregateResourceConfigRequest getAggregateResourceConfigRequest) throws ValidationException,
            NoSuchConfigurationAggregatorException, OversizedConfigurationItemException, ResourceNotDiscoveredException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns configuration item that is aggregated for your specific resource in a specific source account and region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAggregateResourceConfigRequest.Builder} avoiding
     * the need to create one manually via {@link GetAggregateResourceConfigRequest#builder()}
     * </p>
     *
     * @param getAggregateResourceConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetAggregateResourceConfigRequest.Builder} to create a
     *        request.
     * @return Result of the GetAggregateResourceConfig operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws OversizedConfigurationItemException
     *         The configuration item size is outside the allowable range.
     * @throws ResourceNotDiscoveredException
     *         You have specified a resource that is either unknown or has not been discovered.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAggregateResourceConfigResponse getAggregateResourceConfig(
            Consumer<GetAggregateResourceConfigRequest.Builder> getAggregateResourceConfigRequest) throws ValidationException,
            NoSuchConfigurationAggregatorException, OversizedConfigurationItemException, ResourceNotDiscoveredException,
            AwsServiceException, SdkClientException, ConfigException {
        return getAggregateResourceConfig(GetAggregateResourceConfigRequest.builder()
                .applyMutation(getAggregateResourceConfigRequest).build());
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Config rule. The results indicate which Amazon Web Services
     * resources were evaluated by the rule, when each resource was last evaluated, and whether each resource complies
     * with the rule.
     * </p>
     *
     * @param getComplianceDetailsByConfigRuleRequest
     * @return Result of the GetComplianceDetailsByConfigRule operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceDetailsByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceDetailsByConfigRuleResponse getComplianceDetailsByConfigRule(
            GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, NoSuchConfigRuleException, AwsServiceException,
            SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Config rule. The results indicate which Amazon Web Services
     * resources were evaluated by the rule, when each resource was last evaluated, and whether each resource complies
     * with the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceDetailsByConfigRuleRequest.Builder}
     * avoiding the need to create one manually via {@link GetComplianceDetailsByConfigRuleRequest#builder()}
     * </p>
     *
     * @param getComplianceDetailsByConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest.Builder} to
     *        create a request.
     * @return Result of the GetComplianceDetailsByConfigRule operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceDetailsByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceDetailsByConfigRuleResponse getComplianceDetailsByConfigRule(
            Consumer<GetComplianceDetailsByConfigRuleRequest.Builder> getComplianceDetailsByConfigRuleRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, NoSuchConfigRuleException, AwsServiceException,
            SdkClientException, ConfigException {
        return getComplianceDetailsByConfigRule(GetComplianceDetailsByConfigRuleRequest.builder()
                .applyMutation(getComplianceDetailsByConfigRuleRequest).build());
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Config rule. The results indicate which Amazon Web Services
     * resources were evaluated by the rule, when each resource was last evaluated, and whether each resource complies
     * with the rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByConfigRuleIterable responses = client.getComplianceDetailsByConfigRulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByConfigRuleIterable responses = client
     *             .getComplianceDetailsByConfigRulePaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByConfigRuleIterable responses = client.getComplianceDetailsByConfigRulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest)}
     * operation.</b>
     * </p>
     *
     * @param getComplianceDetailsByConfigRuleRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceDetailsByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceDetailsByConfigRuleIterable getComplianceDetailsByConfigRulePaginator(
            GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, NoSuchConfigRuleException, AwsServiceException,
            SdkClientException, ConfigException {
        return new GetComplianceDetailsByConfigRuleIterable(this, getComplianceDetailsByConfigRuleRequest);
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Config rule. The results indicate which Amazon Web Services
     * resources were evaluated by the rule, when each resource was last evaluated, and whether each resource complies
     * with the rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByConfigRuleIterable responses = client.getComplianceDetailsByConfigRulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByConfigRuleIterable responses = client
     *             .getComplianceDetailsByConfigRulePaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByConfigRuleIterable responses = client.getComplianceDetailsByConfigRulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getComplianceDetailsByConfigRule(software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceDetailsByConfigRuleRequest.Builder}
     * avoiding the need to create one manually via {@link GetComplianceDetailsByConfigRuleRequest#builder()}
     * </p>
     *
     * @param getComplianceDetailsByConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceDetailsByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceDetailsByConfigRuleIterable getComplianceDetailsByConfigRulePaginator(
            Consumer<GetComplianceDetailsByConfigRuleRequest.Builder> getComplianceDetailsByConfigRuleRequest)
            throws InvalidParameterValueException, InvalidNextTokenException, NoSuchConfigRuleException, AwsServiceException,
            SdkClientException, ConfigException {
        return getComplianceDetailsByConfigRulePaginator(GetComplianceDetailsByConfigRuleRequest.builder()
                .applyMutation(getComplianceDetailsByConfigRuleRequest).build());
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Amazon Web Services resource. The results indicate which Config
     * rules were used to evaluate the resource, when each rule was last invoked, and whether the resource complies with
     * each rule.
     * </p>
     *
     * @param getComplianceDetailsByResourceRequest
     * @return Result of the GetComplianceDetailsByResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceDetailsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceDetailsByResourceResponse getComplianceDetailsByResource(
            GetComplianceDetailsByResourceRequest getComplianceDetailsByResourceRequest) throws InvalidParameterValueException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Amazon Web Services resource. The results indicate which Config
     * rules were used to evaluate the resource, when each rule was last invoked, and whether the resource complies with
     * each rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceDetailsByResourceRequest.Builder}
     * avoiding the need to create one manually via {@link GetComplianceDetailsByResourceRequest#builder()}
     * </p>
     *
     * @param getComplianceDetailsByResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest.Builder} to
     *        create a request.
     * @return Result of the GetComplianceDetailsByResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceDetailsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceDetailsByResourceResponse getComplianceDetailsByResource(
            Consumer<GetComplianceDetailsByResourceRequest.Builder> getComplianceDetailsByResourceRequest)
            throws InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return getComplianceDetailsByResource(GetComplianceDetailsByResourceRequest.builder()
                .applyMutation(getComplianceDetailsByResourceRequest).build());
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Amazon Web Services resource. The results indicate which Config
     * rules were used to evaluate the resource, when each rule was last invoked, and whether the resource complies with
     * each rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getComplianceDetailsByResource(software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByResourceIterable responses = client.getComplianceDetailsByResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByResourceIterable responses = client
     *             .getComplianceDetailsByResourcePaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByResourceIterable responses = client.getComplianceDetailsByResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getComplianceDetailsByResource(software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param getComplianceDetailsByResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceDetailsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceDetailsByResourceIterable getComplianceDetailsByResourcePaginator(
            GetComplianceDetailsByResourceRequest getComplianceDetailsByResourceRequest) throws InvalidParameterValueException,
            AwsServiceException, SdkClientException, ConfigException {
        return new GetComplianceDetailsByResourceIterable(this, getComplianceDetailsByResourceRequest);
    }

    /**
     * <p>
     * Returns the evaluation results for the specified Amazon Web Services resource. The results indicate which Config
     * rules were used to evaluate the resource, when each rule was last invoked, and whether the resource complies with
     * each rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getComplianceDetailsByResource(software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByResourceIterable responses = client.getComplianceDetailsByResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByResourceIterable responses = client
     *             .getComplianceDetailsByResourcePaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetComplianceDetailsByResourceIterable responses = client.getComplianceDetailsByResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getComplianceDetailsByResource(software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceDetailsByResourceRequest.Builder}
     * avoiding the need to create one manually via {@link GetComplianceDetailsByResourceRequest#builder()}
     * </p>
     *
     * @param getComplianceDetailsByResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceDetailsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceDetailsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceDetailsByResourceIterable getComplianceDetailsByResourcePaginator(
            Consumer<GetComplianceDetailsByResourceRequest.Builder> getComplianceDetailsByResourceRequest)
            throws InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return getComplianceDetailsByResourcePaginator(GetComplianceDetailsByResourceRequest.builder()
                .applyMutation(getComplianceDetailsByResourceRequest).build());
    }

    /**
     * <p>
     * Returns the number of Config rules that are compliant and noncompliant, up to a maximum of 25 for each.
     * </p>
     *
     * @param getComplianceSummaryByConfigRuleRequest
     * @return Result of the GetComplianceSummaryByConfigRule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceSummaryByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceSummaryByConfigRuleResponse getComplianceSummaryByConfigRule(
            GetComplianceSummaryByConfigRuleRequest getComplianceSummaryByConfigRuleRequest) throws AwsServiceException,
            SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of Config rules that are compliant and noncompliant, up to a maximum of 25 for each.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceSummaryByConfigRuleRequest.Builder}
     * avoiding the need to create one manually via {@link GetComplianceSummaryByConfigRuleRequest#builder()}
     * </p>
     *
     * @param getComplianceSummaryByConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleRequest.Builder} to
     *        create a request.
     * @return Result of the GetComplianceSummaryByConfigRule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceSummaryByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceSummaryByConfigRuleResponse getComplianceSummaryByConfigRule(
            Consumer<GetComplianceSummaryByConfigRuleRequest.Builder> getComplianceSummaryByConfigRuleRequest)
            throws AwsServiceException, SdkClientException, ConfigException {
        return getComplianceSummaryByConfigRule(GetComplianceSummaryByConfigRuleRequest.builder()
                .applyMutation(getComplianceSummaryByConfigRuleRequest).build());
    }

    /**
     * <p>
     * Returns the number of Config rules that are compliant and noncompliant, up to a maximum of 25 for each.
     * </p>
     *
     * @return Result of the GetComplianceSummaryByConfigRule operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceSummaryByConfigRule
     * @see #getComplianceSummaryByConfigRule(GetComplianceSummaryByConfigRuleRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceSummaryByConfigRuleResponse getComplianceSummaryByConfigRule() throws AwsServiceException,
            SdkClientException, ConfigException {
        return getComplianceSummaryByConfigRule(GetComplianceSummaryByConfigRuleRequest.builder().build());
    }

    /**
     * <p>
     * Returns the number of resources that are compliant and the number that are noncompliant. You can specify one or
     * more resource types to get these numbers for each resource type. The maximum number returned is 100.
     * </p>
     *
     * @param getComplianceSummaryByResourceTypeRequest
     * @return Result of the GetComplianceSummaryByResourceType operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceSummaryByResourceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceSummaryByResourceTypeResponse getComplianceSummaryByResourceType(
            GetComplianceSummaryByResourceTypeRequest getComplianceSummaryByResourceTypeRequest)
            throws InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the number of resources that are compliant and the number that are noncompliant. You can specify one or
     * more resource types to get these numbers for each resource type. The maximum number returned is 100.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceSummaryByResourceTypeRequest.Builder}
     * avoiding the need to create one manually via {@link GetComplianceSummaryByResourceTypeRequest#builder()}
     * </p>
     *
     * @param getComplianceSummaryByResourceTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest.Builder} to
     *        create a request.
     * @return Result of the GetComplianceSummaryByResourceType operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceSummaryByResourceType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceSummaryByResourceTypeResponse getComplianceSummaryByResourceType(
            Consumer<GetComplianceSummaryByResourceTypeRequest.Builder> getComplianceSummaryByResourceTypeRequest)
            throws InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return getComplianceSummaryByResourceType(GetComplianceSummaryByResourceTypeRequest.builder()
                .applyMutation(getComplianceSummaryByResourceTypeRequest).build());
    }

    /**
     * <p>
     * Returns the number of resources that are compliant and the number that are noncompliant. You can specify one or
     * more resource types to get these numbers for each resource type. The maximum number returned is 100.
     * </p>
     *
     * @return Result of the GetComplianceSummaryByResourceType operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetComplianceSummaryByResourceType
     * @see #getComplianceSummaryByResourceType(GetComplianceSummaryByResourceTypeRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetComplianceSummaryByResourceType"
     *      target="_top">AWS API Documentation</a>
     */
    default GetComplianceSummaryByResourceTypeResponse getComplianceSummaryByResourceType()
            throws InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return getComplianceSummaryByResourceType(GetComplianceSummaryByResourceTypeRequest.builder().build());
    }

    /**
     * <p>
     * Returns compliance details of a conformance pack for all Amazon Web Services resources that are monitered by
     * conformance pack.
     * </p>
     *
     * @param getConformancePackComplianceDetailsRequest
     * @return Result of the GetConformancePackComplianceDetails operation returned by the service.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws NoSuchConfigRuleInConformancePackException
     *         Config rule that you passed in the filter does not exist.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetConformancePackComplianceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConformancePackComplianceDetailsResponse getConformancePackComplianceDetails(
            GetConformancePackComplianceDetailsRequest getConformancePackComplianceDetailsRequest) throws InvalidLimitException,
            InvalidNextTokenException, NoSuchConformancePackException, NoSuchConfigRuleInConformancePackException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns compliance details of a conformance pack for all Amazon Web Services resources that are monitered by
     * conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConformancePackComplianceDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetConformancePackComplianceDetailsRequest#builder()}
     * </p>
     *
     * @param getConformancePackComplianceDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest.Builder} to
     *        create a request.
     * @return Result of the GetConformancePackComplianceDetails operation returned by the service.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws NoSuchConfigRuleInConformancePackException
     *         Config rule that you passed in the filter does not exist.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetConformancePackComplianceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConformancePackComplianceDetailsResponse getConformancePackComplianceDetails(
            Consumer<GetConformancePackComplianceDetailsRequest.Builder> getConformancePackComplianceDetailsRequest)
            throws InvalidLimitException, InvalidNextTokenException, NoSuchConformancePackException,
            NoSuchConfigRuleInConformancePackException, InvalidParameterValueException, AwsServiceException, SdkClientException,
            ConfigException {
        return getConformancePackComplianceDetails(GetConformancePackComplianceDetailsRequest.builder()
                .applyMutation(getConformancePackComplianceDetailsRequest).build());
    }

    /**
     * <p>
     * Returns compliance details of a conformance pack for all Amazon Web Services resources that are monitered by
     * conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getConformancePackComplianceDetails(software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceDetailsIterable responses = client.getConformancePackComplianceDetailsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceDetailsIterable responses = client
     *             .getConformancePackComplianceDetailsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceDetailsIterable responses = client.getConformancePackComplianceDetailsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConformancePackComplianceDetails(software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getConformancePackComplianceDetailsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws NoSuchConfigRuleInConformancePackException
     *         Config rule that you passed in the filter does not exist.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetConformancePackComplianceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConformancePackComplianceDetailsIterable getConformancePackComplianceDetailsPaginator(
            GetConformancePackComplianceDetailsRequest getConformancePackComplianceDetailsRequest) throws InvalidLimitException,
            InvalidNextTokenException, NoSuchConformancePackException, NoSuchConfigRuleInConformancePackException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return new GetConformancePackComplianceDetailsIterable(this, getConformancePackComplianceDetailsRequest);
    }

    /**
     * <p>
     * Returns compliance details of a conformance pack for all Amazon Web Services resources that are monitered by
     * conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getConformancePackComplianceDetails(software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceDetailsIterable responses = client.getConformancePackComplianceDetailsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceDetailsIterable responses = client
     *             .getConformancePackComplianceDetailsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceDetailsIterable responses = client.getConformancePackComplianceDetailsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConformancePackComplianceDetails(software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConformancePackComplianceDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link GetConformancePackComplianceDetailsRequest#builder()}
     * </p>
     *
     * @param getConformancePackComplianceDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws NoSuchConfigRuleInConformancePackException
     *         Config rule that you passed in the filter does not exist.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetConformancePackComplianceDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConformancePackComplianceDetailsIterable getConformancePackComplianceDetailsPaginator(
            Consumer<GetConformancePackComplianceDetailsRequest.Builder> getConformancePackComplianceDetailsRequest)
            throws InvalidLimitException, InvalidNextTokenException, NoSuchConformancePackException,
            NoSuchConfigRuleInConformancePackException, InvalidParameterValueException, AwsServiceException, SdkClientException,
            ConfigException {
        return getConformancePackComplianceDetailsPaginator(GetConformancePackComplianceDetailsRequest.builder()
                .applyMutation(getConformancePackComplianceDetailsRequest).build());
    }

    /**
     * <p>
     * Returns compliance details for the conformance pack based on the cumulative compliance results of all the rules
     * in that conformance pack.
     * </p>
     *
     * @param getConformancePackComplianceSummaryRequest
     * @return Result of the GetConformancePackComplianceSummary operation returned by the service.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetConformancePackComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConformancePackComplianceSummaryResponse getConformancePackComplianceSummary(
            GetConformancePackComplianceSummaryRequest getConformancePackComplianceSummaryRequest)
            throws NoSuchConformancePackException, InvalidLimitException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns compliance details for the conformance pack based on the cumulative compliance results of all the rules
     * in that conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConformancePackComplianceSummaryRequest.Builder}
     * avoiding the need to create one manually via {@link GetConformancePackComplianceSummaryRequest#builder()}
     * </p>
     *
     * @param getConformancePackComplianceSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest.Builder} to
     *        create a request.
     * @return Result of the GetConformancePackComplianceSummary operation returned by the service.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetConformancePackComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConformancePackComplianceSummaryResponse getConformancePackComplianceSummary(
            Consumer<GetConformancePackComplianceSummaryRequest.Builder> getConformancePackComplianceSummaryRequest)
            throws NoSuchConformancePackException, InvalidLimitException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        return getConformancePackComplianceSummary(GetConformancePackComplianceSummaryRequest.builder()
                .applyMutation(getConformancePackComplianceSummaryRequest).build());
    }

    /**
     * <p>
     * Returns compliance details for the conformance pack based on the cumulative compliance results of all the rules
     * in that conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceSummaryIterable responses = client.getConformancePackComplianceSummaryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceSummaryIterable responses = client
     *             .getConformancePackComplianceSummaryPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceSummaryIterable responses = client.getConformancePackComplianceSummaryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getConformancePackComplianceSummaryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetConformancePackComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConformancePackComplianceSummaryIterable getConformancePackComplianceSummaryPaginator(
            GetConformancePackComplianceSummaryRequest getConformancePackComplianceSummaryRequest)
            throws NoSuchConformancePackException, InvalidLimitException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        return new GetConformancePackComplianceSummaryIterable(this, getConformancePackComplianceSummaryRequest);
    }

    /**
     * <p>
     * Returns compliance details for the conformance pack based on the cumulative compliance results of all the rules
     * in that conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceSummaryIterable responses = client.getConformancePackComplianceSummaryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceSummaryIterable responses = client
     *             .getConformancePackComplianceSummaryPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetConformancePackComplianceSummaryIterable responses = client.getConformancePackComplianceSummaryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getConformancePackComplianceSummary(software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConformancePackComplianceSummaryRequest.Builder}
     * avoiding the need to create one manually via {@link GetConformancePackComplianceSummaryRequest#builder()}
     * </p>
     *
     * @param getConformancePackComplianceSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchConformancePackException
     *         You specified one or more conformance packs that do not exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetConformancePackComplianceSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConformancePackComplianceSummaryIterable getConformancePackComplianceSummaryPaginator(
            Consumer<GetConformancePackComplianceSummaryRequest.Builder> getConformancePackComplianceSummaryRequest)
            throws NoSuchConformancePackException, InvalidLimitException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        return getConformancePackComplianceSummaryPaginator(GetConformancePackComplianceSummaryRequest.builder()
                .applyMutation(getConformancePackComplianceSummaryRequest).build());
    }

    /**
     * <p>
     * Returns the policy definition containing the logic for your Config Custom Policy rule.
     * </p>
     *
     * @param getCustomRulePolicyRequest
     * @return Result of the GetCustomRulePolicy operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetCustomRulePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetCustomRulePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCustomRulePolicyResponse getCustomRulePolicy(GetCustomRulePolicyRequest getCustomRulePolicyRequest)
            throws NoSuchConfigRuleException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the policy definition containing the logic for your Config Custom Policy rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCustomRulePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetCustomRulePolicyRequest#builder()}
     * </p>
     *
     * @param getCustomRulePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetCustomRulePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetCustomRulePolicy operation returned by the service.
     * @throws NoSuchConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an Config Process Check rule, that
     *         the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetCustomRulePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetCustomRulePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCustomRulePolicyResponse getCustomRulePolicy(
            Consumer<GetCustomRulePolicyRequest.Builder> getCustomRulePolicyRequest) throws NoSuchConfigRuleException,
            AwsServiceException, SdkClientException, ConfigException {
        return getCustomRulePolicy(GetCustomRulePolicyRequest.builder().applyMutation(getCustomRulePolicyRequest).build());
    }

    /**
     * <p>
     * Returns the resource types, the number of each resource type, and the total number of resources that Config is
     * recording in this region for your Amazon Web Services account.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM
     * users, and 15 S3 buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Config returns the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource types (EC2 instances, IAM users, and S3 buckets).
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of each resource type (25, 20, and 15).
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of all resources (60).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * The response is paginated. By default, Config lists 100 <a>ResourceCount</a> objects on each page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * If you make a call to the <a>GetDiscoveredResourceCounts</a> action, you might not immediately receive resource
     * counts in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are a new Config customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * You just enabled resource recording.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It might take a few minutes for Config to record and count your resources. Wait a few minutes and then retry the
     * <a>GetDiscoveredResourceCounts</a> action.
     * </p>
     * </note>
     *
     * @param getDiscoveredResourceCountsRequest
     * @return Result of the GetDiscoveredResourceCounts operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDiscoveredResourceCountsResponse getDiscoveredResourceCounts(
            GetDiscoveredResourceCountsRequest getDiscoveredResourceCountsRequest) throws ValidationException,
            InvalidLimitException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the resource types, the number of each resource type, and the total number of resources that Config is
     * recording in this region for your Amazon Web Services account.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM
     * users, and 15 S3 buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Config returns the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource types (EC2 instances, IAM users, and S3 buckets).
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of each resource type (25, 20, and 15).
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of all resources (60).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * The response is paginated. By default, Config lists 100 <a>ResourceCount</a> objects on each page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * If you make a call to the <a>GetDiscoveredResourceCounts</a> action, you might not immediately receive resource
     * counts in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are a new Config customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * You just enabled resource recording.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It might take a few minutes for Config to record and count your resources. Wait a few minutes and then retry the
     * <a>GetDiscoveredResourceCounts</a> action.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDiscoveredResourceCountsRequest.Builder}
     * avoiding the need to create one manually via {@link GetDiscoveredResourceCountsRequest#builder()}
     * </p>
     *
     * @param getDiscoveredResourceCountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest.Builder} to create
     *        a request.
     * @return Result of the GetDiscoveredResourceCounts operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDiscoveredResourceCountsResponse getDiscoveredResourceCounts(
            Consumer<GetDiscoveredResourceCountsRequest.Builder> getDiscoveredResourceCountsRequest) throws ValidationException,
            InvalidLimitException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        return getDiscoveredResourceCounts(GetDiscoveredResourceCountsRequest.builder()
                .applyMutation(getDiscoveredResourceCountsRequest).build());
    }

    /**
     * <p>
     * Returns the resource types, the number of each resource type, and the total number of resources that Config is
     * recording in this region for your Amazon Web Services account.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM
     * users, and 15 S3 buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Config returns the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource types (EC2 instances, IAM users, and S3 buckets).
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of each resource type (25, 20, and 15).
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of all resources (60).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * The response is paginated. By default, Config lists 100 <a>ResourceCount</a> objects on each page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * If you make a call to the <a>GetDiscoveredResourceCounts</a> action, you might not immediately receive resource
     * counts in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are a new Config customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * You just enabled resource recording.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It might take a few minutes for Config to record and count your resources. Wait a few minutes and then retry the
     * <a>GetDiscoveredResourceCounts</a> action.
     * </p>
     * </note>
     *
     * @return Result of the GetDiscoveredResourceCounts operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetDiscoveredResourceCounts
     * @see #getDiscoveredResourceCounts(GetDiscoveredResourceCountsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDiscoveredResourceCountsResponse getDiscoveredResourceCounts() throws ValidationException, InvalidLimitException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        return getDiscoveredResourceCounts(GetDiscoveredResourceCountsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the resource types, the number of each resource type, and the total number of resources that Config is
     * recording in this region for your Amazon Web Services account.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM
     * users, and 15 S3 buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Config returns the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource types (EC2 instances, IAM users, and S3 buckets).
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of each resource type (25, 20, and 15).
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of all resources (60).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * The response is paginated. By default, Config lists 100 <a>ResourceCount</a> objects on each page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * If you make a call to the <a>GetDiscoveredResourceCounts</a> action, you might not immediately receive resource
     * counts in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are a new Config customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * You just enabled resource recording.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It might take a few minutes for Config to record and count your resources. Wait a few minutes and then retry the
     * <a>GetDiscoveredResourceCounts</a> action.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsIterable responses = client.getDiscoveredResourceCountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsIterable responses = client
     *             .getDiscoveredResourceCountsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsIterable responses = client.getDiscoveredResourceCountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetDiscoveredResourceCounts
     * @see #getDiscoveredResourceCountsPaginator(GetDiscoveredResourceCountsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDiscoveredResourceCountsIterable getDiscoveredResourceCountsPaginator() throws ValidationException,
            InvalidLimitException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        return getDiscoveredResourceCountsPaginator(GetDiscoveredResourceCountsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the resource types, the number of each resource type, and the total number of resources that Config is
     * recording in this region for your Amazon Web Services account.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM
     * users, and 15 S3 buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Config returns the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource types (EC2 instances, IAM users, and S3 buckets).
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of each resource type (25, 20, and 15).
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of all resources (60).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * The response is paginated. By default, Config lists 100 <a>ResourceCount</a> objects on each page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * If you make a call to the <a>GetDiscoveredResourceCounts</a> action, you might not immediately receive resource
     * counts in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are a new Config customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * You just enabled resource recording.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It might take a few minutes for Config to record and count your resources. Wait a few minutes and then retry the
     * <a>GetDiscoveredResourceCounts</a> action.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsIterable responses = client.getDiscoveredResourceCountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsIterable responses = client
     *             .getDiscoveredResourceCountsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsIterable responses = client.getDiscoveredResourceCountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getDiscoveredResourceCountsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDiscoveredResourceCountsIterable getDiscoveredResourceCountsPaginator(
            GetDiscoveredResourceCountsRequest getDiscoveredResourceCountsRequest) throws ValidationException,
            InvalidLimitException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        return new GetDiscoveredResourceCountsIterable(this, getDiscoveredResourceCountsRequest);
    }

    /**
     * <p>
     * Returns the resource types, the number of each resource type, and the total number of resources that Config is
     * recording in this region for your Amazon Web Services account.
     * </p>
     * <p class="title">
     * <b>Example</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Config is recording three resource types in the US East (Ohio) Region for your account: 25 EC2 instances, 20 IAM
     * users, and 15 S3 buckets.
     * </p>
     * </li>
     * <li>
     * <p>
     * You make a call to the <code>GetDiscoveredResourceCounts</code> action and specify that you want all resource
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Config returns the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource types (EC2 instances, IAM users, and S3 buckets).
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of each resource type (25, 20, and 15).
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of all resources (60).
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ol>
     * <p>
     * The response is paginated. By default, Config lists 100 <a>ResourceCount</a> objects on each page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * If you make a call to the <a>GetDiscoveredResourceCounts</a> action, you might not immediately receive resource
     * counts in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You are a new Config customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * You just enabled resource recording.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It might take a few minutes for Config to record and count your resources. Wait a few minutes and then retry the
     * <a>GetDiscoveredResourceCounts</a> action.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsIterable responses = client.getDiscoveredResourceCountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsIterable responses = client
     *             .getDiscoveredResourceCountsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetDiscoveredResourceCountsIterable responses = client.getDiscoveredResourceCountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDiscoveredResourceCounts(software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDiscoveredResourceCountsRequest.Builder}
     * avoiding the need to create one manually via {@link GetDiscoveredResourceCountsRequest#builder()}
     * </p>
     *
     * @param getDiscoveredResourceCountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetDiscoveredResourceCounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetDiscoveredResourceCounts"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDiscoveredResourceCountsIterable getDiscoveredResourceCountsPaginator(
            Consumer<GetDiscoveredResourceCountsRequest.Builder> getDiscoveredResourceCountsRequest) throws ValidationException,
            InvalidLimitException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        return getDiscoveredResourceCountsPaginator(GetDiscoveredResourceCountsRequest.builder()
                .applyMutation(getDiscoveredResourceCountsRequest).build());
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization Config rule.
     * </p>
     *
     * @param getOrganizationConfigRuleDetailedStatusRequest
     * @return Result of the GetOrganizationConfigRuleDetailedStatus operation returned by the service.
     * @throws NoSuchOrganizationConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check
     *         rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying
     *         again.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetOrganizationConfigRuleDetailedStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationConfigRuleDetailedStatusResponse getOrganizationConfigRuleDetailedStatus(
            GetOrganizationConfigRuleDetailedStatusRequest getOrganizationConfigRuleDetailedStatusRequest)
            throws NoSuchOrganizationConfigRuleException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization Config rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetOrganizationConfigRuleDetailedStatusRequest.Builder} avoiding the need to create one manually via
     * {@link GetOrganizationConfigRuleDetailedStatusRequest#builder()}
     * </p>
     *
     * @param getOrganizationConfigRuleDetailedStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest.Builder}
     *        to create a request.
     * @return Result of the GetOrganizationConfigRuleDetailedStatus operation returned by the service.
     * @throws NoSuchOrganizationConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check
     *         rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying
     *         again.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetOrganizationConfigRuleDetailedStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationConfigRuleDetailedStatusResponse getOrganizationConfigRuleDetailedStatus(
            Consumer<GetOrganizationConfigRuleDetailedStatusRequest.Builder> getOrganizationConfigRuleDetailedStatusRequest)
            throws NoSuchOrganizationConfigRuleException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return getOrganizationConfigRuleDetailedStatus(GetOrganizationConfigRuleDetailedStatusRequest.builder()
                .applyMutation(getOrganizationConfigRuleDetailedStatusRequest).build());
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization Config rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getOrganizationConfigRuleDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConfigRuleDetailedStatusIterable responses = client.getOrganizationConfigRuleDetailedStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetOrganizationConfigRuleDetailedStatusIterable responses = client
     *             .getOrganizationConfigRuleDetailedStatusPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConfigRuleDetailedStatusIterable responses = client.getOrganizationConfigRuleDetailedStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOrganizationConfigRuleDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getOrganizationConfigRuleDetailedStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchOrganizationConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check
     *         rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying
     *         again.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetOrganizationConfigRuleDetailedStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationConfigRuleDetailedStatusIterable getOrganizationConfigRuleDetailedStatusPaginator(
            GetOrganizationConfigRuleDetailedStatusRequest getOrganizationConfigRuleDetailedStatusRequest)
            throws NoSuchOrganizationConfigRuleException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return new GetOrganizationConfigRuleDetailedStatusIterable(this, getOrganizationConfigRuleDetailedStatusRequest);
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization Config rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getOrganizationConfigRuleDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConfigRuleDetailedStatusIterable responses = client.getOrganizationConfigRuleDetailedStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetOrganizationConfigRuleDetailedStatusIterable responses = client
     *             .getOrganizationConfigRuleDetailedStatusPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConfigRuleDetailedStatusIterable responses = client.getOrganizationConfigRuleDetailedStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOrganizationConfigRuleDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetOrganizationConfigRuleDetailedStatusRequest.Builder} avoiding the need to create one manually via
     * {@link GetOrganizationConfigRuleDetailedStatusRequest#builder()}
     * </p>
     *
     * @param getOrganizationConfigRuleDetailedStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchOrganizationConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check
     *         rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying
     *         again.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetOrganizationConfigRuleDetailedStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConfigRuleDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationConfigRuleDetailedStatusIterable getOrganizationConfigRuleDetailedStatusPaginator(
            Consumer<GetOrganizationConfigRuleDetailedStatusRequest.Builder> getOrganizationConfigRuleDetailedStatusRequest)
            throws NoSuchOrganizationConfigRuleException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return getOrganizationConfigRuleDetailedStatusPaginator(GetOrganizationConfigRuleDetailedStatusRequest.builder()
                .applyMutation(getOrganizationConfigRuleDetailedStatusRequest).build());
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization conformance pack.
     * </p>
     *
     * @param getOrganizationConformancePackDetailedStatusRequest
     * @return Result of the GetOrganizationConformancePackDetailedStatus operation returned by the service.
     * @throws NoSuchOrganizationConformancePackException
     *         Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetOrganizationConformancePackDetailedStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConformancePackDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationConformancePackDetailedStatusResponse getOrganizationConformancePackDetailedStatus(
            GetOrganizationConformancePackDetailedStatusRequest getOrganizationConformancePackDetailedStatusRequest)
            throws NoSuchOrganizationConformancePackException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetOrganizationConformancePackDetailedStatusRequest.Builder} avoiding the need to create one manually via
     * {@link GetOrganizationConformancePackDetailedStatusRequest#builder()}
     * </p>
     *
     * @param getOrganizationConformancePackDetailedStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest.Builder}
     *        to create a request.
     * @return Result of the GetOrganizationConformancePackDetailedStatus operation returned by the service.
     * @throws NoSuchOrganizationConformancePackException
     *         Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetOrganizationConformancePackDetailedStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConformancePackDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationConformancePackDetailedStatusResponse getOrganizationConformancePackDetailedStatus(
            Consumer<GetOrganizationConformancePackDetailedStatusRequest.Builder> getOrganizationConformancePackDetailedStatusRequest)
            throws NoSuchOrganizationConformancePackException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return getOrganizationConformancePackDetailedStatus(GetOrganizationConformancePackDetailedStatusRequest.builder()
                .applyMutation(getOrganizationConformancePackDetailedStatusRequest).build());
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getOrganizationConformancePackDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConformancePackDetailedStatusIterable responses = client.getOrganizationConformancePackDetailedStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetOrganizationConformancePackDetailedStatusIterable responses = client
     *             .getOrganizationConformancePackDetailedStatusPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConformancePackDetailedStatusIterable responses = client.getOrganizationConformancePackDetailedStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOrganizationConformancePackDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getOrganizationConformancePackDetailedStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchOrganizationConformancePackException
     *         Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetOrganizationConformancePackDetailedStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConformancePackDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationConformancePackDetailedStatusIterable getOrganizationConformancePackDetailedStatusPaginator(
            GetOrganizationConformancePackDetailedStatusRequest getOrganizationConformancePackDetailedStatusRequest)
            throws NoSuchOrganizationConformancePackException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return new GetOrganizationConformancePackDetailedStatusIterable(this, getOrganizationConformancePackDetailedStatusRequest);
    }

    /**
     * <p>
     * Returns detailed status for each member account within an organization for a given organization conformance pack.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getOrganizationConformancePackDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConformancePackDetailedStatusIterable responses = client.getOrganizationConformancePackDetailedStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetOrganizationConformancePackDetailedStatusIterable responses = client
     *             .getOrganizationConformancePackDetailedStatusPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetOrganizationConformancePackDetailedStatusIterable responses = client.getOrganizationConformancePackDetailedStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOrganizationConformancePackDetailedStatus(software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetOrganizationConformancePackDetailedStatusRequest.Builder} avoiding the need to create one manually via
     * {@link GetOrganizationConformancePackDetailedStatusRequest#builder()}
     * </p>
     *
     * @param getOrganizationConformancePackDetailedStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchOrganizationConformancePackException
     *         Config organization conformance pack that you passed in the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetOrganizationConformancePackDetailedStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationConformancePackDetailedStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationConformancePackDetailedStatusIterable getOrganizationConformancePackDetailedStatusPaginator(
            Consumer<GetOrganizationConformancePackDetailedStatusRequest.Builder> getOrganizationConformancePackDetailedStatusRequest)
            throws NoSuchOrganizationConformancePackException, InvalidLimitException, InvalidNextTokenException,
            OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        return getOrganizationConformancePackDetailedStatusPaginator(GetOrganizationConformancePackDetailedStatusRequest
                .builder().applyMutation(getOrganizationConformancePackDetailedStatusRequest).build());
    }

    /**
     * <p>
     * Returns the policy definition containing the logic for your organization Config Custom Policy rule.
     * </p>
     *
     * @param getOrganizationCustomRulePolicyRequest
     * @return Result of the GetOrganizationCustomRulePolicy operation returned by the service.
     * @throws NoSuchOrganizationConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check
     *         rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying
     *         again.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetOrganizationCustomRulePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationCustomRulePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationCustomRulePolicyResponse getOrganizationCustomRulePolicy(
            GetOrganizationCustomRulePolicyRequest getOrganizationCustomRulePolicyRequest)
            throws NoSuchOrganizationConfigRuleException, OrganizationAccessDeniedException, AwsServiceException,
            SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the policy definition containing the logic for your organization Config Custom Policy rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOrganizationCustomRulePolicyRequest.Builder}
     * avoiding the need to create one manually via {@link GetOrganizationCustomRulePolicyRequest#builder()}
     * </p>
     *
     * @param getOrganizationCustomRulePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyRequest.Builder} to
     *        create a request.
     * @return Result of the GetOrganizationCustomRulePolicy operation returned by the service.
     * @throws NoSuchOrganizationConfigRuleException
     *         The Config rule in the request is not valid. Verify that the rule is an organization Config Process Check
     *         rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are used before trying
     *         again.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following
     *         reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetOrganizationCustomRulePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetOrganizationCustomRulePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationCustomRulePolicyResponse getOrganizationCustomRulePolicy(
            Consumer<GetOrganizationCustomRulePolicyRequest.Builder> getOrganizationCustomRulePolicyRequest)
            throws NoSuchOrganizationConfigRuleException, OrganizationAccessDeniedException, AwsServiceException,
            SdkClientException, ConfigException {
        return getOrganizationCustomRulePolicy(GetOrganizationCustomRulePolicyRequest.builder()
                .applyMutation(getOrganizationCustomRulePolicyRequest).build());
    }

    /**
     * <important>
     * <p>
     * For accurate reporting on the compliance status, you must record the <code>AWS::Config::ResourceCompliance</code>
     * resource type. For more information, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html">Selecting Which Resources
     * Config Records</a>.
     * </p>
     * </important>
     * <p>
     * Returns a list of <code>ConfigurationItems</code> for the specified resource. The list contains details about
     * each state of the resource during the specified time interval. If you specified a retention period to retain your
     * <code>ConfigurationItems</code> between a minimum of 30 days and a maximum of 7 years (2557 days), Config returns
     * the <code>ConfigurationItems</code> for the specified retention period.
     * </p>
     * <p>
     * The response is paginated. By default, Config returns a limit of 10 configuration items per page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * Each call to the API is limited to span a duration of seven days. It is likely that the number of records
     * returned is smaller than the specified <code>limit</code>. In such cases, you can make another call, using the
     * <code>nextToken</code>.
     * </p>
     * </note>
     *
     * @param getResourceConfigHistoryRequest
     *        The input for the <a>GetResourceConfigHistory</a> action.
     * @return Result of the GetResourceConfigHistory operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidTimeRangeException
     *         The specified time range is not valid. The earlier time is not chronologically before the later time.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws ResourceNotDiscoveredException
     *         You have specified a resource that is either unknown or has not been discovered.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetResourceConfigHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceConfigHistoryResponse getResourceConfigHistory(
            GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) throws ValidationException,
            InvalidTimeRangeException, InvalidLimitException, InvalidNextTokenException,
            NoAvailableConfigurationRecorderException, ResourceNotDiscoveredException, AwsServiceException, SdkClientException,
            ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <important>
     * <p>
     * For accurate reporting on the compliance status, you must record the <code>AWS::Config::ResourceCompliance</code>
     * resource type. For more information, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html">Selecting Which Resources
     * Config Records</a>.
     * </p>
     * </important>
     * <p>
     * Returns a list of <code>ConfigurationItems</code> for the specified resource. The list contains details about
     * each state of the resource during the specified time interval. If you specified a retention period to retain your
     * <code>ConfigurationItems</code> between a minimum of 30 days and a maximum of 7 years (2557 days), Config returns
     * the <code>ConfigurationItems</code> for the specified retention period.
     * </p>
     * <p>
     * The response is paginated. By default, Config returns a limit of 10 configuration items per page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * Each call to the API is limited to span a duration of seven days. It is likely that the number of records
     * returned is smaller than the specified <code>limit</code>. In such cases, you can make another call, using the
     * <code>nextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceConfigHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetResourceConfigHistoryRequest#builder()}
     * </p>
     *
     * @param getResourceConfigHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest.Builder} to create a
     *        request. The input for the <a>GetResourceConfigHistory</a> action.
     * @return Result of the GetResourceConfigHistory operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidTimeRangeException
     *         The specified time range is not valid. The earlier time is not chronologically before the later time.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws ResourceNotDiscoveredException
     *         You have specified a resource that is either unknown or has not been discovered.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetResourceConfigHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceConfigHistoryResponse getResourceConfigHistory(
            Consumer<GetResourceConfigHistoryRequest.Builder> getResourceConfigHistoryRequest) throws ValidationException,
            InvalidTimeRangeException, InvalidLimitException, InvalidNextTokenException,
            NoAvailableConfigurationRecorderException, ResourceNotDiscoveredException, AwsServiceException, SdkClientException,
            ConfigException {
        return getResourceConfigHistory(GetResourceConfigHistoryRequest.builder().applyMutation(getResourceConfigHistoryRequest)
                .build());
    }

    /**
     * <important>
     * <p>
     * For accurate reporting on the compliance status, you must record the <code>AWS::Config::ResourceCompliance</code>
     * resource type. For more information, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html">Selecting Which Resources
     * Config Records</a>.
     * </p>
     * </important>
     * <p>
     * Returns a list of <code>ConfigurationItems</code> for the specified resource. The list contains details about
     * each state of the resource during the specified time interval. If you specified a retention period to retain your
     * <code>ConfigurationItems</code> between a minimum of 30 days and a maximum of 7 years (2557 days), Config returns
     * the <code>ConfigurationItems</code> for the specified retention period.
     * </p>
     * <p>
     * The response is paginated. By default, Config returns a limit of 10 configuration items per page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * Each call to the API is limited to span a duration of seven days. It is likely that the number of records
     * returned is smaller than the specified <code>limit</code>. In such cases, you can make another call, using the
     * <code>nextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getResourceConfigHistory(software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryIterable responses = client.getResourceConfigHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryIterable responses = client
     *             .getResourceConfigHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryIterable responses = client.getResourceConfigHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceConfigHistory(software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getResourceConfigHistoryRequest
     *        The input for the <a>GetResourceConfigHistory</a> action.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidTimeRangeException
     *         The specified time range is not valid. The earlier time is not chronologically before the later time.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws ResourceNotDiscoveredException
     *         You have specified a resource that is either unknown or has not been discovered.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetResourceConfigHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceConfigHistoryIterable getResourceConfigHistoryPaginator(
            GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) throws ValidationException,
            InvalidTimeRangeException, InvalidLimitException, InvalidNextTokenException,
            NoAvailableConfigurationRecorderException, ResourceNotDiscoveredException, AwsServiceException, SdkClientException,
            ConfigException {
        return new GetResourceConfigHistoryIterable(this, getResourceConfigHistoryRequest);
    }

    /**
     * <important>
     * <p>
     * For accurate reporting on the compliance status, you must record the <code>AWS::Config::ResourceCompliance</code>
     * resource type. For more information, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html">Selecting Which Resources
     * Config Records</a>.
     * </p>
     * </important>
     * <p>
     * Returns a list of <code>ConfigurationItems</code> for the specified resource. The list contains details about
     * each state of the resource during the specified time interval. If you specified a retention period to retain your
     * <code>ConfigurationItems</code> between a minimum of 30 days and a maximum of 7 years (2557 days), Config returns
     * the <code>ConfigurationItems</code> for the specified retention period.
     * </p>
     * <p>
     * The response is paginated. By default, Config returns a limit of 10 configuration items per page. You can
     * customize this number with the <code>limit</code> parameter. The response includes a <code>nextToken</code>
     * string. To get the next page of results, run the request again and specify the string for the
     * <code>nextToken</code> parameter.
     * </p>
     * <note>
     * <p>
     * Each call to the API is limited to span a duration of seven days. It is likely that the number of records
     * returned is smaller than the specified <code>limit</code>. In such cases, you can make another call, using the
     * <code>nextToken</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getResourceConfigHistory(software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryIterable responses = client.getResourceConfigHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryIterable responses = client
     *             .getResourceConfigHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.GetResourceConfigHistoryIterable responses = client.getResourceConfigHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceConfigHistory(software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceConfigHistoryRequest.Builder} avoiding
     * the need to create one manually via {@link GetResourceConfigHistoryRequest#builder()}
     * </p>
     *
     * @param getResourceConfigHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest.Builder} to create a
     *        request. The input for the <a>GetResourceConfigHistory</a> action.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidTimeRangeException
     *         The specified time range is not valid. The earlier time is not chronologically before the later time.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws ResourceNotDiscoveredException
     *         You have specified a resource that is either unknown or has not been discovered.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetResourceConfigHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceConfigHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceConfigHistoryIterable getResourceConfigHistoryPaginator(
            Consumer<GetResourceConfigHistoryRequest.Builder> getResourceConfigHistoryRequest) throws ValidationException,
            InvalidTimeRangeException, InvalidLimitException, InvalidNextTokenException,
            NoAvailableConfigurationRecorderException, ResourceNotDiscoveredException, AwsServiceException, SdkClientException,
            ConfigException {
        return getResourceConfigHistoryPaginator(GetResourceConfigHistoryRequest.builder()
                .applyMutation(getResourceConfigHistoryRequest).build());
    }

    /**
     * <p>
     * Returns a summary of resource evaluation for the specified resource evaluation ID from the proactive rules that
     * were run. The results indicate which evaluation context was used to evaluate the rules, which resource details
     * were evaluated, the evaluation mode that was run, and whether the resource details comply with the configuration
     * of the proactive rules.
     * </p>
     * <note>
     * <p>
     * To see additional information about the evaluation result, such as which rule flagged a resource as
     * NON_COMPLIANT, use the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_GetComplianceDetailsByResource.html"
     * >GetComplianceDetailsByResource</a> API. For more information, see the <a href=
     * "https://docs.aws.amazon.com/config/latest/APIReference/API_GetResourceEvaluationSummary.html#API_GetResourceEvaluationSummary_Examples"
     * >Examples</a> section.
     * </p>
     * </note>
     *
     * @param getResourceEvaluationSummaryRequest
     * @return Result of the GetResourceEvaluationSummary operation returned by the service.
     * @throws ResourceNotFoundException
     *         You have specified a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetResourceEvaluationSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceEvaluationSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceEvaluationSummaryResponse getResourceEvaluationSummary(
            GetResourceEvaluationSummaryRequest getResourceEvaluationSummaryRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a summary of resource evaluation for the specified resource evaluation ID from the proactive rules that
     * were run. The results indicate which evaluation context was used to evaluate the rules, which resource details
     * were evaluated, the evaluation mode that was run, and whether the resource details comply with the configuration
     * of the proactive rules.
     * </p>
     * <note>
     * <p>
     * To see additional information about the evaluation result, such as which rule flagged a resource as
     * NON_COMPLIANT, use the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_GetComplianceDetailsByResource.html"
     * >GetComplianceDetailsByResource</a> API. For more information, see the <a href=
     * "https://docs.aws.amazon.com/config/latest/APIReference/API_GetResourceEvaluationSummary.html#API_GetResourceEvaluationSummary_Examples"
     * >Examples</a> section.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceEvaluationSummaryRequest.Builder}
     * avoiding the need to create one manually via {@link GetResourceEvaluationSummaryRequest#builder()}
     * </p>
     *
     * @param getResourceEvaluationSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryRequest.Builder} to create
     *        a request.
     * @return Result of the GetResourceEvaluationSummary operation returned by the service.
     * @throws ResourceNotFoundException
     *         You have specified a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetResourceEvaluationSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetResourceEvaluationSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceEvaluationSummaryResponse getResourceEvaluationSummary(
            Consumer<GetResourceEvaluationSummaryRequest.Builder> getResourceEvaluationSummaryRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ConfigException {
        return getResourceEvaluationSummary(GetResourceEvaluationSummaryRequest.builder()
                .applyMutation(getResourceEvaluationSummaryRequest).build());
    }

    /**
     * <p>
     * Returns the details of a specific stored query.
     * </p>
     *
     * @param getStoredQueryRequest
     * @return Result of the GetStoredQuery operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws ResourceNotFoundException
     *         You have specified a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStoredQueryResponse getStoredQuery(GetStoredQueryRequest getStoredQueryRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of a specific stored query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStoredQueryRequest.Builder} avoiding the need to
     * create one manually via {@link GetStoredQueryRequest#builder()}
     * </p>
     *
     * @param getStoredQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.GetStoredQueryRequest.Builder} to create a request.
     * @return Result of the GetStoredQuery operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws ResourceNotFoundException
     *         You have specified a resource that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.GetStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStoredQueryResponse getStoredQuery(Consumer<GetStoredQueryRequest.Builder> getStoredQueryRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, ConfigException {
        return getStoredQuery(GetStoredQueryRequest.builder().applyMutation(getStoredQueryRequest).build());
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers that are aggregated for a specific resource
     * type across accounts and regions. A resource identifier includes the resource type, ID, (if available) the custom
     * resource name, source account, and source region. You can narrow the results to include only resources that have
     * specific resource IDs, or a resource name, or source account ID, or source region.
     * </p>
     * <p>
     * For example, if the input consists of accountID 12345678910 and the region is us-east-1 for resource type
     * <code>AWS::EC2::Instance</code> then the API returns all the EC2 instance identifiers of accountID 12345678910
     * and region us-east-1.
     * </p>
     *
     * @param listAggregateDiscoveredResourcesRequest
     * @return Result of the ListAggregateDiscoveredResources operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListAggregateDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListAggregateDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAggregateDiscoveredResourcesResponse listAggregateDiscoveredResources(
            ListAggregateDiscoveredResourcesRequest listAggregateDiscoveredResourcesRequest) throws ValidationException,
            InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException, AwsServiceException,
            SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers that are aggregated for a specific resource
     * type across accounts and regions. A resource identifier includes the resource type, ID, (if available) the custom
     * resource name, source account, and source region. You can narrow the results to include only resources that have
     * specific resource IDs, or a resource name, or source account ID, or source region.
     * </p>
     * <p>
     * For example, if the input consists of accountID 12345678910 and the region is us-east-1 for resource type
     * <code>AWS::EC2::Instance</code> then the API returns all the EC2 instance identifiers of accountID 12345678910
     * and region us-east-1.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAggregateDiscoveredResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAggregateDiscoveredResourcesRequest#builder()}
     * </p>
     *
     * @param listAggregateDiscoveredResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest.Builder} to
     *        create a request.
     * @return Result of the ListAggregateDiscoveredResources operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListAggregateDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListAggregateDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAggregateDiscoveredResourcesResponse listAggregateDiscoveredResources(
            Consumer<ListAggregateDiscoveredResourcesRequest.Builder> listAggregateDiscoveredResourcesRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return listAggregateDiscoveredResources(ListAggregateDiscoveredResourcesRequest.builder()
                .applyMutation(listAggregateDiscoveredResourcesRequest).build());
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers that are aggregated for a specific resource
     * type across accounts and regions. A resource identifier includes the resource type, ID, (if available) the custom
     * resource name, source account, and source region. You can narrow the results to include only resources that have
     * specific resource IDs, or a resource name, or source account ID, or source region.
     * </p>
     * <p>
     * For example, if the input consists of accountID 12345678910 and the region is us-east-1 for resource type
     * <code>AWS::EC2::Instance</code> then the API returns all the EC2 instance identifiers of accountID 12345678910
     * and region us-east-1.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAggregateDiscoveredResources(software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListAggregateDiscoveredResourcesIterable responses = client.listAggregateDiscoveredResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.ListAggregateDiscoveredResourcesIterable responses = client
     *             .listAggregateDiscoveredResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListAggregateDiscoveredResourcesIterable responses = client.listAggregateDiscoveredResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAggregateDiscoveredResources(software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAggregateDiscoveredResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListAggregateDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListAggregateDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAggregateDiscoveredResourcesIterable listAggregateDiscoveredResourcesPaginator(
            ListAggregateDiscoveredResourcesRequest listAggregateDiscoveredResourcesRequest) throws ValidationException,
            InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException, AwsServiceException,
            SdkClientException, ConfigException {
        return new ListAggregateDiscoveredResourcesIterable(this, listAggregateDiscoveredResourcesRequest);
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers that are aggregated for a specific resource
     * type across accounts and regions. A resource identifier includes the resource type, ID, (if available) the custom
     * resource name, source account, and source region. You can narrow the results to include only resources that have
     * specific resource IDs, or a resource name, or source account ID, or source region.
     * </p>
     * <p>
     * For example, if the input consists of accountID 12345678910 and the region is us-east-1 for resource type
     * <code>AWS::EC2::Instance</code> then the API returns all the EC2 instance identifiers of accountID 12345678910
     * and region us-east-1.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAggregateDiscoveredResources(software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListAggregateDiscoveredResourcesIterable responses = client.listAggregateDiscoveredResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.ListAggregateDiscoveredResourcesIterable responses = client
     *             .listAggregateDiscoveredResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListAggregateDiscoveredResourcesIterable responses = client.listAggregateDiscoveredResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAggregateDiscoveredResources(software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAggregateDiscoveredResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAggregateDiscoveredResourcesRequest#builder()}
     * </p>
     *
     * @param listAggregateDiscoveredResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoSuchConfigurationAggregatorException
     *         You have specified a configuration aggregator that does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListAggregateDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListAggregateDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAggregateDiscoveredResourcesIterable listAggregateDiscoveredResourcesPaginator(
            Consumer<ListAggregateDiscoveredResourcesRequest.Builder> listAggregateDiscoveredResourcesRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException,
            AwsServiceException, SdkClientException, ConfigException {
        return listAggregateDiscoveredResourcesPaginator(ListAggregateDiscoveredResourcesRequest.builder()
                .applyMutation(listAggregateDiscoveredResourcesRequest).build());
    }

    /**
     * <p>
     * Returns a list of conformance pack compliance scores. A compliance score is the percentage of the number of
     * compliant rule-resource combinations in a conformance pack compared to the number of total possible rule-resource
     * combinations in the conformance pack. This metric provides you with a high-level view of the compliance state of
     * your conformance packs. You can use it to identify, investigate, and understand the level of compliance in your
     * conformance packs.
     * </p>
     * <note>
     * <p>
     * Conformance packs with no evaluation results will have a compliance score of <code>INSUFFICIENT_DATA</code>.
     * </p>
     * </note>
     *
     * @param listConformancePackComplianceScoresRequest
     * @return Result of the ListConformancePackComplianceScores operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListConformancePackComplianceScores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListConformancePackComplianceScores"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConformancePackComplianceScoresResponse listConformancePackComplianceScores(
            ListConformancePackComplianceScoresRequest listConformancePackComplianceScoresRequest)
            throws InvalidParameterValueException, InvalidLimitException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of conformance pack compliance scores. A compliance score is the percentage of the number of
     * compliant rule-resource combinations in a conformance pack compared to the number of total possible rule-resource
     * combinations in the conformance pack. This metric provides you with a high-level view of the compliance state of
     * your conformance packs. You can use it to identify, investigate, and understand the level of compliance in your
     * conformance packs.
     * </p>
     * <note>
     * <p>
     * Conformance packs with no evaluation results will have a compliance score of <code>INSUFFICIENT_DATA</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConformancePackComplianceScoresRequest.Builder}
     * avoiding the need to create one manually via {@link ListConformancePackComplianceScoresRequest#builder()}
     * </p>
     *
     * @param listConformancePackComplianceScoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest.Builder} to
     *        create a request.
     * @return Result of the ListConformancePackComplianceScores operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListConformancePackComplianceScores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListConformancePackComplianceScores"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConformancePackComplianceScoresResponse listConformancePackComplianceScores(
            Consumer<ListConformancePackComplianceScoresRequest.Builder> listConformancePackComplianceScoresRequest)
            throws InvalidParameterValueException, InvalidLimitException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        return listConformancePackComplianceScores(ListConformancePackComplianceScoresRequest.builder()
                .applyMutation(listConformancePackComplianceScoresRequest).build());
    }

    /**
     * <p>
     * Returns a list of conformance pack compliance scores. A compliance score is the percentage of the number of
     * compliant rule-resource combinations in a conformance pack compared to the number of total possible rule-resource
     * combinations in the conformance pack. This metric provides you with a high-level view of the compliance state of
     * your conformance packs. You can use it to identify, investigate, and understand the level of compliance in your
     * conformance packs.
     * </p>
     * <note>
     * <p>
     * Conformance packs with no evaluation results will have a compliance score of <code>INSUFFICIENT_DATA</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listConformancePackComplianceScores(software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListConformancePackComplianceScoresIterable responses = client.listConformancePackComplianceScoresPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.ListConformancePackComplianceScoresIterable responses = client
     *             .listConformancePackComplianceScoresPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListConformancePackComplianceScoresIterable responses = client.listConformancePackComplianceScoresPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConformancePackComplianceScores(software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConformancePackComplianceScoresRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListConformancePackComplianceScores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListConformancePackComplianceScores"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConformancePackComplianceScoresIterable listConformancePackComplianceScoresPaginator(
            ListConformancePackComplianceScoresRequest listConformancePackComplianceScoresRequest)
            throws InvalidParameterValueException, InvalidLimitException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        return new ListConformancePackComplianceScoresIterable(this, listConformancePackComplianceScoresRequest);
    }

    /**
     * <p>
     * Returns a list of conformance pack compliance scores. A compliance score is the percentage of the number of
     * compliant rule-resource combinations in a conformance pack compared to the number of total possible rule-resource
     * combinations in the conformance pack. This metric provides you with a high-level view of the compliance state of
     * your conformance packs. You can use it to identify, investigate, and understand the level of compliance in your
     * conformance packs.
     * </p>
     * <note>
     * <p>
     * Conformance packs with no evaluation results will have a compliance score of <code>INSUFFICIENT_DATA</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listConformancePackComplianceScores(software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListConformancePackComplianceScoresIterable responses = client.listConformancePackComplianceScoresPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.ListConformancePackComplianceScoresIterable responses = client
     *             .listConformancePackComplianceScoresPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListConformancePackComplianceScoresIterable responses = client.listConformancePackComplianceScoresPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConformancePackComplianceScores(software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConformancePackComplianceScoresRequest.Builder}
     * avoiding the need to create one manually via {@link ListConformancePackComplianceScoresRequest#builder()}
     * </p>
     *
     * @param listConformancePackComplianceScoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListConformancePackComplianceScores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListConformancePackComplianceScores"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConformancePackComplianceScoresIterable listConformancePackComplianceScoresPaginator(
            Consumer<ListConformancePackComplianceScoresRequest.Builder> listConformancePackComplianceScoresRequest)
            throws InvalidParameterValueException, InvalidLimitException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, ConfigException {
        return listConformancePackComplianceScoresPaginator(ListConformancePackComplianceScoresRequest.builder()
                .applyMutation(listConformancePackComplianceScoresRequest).build());
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers for the resources of that type. A resource
     * identifier includes the resource type, ID, and (if available) the custom resource name. The results consist of
     * resources that Config has discovered, including those that Config is not currently recording. You can narrow the
     * results to include only resources that have specific resource IDs or a resource name.
     * </p>
     * <note>
     * <p>
     * You can specify either resource IDs or a resource name, but not both, in the same request.
     * </p>
     * </note>
     * <p>
     * The response is paginated. By default, Config lists 100 resource identifiers on each page. You can customize this
     * number with the <code>limit</code> parameter. The response includes a <code>nextToken</code> string. To get the
     * next page of results, run the request again and specify the string for the <code>nextToken</code> parameter.
     * </p>
     *
     * @param listDiscoveredResourcesRequest
     * @return Result of the ListDiscoveredResources operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDiscoveredResourcesResponse listDiscoveredResources(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest)
            throws ValidationException, InvalidLimitException, InvalidNextTokenException,
            NoAvailableConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers for the resources of that type. A resource
     * identifier includes the resource type, ID, and (if available) the custom resource name. The results consist of
     * resources that Config has discovered, including those that Config is not currently recording. You can narrow the
     * results to include only resources that have specific resource IDs or a resource name.
     * </p>
     * <note>
     * <p>
     * You can specify either resource IDs or a resource name, but not both, in the same request.
     * </p>
     * </note>
     * <p>
     * The response is paginated. By default, Config lists 100 resource identifiers on each page. You can customize this
     * number with the <code>limit</code> parameter. The response includes a <code>nextToken</code> string. To get the
     * next page of results, run the request again and specify the string for the <code>nextToken</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDiscoveredResourcesRequest.Builder} avoiding
     * the need to create one manually via {@link ListDiscoveredResourcesRequest#builder()}
     * </p>
     *
     * @param listDiscoveredResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest.Builder} to create a
     *        request.
     * @return Result of the ListDiscoveredResources operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDiscoveredResourcesResponse listDiscoveredResources(
            Consumer<ListDiscoveredResourcesRequest.Builder> listDiscoveredResourcesRequest) throws ValidationException,
            InvalidLimitException, InvalidNextTokenException, NoAvailableConfigurationRecorderException, AwsServiceException,
            SdkClientException, ConfigException {
        return listDiscoveredResources(ListDiscoveredResourcesRequest.builder().applyMutation(listDiscoveredResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers for the resources of that type. A resource
     * identifier includes the resource type, ID, and (if available) the custom resource name. The results consist of
     * resources that Config has discovered, including those that Config is not currently recording. You can narrow the
     * results to include only resources that have specific resource IDs or a resource name.
     * </p>
     * <note>
     * <p>
     * You can specify either resource IDs or a resource name, but not both, in the same request.
     * </p>
     * </note>
     * <p>
     * The response is paginated. By default, Config lists 100 resource identifiers on each page. You can customize this
     * number with the <code>limit</code> parameter. The response includes a <code>nextToken</code> string. To get the
     * next page of results, run the request again and specify the string for the <code>nextToken</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDiscoveredResources(software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListDiscoveredResourcesIterable responses = client.listDiscoveredResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.ListDiscoveredResourcesIterable responses = client
     *             .listDiscoveredResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListDiscoveredResourcesIterable responses = client.listDiscoveredResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDiscoveredResources(software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDiscoveredResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDiscoveredResourcesIterable listDiscoveredResourcesPaginator(
            ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) throws ValidationException, InvalidLimitException,
            InvalidNextTokenException, NoAvailableConfigurationRecorderException, AwsServiceException, SdkClientException,
            ConfigException {
        return new ListDiscoveredResourcesIterable(this, listDiscoveredResourcesRequest);
    }

    /**
     * <p>
     * Accepts a resource type and returns a list of resource identifiers for the resources of that type. A resource
     * identifier includes the resource type, ID, and (if available) the custom resource name. The results consist of
     * resources that Config has discovered, including those that Config is not currently recording. You can narrow the
     * results to include only resources that have specific resource IDs or a resource name.
     * </p>
     * <note>
     * <p>
     * You can specify either resource IDs or a resource name, but not both, in the same request.
     * </p>
     * </note>
     * <p>
     * The response is paginated. By default, Config lists 100 resource identifiers on each page. You can customize this
     * number with the <code>limit</code> parameter. The response includes a <code>nextToken</code> string. To get the
     * next page of results, run the request again and specify the string for the <code>nextToken</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDiscoveredResources(software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListDiscoveredResourcesIterable responses = client.listDiscoveredResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.ListDiscoveredResourcesIterable responses = client
     *             .listDiscoveredResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListDiscoveredResourcesIterable responses = client.listDiscoveredResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDiscoveredResources(software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDiscoveredResourcesRequest.Builder} avoiding
     * the need to create one manually via {@link ListDiscoveredResourcesRequest#builder()}
     * </p>
     *
     * @param listDiscoveredResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListDiscoveredResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListDiscoveredResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDiscoveredResourcesIterable listDiscoveredResourcesPaginator(
            Consumer<ListDiscoveredResourcesRequest.Builder> listDiscoveredResourcesRequest) throws ValidationException,
            InvalidLimitException, InvalidNextTokenException, NoAvailableConfigurationRecorderException, AwsServiceException,
            SdkClientException, ConfigException {
        return listDiscoveredResourcesPaginator(ListDiscoveredResourcesRequest.builder()
                .applyMutation(listDiscoveredResourcesRequest).build());
    }

    /**
     * <p>
     * Returns a list of proactive resource evaluations.
     * </p>
     *
     * @param listResourceEvaluationsRequest
     * @return Result of the ListResourceEvaluations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidTimeRangeException
     *         The specified time range is not valid. The earlier time is not chronologically before the later time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListResourceEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListResourceEvaluations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceEvaluationsResponse listResourceEvaluations(ListResourceEvaluationsRequest listResourceEvaluationsRequest)
            throws InvalidNextTokenException, InvalidParameterValueException, InvalidTimeRangeException, AwsServiceException,
            SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of proactive resource evaluations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceEvaluationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListResourceEvaluationsRequest#builder()}
     * </p>
     *
     * @param listResourceEvaluationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListResourceEvaluations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidTimeRangeException
     *         The specified time range is not valid. The earlier time is not chronologically before the later time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListResourceEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListResourceEvaluations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceEvaluationsResponse listResourceEvaluations(
            Consumer<ListResourceEvaluationsRequest.Builder> listResourceEvaluationsRequest) throws InvalidNextTokenException,
            InvalidParameterValueException, InvalidTimeRangeException, AwsServiceException, SdkClientException, ConfigException {
        return listResourceEvaluations(ListResourceEvaluationsRequest.builder().applyMutation(listResourceEvaluationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of proactive resource evaluations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceEvaluations(software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListResourceEvaluationsIterable responses = client.listResourceEvaluationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.ListResourceEvaluationsIterable responses = client
     *             .listResourceEvaluationsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListResourceEvaluationsIterable responses = client.listResourceEvaluationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceEvaluations(software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceEvaluationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidTimeRangeException
     *         The specified time range is not valid. The earlier time is not chronologically before the later time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListResourceEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListResourceEvaluations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceEvaluationsIterable listResourceEvaluationsPaginator(
            ListResourceEvaluationsRequest listResourceEvaluationsRequest) throws InvalidNextTokenException,
            InvalidParameterValueException, InvalidTimeRangeException, AwsServiceException, SdkClientException, ConfigException {
        return new ListResourceEvaluationsIterable(this, listResourceEvaluationsRequest);
    }

    /**
     * <p>
     * Returns a list of proactive resource evaluations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceEvaluations(software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListResourceEvaluationsIterable responses = client.listResourceEvaluationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.ListResourceEvaluationsIterable responses = client
     *             .listResourceEvaluationsPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListResourceEvaluationsIterable responses = client.listResourceEvaluationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceEvaluations(software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceEvaluationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListResourceEvaluationsRequest#builder()}
     * </p>
     *
     * @param listResourceEvaluationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws InvalidTimeRangeException
     *         The specified time range is not valid. The earlier time is not chronologically before the later time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListResourceEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListResourceEvaluations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceEvaluationsIterable listResourceEvaluationsPaginator(
            Consumer<ListResourceEvaluationsRequest.Builder> listResourceEvaluationsRequest) throws InvalidNextTokenException,
            InvalidParameterValueException, InvalidTimeRangeException, AwsServiceException, SdkClientException, ConfigException {
        return listResourceEvaluationsPaginator(ListResourceEvaluationsRequest.builder()
                .applyMutation(listResourceEvaluationsRequest).build());
    }

    /**
     * <p>
     * Lists the stored queries for a single Amazon Web Services account and a single Amazon Web Services Region. The
     * default is 100.
     * </p>
     *
     * @param listStoredQueriesRequest
     * @return Result of the ListStoredQueries operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListStoredQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListStoredQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStoredQueriesResponse listStoredQueries(ListStoredQueriesRequest listStoredQueriesRequest)
            throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the stored queries for a single Amazon Web Services account and a single Amazon Web Services Region. The
     * default is 100.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStoredQueriesRequest.Builder} avoiding the need
     * to create one manually via {@link ListStoredQueriesRequest#builder()}
     * </p>
     *
     * @param listStoredQueriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.ListStoredQueriesRequest.Builder} to create a request.
     * @return Result of the ListStoredQueries operation returned by the service.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListStoredQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListStoredQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStoredQueriesResponse listStoredQueries(Consumer<ListStoredQueriesRequest.Builder> listStoredQueriesRequest)
            throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        return listStoredQueries(ListStoredQueriesRequest.builder().applyMutation(listStoredQueriesRequest).build());
    }

    /**
     * <p>
     * Lists the stored queries for a single Amazon Web Services account and a single Amazon Web Services Region. The
     * default is 100.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStoredQueries(software.amazon.awssdk.services.config.model.ListStoredQueriesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListStoredQueriesIterable responses = client.listStoredQueriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.ListStoredQueriesIterable responses = client
     *             .listStoredQueriesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.ListStoredQueriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListStoredQueriesIterable responses = client.listStoredQueriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStoredQueries(software.amazon.awssdk.services.config.model.ListStoredQueriesRequest)} operation.</b>
     * </p>
     *
     * @param listStoredQueriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListStoredQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListStoredQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStoredQueriesIterable listStoredQueriesPaginator(ListStoredQueriesRequest listStoredQueriesRequest)
            throws ValidationException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        return new ListStoredQueriesIterable(this, listStoredQueriesRequest);
    }

    /**
     * <p>
     * Lists the stored queries for a single Amazon Web Services account and a single Amazon Web Services Region. The
     * default is 100.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStoredQueries(software.amazon.awssdk.services.config.model.ListStoredQueriesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListStoredQueriesIterable responses = client.listStoredQueriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.ListStoredQueriesIterable responses = client
     *             .listStoredQueriesPaginator(request);
     *     for (software.amazon.awssdk.services.config.model.ListStoredQueriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListStoredQueriesIterable responses = client.listStoredQueriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStoredQueries(software.amazon.awssdk.services.config.model.ListStoredQueriesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStoredQueriesRequest.Builder} avoiding the need
     * to create one manually via {@link ListStoredQueriesRequest#builder()}
     * </p>
     *
     * @param listStoredQueriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.ListStoredQueriesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListStoredQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListStoredQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStoredQueriesIterable listStoredQueriesPaginator(
            Consumer<ListStoredQueriesRequest.Builder> listStoredQueriesRequest) throws ValidationException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        return listStoredQueriesPaginator(ListStoredQueriesRequest.builder().applyMutation(listStoredQueriesRequest).build());
    }

    /**
     * <p>
     * List the tags for Config resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         You have specified a resource that does not exist.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ValidationException, InvalidLimitException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tags for Config resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         You have specified a resource that does not exist.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ValidationException, InvalidLimitException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            ConfigException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * List the tags for Config resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.config.model.ListTagsForResourceRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.config.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.config.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         You have specified a resource that does not exist.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ValidationException, InvalidLimitException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, ConfigException {
        return new ListTagsForResourceIterable(this, listTagsForResourceRequest);
    }

    /**
     * <p>
     * List the tags for Config resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.config.model.ListTagsForResourceRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.config.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.config.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.config.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.config.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         You have specified a resource that does not exist.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidLimitException
     *         The specified limit is outside the allowable range.
     * @throws InvalidNextTokenException
     *         The specified next token is not valid. Specify the <code>nextToken</code> string that was returned in the
     *         previous response to get the next page of results.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ValidationException, InvalidLimitException, InvalidNextTokenException, AwsServiceException, SdkClientException,
            ConfigException {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Authorizes the aggregator account and region to collect data from the source account and region.
     * </p>
     * <note>
     * <p>
     * <code>PutAggregationAuthorization</code> is an idempotent API. Subsequent requests won’t create a duplicate
     * resource if one was already created. If a following request has different <code>tags</code> values, Config will
     * ignore these differences and treat it as an idempotent request of the previous. In this case, <code>tags</code>
     * will not be updated, even if they are different.
     * </p>
     * </note>
     *
     * @param putAggregationAuthorizationRequest
     * @return Result of the PutAggregationAuthorization operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutAggregationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutAggregationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default PutAggregationAuthorizationResponse putAggregationAuthorization(
            PutAggregationAuthorizationRequest putAggregationAuthorizationRequest) throws InvalidParameterValueException,
            AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Authorizes the aggregator account and region to collect data from the source account and region.
     * </p>
     * <note>
     * <p>
     * <code>PutAggregationAuthorization</code> is an idempotent API. Subsequent requests won’t create a duplicate
     * resource if one was already created. If a following request has different <code>tags</code> values, Config will
     * ignore these differences and treat it as an idempotent request of the previous. In this case, <code>tags</code>
     * will not be updated, even if they are different.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAggregationAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link PutAggregationAuthorizationRequest#builder()}
     * </p>
     *
     * @param putAggregationAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.PutAggregationAuthorizationRequest.Builder} to create
     *        a request.
     * @return Result of the PutAggregationAuthorization operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutAggregationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutAggregationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default PutAggregationAuthorizationResponse putAggregationAuthorization(
            Consumer<PutAggregationAuthorizationRequest.Builder> putAggregationAuthorizationRequest)
            throws InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        return putAggregationAuthorization(PutAggregationAuthorizationRequest.builder()
                .applyMutation(putAggregationAuthorizationRequest).build());
    }

    /**
     * <p>
     * Adds or updates an Config rule to evaluate if your Amazon Web Services resources comply with your desired
     * configurations. For information on how many Config rules you can have per account, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html"> <b>Service Limits</b> </a> in
     * the <i>Config Developer Guide</i>.
     * </p>
     * <p>
     * There are two types of rules: <i>Config Managed Rules</i> and <i>Config Custom Rules</i>. You can use
     * <code>PutConfigRule</code> to create both Config Managed Rules and Config Custom Rules.
     * </p>
     * <p>
     * Config Managed Rules are predefined, customizable rules created by Config. For a list of managed rules, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of Config
     * Managed Rules</a>. If you are adding an Config managed rule, you must specify the rule's identifier for the
     * <code>SourceIdentifier</code> key.
     * </p>
     * <p>
     * Config Custom Rules are rules that you create from scratch. There are two ways to create Config custom rules:
     * with Lambda functions (<a href=
     * "https://docs.aws.amazon.com/config/latest/developerguide/gettingstarted-concepts.html#gettingstarted-concepts-function"
     * > Lambda Developer Guide</a>) and with Guard (<a
     * href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>), a policy-as-code
     * language. Config custom rules created with Lambda are called <i>Config Custom Lambda Rules</i> and Config custom
     * rules created with Guard are called <i>Config Custom Policy Rules</i>.
     * </p>
     * <p>
     * If you are adding a new Config Custom Lambda rule, you first need to create an Lambda function that the rule
     * invokes to evaluate your resources. When you use <code>PutConfigRule</code> to add a Custom Lambda rule to
     * Config, you must specify the Amazon Resource Name (ARN) that Lambda assigns to the function. You specify the ARN
     * in the <code>SourceIdentifier</code> key. This key is part of the <code>Source</code> object, which is part of
     * the <code>ConfigRule</code> object.
     * </p>
     * <p>
     * For any new Config rule that you add, specify the <code>ConfigRuleName</code> in the <code>ConfigRule</code>
     * object. Do not specify the <code>ConfigRuleArn</code> or the <code>ConfigRuleId</code>. These values are
     * generated by Config for new rules.
     * </p>
     * <p>
     * If you are updating a rule that you added previously, you can specify the rule by <code>ConfigRuleName</code>,
     * <code>ConfigRuleId</code>, or <code>ConfigRuleArn</code> in the <code>ConfigRule</code> data type that you use in
     * this request.
     * </p>
     * <p>
     * For more information about developing and using Config rules, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html">Evaluating Resources with
     * Config Rules</a> in the <i>Config Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * <code>PutConfigRule</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if one was
     * already created. If a following request has different <code>tags</code> values, Config will ignore these
     * differences and treat it as an idempotent request of the previous. In this case, <code>tags</code> will not be
     * updated, even if they are different.
     * </p>
     * </note>
     *
     * @param putConfigRuleRequest
     * @return Result of the PutConfigRule operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws MaxNumberOfConfigRulesExceededException
     *         Failed to add the Config rule because the account already contains the maximum number of 150 rules.
     *         Consider deleting any deactivated rules before you add new rules.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws InsufficientPermissionsException
     *         Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions
     *         to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have the following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    default PutConfigRuleResponse putConfigRule(PutConfigRuleRequest putConfigRuleRequest) throws InvalidParameterValueException,
            MaxNumberOfConfigRulesExceededException, ResourceInUseException, InsufficientPermissionsException,
            NoAvailableConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates an Config rule to evaluate if your Amazon Web Services resources comply with your desired
     * configurations. For information on how many Config rules you can have per account, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html"> <b>Service Limits</b> </a> in
     * the <i>Config Developer Guide</i>.
     * </p>
     * <p>
     * There are two types of rules: <i>Config Managed Rules</i> and <i>Config Custom Rules</i>. You can use
     * <code>PutConfigRule</code> to create both Config Managed Rules and Config Custom Rules.
     * </p>
     * <p>
     * Config Managed Rules are predefined, customizable rules created by Config. For a list of managed rules, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html">List of Config
     * Managed Rules</a>. If you are adding an Config managed rule, you must specify the rule's identifier for the
     * <code>SourceIdentifier</code> key.
     * </p>
     * <p>
     * Config Custom Rules are rules that you create from scratch. There are two ways to create Config custom rules:
     * with Lambda functions (<a href=
     * "https://docs.aws.amazon.com/config/latest/developerguide/gettingstarted-concepts.html#gettingstarted-concepts-function"
     * > Lambda Developer Guide</a>) and with Guard (<a
     * href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>), a policy-as-code
     * language. Config custom rules created with Lambda are called <i>Config Custom Lambda Rules</i> and Config custom
     * rules created with Guard are called <i>Config Custom Policy Rules</i>.
     * </p>
     * <p>
     * If you are adding a new Config Custom Lambda rule, you first need to create an Lambda function that the rule
     * invokes to evaluate your resources. When you use <code>PutConfigRule</code> to add a Custom Lambda rule to
     * Config, you must specify the Amazon Resource Name (ARN) that Lambda assigns to the function. You specify the ARN
     * in the <code>SourceIdentifier</code> key. This key is part of the <code>Source</code> object, which is part of
     * the <code>ConfigRule</code> object.
     * </p>
     * <p>
     * For any new Config rule that you add, specify the <code>ConfigRuleName</code> in the <code>ConfigRule</code>
     * object. Do not specify the <code>ConfigRuleArn</code> or the <code>ConfigRuleId</code>. These values are
     * generated by Config for new rules.
     * </p>
     * <p>
     * If you are updating a rule that you added previously, you can specify the rule by <code>ConfigRuleName</code>,
     * <code>ConfigRuleId</code>, or <code>ConfigRuleArn</code> in the <code>ConfigRule</code> data type that you use in
     * this request.
     * </p>
     * <p>
     * For more information about developing and using Config rules, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html">Evaluating Resources with
     * Config Rules</a> in the <i>Config Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * <code>PutConfigRule</code> is an idempotent API. Subsequent requests won’t create a duplicate resource if one was
     * already created. If a following request has different <code>tags</code> values, Config will ignore these
     * differences and treat it as an idempotent request of the previous. In this case, <code>tags</code> will not be
     * updated, even if they are different.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigRuleRequest.Builder} avoiding the need to
     * create one manually via {@link PutConfigRuleRequest#builder()}
     * </p>
     *
     * @param putConfigRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.PutConfigRuleRequest.Builder} to create a request.
     * @return Result of the PutConfigRule operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws MaxNumberOfConfigRulesExceededException
     *         Failed to add the Config rule because the account already contains the maximum number of 150 rules.
     *         Consider deleting any deactivated rules before you add new rules.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws InsufficientPermissionsException
     *         Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions
     *         to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have the following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @throws NoAvailableConfigurationRecorderException
     *         There are no configuration recorders available to provide the role needed to describe your resources.
     *         Create a configuration recorder.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    default PutConfigRuleResponse putConfigRule(Consumer<PutConfigRuleRequest.Builder> putConfigRuleRequest)
            throws InvalidParameterValueException, MaxNumberOfConfigRulesExceededException, ResourceInUseException,
            InsufficientPermissionsException, NoAvailableConfigurationRecorderException, AwsServiceException, SdkClientException,
            ConfigException {
        return putConfigRule(PutConfigRuleRequest.builder().applyMutation(putConfigRuleRequest).build());
    }

    /**
     * <p>
     * Creates and updates the configuration aggregator with the selected source accounts and regions. The source
     * account can be individual account(s) or an organization.
     * </p>
     * <p>
     * <code>accountIds</code> that are passed will be replaced with existing accounts. If you want to add additional
     * accounts into the aggregator, call <code>DescribeConfigurationAggregators</code> to get the previous accounts and
     * then append new ones.
     * </p>
     * <note>
     * <p>
     * Config should be enabled in source accounts and regions you want to aggregate.
     * </p>
     * <p>
     * If your source type is an organization, you must be signed in to the management account or a registered delegated
     * administrator and all the features must be enabled in your organization. If the caller is a management account,
     * Config calls <code>EnableAwsServiceAccess</code> API to enable integration between Config and Organizations. If
     * the caller is a registered delegated administrator, Config calls <code>ListDelegatedAdministrators</code> API to
     * verify whether the caller is a valid delegated administrator.
     * </p>
     * <p>
     * To register a delegated administrator, see <a href=
     * "https://docs.aws.amazon.com/config/latest/developerguide/set-up-aggregator-cli.html#register-a-delegated-administrator-cli"
     * >Register a Delegated Administrator</a> in the <i>Config developer guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * <code>PutConfigurationAggregator</code> is an idempotent API. Subsequent requests won’t create a duplicate
     * resource if one was already created. If a following request has different <code>tags</code> values, Config will
     * ignore these differences and treat it as an idempotent request of the previous. In this case, <code>tags</code>
     * will not be updated, even if they are different.
     * </p>
     * </note>
     *
     * @param putConfigurationAggregatorRequest
     * @return Result of the PutConfigurationAggregator operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws LimitExceededException
     *         For <code>StartConfigRulesEvaluation</code> API, this exception is thrown if an evaluation is in progress
     *         or if you call the <a>StartConfigRulesEvaluation</a> API more than once per minute.</p>
     *         <p>
     *         For <code>PutConfigurationAggregator</code> API, this exception is thrown if the number of accounts and
     *         aggregators exceeds the limit.
     * @throws InvalidRoleException
     *         You have provided a null or empty Amazon Resource Name (ARN) for the IAM role assumed by Config and used
     *         by the configuration recorder.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws NoAvailableOrganizationException
     *         Organization is no longer available.
     * @throws OrganizationAllFeaturesNotEnabledException
     *         Config resource cannot be created because your organization does not have all features enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutConfigurationAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationAggregatorResponse putConfigurationAggregator(
            PutConfigurationAggregatorRequest putConfigurationAggregatorRequest) throws InvalidParameterValueException,
            LimitExceededException, InvalidRoleException, OrganizationAccessDeniedException, NoAvailableOrganizationException,
            OrganizationAllFeaturesNotEnabledException, AwsServiceException, SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and updates the configuration aggregator with the selected source accounts and regions. The source
     * account can be individual account(s) or an organization.
     * </p>
     * <p>
     * <code>accountIds</code> that are passed will be replaced with existing accounts. If you want to add additional
     * accounts into the aggregator, call <code>DescribeConfigurationAggregators</code> to get the previous accounts and
     * then append new ones.
     * </p>
     * <note>
     * <p>
     * Config should be enabled in source accounts and regions you want to aggregate.
     * </p>
     * <p>
     * If your source type is an organization, you must be signed in to the management account or a registered delegated
     * administrator and all the features must be enabled in your organization. If the caller is a management account,
     * Config calls <code>EnableAwsServiceAccess</code> API to enable integration between Config and Organizations. If
     * the caller is a registered delegated administrator, Config calls <code>ListDelegatedAdministrators</code> API to
     * verify whether the caller is a valid delegated administrator.
     * </p>
     * <p>
     * To register a delegated administrator, see <a href=
     * "https://docs.aws.amazon.com/config/latest/developerguide/set-up-aggregator-cli.html#register-a-delegated-administrator-cli"
     * >Register a Delegated Administrator</a> in the <i>Config developer guide</i>.
     * </p>
     * </note> <note>
     * <p>
     * <code>PutConfigurationAggregator</code> is an idempotent API. Subsequent requests won’t create a duplicate
     * resource if one was already created. If a following request has different <code>tags</code> values, Config will
     * ignore these differences and treat it as an idempotent request of the previous. In this case, <code>tags</code>
     * will not be updated, even if they are different.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationAggregatorRequest.Builder} avoiding
     * the need to create one manually via {@link PutConfigurationAggregatorRequest#builder()}
     * </p>
     *
     * @param putConfigurationAggregatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest.Builder} to create a
     *        request.
     * @return Result of the PutConfigurationAggregator operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws LimitExceededException
     *         For <code>StartConfigRulesEvaluation</code> API, this exception is thrown if an evaluation is in progress
     *         or if you call the <a>StartConfigRulesEvaluation</a> API more than once per minute.</p>
     *         <p>
     *         For <code>PutConfigurationAggregator</code> API, this exception is thrown if the number of accounts and
     *         aggregators exceeds the limit.
     * @throws InvalidRoleException
     *         You have provided a null or empty Amazon Resource Name (ARN) for the IAM role assumed by Config and used
     *         by the configuration recorder.
     * @throws OrganizationAccessDeniedException
     *         For <code>PutConfigurationAggregator</code> API, you can see this exception for the following reasons:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principle name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.
     * @throws NoAvailableOrganizationException
     *         Organization is no longer available.
     * @throws OrganizationAllFeaturesNotEnabledException
     *         Config resource cannot be created because your organization does not have all features enabled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutConfigurationAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationAggregatorResponse putConfigurationAggregator(
            Consumer<PutConfigurationAggregatorRequest.Builder> putConfigurationAggregatorRequest)
            throws InvalidParameterValueException, LimitExceededException, InvalidRoleException,
            OrganizationAccessDeniedException, NoAvailableOrganizationException, OrganizationAllFeaturesNotEnabledException,
            AwsServiceException, SdkClientException, ConfigException {
        return putConfigurationAggregator(PutConfigurationAggregatorRequest.builder()
                .applyMutation(putConfigurationAggregatorRequest).build());
    }

    /**
     * <p>
     * Creates a new configuration recorder to record configuration changes for specified resource types.
     * </p>
     * <p>
     * You can also use this action to change the <code>roleARN</code> or the <code>recordingGroup</code> of an existing
     * recorder. For more information, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/stop-start-recorder.html"> <b>Managing the
     * Configuration Recorder</b> </a> in the <i>Config Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can specify only one configuration recorder for each Amazon Web Services Region for each account.
     * </p>
     * <p>
     * If the configuration recorder does not have the <code>recordingGroup</code> field specified, the default is to
     * record all supported resource types.
     * </p>
     * </note>
     *
     * @param putConfigurationRecorderRequest
     *        The input for the <a>PutConfigurationRecorder</a> action.
     * @return Result of the PutConfigurationRecorder operation returned by the service.
     * @throws MaxNumberOfConfigurationRecordersExceededException
     *         You have reached the limit of the number of configuration recorders you can create.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidConfigurationRecorderNameException
     *         You have provided a name for the configuration recorder that is not valid.
     * @throws InvalidRoleException
     *         You have provided a null or empty Amazon Resource Name (ARN) for the IAM role assumed by Config and used
     *         by the configuration recorder.
     * @throws InvalidRecordingGroupException
     *         Indicates one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have provided a combination of parameter values that is not valid. For example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Setting the <code>allSupported</code> field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>
     *         to <code>true</code>, but providing a non-empty list for the <code>resourceTypes</code>field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Setting the <code>allSupported</code> field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>
     *         to <code>true</code>, but also setting the <code>useOnly</code> field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html"
     *         >RecordingStrategy</a> to <code>EXCLUSION_BY_RESOURCE_TYPES</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Every parameter is either null, false, or empty.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have reached the limit of the number of resource types you can provide for the recording group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided resource types or a recording strategy that are not valid.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationRecorderResponse putConfigurationRecorder(
            PutConfigurationRecorderRequest putConfigurationRecorderRequest)
            throws MaxNumberOfConfigurationRecordersExceededException, ValidationException,
            InvalidConfigurationRecorderNameException, InvalidRoleException, InvalidRecordingGroupException, AwsServiceException,
            SdkClientException, ConfigException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new configuration recorder to record configuration changes for specified resource types.
     * </p>
     * <p>
     * You can also use this action to change the <code>roleARN</code> or the <code>recordingGroup</code> of an existing
     * recorder. For more information, see <a
     * href="https://docs.aws.amazon.com/config/latest/developerguide/stop-start-recorder.html"> <b>Managing the
     * Configuration Recorder</b> </a> in the <i>Config Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can specify only one configuration recorder for each Amazon Web Services Region for each account.
     * </p>
     * <p>
     * If the configuration recorder does not have the <code>recordingGroup</code> field specified, the default is to
     * record all supported resource types.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationRecorderRequest.Builder} avoiding
     * the need to create one manually via {@link PutConfigurationRecorderRequest#builder()}
     * </p>
     *
     * @param putConfigurationRecorderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest.Builder} to create a
     *        request. The input for the <a>PutConfigurationRecorder</a> action.
     * @return Result of the PutConfigurationRecorder operation returned by the service.
     * @throws MaxNumberOfConfigurationRecordersExceededException
     *         You have reached the limit of the number of configuration recorders you can create.
     * @throws ValidationException
     *         The requested action is not valid.</p>
     *         <p>
     *         For PutStoredQuery, you will see this exception if there are missing required fields or if the input
     *         value fails the validation, or if you are trying to create more than 300 queries.
     *         </p>
     *         <p>
     *         For GetStoredQuery, ListStoredQuery, and DeleteStoredQuery you will see this exception if there are
     *         missing required fields or if the input value fails the validation.
     * @throws InvalidConfigurationRecorderNameException
     *         You have provided a name for the configuration recorder that is not valid.
     * @throws InvalidRoleException
     *         You have provided a null or empty Amazon Resource Name (ARN) for the IAM role assumed by Config and used
     *         by the configuration recorder.
     * @throws InvalidRecordingGroupException
     *         Indicates one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have provided a combination of parameter values that is not valid. For example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Setting the <code>allSupported</code> field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>
     *         to <code>true</code>, but providing a non-empty list for the <code>resourceTypes</code>field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Setting the <code>allSupported</code> field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a>
     *         to <code>true</code>, but also setting the <code>useOnly</code> field of <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html"
     *         >RecordingStrategy</a> to <code>EXCLUSION_BY_RESOURCE_TYPES</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Every parameter is either null, false, or empty.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have reached the limit of the number of resource types you can provide for the recording group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided resource types or a recording strategy that are not valid.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationRecorderResponse putConfigurationRecorder(
            Consumer<PutConfigurationRecorderRequest.Builder> putConfigurationRecorderRequest)
            throws MaxNumberOfConfigurationRecordersExceededException, ValidationException,
            InvalidConfigurationRecorderNameException, InvalidRoleException, InvalidRecordingGroupException, AwsServiceException,
            SdkClientException, ConfigException {
        return putConfigurationRecorder(PutConfigurationRecorderRequest.builder().applyMutation(putConfigurationRecorderRequest)
                .build());
    }

    /**
     * <p>
     * Creates or updates a conformance pack. A conformance pack is a collection of Config rules that can be easily
     * deployed in an account and a region and across an organization. For information on how many conformance packs you
     * can have per account, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html">
     * <b>Service Limits</b> </a> in the <i>Config Developer Guide</i>.
     * </p>
     * <p>
     * This API creates a service-linked role <code>AWSServiceRoleForConfigConforms</code> in your account. The
     * service-linked role is created only when the role does not exist in your account.
     * </p>
     * <note>
     * <p>
     * You must specify only one of the follow parameters: <code>TemplateS3Uri</code>, <code>TemplateBody</code> or
     * <code>TemplateSSMDocumentDetails</code>.
     * </p>
     * </note>
     *
     * @param putConformancePackRequest
     * @return Result of the PutConformancePack operation returned by the service.
     * @throws InsufficientPermissionsException
     *         Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For PutConfigRule, the rule cannot be created because the IAM role assigned to Config lacks permissions
     *         to perform the config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigRule, the Lambda function cannot be invoked. Check the function ARN, and check the
     *         function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutOrganizationConfigRule, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack cannot be created because
     *         you do not have the following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @throws ConformancePackTemplateValidationException
     *         You have specified a template that is not valid or supported.
     * @throws ResourceInUseException
     *         You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li>
     * @throws InvalidParameterValueException
     *         One or more of the specified parameters are not valid. Verify that your parameters are valid and try
     *         again.
     * @throws MaxNumberOfConformancePacksExceededException
     *         You have reached the limit of the number of conformance packs you can create in an account. For more
     *         information, see <a href="https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html">
     *         <b>Service Limits</b> </a> in the <i>Config Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConfigException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConfigClient.PutConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConformancePack" target="_top">AWS API
     *      Documentation</a>
     */
    default PutConformancePackResponse putConformancePack(PutConformancePackRequest putConformancePackRequest)
            throws InsufficientPermissionsException, ConformancePackTemplateValidationException, ResourceInUseException,
            InvalidParameterValueException, MaxNumberOfConfo