/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceEvaluationSummaryResponse extends ConfigResponse implements
        ToCopyableBuilder<GetResourceEvaluationSummaryResponse.Builder, GetResourceEvaluationSummaryResponse> {
    private static final SdkField<String> RESOURCE_EVALUATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceEvaluationId").getter(getter(GetResourceEvaluationSummaryResponse::resourceEvaluationId))
            .setter(setter(Builder::resourceEvaluationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceEvaluationId").build())
            .build();

    private static final SdkField<String> EVALUATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationMode").getter(getter(GetResourceEvaluationSummaryResponse::evaluationModeAsString))
            .setter(setter(Builder::evaluationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMode").build()).build();

    private static final SdkField<EvaluationStatus> EVALUATION_STATUS_FIELD = SdkField
            .<EvaluationStatus> builder(MarshallingType.SDK_POJO).memberName("EvaluationStatus")
            .getter(getter(GetResourceEvaluationSummaryResponse::evaluationStatus)).setter(setter(Builder::evaluationStatus))
            .constructor(EvaluationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationStatus").build()).build();

    private static final SdkField<Instant> EVALUATION_START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EvaluationStartTimestamp")
            .getter(getter(GetResourceEvaluationSummaryResponse::evaluationStartTimestamp))
            .setter(setter(Builder::evaluationStartTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationStartTimestamp").build())
            .build();

    private static final SdkField<String> COMPLIANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Compliance").getter(getter(GetResourceEvaluationSummaryResponse::complianceAsString))
            .setter(setter(Builder::compliance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compliance").build()).build();

    private static final SdkField<EvaluationContext> EVALUATION_CONTEXT_FIELD = SdkField
            .<EvaluationContext> builder(MarshallingType.SDK_POJO).memberName("EvaluationContext")
            .getter(getter(GetResourceEvaluationSummaryResponse::evaluationContext)).setter(setter(Builder::evaluationContext))
            .constructor(EvaluationContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationContext").build()).build();

    private static final SdkField<ResourceDetails> RESOURCE_DETAILS_FIELD = SdkField
            .<ResourceDetails> builder(MarshallingType.SDK_POJO).memberName("ResourceDetails")
            .getter(getter(GetResourceEvaluationSummaryResponse::resourceDetails)).setter(setter(Builder::resourceDetails))
            .constructor(ResourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_EVALUATION_ID_FIELD,
            EVALUATION_MODE_FIELD, EVALUATION_STATUS_FIELD, EVALUATION_START_TIMESTAMP_FIELD, COMPLIANCE_FIELD,
            EVALUATION_CONTEXT_FIELD, RESOURCE_DETAILS_FIELD));

    private final String resourceEvaluationId;

    private final String evaluationMode;

    private final EvaluationStatus evaluationStatus;

    private final Instant evaluationStartTimestamp;

    private final String compliance;

    private final EvaluationContext evaluationContext;

    private final ResourceDetails resourceDetails;

    private GetResourceEvaluationSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.resourceEvaluationId = builder.resourceEvaluationId;
        this.evaluationMode = builder.evaluationMode;
        this.evaluationStatus = builder.evaluationStatus;
        this.evaluationStartTimestamp = builder.evaluationStartTimestamp;
        this.compliance = builder.compliance;
        this.evaluationContext = builder.evaluationContext;
        this.resourceDetails = builder.resourceDetails;
    }

    /**
     * <p>
     * The unique <code>ResourceEvaluationId</code> of Amazon Web Services resource execution for which you want to
     * retrieve the evaluation summary.
     * </p>
     * 
     * @return The unique <code>ResourceEvaluationId</code> of Amazon Web Services resource execution for which you want
     *         to retrieve the evaluation summary.
     */
    public final String resourceEvaluationId() {
        return resourceEvaluationId;
    }

    /**
     * <p>
     * Lists results of the mode that you requested to retrieve the resource evaluation summary. The valid values are
     * Detective or Proactive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationMode}
     * will return {@link EvaluationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationModeAsString}.
     * </p>
     * 
     * @return Lists results of the mode that you requested to retrieve the resource evaluation summary. The valid
     *         values are Detective or Proactive.
     * @see EvaluationMode
     */
    public final EvaluationMode evaluationMode() {
        return EvaluationMode.fromValue(evaluationMode);
    }

    /**
     * <p>
     * Lists results of the mode that you requested to retrieve the resource evaluation summary. The valid values are
     * Detective or Proactive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationMode}
     * will return {@link EvaluationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationModeAsString}.
     * </p>
     * 
     * @return Lists results of the mode that you requested to retrieve the resource evaluation summary. The valid
     *         values are Detective or Proactive.
     * @see EvaluationMode
     */
    public final String evaluationModeAsString() {
        return evaluationMode;
    }

    /**
     * <p>
     * Returns an <code>EvaluationStatus</code> object.
     * </p>
     * 
     * @return Returns an <code>EvaluationStatus</code> object.
     */
    public final EvaluationStatus evaluationStatus() {
        return evaluationStatus;
    }

    /**
     * <p>
     * The start timestamp when Config rule starts evaluating compliance for the provided resource details.
     * </p>
     * 
     * @return The start timestamp when Config rule starts evaluating compliance for the provided resource details.
     */
    public final Instant evaluationStartTimestamp() {
        return evaluationStartTimestamp;
    }

    /**
     * <p>
     * The compliance status of the resource evaluation summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compliance} will
     * return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #complianceAsString}.
     * </p>
     * 
     * @return The compliance status of the resource evaluation summary.
     * @see ComplianceType
     */
    public final ComplianceType compliance() {
        return ComplianceType.fromValue(compliance);
    }

    /**
     * <p>
     * The compliance status of the resource evaluation summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compliance} will
     * return {@link ComplianceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #complianceAsString}.
     * </p>
     * 
     * @return The compliance status of the resource evaluation summary.
     * @see ComplianceType
     */
    public final String complianceAsString() {
        return compliance;
    }

    /**
     * <p>
     * Returns an <code>EvaluationContext</code> object.
     * </p>
     * 
     * @return Returns an <code>EvaluationContext</code> object.
     */
    public final EvaluationContext evaluationContext() {
        return evaluationContext;
    }

    /**
     * <p>
     * Returns a <code>ResourceDetails</code> object.
     * </p>
     * 
     * @return Returns a <code>ResourceDetails</code> object.
     */
    public final ResourceDetails resourceDetails() {
        return resourceDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceEvaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationStartTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(complianceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationContext());
        hashCode = 31 * hashCode + Objects.hashCode(resourceDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceEvaluationSummaryResponse)) {
            return false;
        }
        GetResourceEvaluationSummaryResponse other = (GetResourceEvaluationSummaryResponse) obj;
        return Objects.equals(resourceEvaluationId(), other.resourceEvaluationId())
                && Objects.equals(evaluationModeAsString(), other.evaluationModeAsString())
                && Objects.equals(evaluationStatus(), other.evaluationStatus())
                && Objects.equals(evaluationStartTimestamp(), other.evaluationStartTimestamp())
                && Objects.equals(complianceAsString(), other.complianceAsString())
                && Objects.equals(evaluationContext(), other.evaluationContext())
                && Objects.equals(resourceDetails(), other.resourceDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceEvaluationSummaryResponse").add("ResourceEvaluationId", resourceEvaluationId())
                .add("EvaluationMode", evaluationModeAsString()).add("EvaluationStatus", evaluationStatus())
                .add("EvaluationStartTimestamp", evaluationStartTimestamp()).add("Compliance", complianceAsString())
                .add("EvaluationContext", evaluationContext()).add("ResourceDetails", resourceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceEvaluationId":
            return Optional.ofNullable(clazz.cast(resourceEvaluationId()));
        case "EvaluationMode":
            return Optional.ofNullable(clazz.cast(evaluationModeAsString()));
        case "EvaluationStatus":
            return Optional.ofNullable(clazz.cast(evaluationStatus()));
        case "EvaluationStartTimestamp":
            return Optional.ofNullable(clazz.cast(evaluationStartTimestamp()));
        case "Compliance":
            return Optional.ofNullable(clazz.cast(complianceAsString()));
        case "EvaluationContext":
            return Optional.ofNullable(clazz.cast(evaluationContext()));
        case "ResourceDetails":
            return Optional.ofNullable(clazz.cast(resourceDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceEvaluationSummaryResponse, T> g) {
        return obj -> g.apply((GetResourceEvaluationSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResourceEvaluationSummaryResponse> {
        /**
         * <p>
         * The unique <code>ResourceEvaluationId</code> of Amazon Web Services resource execution for which you want to
         * retrieve the evaluation summary.
         * </p>
         * 
         * @param resourceEvaluationId
         *        The unique <code>ResourceEvaluationId</code> of Amazon Web Services resource execution for which you
         *        want to retrieve the evaluation summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceEvaluationId(String resourceEvaluationId);

        /**
         * <p>
         * Lists results of the mode that you requested to retrieve the resource evaluation summary. The valid values
         * are Detective or Proactive.
         * </p>
         * 
         * @param evaluationMode
         *        Lists results of the mode that you requested to retrieve the resource evaluation summary. The valid
         *        values are Detective or Proactive.
         * @see EvaluationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationMode
         */
        Builder evaluationMode(String evaluationMode);

        /**
         * <p>
         * Lists results of the mode that you requested to retrieve the resource evaluation summary. The valid values
         * are Detective or Proactive.
         * </p>
         * 
         * @param evaluationMode
         *        Lists results of the mode that you requested to retrieve the resource evaluation summary. The valid
         *        values are Detective or Proactive.
         * @see EvaluationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationMode
         */
        Builder evaluationMode(EvaluationMode evaluationMode);

        /**
         * <p>
         * Returns an <code>EvaluationStatus</code> object.
         * </p>
         * 
         * @param evaluationStatus
         *        Returns an <code>EvaluationStatus</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationStatus(EvaluationStatus evaluationStatus);

        /**
         * <p>
         * Returns an <code>EvaluationStatus</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationStatus.Builder} avoiding the
         * need to create one manually via {@link EvaluationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #evaluationStatus(EvaluationStatus)}.
         * 
         * @param evaluationStatus
         *        a consumer that will call methods on {@link EvaluationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationStatus(EvaluationStatus)
         */
        default Builder evaluationStatus(Consumer<EvaluationStatus.Builder> evaluationStatus) {
            return evaluationStatus(EvaluationStatus.builder().applyMutation(evaluationStatus).build());
        }

        /**
         * <p>
         * The start timestamp when Config rule starts evaluating compliance for the provided resource details.
         * </p>
         * 
         * @param evaluationStartTimestamp
         *        The start timestamp when Config rule starts evaluating compliance for the provided resource details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationStartTimestamp(Instant evaluationStartTimestamp);

        /**
         * <p>
         * The compliance status of the resource evaluation summary.
         * </p>
         * 
         * @param compliance
         *        The compliance status of the resource evaluation summary.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder compliance(String compliance);

        /**
         * <p>
         * The compliance status of the resource evaluation summary.
         * </p>
         * 
         * @param compliance
         *        The compliance status of the resource evaluation summary.
         * @see ComplianceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceType
         */
        Builder compliance(ComplianceType compliance);

        /**
         * <p>
         * Returns an <code>EvaluationContext</code> object.
         * </p>
         * 
         * @param evaluationContext
         *        Returns an <code>EvaluationContext</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationContext(EvaluationContext evaluationContext);

        /**
         * <p>
         * Returns an <code>EvaluationContext</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationContext.Builder} avoiding the
         * need to create one manually via {@link EvaluationContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationContext.Builder#build()} is called immediately and its
         * result is passed to {@link #evaluationContext(EvaluationContext)}.
         * 
         * @param evaluationContext
         *        a consumer that will call methods on {@link EvaluationContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationContext(EvaluationContext)
         */
        default Builder evaluationContext(Consumer<EvaluationContext.Builder> evaluationContext) {
            return evaluationContext(EvaluationContext.builder().applyMutation(evaluationContext).build());
        }

        /**
         * <p>
         * Returns a <code>ResourceDetails</code> object.
         * </p>
         * 
         * @param resourceDetails
         *        Returns a <code>ResourceDetails</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDetails(ResourceDetails resourceDetails);

        /**
         * <p>
         * Returns a <code>ResourceDetails</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceDetails.Builder} avoiding the
         * need to create one manually via {@link ResourceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceDetails(ResourceDetails)}.
         * 
         * @param resourceDetails
         *        a consumer that will call methods on {@link ResourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceDetails(ResourceDetails)
         */
        default Builder resourceDetails(Consumer<ResourceDetails.Builder> resourceDetails) {
            return resourceDetails(ResourceDetails.builder().applyMutation(resourceDetails).build());
        }
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private String resourceEvaluationId;

        private String evaluationMode;

        private EvaluationStatus evaluationStatus;

        private Instant evaluationStartTimestamp;

        private String compliance;

        private EvaluationContext evaluationContext;

        private ResourceDetails resourceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceEvaluationSummaryResponse model) {
            super(model);
            resourceEvaluationId(model.resourceEvaluationId);
            evaluationMode(model.evaluationMode);
            evaluationStatus(model.evaluationStatus);
            evaluationStartTimestamp(model.evaluationStartTimestamp);
            compliance(model.compliance);
            evaluationContext(model.evaluationContext);
            resourceDetails(model.resourceDetails);
        }

        public final String getResourceEvaluationId() {
            return resourceEvaluationId;
        }

        public final void setResourceEvaluationId(String resourceEvaluationId) {
            this.resourceEvaluationId = resourceEvaluationId;
        }

        @Override
        public final Builder resourceEvaluationId(String resourceEvaluationId) {
            this.resourceEvaluationId = resourceEvaluationId;
            return this;
        }

        public final String getEvaluationMode() {
            return evaluationMode;
        }

        public final void setEvaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
        }

        @Override
        public final Builder evaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
            return this;
        }

        @Override
        public final Builder evaluationMode(EvaluationMode evaluationMode) {
            this.evaluationMode(evaluationMode == null ? null : evaluationMode.toString());
            return this;
        }

        public final EvaluationStatus.Builder getEvaluationStatus() {
            return evaluationStatus != null ? evaluationStatus.toBuilder() : null;
        }

        public final void setEvaluationStatus(EvaluationStatus.BuilderImpl evaluationStatus) {
            this.evaluationStatus = evaluationStatus != null ? evaluationStatus.build() : null;
        }

        @Override
        public final Builder evaluationStatus(EvaluationStatus evaluationStatus) {
            this.evaluationStatus = evaluationStatus;
            return this;
        }

        public final Instant getEvaluationStartTimestamp() {
            return evaluationStartTimestamp;
        }

        public final void setEvaluationStartTimestamp(Instant evaluationStartTimestamp) {
            this.evaluationStartTimestamp = evaluationStartTimestamp;
        }

        @Override
        public final Builder evaluationStartTimestamp(Instant evaluationStartTimestamp) {
            this.evaluationStartTimestamp = evaluationStartTimestamp;
            return this;
        }

        public final String getCompliance() {
            return compliance;
        }

        public final void setCompliance(String compliance) {
            this.compliance = compliance;
        }

        @Override
        public final Builder compliance(String compliance) {
            this.compliance = compliance;
            return this;
        }

        @Override
        public final Builder compliance(ComplianceType compliance) {
            this.compliance(compliance == null ? null : compliance.toString());
            return this;
        }

        public final EvaluationContext.Builder getEvaluationContext() {
            return evaluationContext != null ? evaluationContext.toBuilder() : null;
        }

        public final void setEvaluationContext(EvaluationContext.BuilderImpl evaluationContext) {
            this.evaluationContext = evaluationContext != null ? evaluationContext.build() : null;
        }

        @Override
        public final Builder evaluationContext(EvaluationContext evaluationContext) {
            this.evaluationContext = evaluationContext;
            return this;
        }

        public final ResourceDetails.Builder getResourceDetails() {
            return resourceDetails != null ? resourceDetails.toBuilder() : null;
        }

        public final void setResourceDetails(ResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        @Override
        public final Builder resourceDetails(ResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        @Override
        public GetResourceEvaluationSummaryResponse build() {
            return new GetResourceEvaluationSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
