/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The analyzed transcript segment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealTimeContactAnalysisSegmentTranscript implements SdkPojo, Serializable,
        ToCopyableBuilder<RealTimeContactAnalysisSegmentTranscript.Builder, RealTimeContactAnalysisSegmentTranscript> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(RealTimeContactAnalysisSegmentTranscript::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantId").getter(getter(RealTimeContactAnalysisSegmentTranscript::participantId))
            .setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()).build();

    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantRole").getter(getter(RealTimeContactAnalysisSegmentTranscript::participantRoleAsString))
            .setter(setter(Builder::participantRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(RealTimeContactAnalysisSegmentTranscript::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(RealTimeContactAnalysisSegmentTranscript::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(RealTimeContactAnalysisSegmentTranscript::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<RealTimeContactAnalysisTimeData> TIME_FIELD = SdkField
            .<RealTimeContactAnalysisTimeData> builder(MarshallingType.SDK_POJO).memberName("Time")
            .getter(getter(RealTimeContactAnalysisSegmentTranscript::time)).setter(setter(Builder::time))
            .constructor(RealTimeContactAnalysisTimeData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()).build();

    private static final SdkField<RealTimeContactAnalysisTranscriptItemRedaction> REDACTION_FIELD = SdkField
            .<RealTimeContactAnalysisTranscriptItemRedaction> builder(MarshallingType.SDK_POJO).memberName("Redaction")
            .getter(getter(RealTimeContactAnalysisSegmentTranscript::redaction)).setter(setter(Builder::redaction))
            .constructor(RealTimeContactAnalysisTranscriptItemRedaction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Redaction").build()).build();

    private static final SdkField<String> SENTIMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Sentiment").getter(getter(RealTimeContactAnalysisSegmentTranscript::sentimentAsString))
            .setter(setter(Builder::sentiment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sentiment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            PARTICIPANT_ID_FIELD, PARTICIPANT_ROLE_FIELD, DISPLAY_NAME_FIELD, CONTENT_FIELD, CONTENT_TYPE_FIELD, TIME_FIELD,
            REDACTION_FIELD, SENTIMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String participantId;

    private final String participantRole;

    private final String displayName;

    private final String content;

    private final String contentType;

    private final RealTimeContactAnalysisTimeData time;

    private final RealTimeContactAnalysisTranscriptItemRedaction redaction;

    private final String sentiment;

    private RealTimeContactAnalysisSegmentTranscript(BuilderImpl builder) {
        this.id = builder.id;
        this.participantId = builder.participantId;
        this.participantRole = builder.participantRole;
        this.displayName = builder.displayName;
        this.content = builder.content;
        this.contentType = builder.contentType;
        this.time = builder.time;
        this.redaction = builder.redaction;
        this.sentiment = builder.sentiment;
    }

    /**
     * <p>
     * The identifier of the transcript.
     * </p>
     * 
     * @return The identifier of the transcript.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The identifier of the participant.
     * </p>
     * 
     * @return The identifier of the participant.
     */
    public final String participantId() {
        return participantId;
    }

    /**
     * <p>
     * The role of the participant. For example, is it a customer, agent, or system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return The role of the participant. For example, is it a customer, agent, or system.
     * @see ParticipantRole
     */
    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(participantRole);
    }

    /**
     * <p>
     * The role of the participant. For example, is it a customer, agent, or system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return The role of the participant. For example, is it a customer, agent, or system.
     * @see ParticipantRole
     */
    public final String participantRoleAsString() {
        return participantRole;
    }

    /**
     * <p>
     * The display name of the participant.
     * </p>
     * 
     * @return The display name of the participant.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The content of the transcript. Can be redacted.
     * </p>
     * 
     * @return The content of the transcript. Can be redacted.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The type of content of the item. For example, <code>text/plain</code>.
     * </p>
     * 
     * @return The type of content of the item. For example, <code>text/plain</code>.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * Field describing the time of the event. It can have different representations of time.
     * </p>
     * 
     * @return Field describing the time of the event. It can have different representations of time.
     */
    public final RealTimeContactAnalysisTimeData time() {
        return time;
    }

    /**
     * <p>
     * Object describing redaction that was applied to the transcript. If transcript has the field it means part of the
     * transcript was redacted.
     * </p>
     * 
     * @return Object describing redaction that was applied to the transcript. If transcript has the field it means part
     *         of the transcript was redacted.
     */
    public final RealTimeContactAnalysisTranscriptItemRedaction redaction() {
        return redaction;
    }

    /**
     * <p>
     * The sentiment detected for this piece of transcript.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sentiment} will
     * return {@link RealTimeContactAnalysisSentimentLabel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sentimentAsString}.
     * </p>
     * 
     * @return The sentiment detected for this piece of transcript.
     * @see RealTimeContactAnalysisSentimentLabel
     */
    public final RealTimeContactAnalysisSentimentLabel sentiment() {
        return RealTimeContactAnalysisSentimentLabel.fromValue(sentiment);
    }

    /**
     * <p>
     * The sentiment detected for this piece of transcript.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sentiment} will
     * return {@link RealTimeContactAnalysisSentimentLabel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sentimentAsString}.
     * </p>
     * 
     * @return The sentiment detected for this piece of transcript.
     * @see RealTimeContactAnalysisSentimentLabel
     */
    public final String sentimentAsString() {
        return sentiment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(participantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(time());
        hashCode = 31 * hashCode + Objects.hashCode(redaction());
        hashCode = 31 * hashCode + Objects.hashCode(sentimentAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealTimeContactAnalysisSegmentTranscript)) {
            return false;
        }
        RealTimeContactAnalysisSegmentTranscript other = (RealTimeContactAnalysisSegmentTranscript) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(participantId(), other.participantId())
                && Objects.equals(participantRoleAsString(), other.participantRoleAsString())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(content(), other.content())
                && Objects.equals(contentType(), other.contentType()) && Objects.equals(time(), other.time())
                && Objects.equals(redaction(), other.redaction())
                && Objects.equals(sentimentAsString(), other.sentimentAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealTimeContactAnalysisSegmentTranscript").add("Id", id()).add("ParticipantId", participantId())
                .add("ParticipantRole", participantRoleAsString()).add("DisplayName", displayName()).add("Content", content())
                .add("ContentType", contentType()).add("Time", time()).add("Redaction", redaction())
                .add("Sentiment", sentimentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ParticipantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "ParticipantRole":
            return Optional.ofNullable(clazz.cast(participantRoleAsString()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "Time":
            return Optional.ofNullable(clazz.cast(time()));
        case "Redaction":
            return Optional.ofNullable(clazz.cast(redaction()));
        case "Sentiment":
            return Optional.ofNullable(clazz.cast(sentimentAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RealTimeContactAnalysisSegmentTranscript, T> g) {
        return obj -> g.apply((RealTimeContactAnalysisSegmentTranscript) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealTimeContactAnalysisSegmentTranscript> {
        /**
         * <p>
         * The identifier of the transcript.
         * </p>
         * 
         * @param id
         *        The identifier of the transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier of the participant.
         * </p>
         * 
         * @param participantId
         *        The identifier of the participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * The role of the participant. For example, is it a customer, agent, or system.
         * </p>
         * 
         * @param participantRole
         *        The role of the participant. For example, is it a customer, agent, or system.
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(String participantRole);

        /**
         * <p>
         * The role of the participant. For example, is it a customer, agent, or system.
         * </p>
         * 
         * @param participantRole
         *        The role of the participant. For example, is it a customer, agent, or system.
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(ParticipantRole participantRole);

        /**
         * <p>
         * The display name of the participant.
         * </p>
         * 
         * @param displayName
         *        The display name of the participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The content of the transcript. Can be redacted.
         * </p>
         * 
         * @param content
         *        The content of the transcript. Can be redacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The type of content of the item. For example, <code>text/plain</code>.
         * </p>
         * 
         * @param contentType
         *        The type of content of the item. For example, <code>text/plain</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Field describing the time of the event. It can have different representations of time.
         * </p>
         * 
         * @param time
         *        Field describing the time of the event. It can have different representations of time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(RealTimeContactAnalysisTimeData time);

        /**
         * <p>
         * Field describing the time of the event. It can have different representations of time.
         * </p>
         * This is a convenience method that creates an instance of the {@link RealTimeContactAnalysisTimeData.Builder}
         * avoiding the need to create one manually via {@link RealTimeContactAnalysisTimeData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RealTimeContactAnalysisTimeData.Builder#build()} is called
         * immediately and its result is passed to {@link #time(RealTimeContactAnalysisTimeData)}.
         * 
         * @param time
         *        a consumer that will call methods on {@link RealTimeContactAnalysisTimeData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #time(RealTimeContactAnalysisTimeData)
         */
        default Builder time(Consumer<RealTimeContactAnalysisTimeData.Builder> time) {
            return time(RealTimeContactAnalysisTimeData.builder().applyMutation(time).build());
        }

        /**
         * <p>
         * Object describing redaction that was applied to the transcript. If transcript has the field it means part of
         * the transcript was redacted.
         * </p>
         * 
         * @param redaction
         *        Object describing redaction that was applied to the transcript. If transcript has the field it means
         *        part of the transcript was redacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redaction(RealTimeContactAnalysisTranscriptItemRedaction redaction);

        /**
         * <p>
         * Object describing redaction that was applied to the transcript. If transcript has the field it means part of
         * the transcript was redacted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RealTimeContactAnalysisTranscriptItemRedaction.Builder} avoiding the need to create one manually via
         * {@link RealTimeContactAnalysisTranscriptItemRedaction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RealTimeContactAnalysisTranscriptItemRedaction.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #redaction(RealTimeContactAnalysisTranscriptItemRedaction)}.
         * 
         * @param redaction
         *        a consumer that will call methods on {@link RealTimeContactAnalysisTranscriptItemRedaction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redaction(RealTimeContactAnalysisTranscriptItemRedaction)
         */
        default Builder redaction(Consumer<RealTimeContactAnalysisTranscriptItemRedaction.Builder> redaction) {
            return redaction(RealTimeContactAnalysisTranscriptItemRedaction.builder().applyMutation(redaction).build());
        }

        /**
         * <p>
         * The sentiment detected for this piece of transcript.
         * </p>
         * 
         * @param sentiment
         *        The sentiment detected for this piece of transcript.
         * @see RealTimeContactAnalysisSentimentLabel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RealTimeContactAnalysisSentimentLabel
         */
        Builder sentiment(String sentiment);

        /**
         * <p>
         * The sentiment detected for this piece of transcript.
         * </p>
         * 
         * @param sentiment
         *        The sentiment detected for this piece of transcript.
         * @see RealTimeContactAnalysisSentimentLabel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RealTimeContactAnalysisSentimentLabel
         */
        Builder sentiment(RealTimeContactAnalysisSentimentLabel sentiment);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String participantId;

        private String participantRole;

        private String displayName;

        private String content;

        private String contentType;

        private RealTimeContactAnalysisTimeData time;

        private RealTimeContactAnalysisTranscriptItemRedaction redaction;

        private String sentiment;

        private BuilderImpl() {
        }

        private BuilderImpl(RealTimeContactAnalysisSegmentTranscript model) {
            id(model.id);
            participantId(model.participantId);
            participantRole(model.participantRole);
            displayName(model.displayName);
            content(model.content);
            contentType(model.contentType);
            time(model.time);
            redaction(model.redaction);
            sentiment(model.sentiment);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getParticipantRole() {
            return participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final RealTimeContactAnalysisTimeData.Builder getTime() {
            return time != null ? time.toBuilder() : null;
        }

        public final void setTime(RealTimeContactAnalysisTimeData.BuilderImpl time) {
            this.time = time != null ? time.build() : null;
        }

        @Override
        public final Builder time(RealTimeContactAnalysisTimeData time) {
            this.time = time;
            return this;
        }

        public final RealTimeContactAnalysisTranscriptItemRedaction.Builder getRedaction() {
            return redaction != null ? redaction.toBuilder() : null;
        }

        public final void setRedaction(RealTimeContactAnalysisTranscriptItemRedaction.BuilderImpl redaction) {
            this.redaction = redaction != null ? redaction.build() : null;
        }

        @Override
        public final Builder redaction(RealTimeContactAnalysisTranscriptItemRedaction redaction) {
            this.redaction = redaction;
            return this;
        }

        public final String getSentiment() {
            return sentiment;
        }

        public final void setSentiment(String sentiment) {
            this.sentiment = sentiment;
        }

        @Override
        public final Builder sentiment(String sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        @Override
        public final Builder sentiment(RealTimeContactAnalysisSentimentLabel sentiment) {
            this.sentiment(sentiment == null ? null : sentiment.toString());
            return this;
        }

        @Override
        public RealTimeContactAnalysisSegmentTranscript build() {
            return new RealTimeContactAnalysisSegmentTranscript(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
