/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An analyzed segment for a real-time analysis session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealtimeContactAnalysisSegment implements SdkPojo, Serializable,
        ToCopyableBuilder<RealtimeContactAnalysisSegment.Builder, RealtimeContactAnalysisSegment> {
    private static final SdkField<RealTimeContactAnalysisSegmentTranscript> TRANSCRIPT_FIELD = SdkField
            .<RealTimeContactAnalysisSegmentTranscript> builder(MarshallingType.SDK_POJO).memberName("Transcript")
            .getter(getter(RealtimeContactAnalysisSegment::transcript)).setter(setter(Builder::transcript))
            .constructor(RealTimeContactAnalysisSegmentTranscript::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build()).build();

    private static final SdkField<RealTimeContactAnalysisSegmentCategories> CATEGORIES_FIELD = SdkField
            .<RealTimeContactAnalysisSegmentCategories> builder(MarshallingType.SDK_POJO).memberName("Categories")
            .getter(getter(RealtimeContactAnalysisSegment::categories)).setter(setter(Builder::categories))
            .constructor(RealTimeContactAnalysisSegmentCategories::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build()).build();

    private static final SdkField<RealTimeContactAnalysisSegmentIssues> ISSUES_FIELD = SdkField
            .<RealTimeContactAnalysisSegmentIssues> builder(MarshallingType.SDK_POJO).memberName("Issues")
            .getter(getter(RealtimeContactAnalysisSegment::issues)).setter(setter(Builder::issues))
            .constructor(RealTimeContactAnalysisSegmentIssues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issues").build()).build();

    private static final SdkField<RealTimeContactAnalysisSegmentEvent> EVENT_FIELD = SdkField
            .<RealTimeContactAnalysisSegmentEvent> builder(MarshallingType.SDK_POJO).memberName("Event")
            .getter(getter(RealtimeContactAnalysisSegment::event)).setter(setter(Builder::event))
            .constructor(RealTimeContactAnalysisSegmentEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event").build()).build();

    private static final SdkField<RealTimeContactAnalysisSegmentAttachments> ATTACHMENTS_FIELD = SdkField
            .<RealTimeContactAnalysisSegmentAttachments> builder(MarshallingType.SDK_POJO).memberName("Attachments")
            .getter(getter(RealtimeContactAnalysisSegment::attachments)).setter(setter(Builder::attachments))
            .constructor(RealTimeContactAnalysisSegmentAttachments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FIELD,
            CATEGORIES_FIELD, ISSUES_FIELD, EVENT_FIELD, ATTACHMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final RealTimeContactAnalysisSegmentTranscript transcript;

    private final RealTimeContactAnalysisSegmentCategories categories;

    private final RealTimeContactAnalysisSegmentIssues issues;

    private final RealTimeContactAnalysisSegmentEvent event;

    private final RealTimeContactAnalysisSegmentAttachments attachments;

    private final Type type;

    private RealtimeContactAnalysisSegment(BuilderImpl builder) {
        this.transcript = builder.transcript;
        this.categories = builder.categories;
        this.issues = builder.issues;
        this.event = builder.event;
        this.attachments = builder.attachments;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Transcript property for this object.
     * 
     * @return The value of the Transcript property for this object.
     */
    public final RealTimeContactAnalysisSegmentTranscript transcript() {
        return transcript;
    }

    /**
     * Returns the value of the Categories property for this object.
     * 
     * @return The value of the Categories property for this object.
     */
    public final RealTimeContactAnalysisSegmentCategories categories() {
        return categories;
    }

    /**
     * Returns the value of the Issues property for this object.
     * 
     * @return The value of the Issues property for this object.
     */
    public final RealTimeContactAnalysisSegmentIssues issues() {
        return issues;
    }

    /**
     * Returns the value of the Event property for this object.
     * 
     * @return The value of the Event property for this object.
     */
    public final RealTimeContactAnalysisSegmentEvent event() {
        return event;
    }

    /**
     * <p>
     * The analyzed attachments.
     * </p>
     * 
     * @return The analyzed attachments.
     */
    public final RealTimeContactAnalysisSegmentAttachments attachments() {
        return attachments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcript());
        hashCode = 31 * hashCode + Objects.hashCode(categories());
        hashCode = 31 * hashCode + Objects.hashCode(issues());
        hashCode = 31 * hashCode + Objects.hashCode(event());
        hashCode = 31 * hashCode + Objects.hashCode(attachments());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealtimeContactAnalysisSegment)) {
            return false;
        }
        RealtimeContactAnalysisSegment other = (RealtimeContactAnalysisSegment) obj;
        return Objects.equals(transcript(), other.transcript()) && Objects.equals(categories(), other.categories())
                && Objects.equals(issues(), other.issues()) && Objects.equals(event(), other.event())
                && Objects.equals(attachments(), other.attachments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealtimeContactAnalysisSegment").add("Transcript", transcript()).add("Categories", categories())
                .add("Issues", issues()).add("Event", event()).add("Attachments", attachments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Transcript":
            return Optional.ofNullable(clazz.cast(transcript()));
        case "Categories":
            return Optional.ofNullable(clazz.cast(categories()));
        case "Issues":
            return Optional.ofNullable(clazz.cast(issues()));
        case "Event":
            return Optional.ofNullable(clazz.cast(event()));
        case "Attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #transcript()} initialized to the given value.
     *
     * Sets the value of the Transcript property for this object.
     *
     * @param transcript
     *        The new value for the Transcript property for this object.
     */
    public static RealtimeContactAnalysisSegment fromTranscript(RealTimeContactAnalysisSegmentTranscript transcript) {
        return builder().transcript(transcript).build();
    }

    /**
     * Create an instance of this class with {@link #transcript()} initialized to the given value.
     *
     * Sets the value of the Transcript property for this object.
     *
     * @param transcript
     *        The new value for the Transcript property for this object.
     */
    public static RealtimeContactAnalysisSegment fromTranscript(
            Consumer<RealTimeContactAnalysisSegmentTranscript.Builder> transcript) {
        RealTimeContactAnalysisSegmentTranscript.Builder builder = RealTimeContactAnalysisSegmentTranscript.builder();
        transcript.accept(builder);
        return fromTranscript(builder.build());
    }

    /**
     * Create an instance of this class with {@link #categories()} initialized to the given value.
     *
     * Sets the value of the Categories property for this object.
     *
     * @param categories
     *        The new value for the Categories property for this object.
     */
    public static RealtimeContactAnalysisSegment fromCategories(RealTimeContactAnalysisSegmentCategories categories) {
        return builder().categories(categories).build();
    }

    /**
     * Create an instance of this class with {@link #categories()} initialized to the given value.
     *
     * Sets the value of the Categories property for this object.
     *
     * @param categories
     *        The new value for the Categories property for this object.
     */
    public static RealtimeContactAnalysisSegment fromCategories(
            Consumer<RealTimeContactAnalysisSegmentCategories.Builder> categories) {
        RealTimeContactAnalysisSegmentCategories.Builder builder = RealTimeContactAnalysisSegmentCategories.builder();
        categories.accept(builder);
        return fromCategories(builder.build());
    }

    /**
     * Create an instance of this class with {@link #issues()} initialized to the given value.
     *
     * Sets the value of the Issues property for this object.
     *
     * @param issues
     *        The new value for the Issues property for this object.
     */
    public static RealtimeContactAnalysisSegment fromIssues(RealTimeContactAnalysisSegmentIssues issues) {
        return builder().issues(issues).build();
    }

    /**
     * Create an instance of this class with {@link #issues()} initialized to the given value.
     *
     * Sets the value of the Issues property for this object.
     *
     * @param issues
     *        The new value for the Issues property for this object.
     */
    public static RealtimeContactAnalysisSegment fromIssues(Consumer<RealTimeContactAnalysisSegmentIssues.Builder> issues) {
        RealTimeContactAnalysisSegmentIssues.Builder builder = RealTimeContactAnalysisSegmentIssues.builder();
        issues.accept(builder);
        return fromIssues(builder.build());
    }

    /**
     * Create an instance of this class with {@link #event()} initialized to the given value.
     *
     * Sets the value of the Event property for this object.
     *
     * @param event
     *        The new value for the Event property for this object.
     */
    public static RealtimeContactAnalysisSegment fromEvent(RealTimeContactAnalysisSegmentEvent event) {
        return builder().event(event).build();
    }

    /**
     * Create an instance of this class with {@link #event()} initialized to the given value.
     *
     * Sets the value of the Event property for this object.
     *
     * @param event
     *        The new value for the Event property for this object.
     */
    public static RealtimeContactAnalysisSegment fromEvent(Consumer<RealTimeContactAnalysisSegmentEvent.Builder> event) {
        RealTimeContactAnalysisSegmentEvent.Builder builder = RealTimeContactAnalysisSegmentEvent.builder();
        event.accept(builder);
        return fromEvent(builder.build());
    }

    /**
     * Create an instance of this class with {@link #attachments()} initialized to the given value.
     *
     * <p>
     * The analyzed attachments.
     * </p>
     * 
     * @param attachments
     *        The analyzed attachments.
     */
    public static RealtimeContactAnalysisSegment fromAttachments(RealTimeContactAnalysisSegmentAttachments attachments) {
        return builder().attachments(attachments).build();
    }

    /**
     * Create an instance of this class with {@link #attachments()} initialized to the given value.
     *
     * <p>
     * The analyzed attachments.
     * </p>
     * 
     * @param attachments
     *        The analyzed attachments.
     */
    public static RealtimeContactAnalysisSegment fromAttachments(
            Consumer<RealTimeContactAnalysisSegmentAttachments.Builder> attachments) {
        RealTimeContactAnalysisSegmentAttachments.Builder builder = RealTimeContactAnalysisSegmentAttachments.builder();
        attachments.accept(builder);
        return fromAttachments(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RealtimeContactAnalysisSegment, T> g) {
        return obj -> g.apply((RealtimeContactAnalysisSegment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealtimeContactAnalysisSegment> {
        /**
         * Sets the value of the Transcript property for this object.
         *
         * @param transcript
         *        The new value for the Transcript property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcript(RealTimeContactAnalysisSegmentTranscript transcript);

        /**
         * Sets the value of the Transcript property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link RealTimeContactAnalysisSegmentTranscript.Builder} avoiding the need to create one manually via
         * {@link RealTimeContactAnalysisSegmentTranscript#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RealTimeContactAnalysisSegmentTranscript.Builder#build()} is
         * called immediately and its result is passed to {@link #transcript(RealTimeContactAnalysisSegmentTranscript)}.
         * 
         * @param transcript
         *        a consumer that will call methods on {@link RealTimeContactAnalysisSegmentTranscript.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcript(RealTimeContactAnalysisSegmentTranscript)
         */
        default Builder transcript(Consumer<RealTimeContactAnalysisSegmentTranscript.Builder> transcript) {
            return transcript(RealTimeContactAnalysisSegmentTranscript.builder().applyMutation(transcript).build());
        }

        /**
         * Sets the value of the Categories property for this object.
         *
         * @param categories
         *        The new value for the Categories property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categories(RealTimeContactAnalysisSegmentCategories categories);

        /**
         * Sets the value of the Categories property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link RealTimeContactAnalysisSegmentCategories.Builder} avoiding the need to create one manually via
         * {@link RealTimeContactAnalysisSegmentCategories#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RealTimeContactAnalysisSegmentCategories.Builder#build()} is
         * called immediately and its result is passed to {@link #categories(RealTimeContactAnalysisSegmentCategories)}.
         * 
         * @param categories
         *        a consumer that will call methods on {@link RealTimeContactAnalysisSegmentCategories.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categories(RealTimeContactAnalysisSegmentCategories)
         */
        default Builder categories(Consumer<RealTimeContactAnalysisSegmentCategories.Builder> categories) {
            return categories(RealTimeContactAnalysisSegmentCategories.builder().applyMutation(categories).build());
        }

        /**
         * Sets the value of the Issues property for this object.
         *
         * @param issues
         *        The new value for the Issues property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issues(RealTimeContactAnalysisSegmentIssues issues);

        /**
         * Sets the value of the Issues property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link RealTimeContactAnalysisSegmentIssues.Builder} avoiding the need to create one manually via
         * {@link RealTimeContactAnalysisSegmentIssues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RealTimeContactAnalysisSegmentIssues.Builder#build()} is called
         * immediately and its result is passed to {@link #issues(RealTimeContactAnalysisSegmentIssues)}.
         * 
         * @param issues
         *        a consumer that will call methods on {@link RealTimeContactAnalysisSegmentIssues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issues(RealTimeContactAnalysisSegmentIssues)
         */
        default Builder issues(Consumer<RealTimeContactAnalysisSegmentIssues.Builder> issues) {
            return issues(RealTimeContactAnalysisSegmentIssues.builder().applyMutation(issues).build());
        }

        /**
         * Sets the value of the Event property for this object.
         *
         * @param event
         *        The new value for the Event property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder event(RealTimeContactAnalysisSegmentEvent event);

        /**
         * Sets the value of the Event property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link RealTimeContactAnalysisSegmentEvent.Builder} avoiding the need to create one manually via
         * {@link RealTimeContactAnalysisSegmentEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RealTimeContactAnalysisSegmentEvent.Builder#build()} is called
         * immediately and its result is passed to {@link #event(RealTimeContactAnalysisSegmentEvent)}.
         * 
         * @param event
         *        a consumer that will call methods on {@link RealTimeContactAnalysisSegmentEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #event(RealTimeContactAnalysisSegmentEvent)
         */
        default Builder event(Consumer<RealTimeContactAnalysisSegmentEvent.Builder> event) {
            return event(RealTimeContactAnalysisSegmentEvent.builder().applyMutation(event).build());
        }

        /**
         * <p>
         * The analyzed attachments.
         * </p>
         * 
         * @param attachments
         *        The analyzed attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(RealTimeContactAnalysisSegmentAttachments attachments);

        /**
         * <p>
         * The analyzed attachments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RealTimeContactAnalysisSegmentAttachments.Builder} avoiding the need to create one manually via
         * {@link RealTimeContactAnalysisSegmentAttachments#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RealTimeContactAnalysisSegmentAttachments.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #attachments(RealTimeContactAnalysisSegmentAttachments)}.
         * 
         * @param attachments
         *        a consumer that will call methods on {@link RealTimeContactAnalysisSegmentAttachments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(RealTimeContactAnalysisSegmentAttachments)
         */
        default Builder attachments(Consumer<RealTimeContactAnalysisSegmentAttachments.Builder> attachments) {
            return attachments(RealTimeContactAnalysisSegmentAttachments.builder().applyMutation(attachments).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RealTimeContactAnalysisSegmentTranscript transcript;

        private RealTimeContactAnalysisSegmentCategories categories;

        private RealTimeContactAnalysisSegmentIssues issues;

        private RealTimeContactAnalysisSegmentEvent event;

        private RealTimeContactAnalysisSegmentAttachments attachments;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RealtimeContactAnalysisSegment model) {
            transcript(model.transcript);
            categories(model.categories);
            issues(model.issues);
            event(model.event);
            attachments(model.attachments);
        }

        public final RealTimeContactAnalysisSegmentTranscript.Builder getTranscript() {
            return transcript != null ? transcript.toBuilder() : null;
        }

        public final void setTranscript(RealTimeContactAnalysisSegmentTranscript.BuilderImpl transcript) {
            Object oldValue = this.transcript;
            this.transcript = transcript != null ? transcript.build() : null;
            handleUnionValueChange(Type.TRANSCRIPT, oldValue, this.transcript);
        }

        @Override
        public final Builder transcript(RealTimeContactAnalysisSegmentTranscript transcript) {
            Object oldValue = this.transcript;
            this.transcript = transcript;
            handleUnionValueChange(Type.TRANSCRIPT, oldValue, this.transcript);
            return this;
        }

        public final RealTimeContactAnalysisSegmentCategories.Builder getCategories() {
            return categories != null ? categories.toBuilder() : null;
        }

        public final void setCategories(RealTimeContactAnalysisSegmentCategories.BuilderImpl categories) {
            Object oldValue = this.categories;
            this.categories = categories != null ? categories.build() : null;
            handleUnionValueChange(Type.CATEGORIES, oldValue, this.categories);
        }

        @Override
        public final Builder categories(RealTimeContactAnalysisSegmentCategories categories) {
            Object oldValue = this.categories;
            this.categories = categories;
            handleUnionValueChange(Type.CATEGORIES, oldValue, this.categories);
            return this;
        }

        public final RealTimeContactAnalysisSegmentIssues.Builder getIssues() {
            return issues != null ? issues.toBuilder() : null;
        }

        public final void setIssues(RealTimeContactAnalysisSegmentIssues.BuilderImpl issues) {
            Object oldValue = this.issues;
            this.issues = issues != null ? issues.build() : null;
            handleUnionValueChange(Type.ISSUES, oldValue, this.issues);
        }

        @Override
        public final Builder issues(RealTimeContactAnalysisSegmentIssues issues) {
            Object oldValue = this.issues;
            this.issues = issues;
            handleUnionValueChange(Type.ISSUES, oldValue, this.issues);
            return this;
        }

        public final RealTimeContactAnalysisSegmentEvent.Builder getEvent() {
            return event != null ? event.toBuilder() : null;
        }

        public final void setEvent(RealTimeContactAnalysisSegmentEvent.BuilderImpl event) {
            Object oldValue = this.event;
            this.event = event != null ? event.build() : null;
            handleUnionValueChange(Type.EVENT, oldValue, this.event);
        }

        @Override
        public final Builder event(RealTimeContactAnalysisSegmentEvent event) {
            Object oldValue = this.event;
            this.event = event;
            handleUnionValueChange(Type.EVENT, oldValue, this.event);
            return this;
        }

        public final RealTimeContactAnalysisSegmentAttachments.Builder getAttachments() {
            return attachments != null ? attachments.toBuilder() : null;
        }

        public final void setAttachments(RealTimeContactAnalysisSegmentAttachments.BuilderImpl attachments) {
            Object oldValue = this.attachments;
            this.attachments = attachments != null ? attachments.build() : null;
            handleUnionValueChange(Type.ATTACHMENTS, oldValue, this.attachments);
        }

        @Override
        public final Builder attachments(RealTimeContactAnalysisSegmentAttachments attachments) {
            Object oldValue = this.attachments;
            this.attachments = attachments;
            handleUnionValueChange(Type.ATTACHMENTS, oldValue, this.attachments);
            return this;
        }

        @Override
        public RealtimeContactAnalysisSegment build() {
            return new RealtimeContactAnalysisSegment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RealtimeContactAnalysisSegment#type()
     */
    public enum Type {
        TRANSCRIPT,

        CATEGORIES,

        ISSUES,

        EVENT,

        ATTACHMENTS,

        UNKNOWN_TO_SDK_VERSION
    }
}
