/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The distribution that determines which Amazon Web Services Regions should be used to sign in agents in to both the
 * instance and its replica(s).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignInConfig implements SdkPojo, Serializable, ToCopyableBuilder<SignInConfig.Builder, SignInConfig> {
    private static final SdkField<List<SignInDistribution>> DISTRIBUTIONS_FIELD = SdkField
            .<List<SignInDistribution>> builder(MarshallingType.LIST)
            .memberName("Distributions")
            .getter(getter(SignInConfig::distributions))
            .setter(setter(Builder::distributions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distributions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SignInDistribution> builder(MarshallingType.SDK_POJO)
                                            .constructor(SignInDistribution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SignInDistribution> distributions;

    private SignInConfig(BuilderImpl builder) {
        this.distributions = builder.distributions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Distributions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDistributions() {
        return distributions != null && !(distributions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about traffic distributions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDistributions} method.
     * </p>
     * 
     * @return Information about traffic distributions.
     */
    public final List<SignInDistribution> distributions() {
        return distributions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDistributions() ? distributions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignInConfig)) {
            return false;
        }
        SignInConfig other = (SignInConfig) obj;
        return hasDistributions() == other.hasDistributions() && Objects.equals(distributions(), other.distributions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignInConfig").add("Distributions", hasDistributions() ? distributions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Distributions":
            return Optional.ofNullable(clazz.cast(distributions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SignInConfig, T> g) {
        return obj -> g.apply((SignInConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SignInConfig> {
        /**
         * <p>
         * Information about traffic distributions.
         * </p>
         * 
         * @param distributions
         *        Information about traffic distributions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributions(Collection<SignInDistribution> distributions);

        /**
         * <p>
         * Information about traffic distributions.
         * </p>
         * 
         * @param distributions
         *        Information about traffic distributions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributions(SignInDistribution... distributions);

        /**
         * <p>
         * Information about traffic distributions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.SignInDistribution.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.SignInDistribution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.SignInDistribution.Builder#build()} is called
         * immediately and its result is passed to {@link #distributions(List<SignInDistribution>)}.
         * 
         * @param distributions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.SignInDistribution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distributions(java.util.Collection<SignInDistribution>)
         */
        Builder distributions(Consumer<SignInDistribution.Builder>... distributions);
    }

    static final class BuilderImpl implements Builder {
        private List<SignInDistribution> distributions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SignInConfig model) {
            distributions(model.distributions);
        }

        public final List<SignInDistribution.Builder> getDistributions() {
            List<SignInDistribution.Builder> result = SignInDistributionListCopier.copyToBuilder(this.distributions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDistributions(Collection<SignInDistribution.BuilderImpl> distributions) {
            this.distributions = SignInDistributionListCopier.copyFromBuilder(distributions);
        }

        @Override
        public final Builder distributions(Collection<SignInDistribution> distributions) {
            this.distributions = SignInDistributionListCopier.copy(distributions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributions(SignInDistribution... distributions) {
            distributions(Arrays.asList(distributions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributions(Consumer<SignInDistribution.Builder>... distributions) {
            distributions(Stream.of(distributions).map(c -> SignInDistribution.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SignInConfig build() {
            return new SignInConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
