/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaigns.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcampaigns.model.AgentlessDialerConfig;
import software.amazon.awssdk.services.connectcampaigns.model.PredictiveDialerConfig;
import software.amazon.awssdk.services.connectcampaigns.model.ProgressiveDialerConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DialerConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DialerConfig> {
    private static final SdkField<ProgressiveDialerConfig> PROGRESSIVE_DIALER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("progressiveDialerConfig").getter(DialerConfig.getter(DialerConfig::progressiveDialerConfig)).setter(DialerConfig.setter(Builder::progressiveDialerConfig)).constructor(ProgressiveDialerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressiveDialerConfig").build()}).build();
    private static final SdkField<PredictiveDialerConfig> PREDICTIVE_DIALER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("predictiveDialerConfig").getter(DialerConfig.getter(DialerConfig::predictiveDialerConfig)).setter(DialerConfig.setter(Builder::predictiveDialerConfig)).constructor(PredictiveDialerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictiveDialerConfig").build()}).build();
    private static final SdkField<AgentlessDialerConfig> AGENTLESS_DIALER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("agentlessDialerConfig").getter(DialerConfig.getter(DialerConfig::agentlessDialerConfig)).setter(DialerConfig.setter(Builder::agentlessDialerConfig)).constructor(AgentlessDialerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentlessDialerConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESSIVE_DIALER_CONFIG_FIELD, PREDICTIVE_DIALER_CONFIG_FIELD, AGENTLESS_DIALER_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final ProgressiveDialerConfig progressiveDialerConfig;
    private final PredictiveDialerConfig predictiveDialerConfig;
    private final AgentlessDialerConfig agentlessDialerConfig;
    private final Type type;

    private DialerConfig(BuilderImpl builder) {
        this.progressiveDialerConfig = builder.progressiveDialerConfig;
        this.predictiveDialerConfig = builder.predictiveDialerConfig;
        this.agentlessDialerConfig = builder.agentlessDialerConfig;
        this.type = builder.type;
    }

    public final ProgressiveDialerConfig progressiveDialerConfig() {
        return this.progressiveDialerConfig;
    }

    public final PredictiveDialerConfig predictiveDialerConfig() {
        return this.predictiveDialerConfig;
    }

    public final AgentlessDialerConfig agentlessDialerConfig() {
        return this.agentlessDialerConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.progressiveDialerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictiveDialerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentlessDialerConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DialerConfig)) {
            return false;
        }
        DialerConfig other = (DialerConfig)obj;
        return Objects.equals(this.progressiveDialerConfig(), other.progressiveDialerConfig()) && Objects.equals(this.predictiveDialerConfig(), other.predictiveDialerConfig()) && Objects.equals(this.agentlessDialerConfig(), other.agentlessDialerConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DialerConfig").add("ProgressiveDialerConfig", (Object)this.progressiveDialerConfig()).add("PredictiveDialerConfig", (Object)this.predictiveDialerConfig()).add("AgentlessDialerConfig", (Object)this.agentlessDialerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "progressiveDialerConfig": {
                return Optional.ofNullable(clazz.cast(this.progressiveDialerConfig()));
            }
            case "predictiveDialerConfig": {
                return Optional.ofNullable(clazz.cast(this.predictiveDialerConfig()));
            }
            case "agentlessDialerConfig": {
                return Optional.ofNullable(clazz.cast(this.agentlessDialerConfig()));
            }
        }
        return Optional.empty();
    }

    public static DialerConfig fromProgressiveDialerConfig(ProgressiveDialerConfig progressiveDialerConfig) {
        return (DialerConfig)DialerConfig.builder().progressiveDialerConfig(progressiveDialerConfig).build();
    }

    public static DialerConfig fromProgressiveDialerConfig(Consumer<ProgressiveDialerConfig.Builder> progressiveDialerConfig) {
        ProgressiveDialerConfig.Builder builder = ProgressiveDialerConfig.builder();
        progressiveDialerConfig.accept(builder);
        return DialerConfig.fromProgressiveDialerConfig((ProgressiveDialerConfig)builder.build());
    }

    public static DialerConfig fromPredictiveDialerConfig(PredictiveDialerConfig predictiveDialerConfig) {
        return (DialerConfig)DialerConfig.builder().predictiveDialerConfig(predictiveDialerConfig).build();
    }

    public static DialerConfig fromPredictiveDialerConfig(Consumer<PredictiveDialerConfig.Builder> predictiveDialerConfig) {
        PredictiveDialerConfig.Builder builder = PredictiveDialerConfig.builder();
        predictiveDialerConfig.accept(builder);
        return DialerConfig.fromPredictiveDialerConfig((PredictiveDialerConfig)builder.build());
    }

    public static DialerConfig fromAgentlessDialerConfig(AgentlessDialerConfig agentlessDialerConfig) {
        return (DialerConfig)DialerConfig.builder().agentlessDialerConfig(agentlessDialerConfig).build();
    }

    public static DialerConfig fromAgentlessDialerConfig(Consumer<AgentlessDialerConfig.Builder> agentlessDialerConfig) {
        AgentlessDialerConfig.Builder builder = AgentlessDialerConfig.builder();
        agentlessDialerConfig.accept(builder);
        return DialerConfig.fromAgentlessDialerConfig((AgentlessDialerConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DialerConfig, T> g) {
        return obj -> g.apply((DialerConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PROGRESSIVE_DIALER_CONFIG,
        PREDICTIVE_DIALER_CONFIG,
        AGENTLESS_DIALER_CONFIG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ProgressiveDialerConfig progressiveDialerConfig;
        private PredictiveDialerConfig predictiveDialerConfig;
        private AgentlessDialerConfig agentlessDialerConfig;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DialerConfig model) {
            this.progressiveDialerConfig(model.progressiveDialerConfig);
            this.predictiveDialerConfig(model.predictiveDialerConfig);
            this.agentlessDialerConfig(model.agentlessDialerConfig);
        }

        public final ProgressiveDialerConfig.Builder getProgressiveDialerConfig() {
            return this.progressiveDialerConfig != null ? this.progressiveDialerConfig.toBuilder() : null;
        }

        public final void setProgressiveDialerConfig(ProgressiveDialerConfig.BuilderImpl progressiveDialerConfig) {
            ProgressiveDialerConfig oldValue = this.progressiveDialerConfig;
            this.progressiveDialerConfig = progressiveDialerConfig != null ? progressiveDialerConfig.build() : null;
            this.handleUnionValueChange(Type.PROGRESSIVE_DIALER_CONFIG, oldValue, this.progressiveDialerConfig);
        }

        @Override
        public final Builder progressiveDialerConfig(ProgressiveDialerConfig progressiveDialerConfig) {
            ProgressiveDialerConfig oldValue = this.progressiveDialerConfig;
            this.progressiveDialerConfig = progressiveDialerConfig;
            this.handleUnionValueChange(Type.PROGRESSIVE_DIALER_CONFIG, oldValue, this.progressiveDialerConfig);
            return this;
        }

        public final PredictiveDialerConfig.Builder getPredictiveDialerConfig() {
            return this.predictiveDialerConfig != null ? this.predictiveDialerConfig.toBuilder() : null;
        }

        public final void setPredictiveDialerConfig(PredictiveDialerConfig.BuilderImpl predictiveDialerConfig) {
            PredictiveDialerConfig oldValue = this.predictiveDialerConfig;
            this.predictiveDialerConfig = predictiveDialerConfig != null ? predictiveDialerConfig.build() : null;
            this.handleUnionValueChange(Type.PREDICTIVE_DIALER_CONFIG, oldValue, this.predictiveDialerConfig);
        }

        @Override
        public final Builder predictiveDialerConfig(PredictiveDialerConfig predictiveDialerConfig) {
            PredictiveDialerConfig oldValue = this.predictiveDialerConfig;
            this.predictiveDialerConfig = predictiveDialerConfig;
            this.handleUnionValueChange(Type.PREDICTIVE_DIALER_CONFIG, oldValue, this.predictiveDialerConfig);
            return this;
        }

        public final AgentlessDialerConfig.Builder getAgentlessDialerConfig() {
            return this.agentlessDialerConfig != null ? this.agentlessDialerConfig.toBuilder() : null;
        }

        public final void setAgentlessDialerConfig(AgentlessDialerConfig.BuilderImpl agentlessDialerConfig) {
            AgentlessDialerConfig oldValue = this.agentlessDialerConfig;
            this.agentlessDialerConfig = agentlessDialerConfig != null ? agentlessDialerConfig.build() : null;
            this.handleUnionValueChange(Type.AGENTLESS_DIALER_CONFIG, oldValue, this.agentlessDialerConfig);
        }

        @Override
        public final Builder agentlessDialerConfig(AgentlessDialerConfig agentlessDialerConfig) {
            AgentlessDialerConfig oldValue = this.agentlessDialerConfig;
            this.agentlessDialerConfig = agentlessDialerConfig;
            this.handleUnionValueChange(Type.AGENTLESS_DIALER_CONFIG, oldValue, this.agentlessDialerConfig);
            return this;
        }

        public DialerConfig build() {
            return new DialerConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DialerConfig> {
        public Builder progressiveDialerConfig(ProgressiveDialerConfig var1);

        default public Builder progressiveDialerConfig(Consumer<ProgressiveDialerConfig.Builder> progressiveDialerConfig) {
            return this.progressiveDialerConfig((ProgressiveDialerConfig)((ProgressiveDialerConfig.Builder)ProgressiveDialerConfig.builder().applyMutation(progressiveDialerConfig)).build());
        }

        public Builder predictiveDialerConfig(PredictiveDialerConfig var1);

        default public Builder predictiveDialerConfig(Consumer<PredictiveDialerConfig.Builder> predictiveDialerConfig) {
            return this.predictiveDialerConfig((PredictiveDialerConfig)((PredictiveDialerConfig.Builder)PredictiveDialerConfig.builder().applyMutation(predictiveDialerConfig)).build());
        }

        public Builder agentlessDialerConfig(AgentlessDialerConfig var1);

        default public Builder agentlessDialerConfig(Consumer<AgentlessDialerConfig.Builder> agentlessDialerConfig) {
            return this.agentlessDialerConfig((AgentlessDialerConfig)((AgentlessDialerConfig.Builder)AgentlessDialerConfig.builder().applyMutation(agentlessDialerConfig)).build());
        }
    }
}

