/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLayoutResponse extends ConnectCasesResponse implements
        ToCopyableBuilder<GetLayoutResponse.Builder, GetLayoutResponse> {
    private static final SdkField<LayoutContent> CONTENT_FIELD = SdkField.<LayoutContent> builder(MarshallingType.SDK_POJO)
            .memberName("content").getter(getter(GetLayoutResponse::content)).setter(setter(Builder::content))
            .constructor(LayoutContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> LAYOUT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("layoutArn").getter(getter(GetLayoutResponse::layoutArn)).setter(setter(Builder::layoutArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layoutArn").build()).build();

    private static final SdkField<String> LAYOUT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("layoutId").getter(getter(GetLayoutResponse::layoutId)).setter(setter(Builder::layoutId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layoutId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetLayoutResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetLayoutResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            LAYOUT_ARN_FIELD, LAYOUT_ID_FIELD, NAME_FIELD, TAGS_FIELD));

    private final LayoutContent content;

    private final String layoutArn;

    private final String layoutId;

    private final String name;

    private final Map<String, String> tags;

    private GetLayoutResponse(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.layoutArn = builder.layoutArn;
        this.layoutId = builder.layoutId;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Information about which fields will be present in the layout, the order of the fields, and read-only attribute of
     * the field.
     * </p>
     * 
     * @return Information about which fields will be present in the layout, the order of the fields, and read-only
     *         attribute of the field.
     */
    public final LayoutContent content() {
        return content;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the newly created layout.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the newly created layout.
     */
    public final String layoutArn() {
        return layoutArn;
    }

    /**
     * <p>
     * The unique identifier of the layout.
     * </p>
     * 
     * @return The unique identifier of the layout.
     */
    public final String layoutId() {
        return layoutId;
    }

    /**
     * <p>
     * The name of the layout. It must be unique.
     * </p>
     * 
     * @return The name of the layout. It must be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control
     * access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or
     *         control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(layoutArn());
        hashCode = 31 * hashCode + Objects.hashCode(layoutId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLayoutResponse)) {
            return false;
        }
        GetLayoutResponse other = (GetLayoutResponse) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(layoutArn(), other.layoutArn())
                && Objects.equals(layoutId(), other.layoutId()) && Objects.equals(name(), other.name())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLayoutResponse").add("Content", content()).add("LayoutArn", layoutArn())
                .add("LayoutId", layoutId()).add("Name", name()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "layoutArn":
            return Optional.ofNullable(clazz.cast(layoutArn()));
        case "layoutId":
            return Optional.ofNullable(clazz.cast(layoutId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLayoutResponse, T> g) {
        return obj -> g.apply((GetLayoutResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCasesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLayoutResponse> {
        /**
         * <p>
         * Information about which fields will be present in the layout, the order of the fields, and read-only
         * attribute of the field.
         * </p>
         * 
         * @param content
         *        Information about which fields will be present in the layout, the order of the fields, and read-only
         *        attribute of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(LayoutContent content);

        /**
         * <p>
         * Information about which fields will be present in the layout, the order of the fields, and read-only
         * attribute of the field.
         * </p>
         * This is a convenience method that creates an instance of the {@link LayoutContent.Builder} avoiding the need
         * to create one manually via {@link LayoutContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LayoutContent.Builder#build()} is called immediately and its
         * result is passed to {@link #content(LayoutContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link LayoutContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(LayoutContent)
         */
        default Builder content(Consumer<LayoutContent.Builder> content) {
            return content(LayoutContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the newly created layout.
         * </p>
         * 
         * @param layoutArn
         *        The Amazon Resource Name (ARN) of the newly created layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layoutArn(String layoutArn);

        /**
         * <p>
         * The unique identifier of the layout.
         * </p>
         * 
         * @param layoutId
         *        The unique identifier of the layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layoutId(String layoutId);

        /**
         * <p>
         * The name of the layout. It must be unique.
         * </p>
         * 
         * @param name
         *        The name of the layout. It must be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control
         * access for this resource.
         * </p>
         * 
         * @param tags
         *        A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or
         *        control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends ConnectCasesResponse.BuilderImpl implements Builder {
        private LayoutContent content;

        private String layoutArn;

        private String layoutId;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLayoutResponse model) {
            super(model);
            content(model.content);
            layoutArn(model.layoutArn);
            layoutId(model.layoutId);
            name(model.name);
            tags(model.tags);
        }

        public final LayoutContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(LayoutContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(LayoutContent content) {
            this.content = content;
            return this;
        }

        public final String getLayoutArn() {
            return layoutArn;
        }

        public final void setLayoutArn(String layoutArn) {
            this.layoutArn = layoutArn;
        }

        @Override
        public final Builder layoutArn(String layoutArn) {
            this.layoutArn = layoutArn;
            return this;
        }

        public final String getLayoutId() {
            return layoutId;
        }

        public final void setLayoutId(String layoutId) {
            this.layoutId = layoutId;
        }

        @Override
        public final Builder layoutId(String layoutId) {
            this.layoutId = layoutId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public GetLayoutResponse build() {
            return new GetLayoutResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
