/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLandingZoneOperationResponse extends ControlTowerResponse implements
        ToCopyableBuilder<GetLandingZoneOperationResponse.Builder, GetLandingZoneOperationResponse> {
    private static final SdkField<LandingZoneOperationDetail> OPERATION_DETAILS_FIELD = SdkField
            .<LandingZoneOperationDetail> builder(MarshallingType.SDK_POJO).memberName("operationDetails")
            .getter(getter(GetLandingZoneOperationResponse::operationDetails)).setter(setter(Builder::operationDetails))
            .constructor(LandingZoneOperationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_DETAILS_FIELD));

    private final LandingZoneOperationDetail operationDetails;

    private GetLandingZoneOperationResponse(BuilderImpl builder) {
        super(builder);
        this.operationDetails = builder.operationDetails;
    }

    /**
     * <p>
     * Details about a landing zone operation.
     * </p>
     * 
     * @return Details about a landing zone operation.
     */
    public final LandingZoneOperationDetail operationDetails() {
        return operationDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(operationDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLandingZoneOperationResponse)) {
            return false;
        }
        GetLandingZoneOperationResponse other = (GetLandingZoneOperationResponse) obj;
        return Objects.equals(operationDetails(), other.operationDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLandingZoneOperationResponse").add("OperationDetails", operationDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operationDetails":
            return Optional.ofNullable(clazz.cast(operationDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLandingZoneOperationResponse, T> g) {
        return obj -> g.apply((GetLandingZoneOperationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ControlTowerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetLandingZoneOperationResponse> {
        /**
         * <p>
         * Details about a landing zone operation.
         * </p>
         * 
         * @param operationDetails
         *        Details about a landing zone operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationDetails(LandingZoneOperationDetail operationDetails);

        /**
         * <p>
         * Details about a landing zone operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link LandingZoneOperationDetail.Builder}
         * avoiding the need to create one manually via {@link LandingZoneOperationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LandingZoneOperationDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #operationDetails(LandingZoneOperationDetail)}.
         * 
         * @param operationDetails
         *        a consumer that will call methods on {@link LandingZoneOperationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operationDetails(LandingZoneOperationDetail)
         */
        default Builder operationDetails(Consumer<LandingZoneOperationDetail.Builder> operationDetails) {
            return operationDetails(LandingZoneOperationDetail.builder().applyMutation(operationDetails).build());
        }
    }

    static final class BuilderImpl extends ControlTowerResponse.BuilderImpl implements Builder {
        private LandingZoneOperationDetail operationDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLandingZoneOperationResponse model) {
            super(model);
            operationDetails(model.operationDetails);
        }

        public final LandingZoneOperationDetail.Builder getOperationDetails() {
            return operationDetails != null ? operationDetails.toBuilder() : null;
        }

        public final void setOperationDetails(LandingZoneOperationDetail.BuilderImpl operationDetails) {
            this.operationDetails = operationDetails != null ? operationDetails.build() : null;
        }

        @Override
        public final Builder operationDetails(LandingZoneOperationDetail operationDetails) {
            this.operationDetails = operationDetails;
            return this;
        }

        @Override
        public GetLandingZoneOperationResponse build() {
            return new GetLandingZoneOperationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
