/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnrollmentStatusesRequest extends CostOptimizationHubRequest implements
        ToCopyableBuilder<ListEnrollmentStatusesRequest.Builder, ListEnrollmentStatusesRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(ListEnrollmentStatusesRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Boolean> INCLUDE_ORGANIZATION_INFO_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeOrganizationInfo").getter(getter(ListEnrollmentStatusesRequest::includeOrganizationInfo))
            .setter(setter(Builder::includeOrganizationInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeOrganizationInfo").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListEnrollmentStatusesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEnrollmentStatusesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            INCLUDE_ORGANIZATION_INFO_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String accountId;

    private final Boolean includeOrganizationInfo;

    private final Integer maxResults;

    private final String nextToken;

    private ListEnrollmentStatusesRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.includeOrganizationInfo = builder.includeOrganizationInfo;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The enrollment status of a specific account ID in the organization.
     * </p>
     * 
     * @return The enrollment status of a specific account ID in the organization.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Indicates whether to return the enrollment status for the organization.
     * </p>
     * 
     * @return Indicates whether to return the enrollment status for the organization.
     */
    public final Boolean includeOrganizationInfo() {
        return includeOrganizationInfo;
    }

    /**
     * <p>
     * The maximum number of objects that are returned for the request.
     * </p>
     * 
     * @return The maximum number of objects that are returned for the request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next set of results.
     * </p>
     * 
     * @return The token to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(includeOrganizationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnrollmentStatusesRequest)) {
            return false;
        }
        ListEnrollmentStatusesRequest other = (ListEnrollmentStatusesRequest) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(includeOrganizationInfo(), other.includeOrganizationInfo())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnrollmentStatusesRequest").add("AccountId", accountId())
                .add("IncludeOrganizationInfo", includeOrganizationInfo()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "includeOrganizationInfo":
            return Optional.ofNullable(clazz.cast(includeOrganizationInfo()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEnrollmentStatusesRequest, T> g) {
        return obj -> g.apply((ListEnrollmentStatusesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostOptimizationHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEnrollmentStatusesRequest> {
        /**
         * <p>
         * The enrollment status of a specific account ID in the organization.
         * </p>
         * 
         * @param accountId
         *        The enrollment status of a specific account ID in the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Indicates whether to return the enrollment status for the organization.
         * </p>
         * 
         * @param includeOrganizationInfo
         *        Indicates whether to return the enrollment status for the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeOrganizationInfo(Boolean includeOrganizationInfo);

        /**
         * <p>
         * The maximum number of objects that are returned for the request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of objects that are returned for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostOptimizationHubRequest.BuilderImpl implements Builder {
        private String accountId;

        private Boolean includeOrganizationInfo;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnrollmentStatusesRequest model) {
            super(model);
            accountId(model.accountId);
            includeOrganizationInfo(model.includeOrganizationInfo);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Boolean getIncludeOrganizationInfo() {
            return includeOrganizationInfo;
        }

        public final void setIncludeOrganizationInfo(Boolean includeOrganizationInfo) {
            this.includeOrganizationInfo = includeOrganizationInfo;
        }

        @Override
        public final Builder includeOrganizationInfo(Boolean includeOrganizationInfo) {
            this.includeOrganizationInfo = includeOrganizationInfo;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEnrollmentStatusesRequest build() {
            return new ListEnrollmentStatusesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
